// Autogenerated Jamon implementation
// /home/stack/0.96/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 33, 1
import java.util.*;
// 34, 1
import org.apache.hadoop.util.StringUtils;
// 35, 1
import org.apache.hadoop.hbase.util.Bytes;
// 36, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 37, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 38, 1
import org.apache.hadoop.hbase.master.HMaster;
// 39, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 40, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 41, 1
import org.apache.hadoop.hbase.HConstants;
// 42, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 43, 1
import org.apache.hadoop.hbase.ServerLoad;
// 44, 1
import org.apache.hadoop.hbase.ServerName;
// 45, 1
import org.apache.hadoop.hbase.client.HBaseAdmin;
// 46, 1
import org.apache.hadoop.hbase.client.HConnectionManager;
// 47, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 48, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 49, 1
import org.apache.hadoop.hbase.TableName;
// 50, 1
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos.SnapshotDescription;
// 51, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 52, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final HBaseAdmin admin;
  private final ServerName metaLocation;
  private final String filter;
  private final ServerManager serverManager;
  private final boolean catalogJanitorEnabled;
  private final Set<ServerName> deadServers;
  private final Map<String,Integer> frags;
  private final AssignmentManager assignmentManager;
  private final String format;
  private final List<ServerName> servers;
  // 63, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeperWatcher().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim()).append(",");

      if ((i+1) % 4 == 0 && i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    quorums.setLength(quorums.length() - 1);
    return quorums.toString();
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    admin = p_implData.getAdmin();
    metaLocation = p_implData.getMetaLocation();
    filter = p_implData.getFilter();
    serverManager = p_implData.getServerManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    deadServers = p_implData.getDeadServers();
    frags = p_implData.getFrags();
    assignmentManager = p_implData.getAssignmentManager();
    format = p_implData.getFormat();
    servers = p_implData.getServers();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 54, 1
    if (format.equals("json") )
    {
      // 54, 30
      jamonWriter.write("\n  ");
      // 55, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_0 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_0.setFormat("json" );
        __jamon__var_0.setFilter(filter);
        __jamon__var_0.renderNoFlush(jamonWriter);
      }
      // 55, 68
      jamonWriter.write("\n  ");
      // 56, 3
      return; 
    }
    // 57, 7
    jamonWriter.write("\n");
    // 58, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 91, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>Master: ");
    // 98, 20
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 98, 62
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/logs/\">Local logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
    // 126, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 126, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 128, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container\">\n\t");
    // 135, 2
    if (master.isActiveMaster() )
    {
      // 135, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 138, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 138, 77
      jamonWriter.write(" </small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 144, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 144, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 146, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 146, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n          for details.\n          </div>\n        ");
      }
      // 151, 15
      jamonWriter.write("\n        ");
      // 152, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 152, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 157, 15
      jamonWriter.write("\n\n        <section>\n            <h2>Region Servers</h2>\n            ");
      // 161, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_1 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_1.setServers(servers );
        __jamon__var_1.renderNoFlush(jamonWriter, master);
      }
      // 161, 74
      jamonWriter.write("\n\n            ");
      // 163, 13
      if ((deadServers != null) )
      {
        // 163, 42
        jamonWriter.write("\n                ");
        // 164, 17
        {
          // 164, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 164, 40
        jamonWriter.write("\n            ");
      }
      // 165, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 168, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_2 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_2.renderNoFlush(jamonWriter, master );
      }
      // 168, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2>Tables</h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">Catalog Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 186, 25
      if ((metaLocation != null) )
      {
        // 186, 55
        jamonWriter.write("\n                            ");
        // 187, 29
        {
          // 187, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 187, 45
        jamonWriter.write("\n                        ");
      }
      // 188, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 191, 25
      if ((metaLocation != null) )
      {
        // 191, 55
        jamonWriter.write("\n                            ");
        // 192, 29
        {
          // 192, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 192, 48
        jamonWriter.write("\n                        ");
      }
      // 193, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 196, 25
      {
        // 196, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 196, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        ");
      // 201, 9
      {
        org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_3 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
        __jamon__var_3.renderNoFlush(jamonWriter, master.getAssignmentManager());
      }
      // 201, 90
      jamonWriter.write("\n\t");
    }
    // 202, 2
    else
    {
      // 202, 9
      jamonWriter.write("\n        <section>\n            ");
      // 204, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_4.renderNoFlush(jamonWriter, master );
      }
      // 204, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 206, 8
    jamonWriter.write("    \n\n\n        <section>\n            ");
    // 210, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_5.setFilter(filter );
      __jamon__var_5.renderNoFlush(jamonWriter);
    }
    // 210, 61
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 223, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 223, 84
    jamonWriter.write(", r");
    // 223, 87
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 223, 147
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 227, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 227, 81
    jamonWriter.write(", ");
    // 227, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 227, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 232, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 232, 78
    jamonWriter.write(", r");
    // 232, 81
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 232, 135
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 237, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 237, 75
    jamonWriter.write(", ");
    // 237, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 237, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Quorum</td>\n                    <td> ");
    // 243, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 243, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 248, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 248, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 253, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 253, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 256, 17
    if (master.isActiveMaster() )
    {
      // 256, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 259, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 259, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 264, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 264, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 269, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 269, 103
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 272, 18
      if (frags != null )
      {
        // 272, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 275, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 275, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 278, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 281, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(master.getCoprocessors())), jamonWriter);
      // 281, 83
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n                ");
    }
    // 284, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n  </body>\n</html>\n\n");
  }
  
  
  // 361, 1
  private void __jamon_innerUnit__userSnapshots(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 362, 1
    
   List<SnapshotDescription> snapshots = admin.listSnapshots();

    // 365, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 365, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 372, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 372, 57
        jamonWriter.write("\n    ");
        // 373, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 376, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 377, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 377, 68
        jamonWriter.write("\">");
        // 377, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 377, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 378, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 378, 74
        jamonWriter.write("\">");
        // 378, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 378, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 380, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 380, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 382, 12
      jamonWriter.write("\n    <p>");
      // 383, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 383, 30
      jamonWriter.write(" snapshot(s) in set.</p>\n</table>\n");
    }
    // 385, 7
    jamonWriter.write("\n");
  }
  
  
  // 296, 1
  private void __jamon_innerUnit__catalogTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 297, 1
    
 HTableDescriptor[] sysTables = admin.listTableDescriptorsByNamespace(NamespaceDescriptor
 .SYSTEM_NAMESPACE_NAME_STR);

    // 302, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
    // 305, 5
    if ((frags != null) )
    {
      // 305, 28
      jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
    }
    // 307, 11
    jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
    // 310, 1
    for (HTableDescriptor systemTable : sysTables)
    {
      // 310, 49
      jamonWriter.write("\n<tr>\n");
      // 312, 1
      TableName tableName = systemTable.getTableName();
      // 313, 5
      jamonWriter.write("<td><a href=\"table.jsp?name=");
      // 313, 33
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
      // 313, 48
      jamonWriter.write("\">");
      // 313, 50
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
      // 313, 65
      jamonWriter.write("</a></td>\n    ");
      // 314, 5
      if ((frags != null))
      {
        // 314, 27
        jamonWriter.write("\n        <td align=\"center\">");
        // 315, 28
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
        // 316, 37
        jamonWriter.write("</td>\n    ");
      }
      // 317, 11
      jamonWriter.write("\n    ");
      // 318, 5
      String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions";
        } else {
            description = "The .NAMESPACE. table holds information about namespaces.";
        }
    
      // 325, 5
      jamonWriter.write("<td>");
      // 325, 9
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
      // 325, 26
      jamonWriter.write("</td>\n</tr>\n");
    }
    // 327, 8
    jamonWriter.write("\n</table>\n");
  }
  
  
  // 331, 1
  private void __jamon_innerUnit__userTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 332, 1
    
   HTableDescriptor[] tables = admin.listTables();

    // 335, 1
    if ((tables != null && tables.length > 0))
    {
      // 335, 45
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Table Name</th>\n        ");
      // 339, 9
      if ((frags != null) )
      {
        // 339, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 341, 15
      jamonWriter.write("\n        <th>Online Regions</th>\n        <th>Description</th>\n    </tr>\n    ");
      // 345, 5
      for (HTableDescriptor htDesc : tables)
      {
        // 345, 45
        jamonWriter.write("\n    <tr>\n        <td><a href=table.jsp?name=");
        // 347, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getNameAsString()), jamonWriter);
        // 347, 81
        jamonWriter.write(">");
        // 347, 82
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getNameAsString()), jamonWriter);
        // 347, 127
        jamonWriter.write("</a> </td>\n        ");
        // 348, 9
        if ((frags != null) )
        {
          // 348, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 349, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(htDesc.getTableName().getNameAsString()) != null ? frags.get(htDesc.getTableName().getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 349, 174
          jamonWriter.write("</td>\n        ");
        }
        // 350, 15
        jamonWriter.write("\n        <td>");
        // 351, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getAssignmentManager().getRegionStates().getRegionsOfTable(htDesc
        .getTableName()).size()), jamonWriter);
        // 352, 35
        jamonWriter.write("\n        <td>");
        // 353, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 353, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 355, 12
      jamonWriter.write("\n    <p>");
      // 356, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.length), jamonWriter);
      // 356, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</table>\n");
    }
    // 358, 7
    jamonWriter.write("\n");
  }
  
  
  // 389, 1
  private void __jamon_innerUnit__deadRegionServers(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 391, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 391, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 399, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
           int infoPort = master.getConfiguration().getInt("hbase.regionserver.info.port", 60030);
    
      // 406, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 408, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 408, 33
      jamonWriter.write("</td>\n        <td>");
      // 409, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 409, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 411, 5
      
        }
    
      // 414, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 416, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 416, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 420, 7
    jamonWriter.write("\n");
    // 421, 1
    
   HConnectionManager.deleteConnection(admin.getConfiguration());

  }
  
  
}
