/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMemStore
extends TestCase {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private MemStore memstore;
    private static final int ROW_COUNT = 10;
    private static final int QUALIFIER_COUNT = 10;
    private static final byte[] FAMILY = Bytes.toBytes((String)"column");
    private static final byte[] CONTENTS = Bytes.toBytes((String)"contents");
    private static final byte[] BASIC = Bytes.toBytes((String)"basic");
    private static final String CONTENTSTR = "contentstr";
    private MultiVersionConsistencyControl mvcc;

    public void setUp() throws Exception {
        super.setUp();
        this.mvcc = new MultiVersionConsistencyControl();
        this.memstore = new MemStore();
    }

    public void testPutSameKey() {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        this.memstore.add(kv);
        byte[] other = Bytes.toBytes((String)"somethingelse");
        KeyValue samekey = new KeyValue(bytes, bytes, bytes, other);
        this.memstore.add(samekey);
        KeyValue found = this.memstore.kvset.first();
        TestMemStore.assertEquals((int)1, (int)this.memstore.kvset.size());
        TestMemStore.assertTrue((String)Bytes.toString((byte[])found.getValue()), (boolean)CellUtil.matchingValue((Cell)samekey, (Cell)found));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScanAcrossSnapshot() throws IOException {
        int rowCount = this.addRows(this.memstore);
        List memstorescanners = this.memstore.getScanners();
        Scan scan = new Scan();
        ArrayList result = new ArrayList();
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        ScanInfo scanInfo = new ScanInfo(null, 0, 1, Long.MAX_VALUE, false, 0L, this.memstore.comparator);
        ScanType scanType = ScanType.USER_SCAN;
        StoreScanner s = new StoreScanner(scan, scanInfo, scanType, null, memstorescanners);
        int count = 0;
        try {
            while (s.next(result)) {
                this.LOG.info(result);
                ++count;
                TestMemStore.assertEquals((int)rowCount, (int)result.size());
                result.clear();
            }
        }
        finally {
            s.close();
        }
        TestMemStore.assertEquals((int)rowCount, (int)count);
        for (KeyValueScanner scanner : memstorescanners) {
            scanner.close();
        }
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        memstorescanners = this.memstore.getScanners();
        s = new StoreScanner(scan, scanInfo, scanType, null, memstorescanners);
        count = 0;
        try {
            while (s.next(result)) {
                this.LOG.info(result);
                TestMemStore.assertTrue((boolean)CellUtil.matchingRow((Cell)((Cell)result.get(0)), (byte[])Bytes.toBytes((int)count)));
                TestMemStore.assertEquals((int)rowCount, (int)result.size());
                if (++count == 2) {
                    this.memstore.snapshot();
                    this.LOG.info((Object)"Snapshotted");
                }
                result.clear();
            }
        }
        finally {
            s.close();
        }
        TestMemStore.assertEquals((int)rowCount, (int)count);
        for (KeyValueScanner scanner : memstorescanners) {
            scanner.close();
        }
        memstorescanners = this.memstore.getScanners();
        long ts = System.currentTimeMillis();
        s = new StoreScanner(scan, scanInfo, scanType, null, memstorescanners);
        count = 0;
        int snapshotIndex = 5;
        try {
            while (s.next(result)) {
                this.LOG.info(result);
                TestMemStore.assertTrue((boolean)CellUtil.matchingRow((Cell)((Cell)result.get(0)), (byte[])Bytes.toBytes((int)count)));
                TestMemStore.assertEquals((String)("count=" + count + ", result=" + result), (int)rowCount, (int)result.size());
                if (++count == snapshotIndex) {
                    this.memstore.snapshot();
                    this.memstore.clearSnapshot((SortedSet)this.memstore.getSnapshot());
                    this.addRows(this.memstore, ts);
                    this.LOG.info((Object)"Snapshotted, cleared it and then added values (which wont be seen)");
                }
                result.clear();
            }
        }
        finally {
            s.close();
        }
        TestMemStore.assertEquals((int)rowCount, (int)count);
    }

    public void testScanAcrossSnapshot2() throws IOException, CloneNotSupportedException {
        byte[] one = Bytes.toBytes((int)1);
        byte[] two = Bytes.toBytes((int)2);
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((int)3);
        KeyValue kv1 = new KeyValue(one, f, q, v);
        KeyValue kv2 = new KeyValue(two, f, q, v);
        this.memstore.add(kv1.clone());
        this.memstore.add(kv2.clone());
        this.verifyScanAcrossSnapshot2(kv1, kv2);
        this.memstore.snapshot();
        this.verifyScanAcrossSnapshot2(kv1, kv2);
        this.memstore = new MemStore();
        this.memstore.add(kv1.clone());
        this.memstore.snapshot();
        this.memstore.add(kv2.clone());
        this.verifyScanAcrossSnapshot2(kv1, kv2);
    }

    private void verifyScanAcrossSnapshot2(KeyValue kv1, KeyValue kv2) throws IOException {
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        List memstorescanners = this.memstore.getScanners();
        TestMemStore.assertEquals((int)1, (int)memstorescanners.size());
        KeyValueScanner scanner = (KeyValueScanner)memstorescanners.get(0);
        scanner.seek(KeyValue.createFirstOnRow((byte[])HConstants.EMPTY_START_ROW));
        TestMemStore.assertEquals((Object)kv1, (Object)scanner.next());
        TestMemStore.assertEquals((Object)kv2, (Object)scanner.next());
        TestMemStore.assertNull((Object)scanner.next());
    }

    private void assertScannerResults(KeyValueScanner scanner, KeyValue[] expected) throws IOException {
        KeyValue next;
        scanner.seek(KeyValue.createFirstOnRow((byte[])new byte[0]));
        ArrayList returned = Lists.newArrayList();
        while ((next = scanner.next()) != null) {
            returned.add(next);
        }
        TestMemStore.assertTrue((String)("Got:\n" + Joiner.on((String)"\n").join((Iterable)returned) + "\nExpected:\n" + Joiner.on((String)"\n").join((Object[])expected)), (boolean)Iterables.elementsEqual(Arrays.asList(expected), (Iterable)returned));
        TestMemStore.assertNull((Object)scanner.peek());
    }

    public void testMemstoreConcurrentControl() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v = Bytes.toBytes((String)"value");
        MultiVersionConsistencyControl.WriteEntry w = this.mvcc.beginMemstoreInsert();
        KeyValue kv1 = new KeyValue(row, f, q1, v);
        kv1.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kv1);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[0]);
        this.mvcc.completeMemstoreInsert(w);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1});
        w = this.mvcc.beginMemstoreInsert();
        KeyValue kv2 = new KeyValue(row, f, q2, v);
        kv2.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kv2);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1});
        this.mvcc.completeMemstoreInsert(w);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1, kv2});
    }

    public void testMemstoreEditsVisibilityWithSameKey() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v1 = Bytes.toBytes((String)"value1");
        byte[] v2 = Bytes.toBytes((String)"value2");
        MultiVersionConsistencyControl.WriteEntry w = this.mvcc.beginMemstoreInsert();
        KeyValue kv11 = new KeyValue(row, f, q1, v1);
        kv11.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kv11);
        KeyValue kv12 = new KeyValue(row, f, q2, v1);
        kv12.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kv12);
        this.mvcc.completeMemstoreInsert(w);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        w = this.mvcc.beginMemstoreInsert();
        KeyValue kv21 = new KeyValue(row, f, q1, v2);
        kv21.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kv21);
        KeyValue kv22 = new KeyValue(row, f, q2, v2);
        kv22.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kv22);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        this.mvcc.completeMemstoreInsert(w);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv21, kv11, kv22, kv12});
    }

    public void testMemstoreDeletesVisibilityWithSameKey() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v1 = Bytes.toBytes((String)"value1");
        MultiVersionConsistencyControl.WriteEntry w = this.mvcc.beginMemstoreInsert();
        KeyValue kv11 = new KeyValue(row, f, q1, v1);
        kv11.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kv11);
        KeyValue kv12 = new KeyValue(row, f, q2, v1);
        kv12.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kv12);
        this.mvcc.completeMemstoreInsert(w);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        w = this.mvcc.beginMemstoreInsert();
        KeyValue kvDel = new KeyValue(row, f, q2, kv11.getTimestamp(), KeyValue.Type.DeleteColumn);
        kvDel.setMvccVersion(w.getWriteNumber());
        this.memstore.add(kvDel);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        this.mvcc.completeMemstoreInsert(w);
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
        s = (KeyValueScanner)this.memstore.getScanners().get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kvDel, kv12});
    }

    public void testReadOwnWritesUnderConcurrency() throws Throwable {
        int i;
        int NUM_THREADS = 8;
        ReadOwnWritesTester[] threads = new ReadOwnWritesTester[NUM_THREADS];
        AtomicReference<Throwable> caught = new AtomicReference<Throwable>();
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i] = new ReadOwnWritesTester(i, this.memstore, this.mvcc, caught);
            threads[i].start();
        }
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i].join();
        }
        if (caught.get() != null) {
            throw (Throwable)caught.get();
        }
    }

    public void testSnapshotting() throws IOException {
        int snapshotCount = 5;
        for (int i = 0; i < 5; ++i) {
            this.addRows(this.memstore);
            this.runSnapshot(this.memstore);
            KeyValueSkipListSet ss = this.memstore.getSnapshot();
            TestMemStore.assertEquals((String)"History not being cleared", (int)0, (int)ss.size());
        }
    }

    public void testMultipleVersionsSimple() throws Exception {
        MemStore m = new MemStore(new Configuration(), KeyValue.COMPARATOR);
        byte[] row = Bytes.toBytes((String)"testRow");
        byte[] family = Bytes.toBytes((String)"testFamily");
        byte[] qf = Bytes.toBytes((String)"testQualifier");
        long[] stamps = new long[]{1L, 2L, 3L};
        byte[][] values = new byte[][]{Bytes.toBytes((String)"value0"), Bytes.toBytes((String)"value1"), Bytes.toBytes((String)"value2")};
        KeyValue key0 = new KeyValue(row, family, qf, stamps[0], values[0]);
        KeyValue key1 = new KeyValue(row, family, qf, stamps[1], values[1]);
        KeyValue key2 = new KeyValue(row, family, qf, stamps[2], values[2]);
        m.add(key0);
        m.add(key1);
        m.add(key2);
        TestMemStore.assertTrue((String)("Expected memstore to hold 3 values, actually has " + m.kvset.size()), (m.kvset.size() == 3 ? 1 : 0) != 0);
    }

    public void testGetNextRow() throws Exception {
        MultiVersionConsistencyControl.resetThreadReadPoint();
        this.addRows(this.memstore);
        Thread.sleep(1L);
        this.addRows(this.memstore);
        KeyValue closestToEmpty = this.memstore.getNextRow(KeyValue.LOWESTKEY);
        TestMemStore.assertTrue((KeyValue.COMPARATOR.compareRows(closestToEmpty, new KeyValue(Bytes.toBytes((int)0), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            KeyValue nr = this.memstore.getNextRow(new KeyValue(Bytes.toBytes((int)i), System.currentTimeMillis()));
            if (i + 1 == 10) {
                TestMemStore.assertEquals((Object)nr, null);
                continue;
            }
            TestMemStore.assertTrue((KeyValue.COMPARATOR.compareRows(nr, new KeyValue(Bytes.toBytes((int)(i + 1)), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        }
        for (int startRowId = 0; startRowId < 10; ++startRowId) {
            ScanInfo scanInfo = new ScanInfo(FAMILY, 0, 1, Integer.MAX_VALUE, false, 0L, this.memstore.comparator);
            ScanType scanType = ScanType.USER_SCAN;
            StoreScanner scanner = new StoreScanner(new Scan(Bytes.toBytes((int)startRowId)), scanInfo, scanType, null, this.memstore.getScanners());
            ArrayList results = new ArrayList();
            int i = 0;
            while (scanner.next(results)) {
                int rowId = startRowId + i;
                Cell left = (Cell)results.get(0);
                byte[] row1 = Bytes.toBytes((int)rowId);
                TestMemStore.assertTrue((String)"Row name", (KeyValue.COMPARATOR.compareRows(left.getRowArray(), left.getRowOffset(), (int)left.getRowLength(), row1, 0, row1.length) == 0 ? 1 : 0) != 0);
                TestMemStore.assertEquals((String)"Count of columns", (int)10, (int)results.size());
                ArrayList<Cell> row = new ArrayList<Cell>();
                for (Cell kv : results) {
                    row.add(kv);
                }
                this.isExpectedRowWithoutTimestamps(rowId, row);
                results.clear();
                ++i;
            }
        }
    }

    public void testGet_memstoreAndSnapShot() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add(new KeyValue(row, fam, qf1, val));
        this.memstore.add(new KeyValue(row, fam, qf2, val));
        this.memstore.add(new KeyValue(row, fam, qf3, val));
        this.memstore.snapshot();
        TestMemStore.assertEquals((int)3, (int)this.memstore.snapshot.size());
        TestMemStore.assertEquals((int)0, (int)this.memstore.kvset.size());
        this.memstore.add(new KeyValue(row, fam, qf4, val));
        this.memstore.add(new KeyValue(row, fam, qf5, val));
        TestMemStore.assertEquals((int)2, (int)this.memstore.kvset.size());
    }

    public void testGetWithDelete() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts1 = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts1, val);
        long ts2 = ts1 + 1L;
        KeyValue put2 = new KeyValue(row, fam, qf1, ts2, val);
        long ts3 = ts2 + 1L;
        KeyValue put3 = new KeyValue(row, fam, qf1, ts3, val);
        this.memstore.add(put1);
        this.memstore.add(put2);
        this.memstore.add(put3);
        TestMemStore.assertEquals((int)3, (int)this.memstore.kvset.size());
        KeyValue del2 = new KeyValue(row, fam, qf1, ts2, KeyValue.Type.Delete, val);
        this.memstore.delete(del2);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(put3);
        expected.add(del2);
        expected.add(put2);
        expected.add(put1);
        TestMemStore.assertEquals((int)4, (int)this.memstore.kvset.size());
        int i = 0;
        for (KeyValue kv : this.memstore.kvset) {
            TestMemStore.assertEquals(expected.get(i++), (Object)kv);
        }
    }

    public void testGetWithDeleteColumn() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts1 = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts1, val);
        long ts2 = ts1 + 1L;
        KeyValue put2 = new KeyValue(row, fam, qf1, ts2, val);
        long ts3 = ts2 + 1L;
        KeyValue put3 = new KeyValue(row, fam, qf1, ts3, val);
        this.memstore.add(put1);
        this.memstore.add(put2);
        this.memstore.add(put3);
        TestMemStore.assertEquals((int)3, (int)this.memstore.kvset.size());
        KeyValue del2 = new KeyValue(row, fam, qf1, ts2, KeyValue.Type.DeleteColumn, val);
        this.memstore.delete(del2);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(put3);
        expected.add(del2);
        expected.add(put2);
        expected.add(put1);
        TestMemStore.assertEquals((int)4, (int)this.memstore.kvset.size());
        int i = 0;
        for (KeyValue kv : this.memstore.kvset) {
            TestMemStore.assertEquals(expected.get(i++), (Object)kv);
        }
    }

    public void testGetWithDeleteFamily() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts, val);
        KeyValue put2 = new KeyValue(row, fam, qf2, ts, val);
        KeyValue put3 = new KeyValue(row, fam, qf3, ts, val);
        KeyValue put4 = new KeyValue(row, fam, qf3, ts + 1L, val);
        this.memstore.add(put1);
        this.memstore.add(put2);
        this.memstore.add(put3);
        this.memstore.add(put4);
        KeyValue del = new KeyValue(row, fam, null, ts, KeyValue.Type.DeleteFamily, val);
        this.memstore.delete(del);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(del);
        expected.add(put1);
        expected.add(put2);
        expected.add(put4);
        expected.add(put3);
        TestMemStore.assertEquals((int)5, (int)this.memstore.kvset.size());
        int i = 0;
        for (KeyValue kv : this.memstore.kvset) {
            TestMemStore.assertEquals(expected.get(i++), (Object)kv);
        }
    }

    public void testKeepDeleteInmemstore() {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts = System.nanoTime();
        this.memstore.add(new KeyValue(row, fam, qf, ts, val));
        KeyValue delete = new KeyValue(row, fam, qf, ts, KeyValue.Type.Delete, val);
        this.memstore.delete(delete);
        TestMemStore.assertEquals((int)2, (int)this.memstore.kvset.size());
        TestMemStore.assertEquals((Object)delete, (Object)this.memstore.kvset.first());
    }

    public void testRetainsDeleteVersion() throws IOException {
        this.memstore.add(KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"));
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care");
        this.memstore.delete(delete);
        TestMemStore.assertEquals((int)2, (int)this.memstore.kvset.size());
        TestMemStore.assertEquals((Object)delete, (Object)this.memstore.kvset.first());
    }

    public void testRetainsDeleteColumn() throws IOException {
        this.memstore.add(KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"));
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care");
        this.memstore.delete(delete);
        TestMemStore.assertEquals((int)2, (int)this.memstore.kvset.size());
        TestMemStore.assertEquals((Object)delete, (Object)this.memstore.kvset.first());
    }

    public void testRetainsDeleteFamily() throws IOException {
        this.memstore.add(KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"));
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteFamily, (String)"dont-care");
        this.memstore.delete(delete);
        TestMemStore.assertEquals((int)2, (int)this.memstore.kvset.size());
        TestMemStore.assertEquals((Object)delete, (Object)this.memstore.kvset.first());
    }

    public void testMultipleTimestamps() throws IOException {
        long[] timestamps = new long[]{20L, 10L, 5L, 1L};
        Scan scan = new Scan();
        for (long timestamp : timestamps) {
            this.addRows(this.memstore, timestamp);
        }
        scan.setTimeRange(0L, 2L);
        TestMemStore.assertTrue((boolean)this.memstore.shouldSeek(scan, Long.MIN_VALUE));
        scan.setTimeRange(20L, 82L);
        TestMemStore.assertTrue((boolean)this.memstore.shouldSeek(scan, Long.MIN_VALUE));
        scan.setTimeRange(10L, 20L);
        TestMemStore.assertTrue((boolean)this.memstore.shouldSeek(scan, Long.MIN_VALUE));
        scan.setTimeRange(8L, 12L);
        TestMemStore.assertTrue((boolean)this.memstore.shouldSeek(scan, Long.MIN_VALUE));
    }

    public void testUpsertMSLAB() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        this.memstore = new MemStore(conf, KeyValue.COMPARATOR);
        int ROW_SIZE = 2048;
        byte[] qualifier = new byte[ROW_SIZE - 4];
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        for (int i = 0; i < 3; ++i) {
            System.gc();
        }
        long usageBefore = bean.getHeapMemoryUsage().getUsed();
        long size = 0L;
        long ts = 0L;
        for (int newValue = 0; newValue < 1000; ++newValue) {
            for (int row = newValue; row < newValue + 1000; ++row) {
                byte[] rowBytes = Bytes.toBytes((int)row);
                size += this.memstore.updateColumnValue(rowBytes, FAMILY, qualifier, (long)newValue, ++ts);
            }
        }
        System.out.println("Wrote " + ts + " vals");
        for (int i = 0; i < 3; ++i) {
            System.gc();
        }
        long usageAfter = bean.getHeapMemoryUsage().getUsed();
        System.out.println("Memory used: " + (usageAfter - usageBefore) + " (heapsize: " + this.memstore.heapSize() + " size: " + size + ")");
    }

    private static byte[] makeQualifier(int i1, int i2) {
        return Bytes.toBytes((String)(Integer.toString(i1) + ";" + Integer.toString(i2)));
    }

    public void testUpsertMemstoreSize() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        this.memstore = new MemStore(conf, KeyValue.COMPARATOR);
        long oldSize = this.memstore.size.get();
        ArrayList<KeyValue> l = new ArrayList<KeyValue>();
        KeyValue kv1 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v");
        KeyValue kv2 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)101L, (String)"v");
        KeyValue kv3 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)102L, (String)"v");
        kv1.setMvccVersion(1L);
        kv2.setMvccVersion(1L);
        kv3.setMvccVersion(1L);
        l.add(kv1);
        l.add(kv2);
        l.add(kv3);
        this.memstore.upsert(l, 2L);
        long newSize = this.memstore.size.get();
        assert (newSize > oldSize);
        KeyValue kv4 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)104L, (String)"v");
        kv4.setMvccVersion(1L);
        l.clear();
        l.add(kv4);
        this.memstore.upsert(l, 3L);
        TestMemStore.assertEquals((long)newSize, (long)this.memstore.size.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateToTimeOfOldestEdit() throws Exception {
        try {
            EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            MemStore memstore = new MemStore();
            long t = memstore.timeOfOldestEdit();
            TestMemStore.assertEquals((long)t, (long)Long.MAX_VALUE);
            memstore.add(KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v"));
            t = memstore.timeOfOldestEdit();
            TestMemStore.assertTrue((t == 1234L ? 1 : 0) != 0);
            t = this.runSnapshot(memstore);
            memstore.delete(KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v"));
            t = memstore.timeOfOldestEdit();
            TestMemStore.assertTrue((t == 1234L ? 1 : 0) != 0);
            t = this.runSnapshot(memstore);
            ArrayList<KeyValue> l = new ArrayList<KeyValue>();
            KeyValue kv1 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v");
            kv1.setMvccVersion(100L);
            l.add(kv1);
            memstore.upsert(l, 1000L);
            t = memstore.timeOfOldestEdit();
            TestMemStore.assertTrue((t == 1234L ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    public void testShouldFlush() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 1000);
        this.checkShouldFlush(conf, true);
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 0);
        this.checkShouldFlush(conf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShouldFlush(Configuration conf, boolean expected) throws Exception {
        try {
            EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            HBaseTestingUtility hbaseUtility = HBaseTestingUtility.createLocalHTU(conf);
            HRegion region = hbaseUtility.createTestRegion("foobar", new HColumnDescriptor("foo"));
            Map stores = region.getStores();
            TestMemStore.assertTrue((stores.size() == 1 ? 1 : 0) != 0);
            Store s = (Store)stores.entrySet().iterator().next().getValue();
            edge.setCurrentTimeMillis(1234L);
            s.add(KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v"));
            edge.setCurrentTimeMillis(1334L);
            TestMemStore.assertTrue((!region.shouldFlush() ? 1 : 0) != 0);
            edge.setCurrentTimeMillis(11234L);
            TestMemStore.assertTrue((region.shouldFlush() == expected ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private int addRows(MemStore hmc) {
        return this.addRows(hmc, Long.MAX_VALUE);
    }

    private int addRows(MemStore hmc, long ts) {
        for (int i = 0; i < 10; ++i) {
            long timestamp = ts == Long.MAX_VALUE ? System.currentTimeMillis() : ts;
            for (int ii = 0; ii < 10; ++ii) {
                byte[] row = Bytes.toBytes((int)i);
                byte[] qf = TestMemStore.makeQualifier(i, ii);
                hmc.add(new KeyValue(row, FAMILY, qf, timestamp, qf));
            }
        }
        return 10;
    }

    private long runSnapshot(MemStore hmc) throws UnexpectedException {
        int oldHistorySize = hmc.getSnapshot().size();
        hmc.snapshot();
        KeyValueSkipListSet ss = hmc.getSnapshot();
        TestMemStore.assertTrue((String)"History size has not increased", (oldHistorySize < ss.size() ? 1 : 0) != 0);
        long t = this.memstore.timeOfOldestEdit();
        TestMemStore.assertTrue((String)"Time of oldest edit is not Long.MAX_VALUE", (t == Long.MAX_VALUE ? 1 : 0) != 0);
        hmc.clearSnapshot((SortedSet)ss);
        return t;
    }

    private void isExpectedRowWithoutTimestamps(int rowIndex, List<Cell> kvs) {
        int i = 0;
        for (Cell kv : kvs) {
            byte[] expectedColname = TestMemStore.makeQualifier(rowIndex, i++);
            TestMemStore.assertTrue((String)"Column name", (boolean)CellUtil.matchingQualifier((Cell)kv, (byte[])expectedColname));
            TestMemStore.assertTrue((String)"Content", (boolean)CellUtil.matchingValue((Cell)kv, (byte[])expectedColname));
        }
    }

    private KeyValue getDeleteKV(byte[] row) {
        return new KeyValue(row, Bytes.toBytes((String)"test_col"), null, Long.MAX_VALUE, KeyValue.Type.Delete, null);
    }

    private KeyValue getKV(byte[] row, byte[] value) {
        return new KeyValue(row, Bytes.toBytes((String)"test_col"), null, Long.MAX_VALUE, value);
    }

    private static void addRows(int count, MemStore mem) {
        long nanos = System.nanoTime();
        for (int i = 0; i < count; ++i) {
            if (i % 1000 == 0) {
                System.out.println(i + " Took for 1k usec: " + (System.nanoTime() - nanos) / 1000L);
                nanos = System.nanoTime();
            }
            long timestamp = System.currentTimeMillis();
            for (int ii = 0; ii < 10; ++ii) {
                byte[] row = Bytes.toBytes((int)i);
                byte[] qf = TestMemStore.makeQualifier(i, ii);
                mem.add(new KeyValue(row, FAMILY, qf, timestamp, qf));
            }
        }
    }

    static void doScan(MemStore ms, int iteration) throws IOException {
        long nanos = System.nanoTime();
        KeyValueScanner s = (KeyValueScanner)ms.getScanners().get(0);
        s.seek(KeyValue.createFirstOnRow((byte[])new byte[0]));
        System.out.println(iteration + " create/seek took: " + (System.nanoTime() - nanos) / 1000L);
        int cnt = 0;
        while (s.next() != null) {
            ++cnt;
        }
        System.out.println(iteration + " took usec: " + (System.nanoTime() - nanos) / 1000L + " for: " + cnt);
    }

    public static void main(String[] args) throws IOException {
        MultiVersionConsistencyControl mvcc = new MultiVersionConsistencyControl();
        MemStore ms = new MemStore();
        long n1 = System.nanoTime();
        TestMemStore.addRows(25000, ms);
        System.out.println("Took for insert: " + (System.nanoTime() - n1) / 1000L);
        System.out.println("foo");
        MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)mvcc);
        for (int i = 0; i < 50; ++i) {
            TestMemStore.doScan(ms, i);
        }
    }

    private class EnvironmentEdgeForMemstoreTest
    implements EnvironmentEdge {
        long t = 1234L;

        private EnvironmentEdgeForMemstoreTest() {
        }

        public long currentTimeMillis() {
            return this.t;
        }

        public void setCurrentTimeMillis(long t) {
            this.t = t;
        }
    }

    private static class ReadOwnWritesTester
    extends Thread {
        static final int NUM_TRIES = 1000;
        final byte[] row;
        final byte[] f = Bytes.toBytes((String)"family");
        final byte[] q1 = Bytes.toBytes((String)"q1");
        final MultiVersionConsistencyControl mvcc;
        final MemStore memstore;
        AtomicReference<Throwable> caughtException;

        public ReadOwnWritesTester(int id, MemStore memstore, MultiVersionConsistencyControl mvcc, AtomicReference<Throwable> caughtException) {
            this.mvcc = mvcc;
            this.memstore = memstore;
            this.caughtException = caughtException;
            this.row = Bytes.toBytes((int)id);
        }

        @Override
        public void run() {
            try {
                this.internalRun();
            }
            catch (Throwable t) {
                this.caughtException.compareAndSet(null, t);
            }
        }

        private void internalRun() throws IOException {
            for (long i = 0L; i < 1000L && this.caughtException.get() == null; ++i) {
                MultiVersionConsistencyControl.WriteEntry w = this.mvcc.beginMemstoreInsert();
                byte[] v = Bytes.toBytes((long)i);
                KeyValue kv = new KeyValue(this.row, this.f, this.q1, i, v);
                kv.setMvccVersion(w.getWriteNumber());
                this.memstore.add(kv);
                this.mvcc.completeMemstoreInsert(w);
                MultiVersionConsistencyControl.resetThreadReadPoint((MultiVersionConsistencyControl)this.mvcc);
                KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners().get(0);
                s.seek(kv);
                KeyValue ret = s.next();
                TestCase.assertNotNull((String)"Didnt find own write at all", (Object)ret);
                TestCase.assertEquals((String)"Didnt read own writes", (long)kv.getTimestamp(), (long)ret.getTimestamp());
            }
        }
    }
}

