/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MultiThreadedWriterBase;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.util.StringUtils;

public class MultiThreadedUpdater
extends MultiThreadedWriterBase {
    private static final Log LOG = LogFactory.getLog(MultiThreadedUpdater.class);
    private Set<HBaseUpdaterThread> updaters = new HashSet<HBaseUpdaterThread>();
    private MultiThreadedWriterBase writer = null;
    private boolean isBatchUpdate = false;
    private final double updatePercent;

    public MultiThreadedUpdater(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, double updatePercent) {
        super(dataGen, conf, tableName, "U");
        this.updatePercent = updatePercent;
    }

    public void setBatchUpdate(boolean isBatchUpdate) {
        this.isBatchUpdate = isBatchUpdate;
    }

    public void linkToWriter(MultiThreadedWriterBase writer) {
        this.writer = writer;
        writer.setTrackWroteKeys(true);
    }

    @Override
    public void start(long startKey, long endKey, int numThreads) throws IOException {
        super.start(startKey, endKey, numThreads);
        if (this.verbose) {
            LOG.debug((Object)("Updating keys [" + startKey + ", " + endKey + ")"));
        }
        for (int i = 0; i < numThreads; ++i) {
            HBaseUpdaterThread updater = new HBaseUpdaterThread(i);
            this.updaters.add(updater);
        }
        this.startThreads(this.updaters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextKeyToUpdate() {
        if (this.writer == null) {
            return this.nextKeyToWrite.getAndIncrement();
        }
        MultiThreadedUpdater multiThreadedUpdater = this;
        synchronized (multiThreadedUpdater) {
            if (this.nextKeyToWrite.get() >= this.endKey) {
                return this.endKey;
            }
            while (this.nextKeyToWrite.get() > this.writer.wroteUpToKey()) {
                Threads.sleepWithoutInterrupt((long)100L);
            }
            long k = this.nextKeyToWrite.getAndIncrement();
            if (this.writer.failedToWriteKey(k)) {
                this.failedKeySet.add(k);
                return this.getNextKeyToUpdate();
            }
            return k;
        }
    }

    @Override
    public void waitForFinish() {
        super.waitForFinish();
        System.out.println("Failed to update keys: " + this.failedKeySet.size());
        for (Long key : this.failedKeySet) {
            System.out.println("Failed to update key: " + key);
        }
    }

    public void mutate(HTable table, Mutation m, long keyBase) {
        this.mutate(table, m, keyBase, null, null, null, null);
    }

    public void mutate(HTable table, Mutation m, long keyBase, byte[] row, byte[] cf, byte[] q, byte[] v) {
        long start = System.currentTimeMillis();
        try {
            if (m instanceof Increment) {
                table.increment((Increment)m);
            } else if (m instanceof Append) {
                table.append((Append)m);
            } else if (m instanceof Put) {
                table.checkAndPut(row, cf, q, v, (Put)m);
            } else if (m instanceof Delete) {
                table.checkAndDelete(row, cf, q, v, (Delete)m);
            } else {
                throw new IllegalArgumentException("unsupported mutation " + m.getClass().getSimpleName());
            }
            this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - start);
        }
        catch (IOException e) {
            String exceptionInfo;
            this.failedKeySet.add(keyBase);
            if (e instanceof RetriesExhaustedWithDetailsException) {
                RetriesExhaustedWithDetailsException aggEx = (RetriesExhaustedWithDetailsException)((Object)e);
                exceptionInfo = aggEx.getExhaustiveDescription();
            } else {
                StringWriter stackWriter = new StringWriter();
                PrintWriter pw = new PrintWriter(stackWriter);
                e.printStackTrace(pw);
                pw.flush();
                exceptionInfo = StringUtils.stringifyException((Throwable)e);
            }
            LOG.error((Object)("Failed to mutate: " + keyBase + " after " + (System.currentTimeMillis() - start) + "ms; region information: " + this.getRegionDebugInfoSafe(table, m.getRow()) + "; errors: " + exceptionInfo));
        }
    }

    private class HBaseUpdaterThread
    extends Thread {
        private final HTable table;

        public HBaseUpdaterThread(int updaterId) throws IOException {
            this.setName(this.getClass().getSimpleName() + "_" + updaterId);
            this.table = new HTable(MultiThreadedUpdater.this.conf, MultiThreadedUpdater.this.tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long rowKeyBase;
                StringBuilder buf = new StringBuilder();
                byte[][] columnFamilies = MultiThreadedUpdater.this.dataGenerator.getColumnFamilies();
                while ((rowKeyBase = MultiThreadedUpdater.this.getNextKeyToUpdate()) < MultiThreadedUpdater.this.endKey) {
                    if ((double)RandomUtils.nextInt((int)100) < MultiThreadedUpdater.this.updatePercent) {
                        byte[] rowKey = MultiThreadedUpdater.this.dataGenerator.getDeterministicUniqueKey(rowKeyBase);
                        Increment inc = new Increment(rowKey);
                        Append app = new Append(rowKey);
                        MultiThreadedUpdater.this.numKeys.addAndGet(1L);
                        int columnCount = 0;
                        for (byte[] cf : columnFamilies) {
                            NavigableMap columnValues;
                            long cfHash = Arrays.hashCode(cf);
                            inc.addColumn(cf, LoadTestDataGenerator.INCREMENT, cfHash);
                            buf.setLength(0);
                            buf.append("#").append(Bytes.toString((byte[])LoadTestDataGenerator.INCREMENT));
                            buf.append(":").append(ClientProtos.MutationProto.MutationType.INCREMENT.getNumber());
                            app.add(cf, LoadTestDataGenerator.MUTATE_INFO, Bytes.toBytes((String)buf.toString()));
                            ++columnCount;
                            if (!MultiThreadedUpdater.this.isBatchUpdate) {
                                MultiThreadedUpdater.this.mutate(this.table, (Mutation)inc, rowKeyBase);
                                MultiThreadedUpdater.this.numCols.addAndGet(1L);
                                inc = new Increment(rowKey);
                                MultiThreadedUpdater.this.mutate(this.table, (Mutation)app, rowKeyBase);
                                MultiThreadedUpdater.this.numCols.addAndGet(1L);
                                app = new Append(rowKey);
                            }
                            Result result = null;
                            try {
                                Get get = new Get(rowKey);
                                get.addFamily(cf);
                                result = this.table.get(get);
                            }
                            catch (IOException ie) {
                                LOG.warn((Object)("Failed to get the row for key = [" + rowKey + "], column family = [" + Bytes.toString((byte[])cf) + "]"), (Throwable)ie);
                            }
                            NavigableMap navigableMap = columnValues = result != null ? result.getFamilyMap(cf) : null;
                            if (columnValues == null) {
                                MultiThreadedUpdater.this.failedKeySet.add(rowKeyBase);
                                LOG.error((Object)("Failed to update the row with key = [" + rowKey + "], since we could not get the original row"));
                            }
                            for (byte[] column : columnValues.keySet()) {
                                if (Bytes.equals((byte[])column, (byte[])LoadTestDataGenerator.INCREMENT) || Bytes.equals((byte[])column, (byte[])LoadTestDataGenerator.MUTATE_INFO)) continue;
                                ClientProtos.MutationProto.MutationType mt = ClientProtos.MutationProto.MutationType.valueOf((int)RandomUtils.nextInt((int)ClientProtos.MutationProto.MutationType.values().length));
                                long columnHash = Arrays.hashCode(column);
                                long hashCode = cfHash + columnHash;
                                byte[] hashCodeBytes = Bytes.toBytes((long)hashCode);
                                byte[] checkedValue = HConstants.EMPTY_BYTE_ARRAY;
                                if (hashCode % 2L == 0L) {
                                    Cell kv = result.getColumnLatestCell(cf, column);
                                    checkedValue = kv != null ? CellUtil.cloneValue((Cell)kv) : null;
                                    Preconditions.checkNotNull((Object)checkedValue, (Object)"Column value to be checked should not be null");
                                }
                                buf.setLength(0);
                                buf.append("#").append(Bytes.toString((byte[])column)).append(":");
                                ++columnCount;
                                switch (mt) {
                                    case PUT: {
                                        Put put = new Put(rowKey);
                                        put.add(cf, column, hashCodeBytes);
                                        MultiThreadedUpdater.this.mutate(this.table, (Mutation)put, rowKeyBase, rowKey, cf, column, checkedValue);
                                        buf.append(ClientProtos.MutationProto.MutationType.PUT.getNumber());
                                        break;
                                    }
                                    case DELETE: {
                                        Delete delete = new Delete(rowKey);
                                        delete.deleteColumns(cf, column);
                                        MultiThreadedUpdater.this.mutate(this.table, (Mutation)delete, rowKeyBase, rowKey, cf, column, checkedValue);
                                        buf.append(ClientProtos.MutationProto.MutationType.DELETE.getNumber());
                                        break;
                                    }
                                    default: {
                                        buf.append(ClientProtos.MutationProto.MutationType.APPEND.getNumber());
                                        app.add(cf, column, hashCodeBytes);
                                    }
                                }
                                app.add(cf, LoadTestDataGenerator.MUTATE_INFO, Bytes.toBytes((String)buf.toString()));
                                if (MultiThreadedUpdater.this.isBatchUpdate) continue;
                                MultiThreadedUpdater.this.mutate(this.table, (Mutation)app, rowKeyBase);
                                MultiThreadedUpdater.this.numCols.addAndGet(1L);
                                app = new Append(rowKey);
                            }
                        }
                        if (MultiThreadedUpdater.this.isBatchUpdate) {
                            if (MultiThreadedUpdater.this.verbose) {
                                LOG.debug((Object)("Preparing increment and append for key = [" + rowKey + "], " + columnCount + " columns"));
                            }
                            MultiThreadedUpdater.this.mutate(this.table, (Mutation)inc, rowKeyBase);
                            MultiThreadedUpdater.this.mutate(this.table, (Mutation)app, rowKeyBase);
                            MultiThreadedUpdater.this.numCols.addAndGet(columnCount);
                        }
                    }
                    if (!MultiThreadedUpdater.this.trackWroteKeys) continue;
                    MultiThreadedUpdater.this.wroteKeys.add(rowKeyBase);
                }
            }
            finally {
                try {
                    this.table.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Error closing table", (Throwable)e);
                }
                MultiThreadedUpdater.this.numThreadsWorking.decrementAndGet();
            }
        }
    }
}

