/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class ZNodeClearer {
    public static final Log LOG = LogFactory.getLog(ZNodeClearer.class);

    private ZNodeClearer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMyEphemeralNodeOnDisk(String fileContent) {
        FileWriter fstream;
        String fileName = ZNodeClearer.getMyEphemeralNodeFileName();
        if (fileName == null) {
            LOG.warn((Object)"Environment variable HBASE_ZNODE_FILE not set; znodes will not be cleared on crash by start scripts (Longer MTTR!)");
            return;
        }
        try {
            fstream = new FileWriter(fileName);
        }
        catch (IOException e) {
            LOG.warn((Object)("Can't write znode file " + fileName), (Throwable)e);
            return;
        }
        BufferedWriter out = new BufferedWriter(fstream);
        try {
            try {
                out.write(fileContent + "\n");
            }
            finally {
                try {
                    out.close();
                }
                finally {
                    fstream.close();
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Can't write znode file " + fileName), (Throwable)e);
        }
    }

    public static String readMyEphemeralNodeOnDisk() throws IOException {
        String fileName = ZNodeClearer.getMyEphemeralNodeFileName();
        if (fileName == null) {
            throw new FileNotFoundException("No filename; set environment variable HBASE_ZNODE_FILE");
        }
        FileReader znodeFile = new FileReader(fileName);
        BufferedReader br = new BufferedReader(znodeFile);
        String file_content = br.readLine();
        br.close();
        return file_content;
    }

    public static String getMyEphemeralNodeFileName() {
        return System.getenv().get("HBASE_ZNODE_FILE");
    }

    public static void deleteMyEphemeralNodeOnDisk() {
        String fileName = ZNodeClearer.getMyEphemeralNodeFileName();
        if (fileName != null) {
            new File(fileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clear(Configuration conf) {
        String znodeFileContent;
        ZooKeeperWatcher zkw;
        Configuration tempConf = new Configuration(conf);
        tempConf.setInt("zookeeper.recovery.retry", 0);
        try {
            zkw = new ZooKeeperWatcher(tempConf, "clean znode for master", new Abortable(){

                public void abort(String why, Throwable e) {
                }

                public boolean isAborted() {
                    return false;
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't connect to zookeeper to read the master znode", (Throwable)e);
            return false;
        }
        try {
            znodeFileContent = ZNodeClearer.readMyEphemeralNodeOnDisk();
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn((Object)"Can't find the znode file; presume non-fatal", (Throwable)fnfe);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't read the content of the znode file", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            zkw.close();
        }
        return MasterAddressTracker.deleteIfEquals((ZooKeeperWatcher)zkw, (String)znodeFileContent);
    }
}

