/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import com.google.protobuf.ByteString;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class Reference {
    private byte[] splitkey;
    private Range region;

    public static Reference createTopReference(byte[] splitRow) {
        return new Reference(splitRow, Range.top);
    }

    public static Reference createBottomReference(byte[] splitRow) {
        return new Reference(splitRow, Range.bottom);
    }

    Reference(byte[] splitRow, Range fr) {
        this.splitkey = splitRow == null ? null : KeyValue.createFirstOnRow((byte[])splitRow).getKey();
        this.region = fr;
    }

    @Deprecated
    public Reference() {
        this(null, Range.bottom);
    }

    public Range getFileRegion() {
        return this.region;
    }

    public byte[] getSplitKey() {
        return this.splitkey;
    }

    public String toString() {
        return "" + (Object)((Object)this.region);
    }

    public static boolean isTopFileRegion(Range r) {
        return r.equals((Object)Range.top);
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        boolean tmp = in.readBoolean();
        this.region = tmp ? Range.top : Range.bottom;
        this.splitkey = Bytes.readByteArray((DataInput)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path write(FileSystem fs, Path p) throws IOException {
        FSDataOutputStream out = fs.create(p, false);
        try {
            out.write(this.toByteArray());
        }
        finally {
            out.close();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reference read(FileSystem fs, Path p) throws IOException {
        Object in = fs.open(p);
        try {
            in = ((InputStream)in).markSupported() ? in : new BufferedInputStream((InputStream)in);
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ((InputStream)in).mark(pblen);
            byte[] pbuf = new byte[pblen];
            int read = ((InputStream)in).read(pbuf);
            if (read != pblen) {
                throw new IOException("read=" + read + ", wanted=" + pblen);
            }
            if (ProtobufUtil.isPBMagicPrefix((byte[])pbuf)) {
                Reference reference = Reference.convert(FSProtos.Reference.parseFrom((InputStream)in));
                return reference;
            }
            ((InputStream)in).reset();
            Reference r = new Reference();
            DataInputStream dis = new DataInputStream((InputStream)in);
            in = dis;
            r.readFields(dis);
            Reference reference = r;
            return reference;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    FSProtos.Reference convert() {
        FSProtos.Reference.Builder builder = FSProtos.Reference.newBuilder();
        builder.setRange(Reference.isTopFileRegion(this.getFileRegion()) ? FSProtos.Reference.Range.TOP : FSProtos.Reference.Range.BOTTOM);
        builder.setSplitkey(ByteString.copyFrom((byte[])this.getSplitKey()));
        return builder.build();
    }

    static Reference convert(FSProtos.Reference r) {
        Reference result = new Reference();
        result.splitkey = r.getSplitkey().toByteArray();
        result.region = r.getRange() == FSProtos.Reference.Range.TOP ? Range.top : Range.bottom;
        return result;
    }

    byte[] toByteArray() throws IOException {
        return ProtobufUtil.prependPBMagic((byte[])this.convert().toByteArray());
    }

    static enum Range {
        top,
        bottom;

    }
}

