/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class FileIOEngine
implements IOEngine {
    static final Log LOG = LogFactory.getLog(FileIOEngine.class);
    private FileChannel fileChannel = null;

    public FileIOEngine(String filePath, long fileSize) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filePath, "rw");
            raf.setLength(fileSize);
            this.fileChannel = raf.getChannel();
            LOG.info((Object)("Allocating " + StringUtils.byteDesc((long)fileSize) + ", on the path:" + filePath));
        }
        catch (FileNotFoundException fex) {
            LOG.error((Object)("Can't create bucket cache file " + filePath), (Throwable)fex);
            throw fex;
        }
        catch (IOException ioex) {
            LOG.error((Object)("Can't extend bucket cache file; insufficient space for " + StringUtils.byteDesc((long)fileSize)), (Throwable)ioex);
            if (raf != null) {
                raf.close();
            }
            throw ioex;
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public void read(ByteBuffer dstBuffer, long offset) throws IOException {
        this.fileChannel.read(dstBuffer, offset);
    }

    @Override
    public void write(ByteBuffer srcBuffer, long offset) throws IOException {
        this.fileChannel.write(srcBuffer, offset);
    }

    @Override
    public void sync() throws IOException {
        this.fileChannel.force(true);
    }

    @Override
    public void shutdown() {
        try {
            this.fileChannel.close();
        }
        catch (IOException ex) {
            LOG.error((Object)"Can't shutdown cleanly", (Throwable)ex);
        }
    }
}

