/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;
import org.cloudera.htrace.Trace;

@InterfaceAudience.Private
public class EnableTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(EnableTableHandler.class);
    private final TableName tableName;
    private final AssignmentManager assignmentManager;
    private final TableLockManager tableLockManager;
    private final CatalogTracker catalogTracker;
    private boolean retainAssignment = false;
    private TableLockManager.TableLock tableLock;

    public EnableTableHandler(Server server, TableName tableName, CatalogTracker catalogTracker, AssignmentManager assignmentManager, TableLockManager tableLockManager, boolean skipTableStateCheck) {
        super(server, EventType.C_M_ENABLE_TABLE);
        this.tableName = tableName;
        this.catalogTracker = catalogTracker;
        this.assignmentManager = assignmentManager;
        this.tableLockManager = tableLockManager;
        this.retainAssignment = skipTableStateCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableTableHandler prepare() throws TableNotFoundException, TableNotDisabledException, IOException {
        this.tableLock = this.tableLockManager.writeLock(this.tableName, EventType.C_M_ENABLE_TABLE.toString());
        this.tableLock.acquire();
        boolean success = false;
        try {
            if (!MetaReader.tableExists((CatalogTracker)this.catalogTracker, (TableName)this.tableName)) {
                if (!this.retainAssignment) {
                    throw new TableNotFoundException(this.tableName);
                }
                try {
                    this.assignmentManager.getZKTable().removeEnablingTable(this.tableName, true);
                }
                catch (KeeperException e) {
                    LOG.warn((Object)("Failed to delete the ENABLING node for the table " + this.tableName + ".  The table will remain unusable. Run HBCK to manually fix the problem."));
                }
            }
            if (!this.retainAssignment) {
                try {
                    if (!this.assignmentManager.getZKTable().checkDisabledAndSetEnablingTable(this.tableName)) {
                        LOG.info((Object)("Table " + this.tableName + " isn't disabled; skipping enable"));
                        throw new TableNotDisabledException(this.tableName);
                    }
                }
                catch (KeeperException e) {
                    throw new IOException("Unable to ensure that the table will be enabling because of a ZooKeeper issue", e);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.releaseTableLock();
            }
        }
        return this;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            LOG.info((Object)("Attempting to enable the table " + this.tableName));
            MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
            if (cpHost != null) {
                cpHost.preEnableTableHandler(this.tableName);
            }
            this.handleEnableTable();
            if (cpHost != null) {
                cpHost.postEnableTableHandler(this.tableName);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableName), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableName), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Error trying to enable the table " + this.tableName), (Throwable)e);
        }
        finally {
            this.releaseTableLock();
        }
    }

    private void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Could not release the table lock", (Throwable)ex);
            }
        }
    }

    private void handleEnableTable() throws IOException, KeeperException, InterruptedException {
        this.assignmentManager.getZKTable().setEnablingTable(this.tableName);
        boolean done = false;
        List tableRegionsAndLocations = MetaReader.getTableRegionsAndLocations((CatalogTracker)this.catalogTracker, (TableName)this.tableName, (boolean)true);
        int countOfRegionsInTable = tableRegionsAndLocations.size();
        List<HRegionInfo> regions = this.regionsToAssignWithServerName(tableRegionsAndLocations);
        int regionsCount = regions.size();
        if (regionsCount == 0) {
            done = true;
        }
        LOG.info((Object)("Table '" + this.tableName + "' has " + countOfRegionsInTable + " regions, of which " + regionsCount + " are offline."));
        BulkEnabler bd = new BulkEnabler(this.server, regions, countOfRegionsInTable, this.retainAssignment);
        try {
            if (bd.bulkAssign()) {
                done = true;
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Enable operation was interrupted when enabling table '" + this.tableName + "'"));
            Thread.currentThread().interrupt();
        }
        if (done) {
            this.assignmentManager.getZKTable().setEnabledTable(this.tableName);
            LOG.info((Object)("Table '" + this.tableName + "' was successfully enabled. Status: done=" + done));
        } else {
            LOG.warn((Object)("Table '" + this.tableName + "' wasn't successfully enabled. Status: done=" + done));
        }
    }

    private List<HRegionInfo> regionsToAssignWithServerName(List<Pair<HRegionInfo, ServerName>> regionsInMeta) throws IOException {
        ServerManager serverManager = ((HMaster)this.server).getServerManager();
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        for (Pair<HRegionInfo, ServerName> regionLocation : regionsInMeta) {
            HRegionInfo hri = (HRegionInfo)regionLocation.getFirst();
            ServerName sn = (ServerName)regionLocation.getSecond();
            if (regionStates.isRegionOffline(hri)) {
                if (this.retainAssignment && sn != null && serverManager.isServerOnline(sn)) {
                    this.assignmentManager.addPlan(hri.getEncodedName(), new RegionPlan(hri, null, sn));
                }
                regions.add(hri);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping assign for the region " + hri + " during enable table " + hri.getTable() + " because its already in tranition or assigned."));
        }
        return regions;
    }

    class BulkEnabler
    extends BulkAssigner {
        private final List<HRegionInfo> regions;
        private final int countOfRegionsInTable;
        private final boolean retainAssignment;

        BulkEnabler(Server server, List<HRegionInfo> regions, int countOfRegionsInTable, boolean retainAssignment) {
            super(server);
            this.regions = regions;
            this.countOfRegionsInTable = countOfRegionsInTable;
            this.retainAssignment = retainAssignment;
        }

        @Override
        protected void populatePool(ExecutorService pool) throws IOException {
            boolean roundRobinAssignment = this.server.getConfiguration().getBoolean("hbase.master.enabletable.roundrobin", false);
            if (this.retainAssignment || !roundRobinAssignment) {
                for (HRegionInfo region : this.regions) {
                    if (EnableTableHandler.this.assignmentManager.getRegionStates().isRegionInTransition(region)) continue;
                    final HRegionInfo hri = region;
                    pool.execute(Trace.wrap((String)"BulkEnabler.populatePool", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EnableTableHandler.this.assignmentManager.assign(hri, true);
                        }
                    }));
                }
            } else {
                try {
                    EnableTableHandler.this.assignmentManager.assign(this.regions);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Assignment was interrupted");
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        protected boolean waitUntilDone(long timeout) throws InterruptedException {
            long startTime = System.currentTimeMillis();
            long remaining = timeout;
            List<HRegionInfo> regions = null;
            int lastNumberOfRegions = 0;
            while (!this.server.isStopped() && remaining > 0L) {
                Thread.sleep(EnableTableHandler.this.waitingTimeForEvents);
                regions = EnableTableHandler.this.assignmentManager.getRegionStates().getRegionsOfTable(EnableTableHandler.this.tableName);
                if (this.isDone(regions)) break;
                if (regions.size() > lastNumberOfRegions) {
                    lastNumberOfRegions = regions.size();
                    timeout += (long)EnableTableHandler.this.waitingTimeForEvents;
                }
                remaining = timeout - (System.currentTimeMillis() - startTime);
            }
            return this.isDone(regions);
        }

        private boolean isDone(List<HRegionInfo> regions) {
            return regions != null && regions.size() >= this.countOfRegionsInTable;
        }
    }
}

