/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class AccessController
extends BaseRegionObserver
implements MasterObserver,
RegionServerObserver,
AccessControlProtos.AccessControlService.Interface,
CoprocessorService {
    public static final Log LOG = LogFactory.getLog(AccessController.class);
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + AccessController.class.getName()));
    TableAuthManager authManager = null;
    boolean aclRegion = false;
    private RegionCoprocessorEnvironment regionEnv;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();

    void initialize(RegionCoprocessorEnvironment e) throws IOException {
        HRegion region = e.getRegion();
        Map<byte[], ListMultimap<String, TablePermission>> tables = AccessControlLists.loadAll(region);
        for (Map.Entry<byte[], ListMultimap<String, TablePermission>> t : tables.entrySet()) {
            byte[] entry = t.getKey();
            ListMultimap<String, TablePermission> perms = t.getValue();
            byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, e.getConfiguration());
            this.authManager.getZKPermissionWatcher().writeToZookeeper(entry, serialized);
        }
    }

    void updateACL(RegionCoprocessorEnvironment e, Map<byte[], List<Cell>> familyMap) {
        TreeSet<byte[]> entries = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        for (Map.Entry<byte[], List<Cell>> f : familyMap.entrySet()) {
            List<Cell> cells = f.getValue();
            for (Cell cell : cells) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (!Bytes.equals((byte[])kv.getBuffer(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])AccessControlLists.ACL_LIST_FAMILY, (int)0, (int)AccessControlLists.ACL_LIST_FAMILY.length)) continue;
                entries.add(kv.getRow());
            }
        }
        ZKPermissionWatcher zkw = this.authManager.getZKPermissionWatcher();
        Configuration conf = this.regionEnv.getConfiguration();
        for (byte[] entry : entries) {
            try {
                ListMultimap<String, TablePermission> perms = AccessControlLists.getPermissions(conf, entry);
                byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, conf);
                zkw.writeToZookeeper(entry, serialized);
            }
            catch (IOException ex) {
                LOG.error((Object)("Failed updating permissions mirror for '" + Bytes.toString((byte[])entry) + "'"), (Throwable)ex);
            }
        }
    }

    AuthResult permissionGranted(String request, User user, Permission.Action permRequest, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families) {
        HRegionInfo hri = e.getRegion().getRegionInfo();
        TableName tableName = hri.getTable();
        if (hri.isMetaRegion() && permRequest == Permission.Action.READ) {
            return AuthResult.allow(request, "All users allowed", user, permRequest, tableName, families);
        }
        if (user == null) {
            return AuthResult.deny(request, "No user associated with request!", null, permRequest, tableName, families);
        }
        if (permRequest == Permission.Action.WRITE && (hri.isMetaRegion() || Bytes.equals((byte[])tableName.getName(), (byte[])AccessControlLists.ACL_GLOBAL_NAME)) && (this.authManager.authorize(user, Permission.Action.CREATE) || this.authManager.authorize(user, Permission.Action.ADMIN))) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (this.authManager.authorize(user, tableName, (byte[])null, permRequest)) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (families != null && families.size() > 0) {
            for (Map.Entry<byte[], Collection<?>> family : families.entrySet()) {
                if (this.authManager.authorize(user, tableName, family.getKey(), permRequest)) continue;
                if (family.getValue() != null && family.getValue().size() > 0) {
                    if (family.getValue() instanceof Set) {
                        Set familySet = (Set)family.getValue();
                        for (byte[] qualifier : familySet) {
                            if (this.authManager.authorize(user, tableName, family.getKey(), qualifier, permRequest)) continue;
                            return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), qualifier));
                        }
                        continue;
                    }
                    if (!(family.getValue() instanceof List)) continue;
                    List kvList = (List)family.getValue();
                    for (KeyValue kv : kvList) {
                        if (this.authManager.authorize(user, tableName, family.getKey(), kv.getQualifier(), permRequest)) continue;
                        return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), kv.getQualifier()));
                    }
                    continue;
                }
                return AuthResult.deny(request, "Failed family check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), null));
            }
            return AuthResult.allow(request, "All family checks passed", user, permRequest, tableName, families);
        }
        return AuthResult.deny(request, "No families to check and table permission failed", user, permRequest, tableName, families);
    }

    private void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            RequestContext ctx = RequestContext.get();
            InetAddress remoteAddr = null;
            if (ctx != null) {
                remoteAddr = ctx.getRemoteAddress();
            }
            AUDITLOG.trace((Object)("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; remote address: " + (remoteAddr != null ? remoteAddr : "") + "; request: " + result.getRequest() + "; context: " + result.toContextString()));
        }
    }

    private User getActiveUser() throws IOException {
        User user = RequestContext.getRequestUser();
        if (!RequestContext.isInRequestContext()) {
            user = User.getCurrent();
        }
        return user;
    }

    private void requirePermission(String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, family, qualifier, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, family, qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
        }
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private void requirePermission(String request, String namespace, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, namespace, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, namespace);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
        }
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private void requirePermission(String request, Permission.Action perm) throws IOException {
        this.requireGlobalPermission(request, perm, null, null);
    }

    private void requirePermission(String request, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<?>> families) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = this.permissionGranted(request, user, perm, env, families);
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + env.getRegion().getTableDesc().getTableName() + (families != null && families.size() > 0 ? ", family: " + result.toFamilyString() : "") + ", action=" + perm.toString() + ")");
        }
    }

    private void requireGlobalPermission(String request, Permission.Action perm, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        User user = this.getActiveUser();
        if (!this.authManager.authorize(user, perm)) {
            this.logResult(AuthResult.deny(request, "Global check failed", user, perm, tableName, familyMap));
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        this.logResult(AuthResult.allow(request, "Global check allowed", user, perm, tableName, familyMap));
    }

    private void requireGlobalPermission(String request, Permission.Action perm, String namespace) throws IOException {
        User user = this.getActiveUser();
        if (!this.authManager.authorize(user, perm)) {
            this.logResult(AuthResult.deny(request, "Global check failed", user, perm, namespace));
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        this.logResult(AuthResult.allow(request, "Global check allowed", user, perm, namespace));
    }

    private boolean hasFamilyQualifierPermission(User user, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Set<byte[]>> familyMap) throws IOException {
        HRegionInfo hri = env.getRegion().getRegionInfo();
        TableName tableName = hri.getTable();
        if (user == null) {
            return false;
        }
        if (familyMap != null && familyMap.size() > 0) {
            for (Map.Entry<byte[], ? extends Set<byte[]>> family : familyMap.entrySet()) {
                if (family.getValue() != null && !family.getValue().isEmpty()) {
                    for (byte[] qualifier : family.getValue()) {
                        if (!this.authManager.matchPermission(user, tableName, family.getKey(), qualifier, perm)) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.authManager.matchPermission(user, tableName, family.getKey(), perm)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Empty family map passed for permission check");
        }
        return false;
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        ZooKeeperWatcher zk = null;
        if (env instanceof MasterCoprocessorEnvironment) {
            MasterCoprocessorEnvironment mEnv = (MasterCoprocessorEnvironment)env;
            zk = mEnv.getMasterServices().getZooKeeper();
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            RegionServerCoprocessorEnvironment rsEnv = (RegionServerCoprocessorEnvironment)env;
            zk = rsEnv.getRegionServerServices().getZooKeeper();
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            zk = this.regionEnv.getRegionServerServices().getZooKeeper();
        }
        if (zk != null) {
            try {
                this.authManager = TableAuthManager.get(zk, env.getConfiguration());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error obtaining TableAuthManager", ioe);
            }
        } else {
            throw new RuntimeException("Error obtaining TableAuthManager, zk found null.");
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) {
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        Set families = desc.getFamiliesKeys();
        TreeMap familyMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (byte[] family : families) {
            familyMap.put(family, null);
        }
        this.requireGlobalPermission("createTable", Permission.Action.CREATE, desc.getTableName(), familyMap);
    }

    @Override
    public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (!AccessControlLists.isAclTable(desc)) {
            String owner = desc.getOwnerString();
            if (owner == null) {
                owner = this.getActiveUser().getShortName();
            }
            UserPermission userperm = new UserPermission(Bytes.toBytes((String)owner), desc.getTableName(), null, Permission.Action.values());
            AccessControlLists.addUserPermission(c.getEnvironment().getConfiguration(), userperm);
        }
    }

    @Override
    public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission("deleteTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName);
    }

    @Override
    public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        this.requirePermission("modifyTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        String owner = htd.getOwnerString();
        if (owner == null) {
            owner = this.getActiveUser().getShortName();
        }
        UserPermission userperm = new UserPermission(Bytes.toBytes((String)owner), htd.getTableName(), null, Permission.Action.values());
        AccessControlLists.addUserPermission(c.getEnvironment().getConfiguration(), userperm);
    }

    @Override
    public void postModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
        this.requirePermission("addColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void postAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        this.requirePermission("modifyColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void postModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        this.requirePermission("deleteColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
    }

    @Override
    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName, col);
    }

    @Override
    public void postDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
    }

    @Override
    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission("enableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (Bytes.equals((byte[])tableName.getName(), (byte[])AccessControlLists.ACL_GLOBAL_NAME)) {
            throw new AccessDeniedException("Not allowed to disable " + AccessControlLists.ACL_TABLE_NAME + " table.");
        }
        this.requirePermission("disableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission("move", region.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    @Override
    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("assign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
        this.requirePermission("unassign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    @Override
    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("regionOffline", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("balance", Permission.Action.ADMIN);
    }

    @Override
    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> c, List<RegionPlan> plans) throws IOException {
    }

    @Override
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission("balanceSwitch", Permission.Action.ADMIN);
        return newValue;
    }

    @Override
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean oldValue, boolean newValue) throws IOException {
    }

    @Override
    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("shutdown", Permission.Action.ADMIN);
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("stopMaster", Permission.Action.ADMIN);
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        AccessControlLists.init(ctx.getEnvironment().getMasterServices());
    }

    @Override
    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("snapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("clone", Permission.Action.ADMIN);
    }

    @Override
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("restore", Permission.Action.ADMIN);
    }

    @Override
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.requirePermission("deleteSnapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    @Override
    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission("createNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireGlobalPermission("deleteNamespace", Permission.Action.ADMIN, namespace);
    }

    @Override
    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        AccessControlLists.removeNamespacePermissions(ctx.getEnvironment().getConfiguration(), namespace);
        LOG.info((Object)(namespace + "entry deleted in " + AccessControlLists.ACL_TABLE_NAME + " table."));
    }

    @Override
    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission("modifyNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        RegionCoprocessorEnvironment env = e.getEnvironment();
        HRegion region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in preOpen()");
        } else {
            HRegionInfo regionInfo = region.getRegionInfo();
            if (this.isSpecialTable(regionInfo)) {
                this.isSystemOrSuperUser(this.regionEnv.getConfiguration());
            } else {
                this.requirePermission("preOpen", Permission.Action.ADMIN);
            }
        }
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        HRegion region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in postOpen()");
            return;
        }
        if (AccessControlLists.isAclRegion(region)) {
            this.aclRegion = true;
            try {
                this.initialize(env);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to initialize permissions cache", ex);
            }
        }
    }

    @Override
    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("flush", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e, byte[] splitRow) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType) throws IOException {
        this.requirePermission("compact", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
        return scanner;
    }

    @Override
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> e, Store store, List<StoreFile> candidates) throws IOException {
        this.requirePermission("compact", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        assert (family != null);
        this.requirePermission("getClosestRowBefore", Permission.Action.READ, c.getEnvironment(), this.makeFamilyMap(family, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        RegionCoprocessorEnvironment e = c.getEnvironment();
        User requestUser = this.getActiveUser();
        AuthResult authResult = this.permissionGranted("get", requestUser, Permission.Action.READ, e, get.getFamilyMap());
        if (authResult.isAllowed()) {
            this.logResult(authResult);
            return;
        }
        if (!this.hasFamilyQualifierPermission(requestUser, Permission.Action.READ, e, get.getFamilyMap())) {
            this.logResult(authResult);
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getTableName() + ", action=READ)");
        }
        TableName table = this.getTableName(e);
        AccessControlFilter filter = new AccessControlFilter(this.authManager, requestUser, table);
        if (get.getFilter() != null) {
            FilterList wrapper = new FilterList(FilterList.Operator.MUST_PASS_ALL, (List)Lists.newArrayList((Object[])new Filter[]{filter, get.getFilter()}));
            get.setFilter((Filter)wrapper);
        } else {
            get.setFilter((Filter)filter);
        }
        this.logResult(AuthResult.allow("get", "Access allowed with filter", requestUser, Permission.Action.READ, authResult.getTableName(), get.getFamilyMap()));
    }

    @Override
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        this.requirePermission("exists", Permission.Action.READ, c.getEnvironment(), get.getFamilyMap());
        return exists;
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        this.requirePermission("put", Permission.Action.WRITE, c.getEnvironment(), put.getFamilyCellMap());
    }

    @Override
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), put.getFamilyCellMap());
        }
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        this.requirePermission("delete", Permission.Action.WRITE, c.getEnvironment(), delete.getFamilyCellMap());
    }

    @Override
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), delete.getFamilyCellMap());
        }
    }

    @Override
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        Map<byte[], ? extends Collection<byte[]>> familyMap = this.makeFamilyMap(family, qualifier);
        this.requirePermission("checkAndPut", Permission.Action.READ, c.getEnvironment(), familyMap);
        this.requirePermission("checkAndPut", Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return result;
    }

    @Override
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        Map<byte[], ? extends Collection<byte[]>> familyMap = this.makeFamilyMap(family, qualifier);
        this.requirePermission("checkAndDelete", Permission.Action.READ, c.getEnvironment(), familyMap);
        this.requirePermission("checkAndDelete", Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return result;
    }

    @Override
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        Map<byte[], ? extends Collection<byte[]>> familyMap = this.makeFamilyMap(family, qualifier);
        this.requirePermission("incrementColumnValue", Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return -1L;
    }

    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        this.requirePermission("append", Permission.Action.WRITE, c.getEnvironment(), append.getFamilyCellMap());
        return null;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        TreeMap familyMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (Map.Entry entry : increment.getFamilyCellMap().entrySet()) {
            TreeSet qualifiers = Sets.newTreeSet((Comparator)Bytes.BYTES_COMPARATOR);
            for (Cell cell : (List)entry.getValue()) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                qualifiers.add(kv.getQualifier());
            }
            familyMap.put(entry.getKey(), qualifiers);
        }
        this.requirePermission("increment", Permission.Action.WRITE, c.getEnvironment(), familyMap);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        String string;
        RegionCoprocessorEnvironment e = c.getEnvironment();
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted("scannerOpen", user, Permission.Action.READ, e, scan.getFamilyMap());
        if (authResult.isAllowed()) {
            this.logResult(authResult);
            return s;
        }
        if (this.hasFamilyQualifierPermission(user, Permission.Action.READ, e, scan.getFamilyMap())) {
            TableName table = this.getTableName(e);
            AccessControlFilter filter = new AccessControlFilter(this.authManager, user, table);
            if (scan.hasFilter()) {
                FilterList wrapper = new FilterList(FilterList.Operator.MUST_PASS_ALL, (List)Lists.newArrayList((Object[])new Filter[]{filter, scan.getFilter()}));
                scan.setFilter((Filter)wrapper);
            } else {
                scan.setFilter((Filter)filter);
            }
            this.logResult(AuthResult.allow("scannerOpen", "Access allowed with filter", user, Permission.Action.READ, authResult.getTableName(), scan.getFamilyMap()));
            return s;
        }
        this.logResult(authResult);
        StringBuilder stringBuilder = new StringBuilder().append("Insufficient permissions for user '");
        if (user != null) {
            string = user.getShortName();
            throw new AccessDeniedException(stringBuilder.append(string).append("' ").append("for scanner open on table ").append(this.getTableName(e)).toString());
        }
        string = "null";
        throw new AccessDeniedException(stringBuilder.append(string).append("' ").append("for scanner open on table ").append(this.getTableName(e)).toString());
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = this.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (RequestContext.isInRequestContext()) {
            String requestUserName = RequestContext.getRequestUserName();
            String owner = this.scannerOwners.get(s);
            if (owner != null && !owner.equals(requestUserName)) {
                throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
            }
        }
    }

    @Override
    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        LinkedList cfs = new LinkedList();
        for (Pair<byte[], String> el : familyPaths) {
            this.requirePermission("preBulkLoadHFile", ctx.getEnvironment().getRegion().getTableDesc().getTableName(), (byte[])el.getFirst(), null, Permission.Action.WRITE);
        }
    }

    private AuthResult hasSomeAccess(RegionCoprocessorEnvironment e, String method, Permission.Action action) throws IOException {
        User requestUser = this.getActiveUser();
        TableName tableName = e.getRegion().getTableDesc().getTableName();
        AuthResult authResult = this.permissionGranted(method, requestUser, action, e, Collections.EMPTY_MAP);
        if (!authResult.isAllowed()) {
            for (UserPermission userPerm : AccessControlLists.getUserTablePermissions(this.regionEnv.getConfiguration(), tableName)) {
                for (Permission.Action userAction : userPerm.getActions()) {
                    if (!userAction.equals((Object)action)) continue;
                    return AuthResult.allow(method, "Access allowed", requestUser, action, tableName, null, null);
                }
            }
        }
        return authResult;
    }

    public void prePrepareBulkLoad(RegionCoprocessorEnvironment e) throws IOException {
        AuthResult authResult = this.hasSomeAccess(e, "prePrepareBulkLoad", Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getTableName() + ", action=WRITE)");
        }
    }

    public void preCleanupBulkLoad(RegionCoprocessorEnvironment e) throws IOException {
        AuthResult authResult = this.hasSomeAccess(e, "preCleanupBulkLoad", Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getTableName() + ", action=WRITE)");
        }
    }

    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        UserPermission perm = ProtobufUtil.toUserPermission((AccessControlProtos.UserPermission)request.getUserPermission());
        AccessControlProtos.GrantResponse response = null;
        try {
            if (this.aclRegion) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received request to grant access permission " + perm.toString()));
                }
                switch (request.getUserPermission().getPermission().getType()) {
                    case Global: 
                    case Table: {
                        this.requirePermission("grant", perm.getTableName(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
                        break;
                    }
                    case Namespace: {
                        this.requireGlobalPermission("grant", Permission.Action.ADMIN, perm.getNamespace());
                    }
                }
                AccessControlLists.addUserPermission(this.regionEnv.getConfiguration(), perm);
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace((Object)("Granted permission " + perm.toString()));
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.GrantResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        UserPermission perm = ProtobufUtil.toUserPermission((AccessControlProtos.UserPermission)request.getUserPermission());
        AccessControlProtos.RevokeResponse response = null;
        try {
            if (this.aclRegion) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received request to revoke access permission " + perm.toString()));
                }
                switch (request.getUserPermission().getPermission().getType()) {
                    case Global: 
                    case Table: {
                        this.requirePermission("revoke", perm.getTableName(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
                        break;
                    }
                    case Namespace: {
                        this.requireGlobalPermission("revoke", Permission.Action.ADMIN, perm.getNamespace());
                    }
                }
                AccessControlLists.removeUserPermission(this.regionEnv.getConfiguration(), perm);
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace((Object)("Revoked permission " + perm.toString()));
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.RevokeResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        AccessControlProtos.GetUserPermissionsResponse response = null;
        try {
            List<UserPermission> perms;
            if (this.aclRegion) {
                perms = null;
                if (request.getType() == AccessControlProtos.Permission.Type.Table) {
                    TableName table = null;
                    if (request.hasTableName()) {
                        table = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
                    }
                    this.requirePermission("userPermissions", table, null, null, Permission.Action.ADMIN);
                    perms = AccessControlLists.getUserTablePermissions(this.regionEnv.getConfiguration(), table);
                } else {
                    perms = request.getType() == AccessControlProtos.Permission.Type.Namespace ? AccessControlLists.getUserNamespacePermissions(this.regionEnv.getConfiguration(), request.getNamespaceName().toStringUtf8()) : AccessControlLists.getUserPermissions(this.regionEnv.getConfiguration(), null);
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = ResponseConverter.buildGetUserPermissionsResponse(perms);
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        Permission[] permissions = new Permission[request.getPermissionCount()];
        for (int i = 0; i < request.getPermissionCount(); ++i) {
            permissions[i] = ProtobufUtil.toPermission((AccessControlProtos.Permission)request.getPermission(i));
        }
        AccessControlProtos.CheckPermissionsResponse response = null;
        try {
            TableName tableName = this.regionEnv.getRegion().getTableDesc().getTableName();
            for (Permission permission : permissions) {
                if (permission instanceof TablePermission) {
                    TablePermission tperm = (TablePermission)permission;
                    for (Permission.Action action : permission.getActions()) {
                        if (!tperm.getTableName().equals((Object)tableName)) {
                            throw new CoprocessorException(AccessController.class, String.format("This method can only execute at the table specified in TablePermission. Table of the region:%s , requested table:%s", tableName, tperm.getTableName()));
                        }
                        TreeMap familyMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
                        if (tperm.getFamily() != null) {
                            if (tperm.getQualifier() != null) {
                                TreeSet qualifiers = Sets.newTreeSet((Comparator)Bytes.BYTES_COMPARATOR);
                                qualifiers.add(tperm.getQualifier());
                                familyMap.put(tperm.getFamily(), qualifiers);
                            } else {
                                familyMap.put(tperm.getFamily(), null);
                            }
                        }
                        this.requirePermission("checkPermissions", action, this.regionEnv, familyMap);
                    }
                    continue;
                }
                for (Permission.Action action : permission.getActions()) {
                    this.requirePermission("checkPermissions", action);
                }
            }
            response = AccessControlProtos.CheckPermissionsResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    @Override
    public Service getService() {
        return AccessControlProtos.AccessControlService.newReflectiveService((AccessControlProtos.AccessControlService.Interface)this);
    }

    private TableName getTableName(RegionCoprocessorEnvironment e) {
        HRegionInfo regionInfo;
        HRegion region = e.getRegion();
        TableName tableName = null;
        if (region != null && (regionInfo = region.getRegionInfo()) != null) {
            tableName = regionInfo.getTable();
        }
        return tableName;
    }

    @Override
    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        this.requirePermission("preClose", Permission.Action.ADMIN);
    }

    private void isSystemOrSuperUser(Configuration conf) throws IOException {
        User activeUser;
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        String currentUser = user.getShortName();
        List superusers = Lists.asList((Object)currentUser, (Object[])conf.getStrings("hbase.superuser", new String[0]));
        if (!superusers.contains((activeUser = this.getActiveUser()).getShortName())) {
            throw new AccessDeniedException("User '" + (user != null ? user.getShortName() : "null") + "is not system or super user.");
        }
    }

    private boolean isSpecialTable(HRegionInfo regionInfo) {
        TableName tableName = regionInfo.getTable();
        return tableName.equals((Object)AccessControlLists.ACL_TABLE_NAME) || tableName.equals((Object)TableName.NAMESPACE_TABLE_NAME) || tableName.equals((Object)TableName.META_TABLE_NAME);
    }

    @Override
    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        this.requirePermission("preStopRegionServer", Permission.Action.ADMIN);
    }

    private Map<byte[], ? extends Collection<byte[]>> makeFamilyMap(byte[] family, byte[] qualifier) {
        if (family == null) {
            return null;
        }
        TreeMap familyMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        familyMap.put(family, qualifier != null ? ImmutableSet.of((Object)qualifier) : null);
        return familyMap;
    }

    @Override
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
        if (tableNamesList == null || tableNamesList.isEmpty()) {
            this.requireGlobalPermission("getTableDescriptors", Permission.Action.ADMIN, null, null);
        } else {
            MasterServices masterServices = ctx.getEnvironment().getMasterServices();
            for (TableName tableName : tableNamesList) {
                try {
                    masterServices.checkTableModifiable(tableName);
                }
                catch (TableNotFoundException ex) {
                    continue;
                }
                catch (TableNotDisabledException ex) {
                    // empty catch block
                }
                this.requirePermission("getTableDescriptors", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
            }
        }
    }

    @Override
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
    }
}

