/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class TableAuthManager {
    private static Log LOG = LogFactory.getLog(TableAuthManager.class);
    private static TableAuthManager instance;
    private volatile PermissionCache<Permission> globalCache;
    private ConcurrentSkipListMap<TableName, PermissionCache<TablePermission>> tableCache = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, PermissionCache<TablePermission>> nsCache = new ConcurrentSkipListMap();
    private Configuration conf;
    private ZKPermissionWatcher zkperms;
    static Map<ZooKeeperWatcher, TableAuthManager> managerMap;

    private TableAuthManager(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        this.conf = conf;
        this.globalCache = this.initGlobal(conf);
        this.zkperms = new ZKPermissionWatcher(watcher, this, conf);
        try {
            this.zkperms.start();
        }
        catch (KeeperException ke) {
            LOG.error((Object)"ZooKeeper initialization failed", (Throwable)ke);
        }
    }

    private PermissionCache<Permission> initGlobal(Configuration conf) throws IOException {
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        PermissionCache<Permission> newCache = new PermissionCache<Permission>();
        String currentUser = user.getShortName();
        List superusers = Lists.asList((Object)currentUser, (Object[])conf.getStrings("hbase.superuser", new String[0]));
        if (superusers != null) {
            for (String name : superusers) {
                if (AccessControlLists.isGroupPrincipal(name)) {
                    newCache.putGroup(AccessControlLists.getGroupName(name), new Permission(Permission.Action.values()));
                    continue;
                }
                newCache.putUser(name, new Permission(Permission.Action.values()));
            }
        }
        return newCache;
    }

    public ZKPermissionWatcher getZKPermissionWatcher() {
        return this.zkperms;
    }

    public void refreshTableCacheFromWritable(TableName table, byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            ListMultimap<String, TablePermission> perms;
            try {
                perms = AccessControlLists.readPermissions(data, this.conf);
            }
            catch (DeserializationException e) {
                throw new IOException(e);
            }
            if (perms != null) {
                if (Bytes.equals((byte[])table.getName(), (byte[])AccessControlLists.ACL_GLOBAL_NAME)) {
                    this.updateGlobalCache(perms);
                } else {
                    this.updateTableCache(table, perms);
                }
            }
        } else {
            LOG.debug((Object)"Skipping permission cache refresh because writable data is empty");
        }
    }

    public void refreshNamespaceCacheFromWritable(String namespace, byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            ListMultimap<String, TablePermission> perms;
            try {
                perms = AccessControlLists.readPermissions(data, this.conf);
            }
            catch (DeserializationException e) {
                throw new IOException(e);
            }
            if (perms != null) {
                this.updateNsCache(namespace, perms);
            }
        } else {
            LOG.debug((Object)"Skipping permission cache refresh because writable data is empty");
        }
    }

    private void updateGlobalCache(ListMultimap<String, TablePermission> userPerms) {
        PermissionCache<Permission> newCache = null;
        try {
            newCache = this.initGlobal(this.conf);
            for (Map.Entry entry : userPerms.entries()) {
                if (AccessControlLists.isGroupPrincipal((String)entry.getKey())) {
                    newCache.putGroup(AccessControlLists.getGroupName((String)entry.getKey()), new Permission(((TablePermission)entry.getValue()).getActions()));
                    continue;
                }
                newCache.putUser((String)entry.getKey(), new Permission(((TablePermission)entry.getValue()).getActions()));
            }
            this.globalCache = newCache;
        }
        catch (IOException e) {
            LOG.error((Object)"Error occured while updating the global cache", (Throwable)e);
        }
    }

    private void updateTableCache(TableName table, ListMultimap<String, TablePermission> tablePerms) {
        PermissionCache<Permission> newTablePerms = new PermissionCache<Permission>();
        for (Map.Entry entry : tablePerms.entries()) {
            if (AccessControlLists.isGroupPrincipal((String)entry.getKey())) {
                newTablePerms.putGroup(AccessControlLists.getGroupName((String)entry.getKey()), (Permission)entry.getValue());
                continue;
            }
            newTablePerms.putUser((String)entry.getKey(), (Permission)entry.getValue());
        }
        this.tableCache.put(table, newTablePerms);
    }

    private void updateNsCache(String namespace, ListMultimap<String, TablePermission> tablePerms) {
        PermissionCache<Permission> newTablePerms = new PermissionCache<Permission>();
        for (Map.Entry entry : tablePerms.entries()) {
            if (AccessControlLists.isGroupPrincipal((String)entry.getKey())) {
                newTablePerms.putGroup(AccessControlLists.getGroupName((String)entry.getKey()), (Permission)entry.getValue());
                continue;
            }
            newTablePerms.putUser((String)entry.getKey(), (Permission)entry.getValue());
        }
        this.nsCache.put(namespace, newTablePerms);
    }

    private PermissionCache<TablePermission> getTablePermissions(TableName table) {
        if (!this.tableCache.containsKey(table)) {
            this.tableCache.putIfAbsent(table, new PermissionCache());
        }
        return this.tableCache.get(table);
    }

    private PermissionCache<TablePermission> getNamespacePermissions(String namespace) {
        if (!this.nsCache.containsKey(namespace)) {
            this.nsCache.putIfAbsent(namespace, new PermissionCache());
        }
        return this.nsCache.get(namespace);
    }

    private boolean authorize(List<Permission> perms, Permission.Action action) {
        if (perms != null) {
            for (Permission p : perms) {
                if (!p.implies(action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No permissions found");
        }
        return false;
    }

    public boolean authorize(User user, Permission.Action action) {
        if (user == null) {
            return false;
        }
        if (this.authorize(this.globalCache.getUser(user.getShortName()), action)) {
            return true;
        }
        String[] groups = user.getGroupNames();
        if (groups != null) {
            for (String group : groups) {
                if (!this.authorize(this.globalCache.getGroup(group), action)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean authorize(List<TablePermission> perms, TableName table, byte[] family, Permission.Action action) {
        return this.authorize(perms, table, family, null, action);
    }

    private boolean authorize(List<TablePermission> perms, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (perms != null) {
            for (TablePermission p : perms) {
                if (!p.implies(table, family, qualifier, action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No permissions found for table=" + table));
        }
        return false;
    }

    public boolean authorize(User user, TableName table, KeyValue kv, Permission.Action action) {
        PermissionCache<TablePermission> tablePerms = this.tableCache.get(table);
        if (tablePerms != null) {
            List<TablePermission> userPerms = tablePerms.getUser(user.getShortName());
            if (this.authorize(userPerms, table, kv, action)) {
                return true;
            }
            String[] groupNames = user.getGroupNames();
            if (groupNames != null) {
                for (String group : groupNames) {
                    List<TablePermission> groupPerms = tablePerms.getGroup(group);
                    if (!this.authorize(groupPerms, table, kv, action)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean authorize(List<TablePermission> perms, TableName table, KeyValue kv, Permission.Action action) {
        if (perms != null) {
            for (TablePermission p : perms) {
                if (!p.implies(table, kv, action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No permissions for authorize() check, table=" + table));
        }
        return false;
    }

    public boolean authorize(User user, String namespace, Permission.Action action) {
        if (this.authorizeUser(user.getShortName(), action)) {
            return true;
        }
        PermissionCache<TablePermission> tablePerms = this.nsCache.get(namespace);
        if (tablePerms != null) {
            List<TablePermission> userPerms = tablePerms.getUser(user.getShortName());
            if (this.authorize(userPerms, namespace, action)) {
                return true;
            }
            String[] groupNames = user.getGroupNames();
            if (groupNames != null) {
                for (String group : groupNames) {
                    List<TablePermission> groupPerms = tablePerms.getGroup(group);
                    if (!this.authorize(groupPerms, namespace, action)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean authorize(List<TablePermission> perms, String namespace, Permission.Action action) {
        if (perms != null) {
            for (TablePermission p : perms) {
                if (!p.implies(namespace, action)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No permissions for authorize() check, table=" + namespace));
        }
        return false;
    }

    public boolean authorizeUser(String username, Permission.Action action) {
        return this.authorize(this.globalCache.getUser(username), action);
    }

    public boolean authorizeUser(String username, TableName table, byte[] family, Permission.Action action) {
        return this.authorizeUser(username, table, family, null, action);
    }

    public boolean authorizeUser(String username, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (this.authorizeUser(username, action)) {
            return true;
        }
        if (table == null) {
            table = AccessControlLists.ACL_TABLE_NAME;
        }
        return this.authorize(this.getTablePermissions(table).getUser(username), table, family, qualifier, action);
    }

    public boolean authorizeGroup(String groupName, Permission.Action action) {
        return this.authorize(this.globalCache.getGroup(groupName), action);
    }

    public boolean authorizeGroup(String groupName, TableName table, byte[] family, Permission.Action action) {
        if (this.authorizeGroup(groupName, action)) {
            return true;
        }
        if (table == null) {
            table = AccessControlLists.ACL_TABLE_NAME;
        }
        return this.authorize(this.getTablePermissions(table).getGroup(groupName), table, family, action);
    }

    public boolean authorize(User user, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (this.authorizeUser(user.getShortName(), table, family, qualifier, action)) {
            return true;
        }
        String[] groups = user.getGroupNames();
        if (groups != null) {
            for (String group : groups) {
                if (!this.authorizeGroup(group, table, family, action)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean authorize(User user, TableName table, byte[] family, Permission.Action action) {
        return this.authorize(user, table, family, null, action);
    }

    public boolean matchPermission(User user, TableName table, byte[] family, Permission.Action action) {
        PermissionCache<TablePermission> tablePerms = this.tableCache.get(table);
        if (tablePerms != null) {
            String[] groups;
            List<TablePermission> userPerms = tablePerms.getUser(user.getShortName());
            if (userPerms != null) {
                for (TablePermission p : userPerms) {
                    if (!p.matchesFamily(table, family, action)) continue;
                    return true;
                }
            }
            if ((groups = user.getGroupNames()) != null) {
                for (String group : groups) {
                    List<TablePermission> groupPerms = tablePerms.getGroup(group);
                    if (groupPerms == null) continue;
                    for (TablePermission p : groupPerms) {
                        if (!p.matchesFamily(table, family, action)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean matchPermission(User user, TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        PermissionCache<TablePermission> tablePerms = this.tableCache.get(table);
        if (tablePerms != null) {
            String[] groups;
            List<TablePermission> userPerms = tablePerms.getUser(user.getShortName());
            if (userPerms != null) {
                for (TablePermission p : userPerms) {
                    if (!p.matchesFamilyQualifier(table, family, qualifier, action)) continue;
                    return true;
                }
            }
            if ((groups = user.getGroupNames()) != null) {
                for (String group : groups) {
                    List<TablePermission> groupPerms = tablePerms.getGroup(group);
                    if (groupPerms == null) continue;
                    for (TablePermission p : groupPerms) {
                        if (!p.matchesFamilyQualifier(table, family, qualifier, action)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void removeNamespace(byte[] ns) {
        this.nsCache.remove(ns);
    }

    public void removeTable(TableName table) {
        this.tableCache.remove(table);
    }

    public void setTableUserPermissions(String username, TableName table, List<TablePermission> perms) {
        PermissionCache<TablePermission> tablePerms = this.getTablePermissions(table);
        tablePerms.replaceUser(username, perms);
        this.writeTableToZooKeeper(table, tablePerms);
    }

    public void setTableGroupPermissions(String group, TableName table, List<TablePermission> perms) {
        PermissionCache<TablePermission> tablePerms = this.getTablePermissions(table);
        tablePerms.replaceGroup(group, perms);
        this.writeTableToZooKeeper(table, tablePerms);
    }

    public void setNamespaceUserPermissions(String username, String namespace, List<TablePermission> perms) {
        PermissionCache<TablePermission> tablePerms = this.getNamespacePermissions(namespace);
        tablePerms.replaceUser(username, perms);
        this.writeNamespaceToZooKeeper(namespace, tablePerms);
    }

    public void setNamespaceGroupPermissions(String group, String namespace, List<TablePermission> perms) {
        PermissionCache<TablePermission> tablePerms = this.getNamespacePermissions(namespace);
        tablePerms.replaceGroup(group, perms);
        this.writeNamespaceToZooKeeper(namespace, tablePerms);
    }

    public void writeTableToZooKeeper(TableName table, PermissionCache<TablePermission> tablePerms) {
        byte[] serialized = new byte[]{};
        if (tablePerms != null) {
            serialized = AccessControlLists.writePermissionsAsBytes(tablePerms.getAllPermissions(), this.conf);
        }
        this.zkperms.writeToZookeeper(table.getName(), serialized);
    }

    public void writeNamespaceToZooKeeper(String namespace, PermissionCache<TablePermission> tablePerms) {
        byte[] serialized = new byte[]{};
        if (tablePerms != null) {
            serialized = AccessControlLists.writePermissionsAsBytes(tablePerms.getAllPermissions(), this.conf);
        }
        this.zkperms.writeToZookeeper(Bytes.toBytes((String)AccessControlLists.toNamespaceEntry(namespace)), serialized);
    }

    public static synchronized TableAuthManager get(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        instance = managerMap.get(watcher);
        if (instance == null) {
            instance = new TableAuthManager(watcher, conf);
            managerMap.put(watcher, instance);
        }
        return instance;
    }

    static {
        managerMap = new HashMap<ZooKeeperWatcher, TableAuthManager>();
    }

    private static class PermissionCache<T extends Permission> {
        private ListMultimap<String, T> userCache = ArrayListMultimap.create();
        private ListMultimap<String, T> groupCache = ArrayListMultimap.create();

        private PermissionCache() {
        }

        public List<T> getUser(String user) {
            return this.userCache.get((Object)user);
        }

        public void putUser(String user, T perm) {
            this.userCache.put((Object)user, perm);
        }

        public List<T> replaceUser(String user, Iterable<? extends T> perms) {
            return this.userCache.replaceValues((Object)user, perms);
        }

        public List<T> getGroup(String group) {
            return this.groupCache.get((Object)group);
        }

        public void putGroup(String group, T perm) {
            this.groupCache.put((Object)group, perm);
        }

        public List<T> replaceGroup(String group, Iterable<? extends T> perms) {
            return this.groupCache.replaceValues((Object)group, perms);
        }

        public ListMultimap<String, T> getAllPermissions() {
            ArrayListMultimap tmp = ArrayListMultimap.create();
            tmp.putAll(this.userCache);
            for (String group : this.groupCache.keySet()) {
                tmp.putAll((Object)("@" + group), (Iterable)this.groupCache.get((Object)group));
            }
            return tmp;
        }
    }
}

