/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.google.protobuf.ZeroCopyLiteralByteString;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.protobuf.generated.CellMessage;
import org.codehaus.jackson.annotate.JsonProperty;

@XmlRootElement(name="Cell")
@XmlAccessorType(value=XmlAccessType.FIELD)
@InterfaceAudience.Private
public class CellModel
implements ProtobufMessageHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="column")
    @XmlAttribute
    private byte[] column;
    @JsonProperty(value="timestamp")
    @XmlAttribute
    private long timestamp = Long.MAX_VALUE;
    @JsonProperty(value="$")
    @XmlValue
    private byte[] value;

    public CellModel() {
    }

    public CellModel(byte[] column, byte[] value) {
        this(column, Long.MAX_VALUE, value);
    }

    public CellModel(byte[] column, byte[] qualifier, byte[] value) {
        this(column, qualifier, Long.MAX_VALUE, value);
    }

    public CellModel(KeyValue kv) {
        this(kv.getFamily(), kv.getQualifier(), kv.getTimestamp(), kv.getValue());
    }

    public CellModel(byte[] column, long timestamp, byte[] value) {
        this.column = column;
        this.timestamp = timestamp;
        this.value = value;
    }

    public CellModel(byte[] column, byte[] qualifier, long timestamp, byte[] value) {
        this.column = KeyValue.makeColumn((byte[])column, (byte[])qualifier);
        this.timestamp = timestamp;
        this.value = value;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public void setColumn(byte[] column) {
        this.column = column;
    }

    public boolean hasUserTimestamp() {
        return this.timestamp != Long.MAX_VALUE;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public byte[] createProtobufOutput() {
        CellMessage.Cell.Builder builder = CellMessage.Cell.newBuilder();
        builder.setColumn(ZeroCopyLiteralByteString.wrap((byte[])this.getColumn()));
        builder.setData(ZeroCopyLiteralByteString.wrap((byte[])this.getValue()));
        if (this.hasUserTimestamp()) {
            builder.setTimestamp(this.getTimestamp());
        }
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        CellMessage.Cell.Builder builder = CellMessage.Cell.newBuilder();
        builder.mergeFrom(message);
        this.setColumn(builder.getColumn().toByteArray());
        this.setValue(builder.getData().toByteArray());
        if (builder.hasTimestamp()) {
            this.setTimestamp(builder.getTimestamp());
        }
        return this;
    }
}

