/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSerialization {
    protected static final int MAXVERSIONS = 3;
    protected static final byte[] fam1 = Bytes.toBytes((String)"colfamily1");
    protected static final byte[] fam2 = Bytes.toBytes((String)"colfamily2");
    protected static final byte[] fam3 = Bytes.toBytes((String)"colfamily3");
    protected static final byte[][] COLUMNS = new byte[][]{fam1, fam2, fam3};

    @Test
    public void testKeyValue() throws Exception {
        String name = "testKeyValue2";
        byte[] row = "testKeyValue2".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf = "qf".getBytes();
        long ts = System.currentTimeMillis();
        byte[] val = "val".getBytes();
        KeyValue kv = new KeyValue(row, fam, qf, ts, val);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        long l = KeyValue.write((KeyValue)kv, (DataOutput)dos);
        dos.close();
        byte[] mb = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(mb);
        DataInputStream dis = new DataInputStream(bais);
        KeyValue deserializedKv = KeyValue.create((DataInput)dis);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getBuffer(), (byte[])deserializedKv.getBuffer()));
        Assert.assertEquals((long)kv.getOffset(), (long)deserializedKv.getOffset());
        Assert.assertEquals((long)kv.getLength(), (long)deserializedKv.getLength());
    }

    @Test
    public void testCreateKeyValueInvalidNegativeLength() {
        KeyValue kv_0 = new KeyValue(Bytes.toBytes((String)"myRow"), Bytes.toBytes((String)"myCF"), Bytes.toBytes((String)"myQualifier"), 12345L, Bytes.toBytes((String)"my12345"));
        KeyValue kv_1 = new KeyValue(Bytes.toBytes((String)"myRow"), Bytes.toBytes((String)"myCF"), Bytes.toBytes((String)"myQualifier"), 12345L, Bytes.toBytes((String)"my123"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        long l = 0L;
        try {
            l = KeyValue.oswrite((KeyValue)kv_0, (OutputStream)dos, (boolean)false);
            Assert.assertEquals((long)100L, (long)(l += KeyValue.oswrite((KeyValue)kv_1, (OutputStream)dos, (boolean)false)));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException" + e.getMessage()));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        try {
            KeyValue.create((DataInput)dis);
            Assert.assertTrue((boolean)kv_0.equals((Object)kv_1));
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception" + e.getMessage()));
        }
        try {
            KeyValue.create((int)-1, (DataInput)dis);
            Assert.fail((String)"Expected corrupt stream");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Failed read -1 bytes, stream corrupt?", (Object)e.getMessage());
        }
    }

    @Test
    public void testSplitLogTask() throws DeserializationException {
        SplitLogTask.Unassigned slt = new SplitLogTask.Unassigned(ServerName.valueOf((String)"mgr,1,1"));
        byte[] bytes = slt.toByteArray();
        SplitLogTask sltDeserialized = SplitLogTask.parseFrom((byte[])bytes);
        Assert.assertTrue((boolean)slt.equals((Object)sltDeserialized));
    }

    @Test
    public void testCompareFilter() throws Exception {
        RowFilter f = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        byte[] bytes = f.toByteArray();
        RowFilter ff = RowFilter.parseFrom((byte[])bytes);
        Assert.assertNotNull((Object)ff);
    }

    @Test
    public void testTableDescriptor() throws Exception {
        String name = "testTableDescriptor";
        HTableDescriptor htd = this.createTableDescriptor("testTableDescriptor");
        byte[] mb = Writables.getBytes((Writable)htd);
        HTableDescriptor deserializedHtd = (HTableDescriptor)Writables.getWritable((byte[])mb, (Writable)new HTableDescriptor());
        Assert.assertEquals((Object)htd.getTableName(), (Object)deserializedHtd.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionInfo() throws Exception {
        HRegionInfo hri = this.createRandomRegion("testRegionInfo");
        byte[] hrib = hri.toByteArray();
        HRegionInfo deserializedHri = HRegionInfo.parseFrom((byte[])hrib);
        Assert.assertEquals((Object)hri.getEncodedName(), (Object)deserializedHri.getEncodedName());
        Assert.assertEquals((Object)hri, (Object)deserializedHri);
        hrib = hri.toDelimitedByteArray();
        DataInputBuffer buf = new DataInputBuffer();
        try {
            buf.reset(hrib, hrib.length);
            deserializedHri = HRegionInfo.parseFrom((DataInputStream)buf);
            Assert.assertEquals((Object)hri.getEncodedName(), (Object)deserializedHri.getEncodedName());
            Assert.assertEquals((Object)hri, (Object)deserializedHri);
        }
        finally {
            buf.close();
        }
    }

    @Test
    public void testRegionInfos() throws Exception {
        HRegionInfo hri = this.createRandomRegion("testRegionInfos");
        byte[] triple = HRegionInfo.toDelimitedByteArray((HRegionInfo[])new HRegionInfo[]{hri, hri, hri});
        List regions = HRegionInfo.parseDelimitedFrom((byte[])triple, (int)0, (int)triple.length);
        Assert.assertTrue((regions.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((HRegionInfo)regions.get(0)).equals(regions.get(1)));
        Assert.assertTrue((boolean)((HRegionInfo)regions.get(0)).equals(regions.get(2)));
    }

    private HRegionInfo createRandomRegion(String name) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)name));
        String[] families = new String[]{"info", "anchor"};
        for (int i = 0; i < families.length; ++i) {
            htd.addFamily(new HColumnDescriptor(families[i]));
        }
        return new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
    }

    @Test
    public void testGet() throws Exception {
        byte[] row = "row".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        int maxVersions = 2;
        Get get = new Get(row);
        get.addColumn(fam, qf1);
        get.setTimeRange(ts, ts + 1L);
        get.setMaxVersions(maxVersions);
        ClientProtos.Get getProto = ProtobufUtil.toGet((Get)get);
        Get desGet = ProtobufUtil.toGet((ClientProtos.Get)getProto);
        Assert.assertTrue((boolean)Bytes.equals((byte[])get.getRow(), (byte[])desGet.getRow()));
        Set set = null;
        Set desSet = null;
        for (Map.Entry entry : get.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desGet.getFamilyMap().containsKey(entry.getKey()));
            set = (Set)entry.getValue();
            desSet = (Set)desGet.getFamilyMap().get(entry.getKey());
            for (byte[] qualifier : set) {
                Assert.assertTrue((boolean)desSet.contains(qualifier));
            }
        }
        Assert.assertEquals((long)get.getMaxVersions(), (long)desGet.getMaxVersions());
        TimeRange tr = get.getTimeRange();
        TimeRange desTr = desGet.getTimeRange();
        Assert.assertEquals((long)tr.getMax(), (long)desTr.getMax());
        Assert.assertEquals((long)tr.getMin(), (long)desTr.getMin());
    }

    @Test
    public void testScan() throws Exception {
        byte[] startRow = "startRow".getBytes();
        byte[] stopRow = "stopRow".getBytes();
        byte[] fam = "fam".getBytes();
        byte[] qf1 = "qf1".getBytes();
        long ts = System.currentTimeMillis();
        int maxVersions = 2;
        Scan scan = new Scan(startRow, stopRow);
        scan.addColumn(fam, qf1);
        scan.setTimeRange(ts, ts + 1L);
        scan.setMaxVersions(maxVersions);
        ClientProtos.Scan scanProto = ProtobufUtil.toScan((Scan)scan);
        Scan desScan = ProtobufUtil.toScan((ClientProtos.Scan)scanProto);
        Assert.assertTrue((boolean)Bytes.equals((byte[])scan.getStartRow(), (byte[])desScan.getStartRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])scan.getStopRow(), (byte[])desScan.getStopRow()));
        Assert.assertEquals((Object)scan.getCacheBlocks(), (Object)desScan.getCacheBlocks());
        Set set = null;
        Set desSet = null;
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            Assert.assertTrue((boolean)desScan.getFamilyMap().containsKey(entry.getKey()));
            set = (Set)entry.getValue();
            desSet = (Set)desScan.getFamilyMap().get(entry.getKey());
            for (byte[] column : set) {
                Assert.assertTrue((boolean)desSet.contains(column));
            }
            scan = new Scan(startRow);
            String name = "testScan";
            byte[] prefix = Bytes.toBytes((String)"testScan");
            scan.setFilter((Filter)new PrefixFilter(prefix));
            scanProto = ProtobufUtil.toScan((Scan)scan);
            desScan = ProtobufUtil.toScan((ClientProtos.Scan)scanProto);
            Filter f = desScan.getFilter();
            Assert.assertTrue((boolean)(f instanceof PrefixFilter));
        }
        Assert.assertEquals((long)scan.getMaxVersions(), (long)desScan.getMaxVersions());
        TimeRange tr = scan.getTimeRange();
        TimeRange desTr = desScan.getTimeRange();
        Assert.assertEquals((long)tr.getMax(), (long)desTr.getMax());
        Assert.assertEquals((long)tr.getMin(), (long)desTr.getMin());
    }

    protected HTableDescriptor createTableDescriptor(String name) {
        return this.createTableDescriptor(name, 3);
    }

    protected HTableDescriptor createTableDescriptor(String name, int versions) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)name));
        htd.addFamily(new HColumnDescriptor(fam1).setMaxVersions(versions).setBlockCacheEnabled(false));
        htd.addFamily(new HColumnDescriptor(fam2).setMaxVersions(versions).setBlockCacheEnabled(false));
        htd.addFamily(new HColumnDescriptor(fam3).setMaxVersions(versions).setBlockCacheEnabled(false));
        return htd;
    }
}

