/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.test.LoadTestKVGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestEncodedSeekers {
    private static final String TABLE_NAME = "encodedSeekersTable";
    private static final String CF_NAME = "encodedSeekersCF";
    private static final byte[] CF_BYTES = Bytes.toBytes((String)"encodedSeekersCF");
    private static final int MAX_VERSIONS = 5;
    private static final int BLOCK_SIZE = 65536;
    private static final int MIN_VALUE_SIZE = 30;
    private static final int MAX_VALUE_SIZE = 60;
    private static final int NUM_ROWS = 1003;
    private static final int NUM_COLS_PER_ROW = 20;
    private static final int NUM_HFILES = 4;
    private static final int NUM_ROWS_PER_FLUSH = 250;
    private final HBaseTestingUtility testUtil = HBaseTestingUtility.createLocalHTU();
    private final DataBlockEncoding encoding;
    private final boolean includeTags;
    private final boolean compressTags;
    private static final boolean VERBOSE = false;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            for (boolean includeTags : new boolean[]{false, true}) {
                for (boolean compressTags : new boolean[]{false, true}) {
                    paramList.add(new Object[]{encoding, includeTags, compressTags});
                }
            }
        }
        return paramList;
    }

    public TestEncodedSeekers(DataBlockEncoding encoding, boolean includeTags, boolean compressTags) {
        this.encoding = encoding;
        this.includeTags = includeTags;
        this.compressTags = compressTags;
    }

    @Test
    public void testEncodedSeeker() throws IOException {
        System.err.println("Testing encoded seekers for encoding : " + this.encoding + ", includeTags : " + this.includeTags + ", compressTags : " + this.compressTags);
        if (this.includeTags) {
            this.testUtil.getConfiguration().setInt("hfile.format.version", 3);
        }
        LruBlockCache cache = (LruBlockCache)new CacheConfig(this.testUtil.getConfiguration()).getBlockCache();
        cache.clearCache();
        HColumnDescriptor hcd = new HColumnDescriptor(CF_NAME).setMaxVersions(5).setDataBlockEncoding(this.encoding).setBlocksize(65536).setBloomFilterType(BloomType.NONE).setCompressTags(this.compressTags);
        HRegion region = this.testUtil.createTestRegion(TABLE_NAME, hcd);
        this.doPuts(region);
        this.doGets(region);
        region.compactStores();
        this.doGets(region);
        Map encodingCounts = cache.getEncodingCountsForTest();
        System.err.println("encodingCounts=" + encodingCounts);
        Assert.assertEquals((long)1L, (long)encodingCounts.size());
        DataBlockEncoding encodingInCache = (DataBlockEncoding)encodingCounts.keySet().iterator().next();
        Assert.assertEquals((Object)this.encoding, (Object)encodingInCache);
        Assert.assertTrue(((Integer)encodingCounts.get(encodingInCache) > 0 ? 1 : 0) != 0);
    }

    private void doPuts(HRegion region) throws IOException {
        LoadTestKVGenerator dataGenerator = new LoadTestKVGenerator(30, 60);
        for (int i = 0; i < 1003; ++i) {
            byte[] key = LoadTestKVGenerator.md5PrefixedKey((long)i).getBytes();
            for (int j = 0; j < 20; ++j) {
                Put put = new Put(key);
                byte[] col = Bytes.toBytes((String)String.valueOf(j));
                byte[] value = dataGenerator.generateRandomSizeValue((byte[][])new byte[][]{key, col});
                if (this.includeTags) {
                    Tag[] tag = new Tag[]{new Tag(1, "Visibility")};
                    KeyValue kv = new KeyValue(key, CF_BYTES, col, Long.MAX_VALUE, value, tag);
                    put.add((Cell)kv);
                } else {
                    put.add(CF_BYTES, col, value);
                }
                region.put(put);
            }
            if (i % 250 != 0) continue;
            region.flushcache();
        }
    }

    private void doGets(HRegion region) throws IOException {
        for (int i = 0; i < 1003; ++i) {
            byte[] rowKey = LoadTestKVGenerator.md5PrefixedKey((long)i).getBytes();
            for (int j = 0; j < 20; ++j) {
                String qualStr = String.valueOf(j);
                byte[] qualBytes = Bytes.toBytes((String)qualStr);
                Get get = new Get(rowKey);
                get.addColumn(CF_BYTES, qualBytes);
                Result result = region.get(get);
                Assert.assertEquals((long)1L, (long)result.size());
                byte[] value = result.getValue(CF_BYTES, qualBytes);
                Assert.assertTrue((boolean)LoadTestKVGenerator.verify((byte[])value, (byte[][])new byte[][]{rowKey, qualBytes}));
            }
        }
    }
}

