/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.TestHRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHRegionBusyWait
extends TestHRegion {
    @Override
    @Before
    public void setup() throws IOException {
        super.setup();
        CONF.set("hbase.busy.wait.duration", "1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=6000L)
    public void testRegionTooBusy() throws IOException {
        String method = "testRegionTooBusy";
        byte[] tableName = Bytes.toBytes((String)method);
        byte[] family = Bytes.toBytes((String)"family");
        this.region = TestHRegionBusyWait.initHRegion(tableName, method, CONF, (byte[][])new byte[][]{family});
        final AtomicBoolean stopped = new AtomicBoolean(true);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TestHRegionBusyWait.this.region.lock.writeLock().lock();
                    stopped.set(false);
                    while (!stopped.get()) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    TestHRegionBusyWait.this.region.lock.writeLock().unlock();
                }
            }
        });
        t.start();
        Get get = new Get(this.row);
        try {
            while (stopped.get()) {
                Thread.sleep(100L);
            }
            this.region.get(get);
            Assert.fail((String)"Should throw RegionTooBusyException");
        }
        catch (InterruptedException ie) {
            Assert.fail((String)"test interrupted");
        }
        catch (RegionTooBusyException e) {
        }
        finally {
            stopped.set(true);
            try {
                t.join();
            }
            catch (Throwable e) {}
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }
}

