/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFSUtils {
    @Test
    public void testMatchingTail() throws IOException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        FileSystem fs = htu.getTestFileSystem();
        Path rootdir = htu.getDataTestDir();
        Assert.assertTrue((rootdir.depth() > 1 ? 1 : 0) != 0);
        Path partPath = new Path("a", "b");
        Path fullPath = new Path(rootdir, partPath);
        Path fullyQualifiedPath = fs.makeQualified(fullPath);
        Assert.assertFalse((boolean)FSUtils.isMatchingTail((Path)fullPath, (Path)partPath));
        Assert.assertFalse((boolean)FSUtils.isMatchingTail((Path)fullPath, (String)partPath.toString()));
        Assert.assertTrue((boolean)FSUtils.isStartingWithPath((Path)rootdir, (String)fullPath.toString()));
        Assert.assertTrue((boolean)FSUtils.isStartingWithPath((Path)fullyQualifiedPath, (String)fullPath.toString()));
        Assert.assertFalse((boolean)FSUtils.isStartingWithPath((Path)rootdir, (String)partPath.toString()));
        Assert.assertFalse((boolean)FSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)partPath));
        Assert.assertTrue((boolean)FSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)fullPath));
        Assert.assertTrue((boolean)FSUtils.isMatchingTail((Path)fullyQualifiedPath, (String)fullPath.toString()));
        Assert.assertTrue((boolean)FSUtils.isMatchingTail((Path)fullyQualifiedPath, (Path)fs.makeQualified(fullPath)));
        Assert.assertTrue((boolean)FSUtils.isStartingWithPath((Path)rootdir, (String)fullyQualifiedPath.toString()));
        Assert.assertFalse((boolean)FSUtils.isMatchingTail((Path)fullPath, (Path)new Path("x")));
        Assert.assertFalse((boolean)FSUtils.isMatchingTail((Path)new Path("x"), (Path)fullPath));
    }

    @Test
    public void testVersion() throws DeserializationException, IOException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        FileSystem fs = htu.getTestFileSystem();
        Path rootdir = htu.getDataTestDir();
        Assert.assertNull((Object)FSUtils.getVersion((FileSystem)fs, (Path)rootdir));
        Path versionFile = new Path(rootdir, "hbase.version");
        FSDataOutputStream s = fs.create(versionFile);
        String version = "8";
        s.writeUTF("8");
        s.close();
        Assert.assertTrue((boolean)fs.exists(versionFile));
        FileStatus[] status = fs.listStatus(versionFile);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((status.length > 0 ? 1 : 0) != 0);
        String newVersion = FSUtils.getVersion((FileSystem)fs, (Path)rootdir);
        Assert.assertEquals((long)"8".length(), (long)newVersion.length());
        Assert.assertEquals((Object)"8", (Object)newVersion);
        Assert.assertEquals((Object)"8", (Object)FSUtils.getVersion((FileSystem)fs, (Path)rootdir));
        FSUtils.checkVersion((FileSystem)fs, (Path)rootdir, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsHDFS() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        htu.getConfiguration().setBoolean("dfs.support.append", false);
        Assert.assertFalse((boolean)FSUtils.isHDFS((Configuration)htu.getConfiguration()));
        htu.getConfiguration().setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = null;
        try {
            cluster = htu.startMiniDFSCluster(1);
            Assert.assertTrue((boolean)FSUtils.isHDFS((Configuration)htu.getConfiguration()));
            Assert.assertTrue((boolean)FSUtils.isAppendSupported((Configuration)htu.getConfiguration()));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void WriteDataToHDFS(FileSystem fs, Path file, int dataSize) throws Exception {
        FSDataOutputStream out = fs.create(file);
        byte[] data = new byte[dataSize];
        out.write(data, 0, dataSize);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testcomputeHDFSBlocksDistribution() throws Exception {
        FileStatus status;
        long maxTime;
        FileSystem fs;
        String[] hosts;
        HBaseTestingUtility htu = new HBaseTestingUtility();
        int DEFAULT_BLOCK_SIZE = 1024;
        htu.getConfiguration().setLong("dfs.block.size", 1024L);
        MiniDFSCluster cluster = null;
        Path testFile = null;
        try {
            boolean ok;
            hosts = new String[]{"host1", "host2", "host3"};
            cluster = htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test1.txt");
            this.WriteDataToHDFS(fs, testFile, 2048);
            maxTime = System.currentTimeMillis() + 2000L;
            do {
                ok = true;
                status = fs.getFileStatus(testFile);
                HDFSBlocksDistribution blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, (FileStatus)status, (long)0L, (long)status.getLen());
                long uniqueBlocksTotalWeight = blocksDistribution.getUniqueBlocksTotalWeight();
                for (String host : hosts) {
                    long weight = blocksDistribution.getWeight(host);
                    ok = ok && uniqueBlocksTotalWeight == weight;
                }
            } while (!ok && System.currentTimeMillis() < maxTime);
            Assert.assertTrue((boolean)ok);
        }
        finally {
            htu.shutdownMiniDFSCluster();
        }
        try {
            String tophost;
            long weight;
            FileStatus status2;
            HDFSBlocksDistribution blocksDistribution;
            long uniqueBlocksTotalWeight;
            hosts = new String[]{"host1", "host2", "host3", "host4"};
            cluster = htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test2.txt");
            this.WriteDataToHDFS(fs, testFile, 3072);
            maxTime = System.currentTimeMillis() + 2000L;
            while ((uniqueBlocksTotalWeight = (blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, (FileStatus)(status2 = fs.getFileStatus(testFile)), (long)0L, (long)status2.getLen())).getUniqueBlocksTotalWeight()) != (weight = blocksDistribution.getWeight(tophost = (String)blocksDistribution.getTopHosts().get(0))) && System.currentTimeMillis() < maxTime) {
            }
            Assert.assertTrue((uniqueBlocksTotalWeight == weight ? 1 : 0) != 0);
        }
        finally {
            htu.shutdownMiniDFSCluster();
        }
        try {
            HDFSBlocksDistribution blocksDistribution;
            hosts = new String[]{"host1", "host2", "host3", "host4"};
            cluster = htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test3.txt");
            this.WriteDataToHDFS(fs, testFile, 1024);
            maxTime = System.currentTimeMillis() + 2000L;
            while ((blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, (FileStatus)(status = fs.getFileStatus(testFile)), (long)0L, (long)status.getLen())).getTopHosts().size() != 3 && System.currentTimeMillis() < maxTime) {
            }
            Assert.assertEquals((String)"Wrong number of hosts distributing blocks.", (long)3L, (long)blocksDistribution.getTopHosts().size());
        }
        finally {
            htu.shutdownMiniDFSCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPermMask() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.data.umask.enable", true);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FsPermission defaultPerms = FSUtils.getFilePermissions((FileSystem)fs, (Configuration)conf, (String)"hbase.data.umask");
        Assert.assertEquals((Object)FsPermission.getDefault(), (Object)defaultPerms);
        conf.setStrings("hbase.data.umask", new String[]{"077"});
        FsPermission filePerm = FSUtils.getFilePermissions((FileSystem)fs, (Configuration)conf, (String)"hbase.data.umask");
        Assert.assertEquals((Object)new FsPermission("700"), (Object)filePerm);
        Path p = new Path("target" + File.separator + UUID.randomUUID().toString());
        try {
            FSDataOutputStream out = FSUtils.create((FileSystem)fs, (Path)p, (FsPermission)filePerm, null);
            out.close();
            FileStatus stat = fs.getFileStatus(p);
            Assert.assertEquals((Object)new FsPermission("700"), (Object)stat.getPermission());
        }
        finally {
            fs.delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAndExists() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        Configuration conf = htu.getConfiguration();
        conf.setBoolean("hbase.data.umask.enable", true);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FsPermission perms = FSUtils.getFilePermissions((FileSystem)fs, (Configuration)conf, (String)"hbase.data.umask");
        String file = UUID.randomUUID().toString();
        Path p = new Path(htu.getDataTestDir(), "temptarget" + File.separator + file);
        Path p1 = new Path(htu.getDataTestDir(), "temppath" + File.separator + file);
        try {
            FSDataOutputStream out = FSUtils.create((FileSystem)fs, (Path)p, (FsPermission)perms, null);
            out.close();
            Assert.assertTrue((String)"The created file should be present", (boolean)FSUtils.isExists((FileSystem)fs, (Path)p));
            FSUtils.delete((FileSystem)fs, (Path)p, (boolean)false);
            FSDataOutputStream out1 = FSUtils.create((FileSystem)fs, (Path)p1, (FsPermission)perms, null);
            out1.close();
            FSUtils.delete((FileSystem)fs, (Path)p1, (boolean)true);
            Assert.assertFalse((String)"The created file should be present", (boolean)FSUtils.isExists((FileSystem)fs, (Path)p1));
        }
        finally {
            FSUtils.delete((FileSystem)fs, (Path)p, (boolean)true);
            FSUtils.delete((FileSystem)fs, (Path)p1, (boolean)true);
        }
    }

    @Test
    public void testRenameAndSetModifyTime() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        Configuration conf = htu.getConfiguration();
        MiniDFSCluster cluster = htu.startMiniDFSCluster(1);
        Assert.assertTrue((boolean)FSUtils.isHDFS((Configuration)conf));
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testDir = htu.getDataTestDirOnTestFS("testArchiveFile");
        String file = UUID.randomUUID().toString();
        Path p = new Path(testDir, file);
        FSDataOutputStream out = fs.create(p);
        out.close();
        Assert.assertTrue((String)"The created file should be present", (boolean)FSUtils.isExists((FileSystem)fs, (Path)p));
        long expect = System.currentTimeMillis() + 1000L;
        Assert.assertNotEquals((long)expect, (long)fs.getFileStatus(p).getModificationTime());
        ManualEnvironmentEdge mockEnv = new ManualEnvironmentEdge();
        mockEnv.setValue(expect);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)mockEnv);
        String dstFile = UUID.randomUUID().toString();
        Path dst = new Path(testDir, dstFile);
        Assert.assertTrue((boolean)FSUtils.renameAndSetModifyTime((FileSystem)fs, (Path)p, (Path)dst));
        Assert.assertFalse((String)"The moved file should not be present", (boolean)FSUtils.isExists((FileSystem)fs, (Path)p));
        Assert.assertTrue((String)"The dst file should be present", (boolean)FSUtils.isExists((FileSystem)fs, (Path)dst));
        Assert.assertEquals((long)expect, (long)fs.getFileStatus(dst).getModificationTime());
        cluster.shutdown();
    }
}

