/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.util.HBaseHomePath;
import org.apache.hadoop.hbase.util.ProcessBasedLocalHBaseCluster;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestProcessBasedCluster {
    private static final Log LOG = LogFactory.getLog(TestProcessBasedCluster.class);
    private static final int COLS_PER_ROW = 5;
    private static final int FLUSHES = 5;
    private static final int NUM_REGIONS = 5;
    private static final int ROWS_PER_FLUSH = 5;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    public void testProcessBasedCluster() throws Exception {
        ProcessBasedLocalHBaseCluster cluster = new ProcessBasedLocalHBaseCluster(TEST_UTIL.getConfiguration(), 2, 3);
        cluster.startMiniDFS();
        cluster.startHBase();
        try {
            Result result;
            TEST_UTIL.createRandomTable("MyTestTable", HTestConst.DEFAULT_CF_STR_SET, 1, 5, 5, 5, 5);
            HTable table = new HTable(TEST_UTIL.getConfiguration(), HTestConst.DEFAULT_TABLE_BYTES);
            ResultScanner scanner = table.getScanner(HTestConst.DEFAULT_CF_BYTES);
            int rows = 0;
            int cols = 0;
            while ((result = scanner.next()) != null) {
                ++rows;
                cols += result.getFamilyMap(HTestConst.DEFAULT_CF_BYTES).size();
            }
            LOG.info((Object)("Read " + rows + " rows, " + cols + " columns"));
            scanner.close();
            table.close();
            Assert.assertEquals((long)19L, (long)rows);
            Assert.assertEquals((long)35L, (long)cols);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw ex;
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testHomePath() {
        File pom = new File(HBaseHomePath.getHomePath(), "pom.xml");
        Assert.assertTrue((String)(pom.getPath() + " does not exist"), (boolean)pom.exists());
    }
}

