/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.util.hbck.OfflineMetaRebuildTestCore;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestOfflineMetaRebuildBase
extends OfflineMetaRebuildTestCore {
    @Test(timeout=120000L)
    public void testMetaRebuild() throws Exception {
        this.wipeOutMeta();
        Assert.assertEquals((long)1L, (long)this.scanMeta());
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        this.TEST_UTIL.shutdownMiniZKCluster();
        HConnectionManager.deleteConnection((Configuration)this.conf);
        HBaseFsck fsck = new HBaseFsck(this.conf);
        Assert.assertTrue((boolean)fsck.rebuildMeta(false));
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.restartHBaseCluster(3);
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(this.TEST_UTIL);
        LOG.info((Object)"Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        LOG.info((Object)"No more RIT in ZK, now doing final test verification");
        Assert.assertEquals((long)5L, (long)this.scanMeta());
        Object[] htbls = this.TEST_UTIL.getHBaseAdmin().listTables();
        LOG.info((Object)("Tables present after restart: " + Arrays.toString(htbls)));
        Assert.assertEquals((long)1L, (long)htbls.length);
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
        LOG.info((Object)("Table " + this.table + " has " + this.tableRowCount(this.conf, this.table) + " entries."));
        Assert.assertEquals((long)16L, (long)this.tableRowCount(this.conf, this.table));
    }
}

