/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.RegionInRecoveryException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterWrapper;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.ipc.CallerDisconnectedException;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MetricsRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapperImpl;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.MultiRowMutationProcessor;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransaction;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.ReversedRegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.RowProcessor;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HashedBytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.util.StringUtils;
import org.cliffc.high_scale_lib.Counter;

@InterfaceAudience.Private
public class HRegion
implements HeapSize {
    public static final Log LOG = LogFactory.getLog(HRegion.class);
    public static final String LOAD_CFS_ON_DEMAND_CONFIG_KEY = "hbase.hregion.scan.loadColumnFamiliesOnDemand";
    private static final Durability DEFAULT_DURABLITY = Durability.SYNC_WAL;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean closing = new AtomicBoolean(false);
    protected volatile long completeSequenceId = -1L;
    private final AtomicLong sequenceId = new AtomicLong(-1L);
    private final ConcurrentHashMap<HashedBytes, RowLockContext> lockedRows = new ConcurrentHashMap();
    protected final Map<byte[], Store> stores = new ConcurrentSkipListMap<byte[], Store>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    private Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    public final AtomicLong memstoreSize = new AtomicLong(0L);
    final Counter numMutationsWithoutWAL = new Counter();
    final Counter dataInMemoryWithoutWAL = new Counter();
    final Counter checkAndMutateChecksPassed = new Counter();
    final Counter checkAndMutateChecksFailed = new Counter();
    final Counter readRequestsCount = new Counter();
    final Counter writeRequestsCount = new Counter();
    final AtomicLong compactionsFinished = new AtomicLong(0L);
    final AtomicLong compactionNumFilesCompacted = new AtomicLong(0L);
    final AtomicLong compactionNumBytesCompacted = new AtomicLong(0L);
    private final HLog log;
    private final HRegionFileSystem fs;
    protected final Configuration conf;
    private final Configuration baseConf;
    private final KeyValue.KVComparator comparator;
    private final int rowLockWaitDuration;
    static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;
    final long busyWaitDuration;
    static final long DEFAULT_BUSY_WAIT_DURATION = HConstants.DEFAULT_HBASE_RPC_TIMEOUT;
    final int maxBusyWaitMultiplier;
    final long maxBusyWaitDuration;
    static final long DEFAULT_ROW_PROCESSOR_TIMEOUT = 60000L;
    final ExecutorService rowProcessorExecutor = Executors.newCachedThreadPool();
    private final ConcurrentHashMap<RegionScanner, Long> scannerReadPoints;
    private long openSeqNum = -1L;
    private boolean isLoadingCfsOnDemandDefault = false;
    private final AtomicInteger majorInProgress = new AtomicInteger(0);
    private final AtomicInteger minorInProgress = new AtomicInteger(0);
    Map<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private boolean disallowWritesInRecovering = false;
    private volatile boolean isRecovering = false;
    final WriteState writestate = new WriteState();
    long memstoreFlushSize;
    final long timestampSlop;
    final long rowProcessorTimeout;
    private volatile long lastFlushTime;
    final RegionServerServices rsServices;
    private RegionServerAccounting rsAccounting;
    private List<Pair<Long, Long>> recentFlushes = new ArrayList<Pair<Long, Long>>();
    private long flushCheckInterval;
    private long flushPerChanges;
    private long blockingMemStoreSize;
    final long threadWakeFrequency;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock updatesLock = new ReentrantReadWriteLock();
    private boolean splitRequest;
    private byte[] explicitSplitPoint = null;
    private final MultiVersionConsistencyControl mvcc = new MultiVersionConsistencyControl();
    private RegionCoprocessorHost coprocessorHost;
    private HTableDescriptor htableDescriptor = null;
    private RegionSplitPolicy splitPolicy;
    private final MetricsRegion metricsRegion;
    private final MetricsRegionWrapperImpl metricsRegionWrapper;
    private final Durability durability;
    private final Object closeLock = new Object();
    public static final String MEMSTORE_PERIODIC_FLUSH_INTERVAL = "hbase.regionserver.optionalcacheflushinterval";
    public static final int DEFAULT_CACHE_FLUSH_INTERVAL = 3600000;
    public static final String MEMSTORE_FLUSH_PER_CHANGES = "hbase.regionserver.flush.per.changes";
    public static final long DEFAULT_FLUSH_PER_CHANGES = 30000000L;
    public static final long MAX_FLUSH_PER_CHANGES = 1000000000L;
    private static final byte[] FOR_UNIT_TESTS_ONLY = Bytes.toBytes((String)"ForUnitTestsOnly");
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + ClassSize.ARRAY + 41 * ClassSize.REFERENCE + 8 + 96 + 4));
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + (long)(3 * ClassSize.ATOMIC_LONG) + (long)(2 * ClassSize.CONCURRENT_HASHMAP) + WriteState.HEAP_SIZE + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)(2 * ClassSize.REENTRANT_LOCK) + (long)ClassSize.ARRAYLIST + MultiVersionConsistencyControl.FIXED_SIZE + (long)ClassSize.TREEMAP + (long)(2 * ClassSize.ATOMIC_INTEGER);
    private static final List<Cell> MOCKED_LIST = new AbstractList<Cell>(){

        @Override
        public void add(int index, Cell element) {
        }

        @Override
        public boolean addAll(int index, Collection<? extends Cell> c) {
            return false;
        }

        @Override
        public KeyValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSmallestReadPoint() {
        long minimumReadPoint;
        ConcurrentHashMap<RegionScanner, Long> concurrentHashMap = this.scannerReadPoints;
        synchronized (concurrentHashMap) {
            minimumReadPoint = this.mvcc.memstoreReadPoint();
            for (Long readPoint : this.scannerReadPoints.values()) {
                if (readPoint >= minimumReadPoint) continue;
                minimumReadPoint = readPoint;
            }
        }
        return minimumReadPoint;
    }

    @Deprecated
    public HRegion(Path tableDir, HLog log, FileSystem fs, Configuration confParam, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
        this(new HRegionFileSystem(confParam, fs, tableDir, regionInfo), log, confParam, htd, rsServices);
    }

    public HRegion(HRegionFileSystem fs, HLog log, Configuration confParam, HTableDescriptor htd, RegionServerServices rsServices) {
        if (htd == null) {
            throw new IllegalArgumentException("Need table descriptor");
        }
        if (confParam instanceof CompoundConfiguration) {
            throw new IllegalArgumentException("Need original base configuration");
        }
        this.comparator = fs.getRegionInfo().getComparator();
        this.log = log;
        this.fs = fs;
        this.baseConf = confParam;
        this.conf = new CompoundConfiguration().add(confParam).addStringMap(htd.getConfiguration()).addWritableMap(htd.getValues());
        this.flushCheckInterval = this.conf.getInt(MEMSTORE_PERIODIC_FLUSH_INTERVAL, 3600000);
        this.flushPerChanges = this.conf.getLong(MEMSTORE_FLUSH_PER_CHANGES, 30000000L);
        if (this.flushPerChanges > 1000000000L) {
            throw new IllegalArgumentException("hbase.regionserver.flush.per.changes can not exceed 1000000000");
        }
        this.rowLockWaitDuration = this.conf.getInt("hbase.rowlock.wait.duration", 30000);
        this.isLoadingCfsOnDemandDefault = this.conf.getBoolean(LOAD_CFS_ON_DEMAND_CONFIG_KEY, true);
        this.htableDescriptor = htd;
        this.rsServices = rsServices;
        this.threadWakeFrequency = this.conf.getLong("hbase.server.thread.wakefrequency", 10000L);
        this.setHTableSpecificConf();
        this.scannerReadPoints = new ConcurrentHashMap();
        this.busyWaitDuration = this.conf.getLong("hbase.busy.wait.duration", DEFAULT_BUSY_WAIT_DURATION);
        this.maxBusyWaitMultiplier = this.conf.getInt("hbase.busy.wait.multiplier.max", 2);
        if (this.busyWaitDuration * (long)this.maxBusyWaitMultiplier <= 0L) {
            throw new IllegalArgumentException("Invalid hbase.busy.wait.duration (" + this.busyWaitDuration + ") or hbase.busy.wait.multiplier.max (" + this.maxBusyWaitMultiplier + "). Their product should be positive");
        }
        this.maxBusyWaitDuration = this.conf.getLong("ipc.client.call.purge.timeout", (long)(2 * HConstants.DEFAULT_HBASE_RPC_TIMEOUT));
        this.timestampSlop = this.conf.getLong("hbase.hregion.keyvalue.timestamp.slop.millisecs", Long.MAX_VALUE);
        this.rowProcessorTimeout = this.conf.getLong("hbase.hregion.row.processor.timeout", 60000L);
        Durability durability = this.durability = htd.getDurability() == Durability.USE_DEFAULT ? DEFAULT_DURABLITY : htd.getDurability();
        if (rsServices != null) {
            this.rsAccounting = this.rsServices.getRegionServerAccounting();
            this.coprocessorHost = new RegionCoprocessorHost(this, rsServices, this.conf);
            this.metricsRegionWrapper = new MetricsRegionWrapperImpl(this);
            this.metricsRegion = new MetricsRegion(this.metricsRegionWrapper);
            Map<String, HRegion> recoveringRegions = rsServices.getRecoveringRegions();
            String encodedName = this.getRegionInfo().getEncodedName();
            if (recoveringRegions != null && recoveringRegions.containsKey(encodedName)) {
                this.isRecovering = true;
                recoveringRegions.put(encodedName, this);
            }
        } else {
            this.metricsRegionWrapper = null;
            this.metricsRegion = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiated " + this));
        }
        this.disallowWritesInRecovering = this.conf.getBoolean("hbase.regionserver.disallow.writes.when.recovering", false);
    }

    void setHTableSpecificConf() {
        if (this.htableDescriptor == null) {
            return;
        }
        long flushSize = this.htableDescriptor.getMemStoreFlushSize();
        if (flushSize <= 0L) {
            flushSize = this.conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
        this.memstoreFlushSize = flushSize;
        this.blockingMemStoreSize = this.memstoreFlushSize * this.conf.getLong("hbase.hregion.memstore.block.multiplier", 2L);
    }

    @Deprecated
    public long initialize() throws IOException {
        return this.initialize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long initialize(CancelableProgressable reporter) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Initializing region " + this);
        long nextSeqId = -1L;
        try {
            long l = nextSeqId = this.initializeRegionInternals(reporter, status);
            return l;
        }
        finally {
            if (nextSeqId == -1L) {
                status.abort("Exception during region " + this.getRegionNameAsString() + " initialization.");
            }
        }
    }

    private long initializeRegionInternals(CancelableProgressable reporter, MonitoredTask status) throws IOException, UnsupportedEncodingException {
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-open hook");
            this.coprocessorHost.preOpen();
        }
        status.setStatus("Writing region info on filesystem");
        this.fs.checkRegionInfoOnFilesystem();
        status.setStatus("Cleaning up temporary data from old regions");
        this.fs.cleanupTempDir();
        status.setStatus("Initializing all the Stores");
        long maxSeqId = this.initializeRegionStores(reporter, status);
        status.setStatus("Cleaning up detritus from prior splits");
        this.fs.cleanupAnySplitDetritus();
        this.fs.cleanupMergesDir();
        this.writestate.setReadOnly(this.htableDescriptor.isReadOnly());
        this.writestate.flushRequested = false;
        this.writestate.compacting = 0;
        this.splitPolicy = RegionSplitPolicy.create(this, this.conf);
        this.lastFlushTime = EnvironmentEdgeManager.currentTimeMillis();
        long nextSeqid = maxSeqId + 1L;
        if (this.isRecovering) {
            nextSeqid += this.flushPerChanges + 10000000L;
        }
        LOG.info((Object)("Onlined " + this.getRegionInfo().getShortNameToLog() + "; next sequenceid=" + nextSeqid));
        this.closing.set(false);
        this.closed.set(false);
        this.completeSequenceId = nextSeqid;
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor post-open hooks");
            this.coprocessorHost.postOpen();
        }
        status.markComplete("Region opened successfully");
        return nextSeqid;
    }

    private long initializeRegionStores(CancelableProgressable reporter, MonitoredTask status) throws IOException, UnsupportedEncodingException {
        long maxSeqId = -1L;
        long maxMemstoreTS = -1L;
        if (!this.htableDescriptor.getFamilies().isEmpty()) {
            ThreadPoolExecutor storeOpenerThreadPool = this.getStoreOpenAndCloseThreadPool("StoreOpener-" + this.getRegionInfo().getShortNameToLog());
            ExecutorCompletionService<HStore> completionService = new ExecutorCompletionService<HStore>(storeOpenerThreadPool);
            for (final HColumnDescriptor family : this.htableDescriptor.getFamilies()) {
                status.setStatus("Instantiating store for column family " + family);
                completionService.submit(new Callable<HStore>(){

                    @Override
                    public HStore call() throws IOException {
                        return HRegion.this.instantiateHStore(family);
                    }
                });
            }
            boolean allStoresOpened = false;
            try {
                for (int i = 0; i < this.htableDescriptor.getFamilies().size(); ++i) {
                    long maxStoreMemstoreTS;
                    Future future = completionService.take();
                    HStore store = (HStore)future.get();
                    this.stores.put(store.getColumnFamilyName().getBytes(), store);
                    long storeSeqIdForReplay = store.getMaxSequenceId(false);
                    this.maxSeqIdInStores.put(store.getColumnFamilyName().getBytes(), storeSeqIdForReplay);
                    long storeSeqIdForAssignment = store.getMaxSequenceId(true);
                    if (maxSeqId == -1L || storeSeqIdForAssignment > maxSeqId) {
                        maxSeqId = storeSeqIdForAssignment;
                    }
                    if ((maxStoreMemstoreTS = store.getMaxMemstoreTS()) <= maxMemstoreTS) continue;
                    maxMemstoreTS = maxStoreMemstoreTS;
                }
                allStoresOpened = true;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
            finally {
                storeOpenerThreadPool.shutdownNow();
                if (!allStoresOpened) {
                    LOG.error((Object)("Could not initialize all stores for the region=" + this));
                    for (Store store : this.stores.values()) {
                        try {
                            store.close();
                        }
                        catch (IOException e) {
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                }
            }
        }
        this.mvcc.initialize(maxMemstoreTS + 1L);
        maxSeqId = Math.max(maxSeqId, this.replayRecoveredEditsIfAny(this.fs.getRegionDir(), this.maxSeqIdInStores, reporter, status));
        return maxSeqId;
    }

    public boolean hasReferences() {
        for (Store store : this.stores.values()) {
            if (!store.hasReferences()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDFSBlocksDistribution getHDFSBlocksDistribution() {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        Map<byte[], Store> map = this.stores;
        synchronized (map) {
            for (Store store : this.stores.values()) {
                for (StoreFile sf : store.getStorefiles()) {
                    HDFSBlocksDistribution storeFileBlocksDistribution = sf.getHDFSBlockDistribution();
                    hdfsBlocksDistribution.add(storeFileBlocksDistribution);
                }
            }
        }
        return hdfsBlocksDistribution;
    }

    public static HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, HTableDescriptor tableDescriptor, HRegionInfo regionInfo) throws IOException {
        Path tablePath = FSUtils.getTableDir(FSUtils.getRootDir(conf), tableDescriptor.getTableName());
        return HRegion.computeHDFSBlocksDistribution(conf, tableDescriptor, regionInfo, tablePath);
    }

    public static HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, HTableDescriptor tableDescriptor, HRegionInfo regionInfo, Path tablePath) throws IOException {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        FileSystem fs = tablePath.getFileSystem(conf);
        HRegionFileSystem regionFs = new HRegionFileSystem(conf, fs, tablePath, regionInfo);
        for (HColumnDescriptor family : tableDescriptor.getFamilies()) {
            Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(family.getNameAsString());
            if (storeFiles == null) continue;
            for (StoreFileInfo storeFileInfo : storeFiles) {
                hdfsBlocksDistribution.add(storeFileInfo.computeHDFSBlocksDistribution(fs));
            }
        }
        return hdfsBlocksDistribution;
    }

    public AtomicLong getMemstoreSize() {
        return this.memstoreSize;
    }

    public long addAndGetGlobalMemstoreSize(long memStoreSize) {
        if (this.rsAccounting != null) {
            this.rsAccounting.addAndGetGlobalMemstoreSize(memStoreSize);
        }
        return this.memstoreSize.addAndGet(memStoreSize);
    }

    public HRegionInfo getRegionInfo() {
        return this.fs.getRegionInfo();
    }

    RegionServerServices getRegionServerServices() {
        return this.rsServices;
    }

    long getReadRequestsCount() {
        return this.readRequestsCount.get();
    }

    long getWriteRequestsCount() {
        return this.writeRequestsCount.get();
    }

    MetricsRegion getMetrics() {
        return this.metricsRegion;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public void setRecovering(boolean newState) {
        boolean wasRecovering = this.isRecovering;
        this.isRecovering = newState;
        if (wasRecovering && !this.isRecovering) {
            this.coprocessorHost.postLogReplay();
        }
    }

    public boolean isRecovering() {
        return this.isRecovering;
    }

    public boolean isAvailable() {
        return !this.isClosed() && !this.isClosing();
    }

    public boolean isSplittable() {
        return this.isAvailable() && !this.hasReferences();
    }

    public boolean isMergeable() {
        if (!this.isAvailable()) {
            LOG.debug((Object)("Region " + this.getRegionNameAsString() + " is not mergeable because it is closing or closed"));
            return false;
        }
        if (this.hasReferences()) {
            LOG.debug((Object)("Region " + this.getRegionNameAsString() + " is not mergeable because it has references"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areWritesEnabled() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            return this.writestate.writesEnabled;
        }
    }

    public MultiVersionConsistencyControl getMVCC() {
        return this.mvcc;
    }

    public long getReadpoint(IsolationLevel isolationLevel) {
        if (isolationLevel == IsolationLevel.READ_UNCOMMITTED) {
            return Long.MAX_VALUE;
        }
        return this.mvcc.memstoreReadPoint();
    }

    public boolean isLoadingCfsOnDemandDefault() {
        return this.isLoadingCfsOnDemandDefault;
    }

    public Map<byte[], List<StoreFile>> close() throws IOException {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], List<StoreFile>> close(boolean abort) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Closing region " + this + (abort ? " due to abort" : ""));
        status.setStatus("Waiting for close lock");
        try {
            Object object = this.closeLock;
            synchronized (object) {
                Map<byte[], List<StoreFile>> map = this.doClose(abort, status);
                return map;
            }
        }
        finally {
            status.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<byte[], List<StoreFile>> doClose(boolean abort, MonitoredTask status) throws IOException {
        if (this.isClosed()) {
            LOG.warn((Object)("Region " + this + " already closed"));
            return null;
        }
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-close hooks");
            this.coprocessorHost.preClose(abort);
        }
        status.setStatus("Disabling compacts and flushes for region");
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            this.writestate.writesEnabled = false;
            LOG.debug((Object)("Closing " + this + ": disabling compactions & flushes"));
            this.waitForFlushesAndCompactions();
        }
        if (!abort && this.worthPreFlushing()) {
            status.setStatus("Pre-flushing region before close");
            LOG.info((Object)("Running close preflush of " + this.getRegionNameAsString()));
            try {
                this.internalFlushcache(status);
            }
            catch (IOException ioe) {
                status.setStatus("Failed pre-flush " + this + "; " + ioe.getMessage());
            }
        }
        this.closing.set(true);
        status.setStatus("Disabling writes for close");
        this.lock.writeLock().lock();
        try {
            if (this.isClosed()) {
                status.abort("Already got closed by another process");
                Map<byte[], List<StoreFile>> ioe = null;
                return ioe;
            }
            LOG.debug((Object)("Updates disabled for region " + this));
            if (!abort) {
                int flushCount = 0;
                while (this.getMemstoreSize().get() > 0L) {
                    try {
                        if (flushCount++ > 0) {
                            int actualFlushes = flushCount - 1;
                            if (actualFlushes > 5) {
                                throw new DroppedSnapshotException("Failed clearing memory after " + actualFlushes + " attempts on region: " + Bytes.toStringBinary((byte[])this.getRegionName()));
                            }
                            LOG.info((Object)("Running extra flush, " + actualFlushes + " (carrying snapshot?) " + this));
                        }
                        this.internalFlushcache(status);
                    }
                    catch (IOException ioe) {
                        status.setStatus("Failed flush " + this + ", putting online again");
                        WriteState writeState2 = this.writestate;
                        synchronized (writeState2) {
                            this.writestate.writesEnabled = true;
                        }
                        throw ioe;
                    }
                }
            }
            TreeMap<byte[], List<StoreFile>> result = new TreeMap<byte[], List<StoreFile>>(Bytes.BYTES_COMPARATOR);
            if (!this.stores.isEmpty()) {
                ThreadPoolExecutor storeCloserThreadPool = this.getStoreOpenAndCloseThreadPool("StoreCloserThread-" + this.getRegionNameAsString());
                ExecutorCompletionService<Pair<byte[], Collection<StoreFile>>> completionService = new ExecutorCompletionService<Pair<byte[], Collection<StoreFile>>>(storeCloserThreadPool);
                for (final Store store : this.stores.values()) {
                    assert (abort || store.getFlushableSize() == 0L);
                    completionService.submit(new Callable<Pair<byte[], Collection<StoreFile>>>(){

                        @Override
                        public Pair<byte[], Collection<StoreFile>> call() throws IOException {
                            return new Pair((Object)store.getFamily().getName(), store.close());
                        }
                    });
                }
                try {
                    for (int i = 0; i < this.stores.size(); ++i) {
                        Future future = completionService.take();
                        Pair storeFiles = (Pair)future.get();
                        ArrayList familyFiles = (ArrayList)result.get(storeFiles.getFirst());
                        if (familyFiles == null) {
                            familyFiles = new ArrayList();
                            result.put((byte[])storeFiles.getFirst(), familyFiles);
                        }
                        familyFiles.addAll((Collection)storeFiles.getSecond());
                    }
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                catch (ExecutionException e) {
                    throw new IOException(e.getCause());
                }
                finally {
                    storeCloserThreadPool.shutdownNow();
                }
            }
            this.closed.set(true);
            if (this.memstoreSize.get() != 0L) {
                LOG.error((Object)("Memstore size is " + this.memstoreSize.get()));
            }
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor post-close hooks");
                this.coprocessorHost.postClose(abort);
            }
            if (this.metricsRegion != null) {
                this.metricsRegion.close();
            }
            if (this.metricsRegionWrapper != null) {
                Closeables.closeQuietly((Closeable)this.metricsRegionWrapper);
            }
            status.markComplete("Closed");
            LOG.info((Object)("Closed " + this));
            TreeMap<byte[], List<StoreFile>> treeMap = result;
            return treeMap;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFlushesAndCompactions() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            while (this.writestate.compacting > 0 || this.writestate.flushing) {
                LOG.debug((Object)("waiting for " + this.writestate.compacting + " compactions" + (this.writestate.flushing ? " & cache flush" : "") + " to complete for region " + this));
                try {
                    this.writestate.wait();
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected ThreadPoolExecutor getStoreOpenAndCloseThreadPool(String threadNamePrefix) {
        int numStores = Math.max(1, this.htableDescriptor.getFamilies().size());
        int maxThreads = Math.min(numStores, this.conf.getInt("hbase.hstore.open.and.close.threads.max", 1));
        return HRegion.getOpenAndCloseThreadPool(maxThreads, threadNamePrefix);
    }

    protected ThreadPoolExecutor getStoreFileOpenAndCloseThreadPool(String threadNamePrefix) {
        int numStores = Math.max(1, this.htableDescriptor.getFamilies().size());
        int maxThreads = Math.max(1, this.conf.getInt("hbase.hstore.open.and.close.threads.max", 1) / numStores);
        return HRegion.getOpenAndCloseThreadPool(maxThreads, threadNamePrefix);
    }

    static ThreadPoolExecutor getOpenAndCloseThreadPool(int maxThreads, final String threadNamePrefix) {
        return Threads.getBoundedCachedThreadPool((int)maxThreads, (long)30L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadNamePrefix + "-" + this.count++);
            }
        });
    }

    private boolean worthPreFlushing() {
        return this.memstoreSize.get() > this.conf.getLong("hbase.hregion.preclose.flush.size", 0x500000L);
    }

    public byte[] getStartKey() {
        return this.getRegionInfo().getStartKey();
    }

    public byte[] getEndKey() {
        return this.getRegionInfo().getEndKey();
    }

    public long getRegionId() {
        return this.getRegionInfo().getRegionId();
    }

    public byte[] getRegionName() {
        return this.getRegionInfo().getRegionName();
    }

    public String getRegionNameAsString() {
        return this.getRegionInfo().getRegionNameAsString();
    }

    public HTableDescriptor getTableDesc() {
        return this.htableDescriptor;
    }

    public HLog getLog() {
        return this.log;
    }

    Configuration getBaseConf() {
        return this.baseConf;
    }

    public FileSystem getFilesystem() {
        return this.fs.getFileSystem();
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.fs;
    }

    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    public long getLargestHStoreSize() {
        long size = 0L;
        for (Store h : this.stores.values()) {
            long storeSize = h.getSize();
            if (storeSize <= size) continue;
            size = storeSize;
        }
        return size;
    }

    public KeyValue.KVComparator getComparator() {
        return this.comparator;
    }

    protected void doRegionCompactionPrep() throws IOException {
    }

    void triggerMajorCompaction() {
        for (Store h : this.stores.values()) {
            h.triggerMajorCompaction();
        }
    }

    public void compactStores(boolean majorCompaction) throws IOException {
        if (majorCompaction) {
            this.triggerMajorCompaction();
        }
        this.compactStores();
    }

    public void compactStores() throws IOException {
        for (Store s : this.getStores().values()) {
            CompactionContext compaction = s.requestCompaction();
            if (compaction == null) continue;
            this.compact(compaction, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compact(CompactionContext compaction, Store store) throws IOException {
        if (!$assertionsDisabled) {
            if (compaction == null) throw new AssertionError();
            if (!compaction.hasSelection()) {
                throw new AssertionError();
            }
        }
        assert (!compaction.getRequest().getFiles().isEmpty());
        if (this.closing.get() || this.closed.get()) {
            LOG.debug((Object)("Skipping compaction on " + this + " because closing/closed"));
            store.cancelRequestedCompaction(compaction);
            return false;
        }
        MonitoredTask status = null;
        boolean didPerformCompaction = false;
        this.lock.readLock().lock();
        try {
            byte[] cf = Bytes.toBytes((String)store.getColumnFamilyName());
            if (this.stores.get(cf) != store) {
                LOG.warn((Object)("Store " + store.getColumnFamilyName() + " on region " + this + " has been re-instantiated, cancel this compaction request. " + " It may be caused by the roll back of split transaction"));
                boolean bl = false;
                return bl;
            }
            status = TaskMonitor.get().createStatus("Compacting " + store + " in " + this);
            if (this.closed.get()) {
                String msg = "Skipping compaction on " + this + " because closed";
                LOG.debug((Object)msg);
                status.abort(msg);
                boolean bl = false;
                return bl;
            }
            boolean wasStateSet = false;
            try {
                WriteState writeState = this.writestate;
                synchronized (writeState) {
                    if (!this.writestate.writesEnabled) {
                        String msg = "NOT compacting region " + this + ". Writes disabled.";
                        LOG.info((Object)msg);
                        status.abort(msg);
                        boolean bl = false;
                        return bl;
                    }
                    wasStateSet = true;
                    ++this.writestate.compacting;
                }
                LOG.info((Object)("Starting compaction on " + store + " in region " + this + (compaction.getRequest().isOffPeak() ? " as an off-peak compaction" : "")));
                this.doRegionCompactionPrep();
                try {
                    status.setStatus("Compacting store " + store);
                    didPerformCompaction = true;
                    store.compact(compaction);
                }
                catch (InterruptedIOException iioe) {
                    String msg = "compaction interrupted";
                    LOG.info((Object)msg, (Throwable)iioe);
                    status.abort(msg);
                    boolean bl = false;
                    if (wasStateSet) {
                        WriteState writeState2 = this.writestate;
                        synchronized (writeState2) {
                            --this.writestate.compacting;
                            if (this.writestate.compacting <= 0) {
                                this.writestate.notifyAll();
                            }
                        }
                    }
                    try {
                        if (!didPerformCompaction) {
                            store.cancelRequestedCompaction(compaction);
                        }
                        if (status == null) return bl;
                        status.cleanup();
                        return bl;
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                }
            }
            finally {
                if (wasStateSet) {
                    WriteState writeState = this.writestate;
                    synchronized (writeState) {
                        --this.writestate.compacting;
                        if (this.writestate.compacting <= 0) {
                            this.writestate.notifyAll();
                        }
                    }
                }
            }
            status.markComplete("Compaction complete");
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (!didPerformCompaction) {
                    store.cancelRequestedCompaction(compaction);
                }
                if (status != null) {
                    status.cleanup();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean flushcache() throws IOException {
        if (this.closing.get()) {
            HRegion.LOG.debug((Object)("Skipping flush on " + this + " because closing"));
            return false;
        }
        status = TaskMonitor.get().createStatus("Flushing " + this);
        status.setStatus("Acquiring readlock on region");
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                HRegion.LOG.debug((Object)("Skipping flush on " + this + " because closed"));
                status.abort("Skipped: closed");
                var2_2 = false;
                return var2_2;
            }
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor pre-flush hooks");
                this.coprocessorHost.preFlush();
            }
            if (this.numMutationsWithoutWAL.get() > 0L) {
                this.numMutationsWithoutWAL.set(0L);
                this.dataInMemoryWithoutWAL.set(0L);
            }
            var2_3 = this.writestate;
            synchronized (var2_3) {
                if (this.writestate.flushing || !this.writestate.writesEnabled) {
                    if (HRegion.LOG.isDebugEnabled()) {
                        HRegion.LOG.debug((Object)("NOT flushing memstore for region " + this + ", flushing=" + this.writestate.flushing + ", writesEnabled=" + this.writestate.writesEnabled));
                    }
                    status.abort("Not flushing since " + (this.writestate.flushing != false ? "already flushing" : "writes not enabled"));
                    var3_5 = false;
                    return var3_5;
                }
                this.writestate.flushing = true;
                ** try [egrp 4[TRYBLOCK] [1 : 391->396)] { 
                {
                }
            }
lbl33:
            // 1 sources

            try {
                result = this.internalFlushcache(status);
                if (this.coprocessorHost != null) {
                    status.setStatus("Running post-flush coprocessor hooks");
                    this.coprocessorHost.postFlush();
                }
                status.markComplete("Flush successful");
                var3_6 = result;
                var4_8 = this.writestate;
            }
            catch (Throwable var6_10) {
                var7_11 = this.writestate;
                synchronized (var7_11) {
                    this.writestate.flushing = false;
                    this.writestate.flushRequested = false;
                    this.writestate.notifyAll();
                }
                throw var6_10;
            }
            synchronized (var4_8) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
            return var3_6;
        }
        finally {
            this.lock.readLock().unlock();
            status.cleanup();
        }
    }

    boolean shouldFlush() {
        if (this.completeSequenceId + this.flushPerChanges < this.sequenceId.get()) {
            return true;
        }
        if (this.flushCheckInterval <= 0L) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if (now - this.getLastFlushTime() < this.flushCheckInterval) {
            return false;
        }
        for (Store s : this.getStores().values()) {
            if (s.timeOfOldestEdit() >= now - this.flushCheckInterval) continue;
            return true;
        }
        return false;
    }

    protected boolean internalFlushcache(MonitoredTask status) throws IOException {
        return this.internalFlushcache(this.log, -1L, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalFlushcache(HLog wal, long myseqid, MonitoredTask status) throws IOException {
        if (this.rsServices != null && this.rsServices.isAborted()) {
            throw new IOException("Aborting flush because server is abortted...");
        }
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        if (this.memstoreSize.get() <= 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Empty memstore size for the current region " + this));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Started memstore flush for " + this + ", current region memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get()) + (wal != null ? "" : "; wal is null, using passed sequenceid=" + myseqid)));
        }
        MultiVersionConsistencyControl.WriteEntry w = null;
        status.setStatus("Obtaining lock to block concurrent updates");
        this.updatesLock.writeLock().lock();
        long totalFlushableSize = 0L;
        status.setStatus("Preparing to flush by snapshotting stores");
        ArrayList<StoreFlushContext> storeFlushCtxs = new ArrayList<StoreFlushContext>(this.stores.size());
        long flushSeqId = -1L;
        try {
            w = this.mvcc.beginMemstoreInsert();
            this.mvcc.advanceMemstore(w);
            if (wal != null) {
                if (!wal.startCacheFlush(this.getRegionInfo().getEncodedNameAsBytes())) {
                    status.setStatus("Flush will not be started for [" + this.getRegionInfo().getEncodedName() + "] - because the WAL is closing.");
                    boolean bl = false;
                    return bl;
                }
                flushSeqId = this.sequenceId.incrementAndGet();
            } else {
                flushSeqId = myseqid;
            }
            for (Store s : this.stores.values()) {
                totalFlushableSize += s.getFlushableSize();
                storeFlushCtxs.add(s.createFlushContext(flushSeqId));
            }
            for (StoreFlushContext flush : storeFlushCtxs) {
                flush.prepare();
            }
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
        String s = "Finished memstore snapshotting " + this + ", syncing WAL and waiting on mvcc, flushsize=" + totalFlushableSize;
        status.setStatus(s);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)s);
        }
        if (wal != null && !this.shouldSyncLog()) {
            wal.sync();
        }
        this.mvcc.waitForRead(w);
        s = "Flushing stores of " + this;
        status.setStatus(s);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)s);
        }
        boolean compactionRequested = false;
        try {
            for (StoreFlushContext flush : storeFlushCtxs) {
                flush.flushCache(status);
            }
            for (StoreFlushContext flush : storeFlushCtxs) {
                boolean needsCompaction = flush.commit(status);
                if (!needsCompaction) continue;
                compactionRequested = true;
            }
            storeFlushCtxs.clear();
            this.addAndGetGlobalMemstoreSize(-totalFlushableSize);
        }
        catch (Throwable t) {
            if (wal != null) {
                wal.abortCacheFlush(this.getRegionInfo().getEncodedNameAsBytes());
            }
            DroppedSnapshotException dse = new DroppedSnapshotException("region: " + Bytes.toStringBinary((byte[])this.getRegionName()));
            dse.initCause(t);
            status.abort("Flush failed: " + StringUtils.stringifyException((Throwable)t));
            throw dse;
        }
        if (wal != null) {
            wal.completeCacheFlush(this.getRegionInfo().getEncodedNameAsBytes());
        }
        this.lastFlushTime = EnvironmentEdgeManager.currentTimeMillis();
        this.completeSequenceId = flushSeqId;
        HRegion t = this;
        synchronized (t) {
            this.notifyAll();
        }
        long time = EnvironmentEdgeManager.currentTimeMillis() - startTime;
        long memstoresize = this.memstoreSize.get();
        String msg = "Finished memstore flush of ~" + StringUtils.humanReadableInt((long)totalFlushableSize) + "/" + totalFlushableSize + ", currentsize=" + StringUtils.humanReadableInt((long)memstoresize) + "/" + memstoresize + " for region " + this + " in " + time + "ms, sequenceid=" + flushSeqId + ", compaction requested=" + compactionRequested + (wal == null ? "; wal=null" : "");
        LOG.info((Object)msg);
        status.setStatus(msg);
        this.recentFlushes.add((Pair<Long, Long>)new Pair((Object)(time / 1000L), (Object)totalFlushableSize));
        return compactionRequested;
    }

    Result getClosestRowBefore(byte[] row) throws IOException {
        return this.getClosestRowBefore(row, HConstants.CATALOG_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getClosestRowBefore(byte[] row, byte[] family) throws IOException {
        Result result;
        if (this.coprocessorHost != null && this.coprocessorHost.preGetClosestRowBefore(row, family, result = new Result())) {
            return result;
        }
        this.checkRow(row, "getClosestRowBefore");
        this.startRegionOperation(Operation.GET);
        this.readRequestsCount.increment();
        try {
            Store store = this.getStore(family);
            KeyValue key = store.getRowKeyAtOrBefore(row);
            Result result2 = null;
            if (key != null) {
                Get get = new Get(key.getRow());
                get.addFamily(family);
                result2 = this.get(get);
            }
            if (this.coprocessorHost != null) {
                this.coprocessorHost.postGetClosestRowBefore(row, family, result2);
            }
            Result result3 = result2;
            return result3;
        }
        finally {
            this.closeRegionOperation(Operation.GET);
        }
    }

    public RegionScanner getScanner(Scan scan) throws IOException {
        return this.getScanner(scan, null);
    }

    void prepareScanner(Scan scan) throws IOException {
        if (!scan.hasFamilies()) {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                scan.addFamily(family);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegionScanner getScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        this.startRegionOperation(Operation.SCAN);
        try {
            this.prepareScanner(scan);
            if (scan.hasFamilies()) {
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    this.checkFamily(family);
                }
            }
            RegionScanner regionScanner = this.instantiateRegionScanner(scan, additionalScanners);
            return regionScanner;
        }
        finally {
            this.closeRegionOperation(Operation.SCAN);
        }
    }

    protected RegionScanner instantiateRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        if (scan.isReversed()) {
            if (scan.getFilter() != null) {
                scan.getFilter().setReversed(true);
            }
            return new ReversedRegionScannerImpl(scan, additionalScanners, this);
        }
        return new RegionScannerImpl(scan, additionalScanners, this);
    }

    void prepareDelete(Delete delete) throws IOException {
        if (delete.getFamilyCellMap().isEmpty()) {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                delete.deleteFamily(family, delete.getTimeStamp());
            }
        } else {
            for (byte[] family : delete.getFamilyCellMap().keySet()) {
                if (family == null) {
                    throw new NoSuchColumnFamilyException("Empty family is invalid");
                }
                this.checkFamily(family);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Delete delete) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation(Operation.DELETE);
        this.writeRequestsCount.increment();
        try {
            delete.getRow();
            this.doBatchMutate((Mutation)delete);
        }
        finally {
            this.closeRegionOperation(Operation.DELETE);
        }
    }

    void delete(NavigableMap<byte[], List<Cell>> familyMap, Durability durability) throws IOException {
        Delete delete = new Delete(FOR_UNIT_TESTS_ONLY);
        delete.setFamilyCellMap(familyMap);
        delete.setDurability(durability);
        this.doBatchMutate((Mutation)delete);
    }

    void prepareDeleteTimestamps(Map<byte[], List<Cell>> familyMap, byte[] byteNow) throws IOException {
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            byte[] family = e.getKey();
            List<Cell> cells = e.getValue();
            TreeMap<byte[], Integer> kvCount = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            for (Cell cell : cells) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (kv.isLatestTimestamp() && kv.isDeleteType()) {
                    Integer count;
                    byte[] qual = kv.getQualifier();
                    if (qual == null) {
                        qual = HConstants.EMPTY_BYTE_ARRAY;
                    }
                    if ((count = (Integer)kvCount.get(qual)) == null) {
                        kvCount.put(qual, 1);
                    } else {
                        kvCount.put(qual, count + 1);
                    }
                    count = (Integer)kvCount.get(qual);
                    Get get = new Get(kv.getRow());
                    get.setMaxVersions(count.intValue());
                    get.addColumn(family, qual);
                    List<Cell> result = this.get(get, false);
                    if (result.size() < count) {
                        kv.updateLatestStamp(byteNow);
                        continue;
                    }
                    if (result.size() > count) {
                        throw new RuntimeException("Unexpected size: " + result.size());
                    }
                    KeyValue getkv = KeyValueUtil.ensureKeyValue((Cell)result.get(count - 1));
                    Bytes.putBytes((byte[])kv.getBuffer(), (int)kv.getTimestampOffset(), (byte[])getkv.getBuffer(), (int)getkv.getTimestampOffset(), (int)8);
                    continue;
                }
                kv.updateLatestStamp(byteNow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Put put) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation(Operation.PUT);
        this.writeRequestsCount.increment();
        try {
            this.doBatchMutate((Mutation)put);
        }
        finally {
            this.closeRegionOperation(Operation.PUT);
        }
    }

    public OperationStatus[] batchMutate(Mutation[] mutations, long nonceGroup, long nonce) throws IOException {
        return this.batchMutate(new MutationBatch(mutations, nonceGroup, nonce));
    }

    public OperationStatus[] batchMutate(Mutation[] mutations) throws IOException {
        return this.batchMutate(mutations, 0L, 0L);
    }

    public OperationStatus[] batchReplay(HLogSplitter.MutationReplay[] mutations) throws IOException {
        return this.batchMutate(new ReplayBatch(mutations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus[] batchMutate(BatchOperationInProgress<?> batchOp) throws IOException {
        boolean initialized = false;
        while (!batchOp.isDone()) {
            long newSize;
            if (!batchOp.isInReplay()) {
                this.checkReadOnly();
            }
            this.checkResources();
            Operation op = Operation.BATCH_MUTATE;
            if (batchOp.isInReplay()) {
                op = Operation.REPLAY_BATCH_MUTATE;
            }
            this.startRegionOperation(op);
            try {
                if (!initialized) {
                    if (!batchOp.isInReplay()) {
                        this.writeRequestsCount.increment();
                        this.doPreMutationHook(batchOp);
                    }
                    initialized = true;
                }
                long addedSize = this.doMiniBatchMutation(batchOp);
                newSize = this.addAndGetGlobalMemstoreSize(addedSize);
            }
            finally {
                this.closeRegionOperation(op);
            }
            if (!this.isFlushSize(newSize)) continue;
            this.requestFlush();
        }
        return batchOp.retCodeDetails;
    }

    private void doPreMutationHook(BatchOperationInProgress<?> batchOp) throws IOException {
        WALEdit walEdit = new WALEdit();
        if (this.coprocessorHost != null) {
            for (int i = 0; i < batchOp.operations.length; ++i) {
                Mutation m = batchOp.getMutation(i);
                if (m instanceof Put) {
                    if (this.coprocessorHost.prePut((Put)m, walEdit, m.getDurability())) {
                        batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    }
                } else if (m instanceof Delete) {
                    Delete curDel = (Delete)m;
                    if (curDel.getFamilyCellMap().isEmpty()) {
                        this.prepareDelete(curDel);
                    }
                    if (this.coprocessorHost.preDelete(curDel, walEdit, m.getDurability())) {
                        batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    }
                } else {
                    batchOp.retCodeDetails[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, "Put/Delete mutations only supported in batchMutate() now");
                }
                if (walEdit.isEmpty()) continue;
                batchOp.walEditsFromCoprocessors[i] = walEdit;
                walEdit = new WALEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doMiniBatchMutation(BatchOperationInProgress<?> batchOp) throws IOException {
        long l;
        boolean success;
        int lastIndexExclusive;
        int firstIndex;
        block73: {
            long now;
            int noOfDeletes;
            int noOfPuts;
            Map[] familyMaps;
            ArrayList acquiredRowLocks;
            boolean locked;
            boolean doRollBackMemstore;
            long txid;
            MultiVersionConsistencyControl.WriteEntry w;
            WALEdit walEdit;
            long currentNonce;
            long currentNonceGroup;
            boolean isInReplay;
            block71: {
                long l2;
                block72: {
                    MiniBatchOperationInProgress<Mutation> miniBatchOp;
                    byte[] byteNow;
                    int numReadyToWrite;
                    block69: {
                        long isPutMutation2;
                        block70: {
                            isInReplay = batchOp.isInReplay();
                            boolean putsCfSetConsistent = true;
                            Set putsCfSet = null;
                            boolean deletesCfSetConsistent = true;
                            Set deletesCfSet = null;
                            currentNonceGroup = 0L;
                            currentNonce = 0L;
                            walEdit = new WALEdit(isInReplay);
                            w = null;
                            txid = 0L;
                            doRollBackMemstore = false;
                            locked = false;
                            acquiredRowLocks = Lists.newArrayListWithCapacity((int)batchOp.operations.length);
                            familyMaps = new Map[batchOp.operations.length];
                            lastIndexExclusive = firstIndex = batchOp.nextIndexToProcess;
                            success = false;
                            noOfPuts = 0;
                            noOfDeletes = 0;
                            numReadyToWrite = 0;
                            now = EnvironmentEdgeManager.currentTimeMillis();
                            while (lastIndexExclusive < batchOp.operations.length) {
                                Mutation mutation = batchOp.getMutation(lastIndexExclusive);
                                boolean isPutMutation2 = mutation instanceof Put;
                                NavigableMap familyMap = mutation.getFamilyCellMap();
                                familyMaps[lastIndexExclusive] = familyMap;
                                if (batchOp.retCodeDetails[lastIndexExclusive].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) {
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                try {
                                    if (isPutMutation2) {
                                        if (isInReplay) {
                                            this.removeNonExistentColumnFamilyForReplay(familyMap);
                                        } else {
                                            this.checkFamilies(familyMap.keySet());
                                        }
                                        this.checkTimestamps(mutation.getFamilyCellMap(), now);
                                    } else {
                                        this.prepareDelete((Delete)mutation);
                                    }
                                }
                                catch (NoSuchColumnFamilyException nscf) {
                                    LOG.warn((Object)"No such column family in batch mutation", (Throwable)nscf);
                                    batchOp.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.BAD_FAMILY, nscf.getMessage());
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                catch (FailedSanityCheckException fsce) {
                                    LOG.warn((Object)"Batch Mutation did not pass sanity check", (Throwable)fsce);
                                    batchOp.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, fsce.getMessage());
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                boolean shouldBlock = numReadyToWrite == 0;
                                RowLock rowLock = null;
                                try {
                                    rowLock = this.getRowLock(mutation.getRow(), shouldBlock);
                                }
                                catch (IOException ioe) {
                                    LOG.warn((Object)("Failed getting lock in batch put, row=" + Bytes.toStringBinary((byte[])mutation.getRow())), (Throwable)ioe);
                                }
                                if (rowLock == null) {
                                    assert (!shouldBlock) : "Should never fail to get lock when blocking";
                                    break;
                                }
                                acquiredRowLocks.add(rowLock);
                                ++lastIndexExclusive;
                                ++numReadyToWrite;
                                if (isPutMutation2) {
                                    if (putsCfSet == null) {
                                        putsCfSet = mutation.getFamilyCellMap().keySet();
                                        continue;
                                    }
                                    putsCfSetConsistent = putsCfSetConsistent && mutation.getFamilyCellMap().keySet().equals(putsCfSet);
                                    continue;
                                }
                                if (deletesCfSet == null) {
                                    deletesCfSet = mutation.getFamilyCellMap().keySet();
                                    continue;
                                }
                                deletesCfSetConsistent = deletesCfSetConsistent && mutation.getFamilyCellMap().keySet().equals(deletesCfSet);
                            }
                            now = EnvironmentEdgeManager.currentTimeMillis();
                            byteNow = Bytes.toBytes((long)now);
                            if (numReadyToWrite > 0) break block69;
                            isPutMutation2 = 0L;
                            if (doRollBackMemstore) {
                                this.rollbackMemstore(batchOp, familyMaps, firstIndex, lastIndexExclusive);
                            }
                            if (w != null) {
                                this.mvcc.completeMemstoreInsert(w);
                            }
                            if (locked) {
                                this.updatesLock.readLock().unlock();
                            }
                            this.releaseRowLocks(acquiredRowLocks);
                            if (noOfPuts > 0 && this.metricsRegion != null) {
                                this.metricsRegion.updatePut();
                            }
                            if (noOfDeletes > 0 && this.metricsRegion != null) {
                                this.metricsRegion.updateDelete();
                            }
                            if (success) break block70;
                            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                                if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                                batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                            }
                        }
                        if (this.coprocessorHost != null && !batchOp.isInReplay()) {
                            MiniBatchOperationInProgress<Mutation> miniBatchOp2 = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                            this.coprocessorHost.postBatchMutateIndispensably(miniBatchOp2, success);
                        }
                        batchOp.nextIndexToProcess = lastIndexExclusive;
                        return isPutMutation2;
                    }
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        Mutation mutation = batchOp.getMutation(i);
                        if (mutation instanceof Put) {
                            this.updateKVTimestamps(familyMaps[i].values(), byteNow);
                            ++noOfPuts;
                            continue;
                        }
                        this.prepareDeleteTimestamps(familyMaps[i], byteNow);
                        ++noOfDeletes;
                    }
                    this.lock(this.updatesLock.readLock(), numReadyToWrite);
                    locked = true;
                    w = this.mvcc.beginMemstoreInsert();
                    if (isInReplay || this.coprocessorHost == null || !this.coprocessorHost.preBatchMutate(miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive))) break block71;
                    l2 = 0L;
                    if (doRollBackMemstore) {
                        this.rollbackMemstore(batchOp, familyMaps, firstIndex, lastIndexExclusive);
                    }
                    if (w != null) {
                        this.mvcc.completeMemstoreInsert(w);
                    }
                    if (locked) {
                        this.updatesLock.readLock().unlock();
                    }
                    this.releaseRowLocks(acquiredRowLocks);
                    if (noOfPuts > 0 && this.metricsRegion != null) {
                        this.metricsRegion.updatePut();
                    }
                    if (noOfDeletes > 0 && this.metricsRegion != null) {
                        this.metricsRegion.updateDelete();
                    }
                    if (success) break block72;
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                    }
                }
                if (this.coprocessorHost != null && !batchOp.isInReplay()) {
                    MiniBatchOperationInProgress<Mutation> miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                    this.coprocessorHost.postBatchMutateIndispensably(miniBatchOp, success);
                }
                batchOp.nextIndexToProcess = lastIndexExclusive;
                return l2;
            }
            try {
                long addedSize = 0L;
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                    doRollBackMemstore = true;
                    addedSize += this.applyFamilyMapToMemstore(familyMaps[i], w);
                }
                boolean hasWalAppends = false;
                Durability durability = Durability.USE_DEFAULT;
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    WALEdit fromCP;
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                    batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    Mutation m = batchOp.getMutation(i);
                    Durability tmpDur = this.getEffectiveDurability(m.getDurability());
                    if (tmpDur.ordinal() > durability.ordinal()) {
                        durability = tmpDur;
                    }
                    if (tmpDur == Durability.SKIP_WAL) {
                        this.recordMutationWithoutWal(m.getFamilyCellMap());
                        continue;
                    }
                    long nonceGroup = batchOp.getNonceGroup(i);
                    long nonce = batchOp.getNonce(i);
                    if (nonceGroup != currentNonceGroup || nonce != currentNonce) {
                        if (walEdit.size() > 0) {
                            assert (isInReplay);
                            if (!isInReplay) {
                                throw new IOException("Multiple nonces per batch and not in replay");
                            }
                            txid = this.log.appendNoSync(this.getRegionInfo(), this.htableDescriptor.getTableName(), walEdit, m.getClusterIds(), now, this.htableDescriptor, this.sequenceId, true, currentNonceGroup, currentNonce);
                            hasWalAppends = true;
                            walEdit = new WALEdit(isInReplay);
                        }
                        currentNonceGroup = nonceGroup;
                        currentNonce = nonce;
                    }
                    if ((fromCP = batchOp.walEditsFromCoprocessors[i]) != null) {
                        for (KeyValue kv : fromCP.getKeyValues()) {
                            walEdit.add(kv);
                        }
                    }
                    this.addFamilyMapToWALEdit(familyMaps[i], walEdit);
                }
                Mutation mutation = batchOp.getMutation(firstIndex);
                if (walEdit.size() > 0) {
                    txid = this.log.appendNoSync(this.getRegionInfo(), this.htableDescriptor.getTableName(), walEdit, mutation.getClusterIds(), now, this.htableDescriptor, this.sequenceId, true, currentNonceGroup, currentNonce);
                    hasWalAppends = true;
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                    locked = false;
                }
                this.releaseRowLocks(acquiredRowLocks);
                if (hasWalAppends) {
                    this.syncOrDefer(txid, durability);
                }
                doRollBackMemstore = false;
                if (!isInReplay && this.coprocessorHost != null) {
                    MiniBatchOperationInProgress<Mutation> miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                    this.coprocessorHost.postBatchMutate(miniBatchOp);
                }
                if (w != null) {
                    this.mvcc.completeMemstoreInsert(w);
                    w = null;
                }
                if (!isInReplay && this.coprocessorHost != null) {
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) continue;
                        Mutation m = batchOp.getMutation(i);
                        if (m instanceof Put) {
                            this.coprocessorHost.postPut((Put)m, walEdit, m.getDurability());
                            continue;
                        }
                        this.coprocessorHost.postDelete((Delete)m, walEdit, m.getDurability());
                    }
                }
                success = true;
                l = addedSize;
                if (doRollBackMemstore) {
                    this.rollbackMemstore(batchOp, familyMaps, firstIndex, lastIndexExclusive);
                }
                if (w != null) {
                    this.mvcc.completeMemstoreInsert(w);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                this.releaseRowLocks(acquiredRowLocks);
                if (noOfPuts > 0 && this.metricsRegion != null) {
                    this.metricsRegion.updatePut();
                }
                if (noOfDeletes > 0 && this.metricsRegion != null) {
                    this.metricsRegion.updateDelete();
                }
                if (success) break block73;
            }
            catch (Throwable throwable) {
                if (doRollBackMemstore) {
                    this.rollbackMemstore(batchOp, familyMaps, firstIndex, lastIndexExclusive);
                }
                if (w != null) {
                    this.mvcc.completeMemstoreInsert(w);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                this.releaseRowLocks(acquiredRowLocks);
                if (noOfPuts > 0 && this.metricsRegion != null) {
                    this.metricsRegion.updatePut();
                }
                if (noOfDeletes > 0 && this.metricsRegion != null) {
                    this.metricsRegion.updateDelete();
                }
                if (!success) {
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                    }
                }
                if (this.coprocessorHost != null && !batchOp.isInReplay()) {
                    MiniBatchOperationInProgress<Mutation> miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                    this.coprocessorHost.postBatchMutateIndispensably(miniBatchOp, success);
                }
                batchOp.nextIndexToProcess = lastIndexExclusive;
                throw throwable;
            }
            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
            }
        }
        if (this.coprocessorHost != null && !batchOp.isInReplay()) {
            MiniBatchOperationInProgress<Mutation> miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
            this.coprocessorHost.postBatchMutateIndispensably(miniBatchOp, success);
        }
        batchOp.nextIndexToProcess = lastIndexExclusive;
        return l;
    }

    protected Durability getEffectiveDurability(Durability d) {
        return d == Durability.USE_DEFAULT ? this.durability : d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Mutation w, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        boolean isPut = w instanceof Put;
        if (!isPut && !(w instanceof Delete)) {
            throw new DoNotRetryIOException("Action must be Put or Delete");
        }
        if (!Bytes.equals((byte[])row, (byte[])w.getRow())) {
            throw new DoNotRetryIOException("Action's getRow must match the passed row");
        }
        this.startRegionOperation();
        try {
            RowLock rowLock;
            block23: {
                Get get = new Get(row);
                this.checkFamily(family);
                get.addColumn(family, qualifier);
                rowLock = this.getRowLock(get.getRow());
                this.mvcc.completeMemstoreInsert(this.mvcc.beginMemstoreInsert());
                try {
                    List<Cell> result = this.get(get, false);
                    boolean valueIsNull = comparator.getValue() == null || comparator.getValue().length == 0;
                    boolean matches = false;
                    if (result.size() == 0 && valueIsNull) {
                        matches = true;
                    } else if (result.size() > 0 && result.get(0).getValueLength() == 0 && valueIsNull) {
                        matches = true;
                    } else if (result.size() == 1 && !valueIsNull) {
                        Cell kv = result.get(0);
                        int compareResult = comparator.compareTo(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
                        switch (compareOp) {
                            case LESS: {
                                matches = compareResult < 0;
                                break;
                            }
                            case LESS_OR_EQUAL: {
                                matches = compareResult <= 0;
                                break;
                            }
                            case EQUAL: {
                                matches = compareResult == 0;
                                break;
                            }
                            case NOT_EQUAL: {
                                matches = compareResult != 0;
                                break;
                            }
                            case GREATER_OR_EQUAL: {
                                matches = compareResult >= 0;
                                break;
                            }
                            case GREATER: {
                                matches = compareResult > 0;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown Compare op " + compareOp.name());
                            }
                        }
                    }
                    if (!matches) break block23;
                    this.doBatchMutate(w);
                    this.checkAndMutateChecksPassed.increment();
                    boolean bl = true;
                    rowLock.release();
                    return bl;
                }
                catch (Throwable throwable) {
                    rowLock.release();
                    throw throwable;
                }
            }
            this.checkAndMutateChecksFailed.increment();
            boolean bl = false;
            rowLock.release();
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    private void doBatchMutate(Mutation mutation) throws IOException, DoNotRetryIOException {
        OperationStatus[] batchMutate = this.batchMutate(new Mutation[]{mutation}, 0L, 0L);
        if (batchMutate[0].getOperationStatusCode().equals((Object)HConstants.OperationStatusCode.SANITY_CHECK_FAILURE)) {
            throw new FailedSanityCheckException(batchMutate[0].getExceptionMsg());
        }
        if (batchMutate[0].getOperationStatusCode().equals((Object)HConstants.OperationStatusCode.BAD_FAMILY)) {
            throw new NoSuchColumnFamilyException(batchMutate[0].getExceptionMsg());
        }
    }

    public void addRegionToSnapshot(HBaseProtos.SnapshotDescription desc, ForeignExceptionSnare exnSnare) throws IOException {
        Path rootDir = FSUtils.getRootDir(this.rsServices.getConfiguration());
        Path snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(desc, rootDir);
        LOG.debug((Object)"Storing region-info for snapshot.");
        HRegionFileSystem snapshotRegionFs = HRegionFileSystem.createRegionOnFileSystem(this.conf, this.fs.getFileSystem(), snapshotDir, this.getRegionInfo());
        LOG.debug((Object)"Creating references for hfiles");
        for (Store store : this.stores.values()) {
            Path dstStoreDir = snapshotRegionFs.getStoreDir(store.getFamily().getNameAsString());
            ArrayList<StoreFile> storeFiles = new ArrayList<StoreFile>(store.getStorefiles());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding snapshot references for " + storeFiles + " hfiles"));
            }
            int sz = storeFiles.size();
            for (int i = 0; i < sz; ++i) {
                if (exnSnare != null) {
                    exnSnare.rethrowException();
                }
                StoreFile storeFile = (StoreFile)storeFiles.get(i);
                Path file = storeFile.getPath();
                LOG.debug((Object)("Creating reference for file (" + (i + 1) + "/" + sz + ") : " + file));
                Path referenceFile = new Path(dstStoreDir, file.getName());
                boolean success = true;
                if (storeFile.isReference()) {
                    storeFile.getFileInfo().getReference().write(this.fs.getFileSystem(), referenceFile);
                } else {
                    success = this.fs.getFileSystem().createNewFile(referenceFile);
                }
                if (success) continue;
                throw new IOException("Failed to create reference file:" + referenceFile);
            }
        }
    }

    void updateKVTimestamps(Iterable<List<Cell>> keyLists, byte[] now) {
        for (List<Cell> cells : keyLists) {
            if (cells == null) continue;
            for (Cell cell : cells) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                kv.updateLatestStamp(now);
            }
        }
    }

    private void checkResources() throws RegionTooBusyException {
        if (this.getRegionInfo().isMetaRegion()) {
            return;
        }
        if (this.memstoreSize.get() > this.blockingMemStoreSize) {
            this.requestFlush();
            throw new RegionTooBusyException("Above memstore limit, regionName=" + (this.getRegionInfo() == null ? "unknown" : this.getRegionInfo().getRegionNameAsString()) + ", server=" + (this.getRegionServerServices() == null ? "unknown" : this.getRegionServerServices().getServerName()) + ", memstoreSize=" + this.memstoreSize.get() + ", blockingMemStoreSize=" + this.blockingMemStoreSize);
        }
    }

    protected void checkReadOnly() throws IOException {
        if (this.writestate.isReadOnly()) {
            throw new IOException("region is read only");
        }
    }

    private void put(byte[] row, byte[] family, List<Cell> edits) throws IOException {
        TreeMap<byte[], List<Cell>> familyMap = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);
        familyMap.put(family, edits);
        Put p = new Put(row);
        p.setFamilyCellMap(familyMap);
        this.doBatchMutate((Mutation)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long applyFamilyMapToMemstore(Map<byte[], List<Cell>> familyMap, MultiVersionConsistencyControl.WriteEntry localizedWriteEntry) {
        long size = 0L;
        boolean freemvcc = false;
        try {
            if (localizedWriteEntry == null) {
                localizedWriteEntry = this.mvcc.beginMemstoreInsert();
                freemvcc = true;
            }
            for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<Cell> cells = e.getValue();
                Store store = this.getStore(family);
                for (Cell cell : cells) {
                    KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                    kv.setMvccVersion(localizedWriteEntry.getWriteNumber());
                    size += store.add(kv);
                }
            }
        }
        finally {
            if (freemvcc) {
                this.mvcc.completeMemstoreInsert(localizedWriteEntry);
            }
        }
        return size;
    }

    private void rollbackMemstore(BatchOperationInProgress<?> batchOp, Map<byte[], List<Cell>>[] familyMaps, int start, int end) {
        int kvsRolledback = 0;
        for (int i = start; i < end; ++i) {
            if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) continue;
            Map<byte[], List<Cell>> familyMap = familyMaps[i];
            for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<Cell> cells = e.getValue();
                Store store = this.getStore(family);
                for (Cell cell : cells) {
                    store.rollback(KeyValueUtil.ensureKeyValue((Cell)cell));
                    ++kvsRolledback;
                }
            }
        }
        LOG.debug((Object)("rollbackMemstore rolled back " + kvsRolledback + " keyvalues from start:" + start + " to end:" + end));
    }

    void checkFamilies(Collection<byte[]> families) throws NoSuchColumnFamilyException {
        for (byte[] family : families) {
            this.checkFamily(family);
        }
    }

    private void removeNonExistentColumnFamilyForReplay(Map<byte[], List<Cell>> familyMap) {
        ArrayList<byte[]> nonExistentList = null;
        for (byte[] family : familyMap.keySet()) {
            if (this.htableDescriptor.hasFamily(family)) continue;
            if (nonExistentList == null) {
                nonExistentList = new ArrayList<byte[]>();
            }
            nonExistentList.add(family);
        }
        if (nonExistentList != null) {
            for (byte[] family : nonExistentList) {
                LOG.info((Object)("No family for " + Bytes.toString((byte[])family) + " omit from reply."));
                familyMap.remove(family);
            }
        }
    }

    void checkTimestamps(Map<byte[], List<Cell>> familyMap, long now) throws FailedSanityCheckException {
        if (this.timestampSlop == Long.MAX_VALUE) {
            return;
        }
        long maxTs = now + this.timestampSlop;
        for (List<Cell> kvs : familyMap.values()) {
            for (Cell cell : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (kv.isLatestTimestamp() || kv.getTimestamp() <= maxTs) continue;
                throw new FailedSanityCheckException("Timestamp for KV out of range " + cell + " (too.new=" + this.timestampSlop + ")");
            }
        }
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<Cell>> familyMap, WALEdit walEdit) {
        for (List<Cell> edits : familyMap.values()) {
            for (Cell cell : edits) {
                walEdit.add(KeyValueUtil.ensureKeyValue((Cell)cell));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFlush() {
        if (this.rsServices == null) {
            return;
        }
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.isFlushRequested()) {
                return;
            }
            this.writestate.flushRequested = true;
        }
        this.rsServices.getFlushRequester().requestFlush(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Flush requested on " + this));
        }
    }

    private boolean isFlushSize(long size) {
        return size > this.memstoreFlushSize;
    }

    protected long replayRecoveredEditsIfAny(Path regiondir, Map<byte[], Long> maxSeqIdInStores, CancelableProgressable reporter, MonitoredTask status) throws UnsupportedEncodingException, IOException {
        long minSeqIdForTheRegion = -1L;
        for (Long maxSeqIdInStore : maxSeqIdInStores.values()) {
            if (maxSeqIdInStore >= minSeqIdForTheRegion && minSeqIdForTheRegion != -1L) continue;
            minSeqIdForTheRegion = maxSeqIdInStore;
        }
        long seqid = minSeqIdForTheRegion;
        FileSystem fs = this.fs.getFileSystem();
        NavigableSet<Path> files = HLogUtil.getSplitEditFilesSorted(fs, regiondir);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found " + (files == null ? 0 : files.size()) + " recovered edits file(s) under " + regiondir));
        }
        if (files == null || files.isEmpty()) {
            return seqid;
        }
        for (Path edits : files) {
            if (edits == null || !fs.exists(edits)) {
                LOG.warn((Object)("Null or non-existent edits file: " + edits));
                continue;
            }
            if (HRegion.isZeroLengthThenDelete(fs, edits)) continue;
            String fileName = edits.getName();
            long maxSeqId = Math.abs(Long.parseLong(fileName));
            if (maxSeqId <= minSeqIdForTheRegion) {
                if (!LOG.isDebugEnabled()) continue;
                String msg = "Maximum sequenceid for this log is " + maxSeqId + " and minimum sequenceid for the region is " + minSeqIdForTheRegion + ", skipped the whole file, path=" + edits;
                LOG.debug((Object)msg);
                continue;
            }
            try {
                seqid = Math.max(seqid, this.replayRecoveredEdits(edits, maxSeqIdInStores, reporter));
            }
            catch (IOException e) {
                boolean skipErrors = this.conf.getBoolean("hbase.hregion.edits.replay.skip.errors", this.conf.getBoolean("hbase.skip.errors", false));
                if (this.conf.get("hbase.skip.errors") != null) {
                    LOG.warn((Object)"The property 'hbase.skip.errors' has been deprecated. Please use hbase.hregion.edits.replay.skip.errors instead.");
                }
                if (skipErrors) {
                    Path p = HLogUtil.moveAsideBadEditsFile(fs, edits);
                    LOG.error((Object)("hbase.hregion.edits.replay.skip.errors=true so continuing. Renamed " + edits + " as " + p), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        if (this.rsAccounting != null) {
            this.rsAccounting.clearRegionReplayEditsSize(this.getRegionName());
        }
        if (seqid > minSeqIdForTheRegion) {
            this.internalFlushcache(null, seqid, status);
        }
        for (Path file : files) {
            if (!fs.delete(file, false)) {
                LOG.error((Object)("Failed delete of " + file));
                continue;
            }
            LOG.debug((Object)("Deleted recovered.edits file=" + file));
        }
        return seqid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replayRecoveredEdits(Path edits, Map<byte[], Long> maxSeqIdInStores, CancelableProgressable reporter) throws IOException {
        String msg = "Replaying edits from " + edits;
        LOG.info((Object)msg);
        MonitoredTask status = TaskMonitor.get().createStatus(msg);
        FileSystem fs = this.fs.getFileSystem();
        status.setStatus("Opening logs");
        HLog.Reader reader = null;
        try {
            reader = HLogFactory.createReader(fs, edits, this.conf);
            long currentEditSeqId = -1L;
            long firstSeqIdInLog = -1L;
            long skippedEdits = 0L;
            long editsCount = 0L;
            long intervalEdits = 0L;
            Store store = null;
            boolean reported_once = false;
            ServerNonceManager ng = this.rsServices == null ? null : this.rsServices.getNonceManager();
            try {
                HLog.Entry entry;
                int interval = this.conf.getInt("hbase.hstore.report.interval.edits", 2000);
                int period = this.conf.getInt("hbase.hstore.report.period", this.conf.getInt("hbase.master.assignment.timeoutmonitor.timeout", 600000) / 2);
                long lastReport = EnvironmentEdgeManager.currentTimeMillis();
                while ((entry = reader.next()) != null) {
                    HLogKey key = entry.getKey();
                    WALEdit val = entry.getEdit();
                    if (ng != null) {
                        ng.reportOperationFromWal(key.getNonceGroup(), key.getNonce(), key.getWriteTime());
                    }
                    if (reporter != null && (intervalEdits += (long)val.size()) >= (long)interval) {
                        intervalEdits = 0L;
                        long cur = EnvironmentEdgeManager.currentTimeMillis();
                        if (lastReport + (long)period <= cur) {
                            status.setStatus("Replaying edits... skipped=" + skippedEdits + " edits=" + editsCount);
                            if (!reporter.progress()) {
                                msg = "Progressable reporter failed, stopping replay";
                                LOG.warn((Object)msg);
                                status.abort(msg);
                                throw new IOException(msg);
                            }
                            reported_once = true;
                            lastReport = cur;
                        }
                    }
                    if (this.coprocessorHost != null) {
                        status.setStatus("Running pre-WAL-restore hook in coprocessors");
                        if (this.coprocessorHost.preWALRestore(this.getRegionInfo(), key, val)) continue;
                    }
                    if (firstSeqIdInLog == -1L) {
                        firstSeqIdInLog = key.getLogSeqNum();
                    }
                    currentEditSeqId = key.getLogSeqNum();
                    boolean flush = false;
                    for (KeyValue kv : val.getKeyValues()) {
                        if (kv.matchingFamily(WALEdit.METAFAMILY) || !Bytes.equals((byte[])key.getEncodedRegionName(), (byte[])this.getRegionInfo().getEncodedNameAsBytes())) {
                            WALProtos.CompactionDescriptor compaction = WALEdit.getCompaction(kv);
                            if (compaction != null) {
                                this.completeCompactionMarker(compaction);
                            }
                            ++skippedEdits;
                            continue;
                        }
                        if (store == null || !kv.matchingFamily(store.getFamily().getName())) {
                            store = this.stores.get(kv.getFamily());
                        }
                        if (store == null) {
                            LOG.warn((Object)("No family for " + kv));
                            ++skippedEdits;
                            continue;
                        }
                        if (key.getLogSeqNum() <= maxSeqIdInStores.get(store.getFamily().getName())) {
                            ++skippedEdits;
                            continue;
                        }
                        flush = this.restoreEdit(store, kv);
                        ++editsCount;
                    }
                    if (flush) {
                        this.internalFlushcache(null, currentEditSeqId, status);
                    }
                    if (this.coprocessorHost == null) continue;
                    this.coprocessorHost.postWALRestore(this.getRegionInfo(), key, val);
                }
            }
            catch (EOFException eof) {
                Path p = HLogUtil.moveAsideBadEditsFile(fs, edits);
                msg = "Encountered EOF. Most likely due to Master failure during log spliting, so we have this data in another edit.  Continuing, but renaming " + edits + " as " + p;
                LOG.warn((Object)msg, (Throwable)eof);
                status.abort(msg);
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof ParseException) {
                    Path p = HLogUtil.moveAsideBadEditsFile(fs, edits);
                    msg = "File corruption encountered!  Continuing, but renaming " + edits + " as " + p;
                    LOG.warn((Object)msg, (Throwable)ioe);
                    status.setStatus(msg);
                }
                status.abort(StringUtils.stringifyException((Throwable)ioe));
                throw ioe;
            }
            if (reporter != null && !reported_once) {
                reporter.progress();
            }
            msg = "Applied " + editsCount + ", skipped " + skippedEdits + ", firstSequenceidInLog=" + firstSeqIdInLog + ", maxSequenceidInLog=" + currentEditSeqId + ", path=" + edits;
            status.markComplete(msg);
            LOG.debug((Object)msg);
            long l = currentEditSeqId;
            return l;
        }
        finally {
            status.cleanup();
            if (reader != null) {
                reader.close();
            }
        }
    }

    void completeCompactionMarker(WALProtos.CompactionDescriptor compaction) throws IOException {
        Store store = this.getStore(compaction.getFamilyName().toByteArray());
        if (store == null) {
            LOG.warn((Object)("Found Compaction WAL edit for deleted family:" + Bytes.toString((byte[])compaction.getFamilyName().toByteArray())));
            return;
        }
        store.completeCompactionMarker(compaction);
    }

    protected boolean restoreEdit(Store s, KeyValue kv) {
        long kvSize = s.add(kv);
        if (this.rsAccounting != null) {
            this.rsAccounting.addAndGetRegionReplayEditsSize(this.getRegionName(), kvSize);
        }
        return this.isFlushSize(this.addAndGetGlobalMemstoreSize(kvSize));
    }

    private static boolean isZeroLengthThenDelete(FileSystem fs, Path p) throws IOException {
        FileStatus stat = fs.getFileStatus(p);
        if (stat.getLen() > 0L) {
            return false;
        }
        LOG.warn((Object)("File " + p + " is zero-length, deleting."));
        fs.delete(p, false);
        return true;
    }

    protected HStore instantiateHStore(HColumnDescriptor family) throws IOException {
        return new HStore(this, family, this.conf);
    }

    public Store getStore(byte[] column) {
        return this.stores.get(column);
    }

    public Map<byte[], Store> getStores() {
        return this.stores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStoreFileList(byte[][] columns) throws IllegalArgumentException {
        ArrayList<String> storeFileNames = new ArrayList<String>();
        Object object = this.closeLock;
        synchronized (object) {
            for (byte[] column : columns) {
                Store store = this.stores.get(column);
                if (store == null) {
                    throw new IllegalArgumentException("No column family : " + new String(column) + " available");
                }
                for (StoreFile storeFile : store.getStorefiles()) {
                    storeFileNames.add(storeFile.getPath().toString());
                }
            }
        }
        return storeFileNames;
    }

    void checkRow(byte[] row, String op) throws IOException {
        if (!HRegion.rowIsInRange(this.getRegionInfo(), row)) {
            throw new WrongRegionException("Requested row out of range for " + op + " on HRegion " + this + ", startKey='" + Bytes.toStringBinary((byte[])this.getStartKey()) + "', getEndKey()='" + Bytes.toStringBinary((byte[])this.getEndKey()) + "', row='" + Bytes.toStringBinary((byte[])row) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowLock getRowLock(byte[] row, boolean waitForLock) throws IOException {
        this.checkRow(row, "row lock");
        this.startRegionOperation();
        try {
            RowLockContext existingContext;
            HashedBytes rowKey = new HashedBytes(row);
            RowLockContext rowLockContext = new RowLockContext(rowKey);
            while ((existingContext = this.lockedRows.putIfAbsent(rowKey, rowLockContext)) != null) {
                if (existingContext.ownedByCurrentThread()) {
                    rowLockContext = existingContext;
                    break;
                }
                if (!waitForLock) {
                    RowLock rowLock = null;
                    return rowLock;
                }
                try {
                    if (existingContext.latch.await(this.rowLockWaitDuration, TimeUnit.MILLISECONDS)) continue;
                    throw new IOException("Timed out waiting for lock for row: " + rowKey);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("Thread interrupted waiting for lock on row: " + rowKey));
                    InterruptedIOException iie = new InterruptedIOException();
                    iie.initCause(ie);
                    throw iie;
                }
            }
            RowLock rowLock = rowLockContext.newLock();
            return rowLock;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public RowLock getRowLock(byte[] row) throws IOException {
        return this.getRowLock(row, true);
    }

    public void releaseRowLocks(List<RowLock> rowLocks) {
        if (rowLocks != null) {
            for (RowLock rowLock : rowLocks) {
                rowLock.release();
            }
            rowLocks.clear();
        }
    }

    private static boolean hasMultipleColumnFamilies(List<Pair<byte[], String>> familyPaths) {
        boolean multipleFamilies = false;
        byte[] family = null;
        for (Pair<byte[], String> pair : familyPaths) {
            byte[] fam = (byte[])pair.getFirst();
            if (family == null) {
                family = fam;
                continue;
            }
            if (Bytes.equals((byte[])family, (byte[])fam)) continue;
            multipleFamilies = true;
            break;
        }
        return multipleFamilies;
    }

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, boolean assignSeqId) throws IOException {
        return this.bulkLoadHFiles(familyPaths, assignSeqId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, boolean assignSeqId, BulkLoadListener bulkLoadListener) throws IOException {
        Preconditions.checkNotNull(familyPaths);
        this.startBulkRegionOperation(HRegion.hasMultipleColumnFamilies(familyPaths));
        try {
            Store store;
            String path;
            this.writeRequestsCount.increment();
            ArrayList<Throwable> ioes = new ArrayList<Throwable>();
            ArrayList<Pair<byte[], String>> failures = new ArrayList<Pair<byte[], String>>();
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = (byte[])p.getFirst();
                path = (String)p.getSecond();
                store = this.getStore(byArray);
                if (store == null) {
                    DoNotRetryIOException ioe = new DoNotRetryIOException("No such column family " + Bytes.toStringBinary((byte[])byArray));
                    ioes.add(ioe);
                    continue;
                }
                try {
                    store.assertBulkLoadHFileOk(new Path(path));
                }
                catch (WrongRegionException wre) {
                    failures.add(p);
                }
                catch (IOException ioe) {
                    ioes.add(ioe);
                }
            }
            if (ioes.size() != 0) {
                IOException e = MultipleIOException.createIOException(ioes);
                LOG.error((Object)"There were one or more IO errors when checking if the bulk load is ok.", (Throwable)e);
                throw e;
            }
            if (failures.size() != 0) {
                StringBuilder list = new StringBuilder();
                for (Pair pair : failures) {
                    list.append("\n").append(Bytes.toString((byte[])((byte[])pair.getFirst()))).append(" : ").append((String)pair.getSecond());
                }
                LOG.warn((Object)("There was a recoverable bulk load failure likely due to a split.  These (family, HFile) pairs were not loaded: " + list));
                boolean i$ = false;
                return i$;
            }
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = (byte[])p.getFirst();
                path = (String)p.getSecond();
                store = this.getStore(byArray);
                try {
                    String finalPath = path;
                    if (bulkLoadListener != null) {
                        finalPath = bulkLoadListener.prepareBulkLoad(byArray, path);
                    }
                    store.bulkLoadHFile(finalPath, assignSeqId ? this.sequenceId.incrementAndGet() : -1L);
                    if (bulkLoadListener == null) continue;
                    bulkLoadListener.doneBulkLoad(byArray, path);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("There was a partial failure due to IO when attempting to load " + Bytes.toString((byte[])((byte[])p.getFirst())) + " : " + (String)p.getSecond()), (Throwable)ioe);
                    if (bulkLoadListener != null) {
                        try {
                            bulkLoadListener.failedBulkLoad(byArray, path);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Error while calling failedBulkLoad for family " + Bytes.toString((byte[])byArray) + " with path " + path), (Throwable)ex);
                        }
                    }
                    throw ioe;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeBulkRegionOperation();
        }
    }

    public boolean equals(Object o) {
        return o instanceof HRegion && Bytes.equals((byte[])this.getRegionName(), (byte[])((HRegion)o).getRegionName());
    }

    public int hashCode() {
        return Bytes.hashCode((byte[])this.getRegionName());
    }

    public String toString() {
        return this.getRegionNameAsString();
    }

    static HRegion newHRegion(Path tableDir, HLog log, FileSystem fs, Configuration conf, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
        try {
            Class regionClass = conf.getClass("hbase.hregion.impl", HRegion.class);
            Constructor c = regionClass.getConstructor(Path.class, HLog.class, FileSystem.class, Configuration.class, HRegionInfo.class, HTableDescriptor.class, RegionServerServices.class);
            return (HRegion)c.newInstance(tableDir, log, fs, conf, regionInfo, htd, rsServices);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not instantiate a region instance.", e);
        }
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, null);
    }

    public static void closeHRegion(HRegion r) throws IOException {
        if (r == null) {
            return;
        }
        r.close();
        if (r.getLog() == null) {
            return;
        }
        r.getLog().closeAndDelete();
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, HLog hlog, boolean initialize) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, hlog, initialize, false);
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, HLog hlog, boolean initialize, boolean ignoreHLog) throws IOException {
        Path tableDir = FSUtils.getTableDir(rootDir, info.getTable());
        return HRegion.createHRegion(info, rootDir, tableDir, conf, hTableDescriptor, hlog, initialize, ignoreHLog);
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Path tableDir, Configuration conf, HTableDescriptor hTableDescriptor, HLog hlog, boolean initialize, boolean ignoreHLog) throws IOException {
        LOG.info((Object)("creating HRegion " + info.getTable().getNameAsString() + " HTD == " + hTableDescriptor + " RootDir = " + rootDir + " Table name == " + info.getTable().getNameAsString()));
        FileSystem fs = FileSystem.get((Configuration)conf);
        HRegionFileSystem rfs = HRegionFileSystem.createRegionOnFileSystem(conf, fs, tableDir, info);
        HLog effectiveHLog = hlog;
        if (hlog == null && !ignoreHLog) {
            effectiveHLog = HLogFactory.createHLog(fs, rfs.getRegionDir(), "WALs", conf);
        }
        HRegion region = HRegion.newHRegion(tableDir, effectiveHLog, fs, conf, info, hTableDescriptor, null);
        if (initialize) {
            region.setSequenceId(region.initialize());
        }
        return region;
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, HLog hlog) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, hlog, true);
    }

    public static HRegion openHRegion(HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        return HRegion.openHRegion(FSUtils.getRootDir(conf), info, htd, wal, conf, rsServices, reporter);
    }

    public static HRegion openHRegion(Path rootDir, HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(rootDir, info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(Path rootDir, HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        FileSystem fs = null;
        if (rsServices != null) {
            fs = rsServices.getFileSystem();
        }
        if (fs == null) {
            fs = FileSystem.get((Configuration)conf);
        }
        return HRegion.openHRegion(conf, fs, rootDir, info, htd, wal, rsServices, reporter);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, HRegionInfo info, HTableDescriptor htd, HLog wal) throws IOException {
        return HRegion.openHRegion(conf, fs, rootDir, info, htd, wal, null, null);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, HRegionInfo info, HTableDescriptor htd, HLog wal, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        Path tableDir = FSUtils.getTableDir(rootDir, info.getTable());
        return HRegion.openHRegion(conf, fs, rootDir, tableDir, info, htd, wal, rsServices, reporter);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, Path tableDir, HRegionInfo info, HTableDescriptor htd, HLog wal, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region: " + info));
        }
        HRegion r = HRegion.newHRegion(tableDir, wal, fs, conf, info, htd, rsServices);
        return r.openHRegion(reporter);
    }

    public static HRegion openHRegion(HRegion other, CancelableProgressable reporter) throws IOException {
        HRegionFileSystem regionFs = other.getRegionFileSystem();
        HRegion r = HRegion.newHRegion(regionFs.getTableDir(), other.getLog(), regionFs.getFileSystem(), other.baseConf, other.getRegionInfo(), other.getTableDesc(), null);
        return r.openHRegion(reporter);
    }

    protected HRegion openHRegion(CancelableProgressable reporter) throws IOException {
        this.checkCompressionCodecs();
        this.openSeqNum = this.initialize(reporter);
        this.setSequenceId(this.openSeqNum);
        return this;
    }

    private void checkCompressionCodecs() throws IOException {
        for (HColumnDescriptor fam : this.htableDescriptor.getColumnFamilies()) {
            CompressionTest.testCompression(fam.getCompression());
            CompressionTest.testCompression(fam.getCompactionCompression());
        }
    }

    HRegion createDaughterRegionFromSplits(HRegionInfo hri) throws IOException {
        this.fs.commitDaughterRegion(hri);
        HRegion r = HRegion.newHRegion(this.fs.getTableDir(), this.getLog(), this.fs.getFileSystem(), this.getBaseConf(), hri, this.getTableDesc(), this.rsServices);
        r.readRequestsCount.set(this.getReadRequestsCount() / 2L);
        r.writeRequestsCount.set(this.getWriteRequestsCount() / 2L);
        return r;
    }

    HRegion createMergedRegionFromMerges(HRegionInfo mergedRegionInfo, HRegion region_b) throws IOException {
        HRegion r = HRegion.newHRegion(this.fs.getTableDir(), this.getLog(), this.fs.getFileSystem(), this.getBaseConf(), mergedRegionInfo, this.getTableDesc(), this.rsServices);
        r.readRequestsCount.set(this.getReadRequestsCount() + region_b.getReadRequestsCount());
        r.writeRequestsCount.set(this.getWriteRequestsCount() + region_b.getWriteRequestsCount());
        this.fs.commitMergedRegion(mergedRegionInfo);
        return r;
    }

    public static void addRegionToMETA(HRegion meta, HRegion r) throws IOException {
        meta.checkResources();
        byte[] row = r.getRegionName();
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ArrayList<Cell> cells = new ArrayList<Cell>(2);
        cells.add((Cell)new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, now, r.getRegionInfo().toByteArray()));
        cells.add((Cell)new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER, now, Bytes.toBytes((short)1)));
        meta.put(row, HConstants.CATALOG_FAMILY, cells);
    }

    @Deprecated
    public static Path getRegionDir(Path tabledir, String name) {
        return new Path(tabledir, name);
    }

    @Deprecated
    public static Path getRegionDir(Path rootdir, HRegionInfo info) {
        return new Path(FSUtils.getTableDir(rootdir, info.getTable()), info.getEncodedName());
    }

    public static boolean rowIsInRange(HRegionInfo info, byte[] row) {
        return !(info.getStartKey().length != 0 && Bytes.compareTo((byte[])info.getStartKey(), (byte[])row) > 0 || info.getEndKey().length != 0 && Bytes.compareTo((byte[])info.getEndKey(), (byte[])row) <= 0);
    }

    public static HRegion mergeAdjacent(HRegion srcA, HRegion srcB) throws IOException {
        HRegion a = srcA;
        HRegion b = srcB;
        if (srcA.getStartKey() == null) {
            if (srcB.getStartKey() == null) {
                throw new IOException("Cannot merge two regions with null start key");
            }
        } else if (srcB.getStartKey() == null || Bytes.compareTo((byte[])srcA.getStartKey(), (byte[])srcB.getStartKey()) > 0) {
            a = srcB;
            b = srcA;
        }
        if (Bytes.compareTo((byte[])a.getEndKey(), (byte[])b.getStartKey()) != 0) {
            throw new IOException("Cannot merge non-adjacent regions");
        }
        return HRegion.merge(a, b);
    }

    public static HRegion merge(HRegion a, HRegion b) throws IOException {
        HRegion dstRegion;
        RegionMergeTransaction rmt;
        if (!a.getRegionInfo().getTable().equals((Object)b.getRegionInfo().getTable())) {
            throw new IOException("Regions do not belong to the same table");
        }
        FileSystem fs = a.getRegionFileSystem().getFileSystem();
        a.flushcache();
        b.flushcache();
        a.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + a));
            a.getRegionFileSystem().logFileSystemState(LOG);
        }
        b.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + b));
            b.getRegionFileSystem().logFileSystemState(LOG);
        }
        if (!(rmt = new RegionMergeTransaction(a, b, true)).prepare(null)) {
            throw new IOException("Unable to merge regions " + a + " and " + b);
        }
        HRegionInfo mergedRegionInfo = rmt.getMergedRegionInfo();
        LOG.info((Object)("starting merge of regions: " + a + " and " + b + " into new region " + mergedRegionInfo.getRegionNameAsString() + " with start key <" + Bytes.toStringBinary((byte[])mergedRegionInfo.getStartKey()) + "> and end key <" + Bytes.toStringBinary((byte[])mergedRegionInfo.getEndKey()) + ">"));
        try {
            dstRegion = rmt.execute(null, null);
        }
        catch (IOException ioe) {
            rmt.rollback(null, null);
            throw new IOException("Failed merging region " + a + " and " + b + ", and succssfully rolled back");
        }
        dstRegion.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            dstRegion.getRegionFileSystem().logFileSystemState(LOG);
        }
        if (dstRegion.getRegionFileSystem().hasReferences(dstRegion.getTableDesc())) {
            throw new IOException("Merged region " + dstRegion + " still has references after the compaction, is compaction canceled?");
        }
        HFileArchiver.archiveRegion(a.getBaseConf(), fs, a.getRegionInfo());
        HFileArchiver.archiveRegion(b.getBaseConf(), fs, b.getRegionInfo());
        LOG.info((Object)("merge completed. New region is " + dstRegion));
        return dstRegion;
    }

    boolean isMajorCompaction() throws IOException {
        for (Store store : this.stores.values()) {
            if (!store.isMajorCompaction()) continue;
            return true;
        }
        return false;
    }

    public Result get(Get get) throws IOException {
        this.checkRow(get.getRow(), "Get");
        if (get.hasFamilies()) {
            for (byte[] family : get.familySet()) {
                this.checkFamily(family);
            }
        } else {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                get.addFamily(family);
            }
        }
        List<Cell> results = this.get(get, true);
        return Result.create(results, get.isCheckExistenceOnly() ? Boolean.valueOf(!results.isEmpty()) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Cell> get(Get get, boolean withCoprocessor) throws IOException {
        ArrayList<Cell> results = new ArrayList<Cell>();
        if (withCoprocessor && this.coprocessorHost != null && this.coprocessorHost.preGet(get, results)) {
            return results;
        }
        Scan scan = new Scan(get);
        RegionScanner scanner = null;
        try {
            scanner = this.getScanner(scan);
            scanner.next(results);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        if (withCoprocessor && this.coprocessorHost != null) {
            this.coprocessorHost.postGet(get, results);
        }
        if (this.metricsRegion != null) {
            long totalSize = 0L;
            if (results != null) {
                for (Cell kv : results) {
                    totalSize += (long)KeyValueUtil.ensureKeyValue((Cell)kv).getLength();
                }
            }
            this.metricsRegion.updateGet(totalSize);
        }
        return results;
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.mutateRowsWithLocks(rm.getMutations(), Collections.singleton(rm.getRow()));
    }

    public void mutateRowsWithLocks(Collection<Mutation> mutations, Collection<byte[]> rowsToLock) throws IOException {
        this.mutateRowsWithLocks(mutations, rowsToLock, 0L, 0L);
    }

    public void mutateRowsWithLocks(Collection<Mutation> mutations, Collection<byte[]> rowsToLock, long nonceGroup, long nonce) throws IOException {
        MultiRowMutationProcessor proc = new MultiRowMutationProcessor(mutations, rowsToLock);
        this.processRowsWithLocks(proc, -1L, nonceGroup, nonce);
    }

    public void processRowsWithLocks(RowProcessor<?, ?> processor, long nonceGroup, long nonce) throws IOException {
        this.processRowsWithLocks(processor, this.rowProcessorTimeout, nonceGroup, nonce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRowsWithLocks(RowProcessor<?, ?> processor, long timeout, long nonceGroup, long nonce) throws IOException {
        for (byte[] row : processor.getRowsToLock()) {
            this.checkRow(row, "processRowsWithLocks");
        }
        if (!processor.readOnly()) {
            this.checkReadOnly();
        }
        this.checkResources();
        this.startRegionOperation();
        WALEdit walEdit = new WALEdit();
        processor.preProcess(this, walEdit);
        if (processor.readOnly()) {
            try {
                long now = EnvironmentEdgeManager.currentTimeMillis();
                this.doProcessRowWithTimeout(processor, now, this, null, null, timeout);
                processor.postProcess(this, walEdit);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                this.closeRegionOperation();
            }
            return;
        }
        MultiVersionConsistencyControl.WriteEntry writeEntry = null;
        boolean locked = false;
        boolean walSyncSuccessful = false;
        ArrayList<RowLock> acquiredRowLocks = null;
        long addedSize = 0L;
        ArrayList<KeyValue> mutations = new ArrayList<KeyValue>();
        Collection<byte[]> rowsToLock = processor.getRowsToLock();
        try {
            block30: {
                acquiredRowLocks = new ArrayList<RowLock>(rowsToLock.size());
                for (byte[] row : rowsToLock) {
                    acquiredRowLocks.add(this.getRowLock(row));
                }
                this.lock(this.updatesLock.readLock(), acquiredRowLocks.size());
                locked = true;
                long now = EnvironmentEdgeManager.currentTimeMillis();
                try {
                    this.doProcessRowWithTimeout(processor, now, this, mutations, walEdit, timeout);
                    if (!mutations.isEmpty()) {
                        writeEntry = this.mvcc.beginMemstoreInsert();
                        for (KeyValue kv : mutations) {
                            kv.setMvccVersion(writeEntry.getWriteNumber());
                            byte[] family = kv.getFamily();
                            this.checkFamily(family);
                            addedSize += this.stores.get(family).add(kv);
                        }
                        long txid = 0L;
                        if (!walEdit.isEmpty()) {
                            txid = this.log.appendNoSync(this.getRegionInfo(), this.htableDescriptor.getTableName(), walEdit, processor.getClusterIds(), now, this.htableDescriptor, this.sequenceId, true, nonceGroup, nonce);
                        }
                        if (locked) {
                            this.updatesLock.readLock().unlock();
                            locked = false;
                        }
                        this.releaseRowLocks(acquiredRowLocks);
                        if (txid != 0L) {
                            this.syncOrDefer(txid, this.getEffectiveDurability(processor.useDurability()));
                        }
                        walSyncSuccessful = true;
                    }
                    if (mutations.isEmpty() || walSyncSuccessful) break block30;
                }
                catch (Throwable throwable) {
                    if (!mutations.isEmpty() && !walSyncSuccessful) {
                        LOG.warn((Object)("Wal sync failed. Roll back " + mutations.size() + " memstore keyvalues for row(s):" + processor.getRowsToLock().iterator().next() + "..."));
                        for (KeyValue kv : mutations) {
                            this.stores.get(kv.getFamily()).rollback(kv);
                        }
                    }
                    if (writeEntry != null) {
                        this.mvcc.completeMemstoreInsert(writeEntry);
                        writeEntry = null;
                    }
                    if (locked) {
                        this.updatesLock.readLock().unlock();
                        locked = false;
                    }
                    this.releaseRowLocks(acquiredRowLocks);
                    throw throwable;
                }
                LOG.warn((Object)("Wal sync failed. Roll back " + mutations.size() + " memstore keyvalues for row(s):" + processor.getRowsToLock().iterator().next() + "..."));
                for (KeyValue kv : mutations) {
                    this.stores.get(kv.getFamily()).rollback(kv);
                }
            }
            if (writeEntry != null) {
                this.mvcc.completeMemstoreInsert(writeEntry);
                writeEntry = null;
            }
            if (locked) {
                this.updatesLock.readLock().unlock();
                locked = false;
            }
            this.releaseRowLocks(acquiredRowLocks);
            processor.postProcess(this, walEdit);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.closeRegionOperation();
            if (!mutations.isEmpty() && this.isFlushSize(this.addAndGetGlobalMemstoreSize(addedSize))) {
                this.requestFlush();
            }
        }
    }

    private void doProcessRowWithTimeout(final RowProcessor<?, ?> processor, final long now, final HRegion region, final List<KeyValue> mutations, final WALEdit walEdit, long timeout) throws IOException {
        if (timeout < 0L) {
            try {
                processor.process(now, region, mutations, walEdit);
            }
            catch (IOException e) {
                LOG.warn((Object)("RowProcessor:" + processor.getClass().getName() + " throws Exception on row(s):" + Bytes.toStringBinary((byte[])processor.getRowsToLock().iterator().next()) + "..."), (Throwable)e);
                throw e;
            }
            return;
        }
        FutureTask<Void> task = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                try {
                    processor.process(now, region, mutations, walEdit);
                    return null;
                }
                catch (IOException e) {
                    LOG.warn((Object)("RowProcessor:" + processor.getClass().getName() + " throws Exception on row(s):" + Bytes.toStringBinary((byte[])processor.getRowsToLock().iterator().next()) + "..."), (Throwable)e);
                    throw e;
                }
            }
        });
        this.rowProcessorExecutor.execute(task);
        try {
            task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            LOG.error((Object)("RowProcessor timeout:" + timeout + " ms on row(s):" + Bytes.toStringBinary((byte[])processor.getRowsToLock().iterator().next()) + "..."));
            throw new IOException(te);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Result append(Append append) throws IOException {
        return this.append(append, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result append(Append append, long nonceGroup, long nonce) throws IOException {
        byte[] row = append.getRow();
        this.checkRow(row, "append");
        boolean flush = false;
        Durability durability = this.getEffectiveDurability(append.getDurability());
        boolean writeToWAL = durability != Durability.SKIP_WAL;
        WALEdit walEdits = null;
        ArrayList allKVs = new ArrayList(append.size());
        HashMap tempMemstore = new HashMap();
        long size = 0L;
        long txid = 0L;
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation(Operation.APPEND);
        this.writeRequestsCount.increment();
        MultiVersionConsistencyControl.WriteEntry w = null;
        try {
            RowLock rowLock = this.getRowLock(row);
            try {
                this.lock(this.updatesLock.readLock());
                this.mvcc.completeMemstoreInsert(this.mvcc.beginMemstoreInsert());
                w = this.mvcc.beginMemstoreInsert();
                try {
                    Store store;
                    long now = EnvironmentEdgeManager.currentTimeMillis();
                    for (Map.Entry family : append.getFamilyCellMap().entrySet()) {
                        store = this.stores.get(family.getKey());
                        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(((List)family.getValue()).size());
                        Collections.sort((List)family.getValue(), store.getComparator());
                        Get get = new Get(row);
                        for (Cell cell : (List)family.getValue()) {
                            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                            get.addColumn((byte[])family.getKey(), kv.getQualifier());
                        }
                        List<Cell> results = this.get(get, false);
                        int idx = 0;
                        for (Cell cell : (List)family.getValue()) {
                            KeyValue newKV;
                            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                            KeyValue oldKv = null;
                            if (idx < results.size() && CellUtil.matchingQualifier((Cell)results.get(idx), (Cell)kv)) {
                                oldKv = KeyValueUtil.ensureKeyValue((Cell)results.get(idx));
                                newKV = new KeyValue(row.length, (int)kv.getFamilyLength(), kv.getQualifierLength(), now, KeyValue.Type.Put, oldKv.getValueLength() + kv.getValueLength(), oldKv.getTagsLength() + kv.getTagsLength());
                                System.arraycopy(oldKv.getBuffer(), oldKv.getValueOffset(), newKV.getBuffer(), newKV.getValueOffset(), oldKv.getValueLength());
                                System.arraycopy(kv.getBuffer(), kv.getValueOffset(), newKV.getBuffer(), newKV.getValueOffset() + oldKv.getValueLength(), kv.getValueLength());
                                System.arraycopy(oldKv.getBuffer(), oldKv.getTagsOffset(), newKV.getBuffer(), newKV.getTagsOffset(), oldKv.getTagsLength());
                                System.arraycopy(kv.getBuffer(), kv.getTagsOffset(), newKV.getBuffer(), newKV.getTagsOffset() + oldKv.getTagsLength(), kv.getTagsLength());
                                System.arraycopy(kv.getBuffer(), kv.getRowOffset(), newKV.getBuffer(), newKV.getRowOffset(), kv.getRowLength());
                                System.arraycopy(kv.getBuffer(), kv.getFamilyOffset(), newKV.getBuffer(), newKV.getFamilyOffset(), kv.getFamilyLength());
                                System.arraycopy(kv.getBuffer(), kv.getQualifierOffset(), newKV.getBuffer(), newKV.getQualifierOffset(), kv.getQualifierLength());
                                ++idx;
                            } else {
                                newKV = kv;
                                newKV.updateLatestStamp(Bytes.toBytes((long)now));
                            }
                            newKV.setMvccVersion(w.getWriteNumber());
                            if (this.coprocessorHost != null) {
                                newKV = KeyValueUtil.ensureKeyValue((Cell)this.coprocessorHost.postMutationBeforeWAL(RegionObserver.MutationType.APPEND, (Mutation)append, (Cell)oldKv, (Cell)newKV));
                            }
                            kvs.add(newKV);
                            if (!writeToWAL) continue;
                            if (walEdits == null) {
                                walEdits = new WALEdit();
                            }
                            walEdits.add(newKV);
                        }
                        tempMemstore.put(store, kvs);
                    }
                    if (writeToWAL) {
                        txid = this.log.appendNoSync(this.getRegionInfo(), this.htableDescriptor.getTableName(), walEdits, new ArrayList<UUID>(), EnvironmentEdgeManager.currentTimeMillis(), this.htableDescriptor, this.sequenceId, true, nonceGroup, nonce);
                    } else {
                        this.recordMutationWithoutWal(append.getFamilyCellMap());
                    }
                    for (Map.Entry entry : tempMemstore.entrySet()) {
                        store = (Store)entry.getKey();
                        if (store.getFamily().getMaxVersions() == 1) {
                            size += store.upsert((Iterable)entry.getValue(), this.getSmallestReadPoint());
                        } else {
                            for (Cell cell : (List)entry.getValue()) {
                                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                                size += store.add(kv);
                            }
                        }
                        allKVs.addAll((Collection)entry.getValue());
                    }
                    size = this.addAndGetGlobalMemstoreSize(size);
                    flush = this.isFlushSize(size);
                }
                finally {
                    this.updatesLock.readLock().unlock();
                }
            }
            finally {
                rowLock.release();
            }
            if (writeToWAL) {
                this.syncOrDefer(txid, durability);
            }
            if (w != null) {
                this.mvcc.completeMemstoreInsert(w);
            }
        }
        catch (Throwable throwable) {
            if (w != null) {
                this.mvcc.completeMemstoreInsert(w);
            }
            this.closeRegionOperation(Operation.APPEND);
            throw throwable;
        }
        this.closeRegionOperation(Operation.APPEND);
        if (this.metricsRegion != null) {
            this.metricsRegion.updateAppend();
        }
        if (flush) {
            this.requestFlush();
        }
        return append.isReturnResults() ? Result.create(allKVs) : null;
    }

    public Result increment(Increment increment) throws IOException {
        return this.increment(increment, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result increment(Increment increment, long nonceGroup, long nonce) throws IOException {
        ArrayList<KeyValue> allKVs;
        boolean flush;
        block31: {
            byte[] row = increment.getRow();
            this.checkRow(row, "increment");
            TimeRange tr = increment.getTimeRange();
            flush = false;
            Durability durability = this.getEffectiveDurability(increment.getDurability());
            boolean writeToWAL = durability != Durability.SKIP_WAL;
            WALEdit walEdits = null;
            allKVs = new ArrayList<KeyValue>(increment.size());
            HashMap tempMemstore = new HashMap();
            long size = 0L;
            long txid = 0L;
            this.checkReadOnly();
            this.checkResources();
            this.startRegionOperation(Operation.INCREMENT);
            this.writeRequestsCount.increment();
            MultiVersionConsistencyControl.WriteEntry w = null;
            try {
                RowLock rowLock = this.getRowLock(row);
                try {
                    this.lock(this.updatesLock.readLock());
                    this.mvcc.completeMemstoreInsert(this.mvcc.beginMemstoreInsert());
                    w = this.mvcc.beginMemstoreInsert();
                    try {
                        Store store;
                        long now = EnvironmentEdgeManager.currentTimeMillis();
                        for (Map.Entry family : increment.getFamilyCellMap().entrySet()) {
                            store = this.stores.get(family.getKey());
                            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(((List)family.getValue()).size());
                            Collections.sort((List)family.getValue(), store.getComparator());
                            Get get = new Get(row);
                            for (Cell cell : (List)family.getValue()) {
                                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                                get.addColumn((byte[])family.getKey(), kv.getQualifier());
                            }
                            get.setTimeRange(tr.getMin(), tr.getMax());
                            List<Cell> results = this.get(get, false);
                            int idx = 0;
                            for (Cell kv : (List)family.getValue()) {
                                long amount = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv));
                                boolean noWriteBack = amount == 0L;
                                Cell c = null;
                                if (idx < results.size() && CellUtil.matchingQualifier((Cell)results.get(idx), (Cell)kv)) {
                                    c = results.get(idx);
                                    if (c.getValueLength() == 8) {
                                        amount += Bytes.toLong((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)8);
                                    } else {
                                        throw new DoNotRetryIOException("Attempted to increment field that isn't 64 bits wide");
                                    }
                                    ++idx;
                                }
                                byte[] q = CellUtil.cloneQualifier((Cell)kv);
                                byte[] val = Bytes.toBytes((long)amount);
                                short oldCellTagsLen = c == null ? (short)0 : c.getTagsLength();
                                short incCellTagsLen = kv.getTagsLength();
                                KeyValue newKV = new KeyValue(row.length, ((byte[])family.getKey()).length, q.length, now, KeyValue.Type.Put, val.length, oldCellTagsLen + incCellTagsLen);
                                System.arraycopy(row, 0, newKV.getBuffer(), newKV.getRowOffset(), row.length);
                                System.arraycopy(family.getKey(), 0, newKV.getBuffer(), newKV.getFamilyOffset(), ((byte[])family.getKey()).length);
                                System.arraycopy(q, 0, newKV.getBuffer(), newKV.getQualifierOffset(), q.length);
                                System.arraycopy(val, 0, newKV.getBuffer(), newKV.getValueOffset(), val.length);
                                if (oldCellTagsLen > 0) {
                                    System.arraycopy(c.getTagsArray(), c.getTagsOffset(), newKV.getBuffer(), newKV.getTagsOffset(), oldCellTagsLen);
                                }
                                if (incCellTagsLen > 0) {
                                    System.arraycopy(kv.getTagsArray(), kv.getTagsOffset(), newKV.getBuffer(), newKV.getTagsOffset() + oldCellTagsLen, incCellTagsLen);
                                }
                                newKV.setMvccVersion(w.getWriteNumber());
                                if (this.coprocessorHost != null) {
                                    newKV = KeyValueUtil.ensureKeyValue((Cell)this.coprocessorHost.postMutationBeforeWAL(RegionObserver.MutationType.INCREMENT, (Mutation)increment, c, (Cell)newKV));
                                }
                                allKVs.add(newKV);
                                if (noWriteBack) continue;
                                kvs.add(newKV);
                                if (!writeToWAL) continue;
                                if (walEdits == null) {
                                    walEdits = new WALEdit();
                                }
                                walEdits.add(newKV);
                            }
                            if (kvs.isEmpty()) continue;
                            tempMemstore.put(store, kvs);
                        }
                        if (walEdits != null && !walEdits.isEmpty()) {
                            if (writeToWAL) {
                                txid = this.log.appendNoSync(this.getRegionInfo(), this.htableDescriptor.getTableName(), walEdits, new ArrayList<UUID>(), EnvironmentEdgeManager.currentTimeMillis(), this.htableDescriptor, this.sequenceId, true, nonceGroup, nonce);
                            } else {
                                this.recordMutationWithoutWal(increment.getFamilyCellMap());
                            }
                        }
                        if (!tempMemstore.isEmpty()) {
                            for (Map.Entry entry : tempMemstore.entrySet()) {
                                store = (Store)entry.getKey();
                                if (store.getFamily().getMaxVersions() == 1) {
                                    size += store.upsert((Iterable)entry.getValue(), this.getSmallestReadPoint());
                                    continue;
                                }
                                for (Cell cell : (List)entry.getValue()) {
                                    KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                                    size += store.add(kv);
                                }
                            }
                            size = this.addAndGetGlobalMemstoreSize(size);
                            flush = this.isFlushSize(size);
                        }
                    }
                    finally {
                        this.updatesLock.readLock().unlock();
                    }
                }
                finally {
                    rowLock.release();
                }
                if (writeToWAL && walEdits != null && !walEdits.isEmpty()) {
                    this.syncOrDefer(txid, durability);
                }
                if (w == null) break block31;
                this.mvcc.completeMemstoreInsert(w);
            }
            catch (Throwable throwable) {
                if (w != null) {
                    this.mvcc.completeMemstoreInsert(w);
                }
                this.closeRegionOperation(Operation.INCREMENT);
                if (this.metricsRegion != null) {
                    this.metricsRegion.updateIncrement();
                }
                throw throwable;
            }
        }
        this.closeRegionOperation(Operation.INCREMENT);
        if (this.metricsRegion != null) {
            this.metricsRegion.updateIncrement();
        }
        if (flush) {
            this.requestFlush();
        }
        return Result.create(allKVs);
    }

    private void checkFamily(byte[] family) throws NoSuchColumnFamilyException {
        if (!this.htableDescriptor.hasFamily(family)) {
            throw new NoSuchColumnFamilyException("Column family " + Bytes.toString((byte[])family) + " does not exist in region " + this + " in table " + this.htableDescriptor);
        }
    }

    public long heapSize() {
        long heapSize = DEEP_OVERHEAD;
        for (Store store : this.stores.values()) {
            heapSize += store.heapSize();
        }
        return heapSize;
    }

    private static void printUsageAndExit(String message) {
        if (message != null && message.length() > 0) {
            System.out.println(message);
        }
        System.out.println("Usage: HRegion CATLALOG_TABLE_DIR [major_compact]");
        System.out.println("Options:");
        System.out.println(" major_compact  Pass this option to major compact passed region.");
        System.out.println("Default outputs scan of passed region.");
        System.exit(1);
    }

    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        if (this.coprocessorServiceHandlers.containsKey(serviceDesc.getFullName())) {
            LOG.error((Object)("Coprocessor service " + serviceDesc.getFullName() + " already registered, rejecting request from " + instance));
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceDesc.getFullName(), instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered coprocessor service: region=" + Bytes.toStringBinary((byte[])this.getRegionName()) + " service=" + serviceDesc.getFullName()));
        }
        return true;
    }

    public Message execService(RpcController controller, ClientProtos.CoprocessorServiceCall call) throws IOException {
        String serviceName = call.getServiceName();
        String methodName = call.getMethodName();
        if (!this.coprocessorServiceHandlers.containsKey(serviceName)) {
            throw new UnknownProtocolException(null, "No registered coprocessor service found for name " + serviceName + " in region " + Bytes.toStringBinary((byte[])this.getRegionName()));
        }
        Service service = this.coprocessorServiceHandlers.get(serviceName);
        Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
        Descriptors.MethodDescriptor methodDesc = serviceDesc.findMethodByName(methodName);
        if (methodDesc == null) {
            throw new UnknownProtocolException(service.getClass(), "Unknown method " + methodName + " called on service " + serviceName + " in region " + Bytes.toStringBinary((byte[])this.getRegionName()));
        }
        Message request = service.getRequestPrototype(methodDesc).newBuilderForType().mergeFrom(call.getRequest()).build();
        if (this.coprocessorHost != null) {
            request = this.coprocessorHost.preEndpointInvocation(service, methodName, request);
        }
        final Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
        service.callMethod(methodDesc, controller, request, (RpcCallback)new RpcCallback<Message>(){

            public void run(Message message) {
                if (message != null) {
                    responseBuilder.mergeFrom(message);
                }
            }
        });
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postEndpointInvocation(service, methodName, request, responseBuilder);
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTable(FileSystem fs, Path p, HLog log, Configuration c, boolean majorCompact) throws IOException {
        block9: {
            HRegion region = null;
            if (!FSUtils.getTableName(p).equals((Object)TableName.META_TABLE_NAME)) {
                throw new IOException("Not a known catalog table: " + p.toString());
            }
            region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.FIRST_META_REGIONINFO, HTableDescriptor.META_TABLEDESC, null);
            try {
                region.initialize();
                if (majorCompact) {
                    region.compactStores(true);
                    break block9;
                }
                Scan scan = new Scan();
                RegionScanner scanner = region.getScanner(scan);
                try {
                    boolean done;
                    ArrayList<Cell> kvs = new ArrayList<Cell>();
                    do {
                        kvs.clear();
                        done = scanner.next(kvs);
                        if (kvs.size() <= 0) continue;
                        LOG.info(kvs);
                    } while (done);
                }
                finally {
                    scanner.close();
                }
            }
            finally {
                region.close();
            }
        }
    }

    boolean shouldForceSplit() {
        return this.splitRequest;
    }

    byte[] getExplicitSplitPoint() {
        return this.explicitSplitPoint;
    }

    void forceSplit(byte[] sp) {
        this.splitRequest = true;
        if (sp != null) {
            this.explicitSplitPoint = sp;
        }
    }

    void clearSplit_TESTS_ONLY() {
        this.splitRequest = false;
    }

    protected void prepareToSplit() {
    }

    public byte[] checkSplit() {
        if (this.getRegionInfo().isMetaTable() || TableName.NAMESPACE_TABLE_NAME.equals((Object)this.getRegionInfo().getTable())) {
            if (this.shouldForceSplit()) {
                LOG.warn((Object)"Cannot split meta region in HBase 0.20 and above");
            }
            return null;
        }
        if (this.isRecovering()) {
            LOG.info((Object)("Cannot split region " + this.getRegionInfo().getEncodedName() + " in recovery."));
            return null;
        }
        if (!this.splitPolicy.shouldSplit()) {
            return null;
        }
        byte[] ret = this.splitPolicy.getSplitPoint();
        if (ret != null) {
            try {
                this.checkRow(ret, "calculated split");
            }
            catch (IOException e) {
                LOG.error((Object)"Ignoring invalid split", (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public int getCompactPriority() {
        int count = Integer.MAX_VALUE;
        for (Store store : this.stores.values()) {
            count = Math.min(count, store.getCompactPriority());
        }
        return count;
    }

    public boolean needsCompaction() {
        for (Store store : this.stores.values()) {
            if (!store.needsCompaction()) continue;
            return true;
        }
        return false;
    }

    public RegionCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    public void setCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
        this.coprocessorHost = coprocessorHost;
    }

    public void startRegionOperation() throws IOException {
        this.startRegionOperation(Operation.ANY);
    }

    protected void startRegionOperation(Operation op) throws IOException {
        switch (op) {
            case INCREMENT: 
            case APPEND: 
            case GET: 
            case SCAN: 
            case SPLIT_REGION: 
            case MERGE_REGION: 
            case PUT: 
            case DELETE: 
            case BATCH_MUTATE: 
            case COMPACT_REGION: {
                if (!this.isRecovering() || !this.disallowWritesInRecovering && (op == Operation.PUT || op == Operation.DELETE || op == Operation.BATCH_MUTATE)) break;
                throw new RegionInRecoveryException(this.getRegionNameAsString() + " is recovering");
            }
        }
        if (op == Operation.MERGE_REGION || op == Operation.SPLIT_REGION || op == Operation.COMPACT_REGION) {
            return;
        }
        if (this.closing.get()) {
            throw new NotServingRegionException(this.getRegionNameAsString() + " is closing");
        }
        this.lock(this.lock.readLock());
        if (this.closed.get()) {
            this.lock.readLock().unlock();
            throw new NotServingRegionException(this.getRegionNameAsString() + " is closed");
        }
        try {
            if (this.coprocessorHost != null) {
                this.coprocessorHost.postStartRegionOperation(op);
            }
        }
        catch (Exception e) {
            this.lock.readLock().unlock();
            throw new IOException(e);
        }
    }

    public void closeRegionOperation() throws IOException {
        this.closeRegionOperation(Operation.ANY);
    }

    public void closeRegionOperation(Operation operation) throws IOException {
        this.lock.readLock().unlock();
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postCloseRegionOperation(operation);
        }
    }

    private void startBulkRegionOperation(boolean writeLockNeeded) throws NotServingRegionException, RegionTooBusyException, InterruptedIOException {
        if (this.closing.get()) {
            throw new NotServingRegionException(this.getRegionNameAsString() + " is closing");
        }
        if (writeLockNeeded) {
            this.lock(this.lock.writeLock());
        } else {
            this.lock(this.lock.readLock());
        }
        if (this.closed.get()) {
            if (writeLockNeeded) {
                this.lock.writeLock().unlock();
            } else {
                this.lock.readLock().unlock();
            }
            throw new NotServingRegionException(this.getRegionNameAsString() + " is closed");
        }
    }

    private void closeBulkRegionOperation() {
        if (this.lock.writeLock().isHeldByCurrentThread()) {
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().unlock();
        }
    }

    private void recordMutationWithoutWal(Map<byte[], List<Cell>> familyMap) {
        this.numMutationsWithoutWAL.increment();
        if (this.numMutationsWithoutWAL.get() <= 1L) {
            LOG.info((Object)("writing data to region " + this + " with WAL disabled. Data may be lost in the event of a crash."));
        }
        long mutationSize = 0L;
        for (List<Cell> cells : familyMap.values()) {
            for (Cell cell : cells) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                mutationSize += (long)(kv.getKeyLength() + kv.getValueLength());
            }
        }
        this.dataInMemoryWithoutWAL.add(mutationSize);
    }

    private void lock(Lock lock) throws RegionTooBusyException, InterruptedIOException {
        this.lock(lock, 1);
    }

    private void lock(Lock lock, int multiplier) throws RegionTooBusyException, InterruptedIOException {
        try {
            long waitTime = Math.min(this.maxBusyWaitDuration, this.busyWaitDuration * (long)Math.min(multiplier, this.maxBusyWaitMultiplier));
            if (!lock.tryLock(waitTime, TimeUnit.MILLISECONDS)) {
                throw new RegionTooBusyException("failed to get a lock in " + waitTime + " ms. " + "regionName=" + (this.getRegionInfo() == null ? "unknown" : this.getRegionInfo().getRegionNameAsString()) + ", server=" + (this.getRegionServerServices() == null ? "unknown" : this.getRegionServerServices().getServerName()));
            }
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted while waiting for a lock");
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(ie);
            throw iie;
        }
    }

    private void syncOrDefer(long txid, Durability durability) throws IOException {
        if (this.getRegionInfo().isMetaRegion()) {
            this.log.sync(txid);
        } else {
            switch (durability) {
                case USE_DEFAULT: {
                    if (!this.shouldSyncLog()) break;
                    this.log.sync(txid);
                    break;
                }
                case SKIP_WAL: {
                    break;
                }
                case ASYNC_WAL: {
                    break;
                }
                case SYNC_WAL: 
                case FSYNC_WAL: {
                    this.log.sync(txid);
                }
            }
        }
    }

    private boolean shouldSyncLog() {
        return this.durability.ordinal() > Durability.ASYNC_WAL.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            HRegion.printUsageAndExit(null);
        }
        boolean majorCompact = false;
        if (args.length > 1) {
            if (!args[1].toLowerCase().startsWith("major")) {
                HRegion.printUsageAndExit("ERROR: Unrecognized option <" + args[1] + ">");
            }
            majorCompact = true;
        }
        Path tableDir = new Path(args[0]);
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        Path logdir = new Path(c.get("hbase.tmp.dir"));
        String logname = "hlog" + FSUtils.getTableName(tableDir) + System.currentTimeMillis();
        HLog log = HLogFactory.createHLog(fs, logdir, logname, c);
        try {
            HRegion.processTable(fs, tableDir, log, c, majorCompact);
        }
        finally {
            log.close();
            BlockCache bc = new CacheConfig(c).getBlockCache();
            if (bc != null) {
                bc.shutdown();
            }
        }
    }

    public long getOpenSeqNum() {
        return this.openSeqNum;
    }

    public Map<byte[], Long> getMaxStoreSeqIdForLogReplay() {
        return this.maxSeqIdInStores;
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState() {
        boolean hasMinor;
        boolean hasMajor = this.majorInProgress.get() > 0;
        boolean bl = hasMinor = this.minorInProgress.get() > 0;
        return hasMajor ? (hasMinor ? AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR : AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR) : (hasMinor ? AdminProtos.GetRegionInfoResponse.CompactionState.MINOR : AdminProtos.GetRegionInfoResponse.CompactionState.NONE);
    }

    public void reportCompactionRequestStart(boolean isMajor) {
        (isMajor ? this.majorInProgress : this.minorInProgress).incrementAndGet();
    }

    public void reportCompactionRequestEnd(boolean isMajor, int numFiles, long filesSizeCompacted) {
        int newValue = (isMajor ? this.majorInProgress : this.minorInProgress).decrementAndGet();
        this.compactionsFinished.incrementAndGet();
        this.compactionNumFilesCompacted.addAndGet(numFiles);
        this.compactionNumBytesCompacted.addAndGet(filesSizeCompacted);
        assert (newValue >= 0);
    }

    public AtomicLong getSequenceId() {
        return this.sequenceId;
    }

    private void setSequenceId(long value) {
        this.sequenceId.set(value);
    }

    public void updatesLock() throws RegionTooBusyException, InterruptedIOException {
        this.lock(this.updatesLock.readLock());
    }

    public void updatesUnlock() throws InterruptedIOException {
        this.updatesLock.readLock().unlock();
    }

    public static class RowLock {
        @VisibleForTesting
        final RowLockContext context;
        private boolean released = false;

        @VisibleForTesting
        RowLock(RowLockContext context) {
            this.context = context;
        }

        public void release() {
            if (!this.released) {
                this.context.releaseLock();
                this.released = true;
            }
        }
    }

    @VisibleForTesting
    class RowLockContext {
        private final HashedBytes row;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Thread thread;
        private int lockCount = 0;

        RowLockContext(HashedBytes row) {
            this.row = row;
            this.thread = Thread.currentThread();
        }

        boolean ownedByCurrentThread() {
            return this.thread == Thread.currentThread();
        }

        RowLock newLock() {
            ++this.lockCount;
            return new RowLock(this);
        }

        void releaseLock() {
            if (!this.ownedByCurrentThread()) {
                throw new IllegalArgumentException("Lock held by thread: " + this.thread + " cannot be released by different thread: " + Thread.currentThread());
            }
            --this.lockCount;
            if (this.lockCount == 0) {
                RowLockContext existingContext = (RowLockContext)HRegion.this.lockedRows.remove(this.row);
                if (existingContext != this) {
                    throw new RuntimeException("Internal row lock state inconsistent, should not happen, row: " + this.row);
                }
                this.latch.countDown();
            }
        }
    }

    public static interface BulkLoadListener {
        public String prepareBulkLoad(byte[] var1, String var2) throws IOException;

        public void doneBulkLoad(byte[] var1, String var2) throws IOException;

        public void failedBulkLoad(byte[] var1, String var2) throws IOException;
    }

    class RegionScannerImpl
    implements RegionScanner {
        KeyValueHeap storeHeap = null;
        KeyValueHeap joinedHeap = null;
        protected KeyValue joinedContinuationRow = null;
        private final KeyValue KV_LIMIT = new KeyValue();
        protected final byte[] stopRow;
        private final Filter filter;
        private int batch;
        protected int isScan;
        private boolean filterClosed = false;
        private long readPt;
        private long maxResultSize;
        protected HRegion region;

        @Override
        public HRegionInfo getRegionInfo() {
            return this.region.getRegionInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
            this.region = region;
            this.maxResultSize = scan.getMaxResultSize();
            this.filter = scan.hasFilter() ? new FilterWrapper(scan.getFilter()) : null;
            this.batch = scan.getBatch();
            this.stopRow = (byte[])(Bytes.equals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW) && !scan.isGetScan() ? null : scan.getStopRow());
            this.isScan = scan.isGetScan() ? -1 : 0;
            IsolationLevel isolationLevel = scan.getIsolationLevel();
            ConcurrentHashMap concurrentHashMap = HRegion.this.scannerReadPoints;
            synchronized (concurrentHashMap) {
                this.readPt = HRegion.this.getReadpoint(isolationLevel);
                HRegion.this.scannerReadPoints.put(this, this.readPt);
            }
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
            ArrayList<KeyValueScanner> joinedScanners = new ArrayList<KeyValueScanner>();
            if (additionalScanners != null) {
                scanners.addAll(additionalScanners);
            }
            for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
                Store store = HRegion.this.stores.get(entry.getKey());
                KeyValueScanner scanner = store.getScanner(scan, (NavigableSet)entry.getValue(), this.readPt);
                if (this.filter == null || !scan.doLoadColumnFamiliesOnDemand() || this.filter.isFamilyEssential((byte[])entry.getKey())) {
                    scanners.add(scanner);
                    continue;
                }
                joinedScanners.add(scanner);
            }
            this.initializeKVHeap(scanners, joinedScanners, region);
        }

        RegionScannerImpl(Scan scan, HRegion region) throws IOException {
            this(scan, null, region);
        }

        protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
            this.storeHeap = new KeyValueHeap(scanners, region.comparator);
            if (!joinedScanners.isEmpty()) {
                this.joinedHeap = new KeyValueHeap(joinedScanners, region.comparator);
            }
        }

        @Override
        public long getMaxResultSize() {
            return this.maxResultSize;
        }

        @Override
        public long getMvccReadPoint() {
            return this.readPt;
        }

        protected void resetFilters() throws IOException {
            if (this.filter != null) {
                this.filter.reset();
            }
        }

        @Override
        public boolean next(List<Cell> outResults) throws IOException {
            return this.next(outResults, this.batch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean next(List<Cell> outResults, int limit) throws IOException {
            if (this.filterClosed) {
                throw new UnknownScannerException("Scanner was closed (timed out?) after we renewed it. Could be caused by a very slow scanner or a lengthy garbage collection");
            }
            HRegion.this.startRegionOperation(Operation.SCAN);
            HRegion.this.readRequestsCount.increment();
            try {
                boolean bl = this.nextRaw(outResults, limit);
                return bl;
            }
            finally {
                HRegion.this.closeRegionOperation(Operation.SCAN);
            }
        }

        @Override
        public boolean nextRaw(List<Cell> outResults) throws IOException {
            return this.nextRaw(outResults, this.batch);
        }

        @Override
        public boolean nextRaw(List<Cell> outResults, int limit) throws IOException {
            boolean returnResult;
            if (outResults.isEmpty()) {
                returnResult = this.nextInternal(outResults, limit);
            } else {
                ArrayList<Cell> tmpList = new ArrayList<Cell>();
                returnResult = this.nextInternal(tmpList, limit);
                outResults.addAll(tmpList);
            }
            this.resetFilters();
            if (this.isFilterDoneInternal()) {
                return false;
            }
            if (this.region != null && this.region.metricsRegion != null) {
                long totalSize = 0L;
                for (Cell c : outResults) {
                    KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)c);
                    totalSize += (long)kv.getLength();
                }
                this.region.metricsRegion.updateScanNext(totalSize);
            }
            return returnResult;
        }

        private void populateFromJoinedHeap(List<Cell> results, int limit) throws IOException {
            assert (this.joinedContinuationRow != null);
            KeyValue kv = this.populateResult(results, this.joinedHeap, limit, this.joinedContinuationRow.getBuffer(), this.joinedContinuationRow.getRowOffset(), this.joinedContinuationRow.getRowLength());
            if (kv != this.KV_LIMIT) {
                this.joinedContinuationRow = null;
            }
            Collections.sort(results, HRegion.this.comparator);
        }

        private KeyValue populateResult(List<Cell> results, KeyValueHeap heap, int limit, byte[] currentRow, int offset, short length) throws IOException {
            KeyValue nextKv;
            do {
                heap.next(results, limit - results.size());
                if (limit <= 0 || results.size() != limit) continue;
                return this.KV_LIMIT;
            } while ((nextKv = heap.peek()) != null && nextKv.matchingRow(currentRow, offset, (int)length));
            return nextKv;
        }

        @Override
        public synchronized boolean isFilterDone() throws IOException {
            return this.isFilterDoneInternal();
        }

        private boolean isFilterDoneInternal() throws IOException {
            return this.filter != null && this.filter.filterAllRemaining();
        }

        private boolean nextInternal(List<Cell> results, int limit) throws IOException {
            boolean stopRow;
            if (!results.isEmpty()) {
                throw new IllegalArgumentException("First parameter should be an empty list");
            }
            RpcCallContext rpcCall = RpcServer.getCurrentCall();
            while (true) {
                long afterTime;
                if (rpcCall != null && (afterTime = rpcCall.disconnectSince()) >= 0L) {
                    throw new CallerDisconnectedException("Aborting on region " + HRegion.this.getRegionNameAsString() + ", call " + this + " after " + afterTime + " ms, since " + "caller disconnected");
                }
                KeyValue current = this.storeHeap.peek();
                byte[] currentRow = null;
                int offset = 0;
                short length = 0;
                if (current != null) {
                    currentRow = current.getBuffer();
                    offset = current.getRowOffset();
                    length = current.getRowLength();
                }
                stopRow = this.isStopRow(currentRow, offset, length);
                if (this.joinedContinuationRow == null) {
                    if (stopRow) {
                        if (this.filter != null && this.filter.hasFilterRow()) {
                            this.filter.filterRowCells(results);
                        }
                        return false;
                    }
                    if (this.filterRowKey(currentRow, offset, length)) {
                        boolean moreRows = this.nextRow(currentRow, offset, length);
                        if (!moreRows) {
                            return false;
                        }
                        results.clear();
                        continue;
                    }
                    KeyValue nextKv = this.populateResult(results, this.storeHeap, limit, currentRow, offset, length);
                    if (nextKv == this.KV_LIMIT) {
                        if (this.filter != null && this.filter.hasFilterRow()) {
                            throw new IncompatibleFilterException("Filter whose hasFilterRow() returns true is incompatible with scan with limit!");
                        }
                        return true;
                    }
                    stopRow = nextKv == null || this.isStopRow(nextKv.getBuffer(), nextKv.getRowOffset(), nextKv.getRowLength());
                    boolean isEmptyRow = results.isEmpty();
                    if (this.filter != null && this.filter.hasFilterRow()) {
                        this.filter.filterRowCells(results);
                    }
                    if (isEmptyRow || this.filterRow()) {
                        results.clear();
                        boolean moreRows = this.nextRow(currentRow, offset, length);
                        if (!moreRows) {
                            return false;
                        }
                        if (!stopRow) continue;
                        return false;
                    }
                    if (this.joinedHeap != null) {
                        boolean mayHaveData;
                        KeyValue nextJoinedKv = this.joinedHeap.peek();
                        boolean bl = mayHaveData = nextJoinedKv != null && nextJoinedKv.matchingRow(currentRow, offset, (int)length) || this.joinedHeap.requestSeek(KeyValue.createFirstOnRow((byte[])currentRow, (int)offset, (short)length), true, true) && this.joinedHeap.peek() != null && this.joinedHeap.peek().matchingRow(currentRow, offset, (int)length);
                        if (mayHaveData) {
                            this.joinedContinuationRow = current;
                            this.populateFromJoinedHeap(results, limit);
                        }
                    }
                } else {
                    this.populateFromJoinedHeap(results, limit);
                }
                if (this.joinedContinuationRow != null) {
                    return true;
                }
                if (!results.isEmpty()) break;
                boolean moreRows = this.nextRow(currentRow, offset, length);
                if (!moreRows) {
                    return false;
                }
                if (stopRow) break;
            }
            return !stopRow;
        }

        private boolean filterRow() throws IOException {
            return this.filter != null && !this.filter.hasFilterRow() && this.filter.filterRow();
        }

        private boolean filterRowKey(byte[] row, int offset, short length) throws IOException {
            return this.filter != null && this.filter.filterRowKey(row, offset, (int)length);
        }

        protected boolean nextRow(byte[] currentRow, int offset, short length) throws IOException {
            KeyValue next;
            assert (this.joinedContinuationRow == null) : "Trying to go to next row during joinedHeap read.";
            while ((next = this.storeHeap.peek()) != null && next.matchingRow(currentRow, offset, (int)length)) {
                this.storeHeap.next(MOCKED_LIST);
            }
            this.resetFilters();
            return this.region.getCoprocessorHost() == null || this.region.getCoprocessorHost().postScannerFilterRow(this, currentRow, offset, length);
        }

        protected boolean isStopRow(byte[] currentRow, int offset, short length) {
            return currentRow == null || this.stopRow != null && HRegion.this.comparator.compareRows(this.stopRow, 0, this.stopRow.length, currentRow, offset, (int)length) <= this.isScan;
        }

        @Override
        public synchronized void close() {
            if (this.storeHeap != null) {
                this.storeHeap.close();
                this.storeHeap = null;
            }
            if (this.joinedHeap != null) {
                this.joinedHeap.close();
                this.joinedHeap = null;
            }
            HRegion.this.scannerReadPoints.remove(this);
            this.filterClosed = true;
        }

        KeyValueHeap getStoreHeapForTesting() {
            return this.storeHeap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean reseek(byte[] row) throws IOException {
            if (row == null) {
                throw new IllegalArgumentException("Row cannot be null.");
            }
            boolean result = false;
            HRegion.this.startRegionOperation();
            try {
                KeyValue kv = KeyValue.createFirstOnRow((byte[])row);
                result = this.storeHeap.requestSeek(kv, true, true);
                if (this.joinedHeap != null) {
                    result = this.joinedHeap.requestSeek(kv, true, true) || result;
                }
            }
            finally {
                HRegion.this.closeRegionOperation();
            }
            return result;
        }
    }

    private static class ReplayBatch
    extends BatchOperationInProgress<HLogSplitter.MutationReplay> {
        public ReplayBatch(HLogSplitter.MutationReplay[] operations) {
            super(operations);
        }

        @Override
        public Mutation getMutation(int index) {
            return ((HLogSplitter.MutationReplay[])this.operations)[index].mutation;
        }

        @Override
        public long getNonceGroup(int index) {
            return ((HLogSplitter.MutationReplay[])this.operations)[index].nonceGroup;
        }

        @Override
        public long getNonce(int index) {
            return ((HLogSplitter.MutationReplay[])this.operations)[index].nonce;
        }

        @Override
        public Mutation[] getMutationsForCoprocs() {
            assert (false);
            throw new RuntimeException("Should not be called for replay batch");
        }

        @Override
        public boolean isInReplay() {
            return true;
        }
    }

    private static class MutationBatch
    extends BatchOperationInProgress<Mutation> {
        private long nonceGroup;
        private long nonce;

        public MutationBatch(Mutation[] operations, long nonceGroup, long nonce) {
            super(operations);
            this.nonceGroup = nonceGroup;
            this.nonce = nonce;
        }

        @Override
        public Mutation getMutation(int index) {
            return ((Mutation[])this.operations)[index];
        }

        @Override
        public long getNonceGroup(int index) {
            return this.nonceGroup;
        }

        @Override
        public long getNonce(int index) {
            return this.nonce;
        }

        @Override
        public Mutation[] getMutationsForCoprocs() {
            return (Mutation[])this.operations;
        }

        @Override
        public boolean isInReplay() {
            return false;
        }
    }

    private static abstract class BatchOperationInProgress<T> {
        T[] operations;
        int nextIndexToProcess = 0;
        OperationStatus[] retCodeDetails;
        WALEdit[] walEditsFromCoprocessors;

        public BatchOperationInProgress(T[] operations) {
            this.operations = operations;
            this.retCodeDetails = new OperationStatus[operations.length];
            this.walEditsFromCoprocessors = new WALEdit[operations.length];
            Arrays.fill(this.retCodeDetails, OperationStatus.NOT_RUN);
        }

        public abstract Mutation getMutation(int var1);

        public abstract long getNonceGroup(int var1);

        public abstract long getNonce(int var1);

        public abstract Mutation[] getMutationsForCoprocs();

        public abstract boolean isInReplay();

        public boolean isDone() {
            return this.nextIndexToProcess == this.operations.length;
        }
    }

    static class WriteState {
        volatile boolean flushing = false;
        volatile boolean flushRequested = false;
        volatile int compacting = 0;
        volatile boolean writesEnabled = true;
        volatile boolean readOnly = false;
        static final long HEAP_SIZE = ClassSize.align((int)(ClassSize.OBJECT + 5));

        WriteState() {
        }

        synchronized void setReadOnly(boolean onOff) {
            this.writesEnabled = !onOff;
            this.readOnly = onOff;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        boolean isFlushRequested() {
            return this.flushRequested;
        }
    }

    public static enum Operation {
        ANY,
        GET,
        PUT,
        DELETE,
        SCAN,
        APPEND,
        INCREMENT,
        SPLIT_REGION,
        MERGE_REGION,
        BATCH_MUTATE,
        REPLAY_BATCH_MUTATE,
        COMPACT_REGION;

    }
}

