/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class ScanQueryMatcher {
    private boolean stickyNextRow;
    private final byte[] stopRow;
    private final TimeRange tr;
    private final Filter filter;
    private final DeleteTracker deletes;
    private boolean retainDeletesInOutput;
    private final boolean keepDeletedCells;
    private final boolean seePastDeleteMarkers;
    private final ColumnTracker columns;
    private final KeyValue startKey;
    private final KeyValue.KVComparator rowComparator;
    byte[] row;
    int rowOffset;
    short rowLength;
    private final long earliestPutTs;
    protected long maxReadPointToTrackVersions;
    private byte[] dropDeletesFromRow = null;
    private byte[] dropDeletesToRow = null;
    private boolean hasNullColumn = true;
    private final long timeToPurgeDeletes;
    private final boolean isUserScan;
    private final boolean isReversed;

    public ScanQueryMatcher(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, ScanType scanType, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS) {
        int maxVersions;
        this.tr = scan.getTimeRange();
        this.rowComparator = scanInfo.getComparator();
        this.deletes = new ScanDeleteTracker();
        this.stopRow = scan.getStopRow();
        this.startKey = KeyValue.createFirstDeleteFamilyOnRow((byte[])scan.getStartRow(), (byte[])scanInfo.getFamily());
        this.filter = scan.getFilter();
        this.earliestPutTs = earliestPutTs;
        this.maxReadPointToTrackVersions = readPointToUse;
        this.timeToPurgeDeletes = scanInfo.getTimeToPurgeDeletes();
        this.isUserScan = scanType == ScanType.USER_SCAN;
        this.keepDeletedCells = scanInfo.getKeepDeletedCells() && !this.isUserScan || scan.isRaw();
        this.retainDeletesInOutput = scanType == ScanType.COMPACT_RETAIN_DELETES || scan.isRaw();
        this.seePastDeleteMarkers = scanInfo.getKeepDeletedCells() && this.isUserScan;
        int n = maxVersions = scan.isRaw() ? scan.getMaxVersions() : Math.min(scan.getMaxVersions(), scanInfo.getMaxVersions());
        if (columns == null || columns.size() == 0) {
            this.hasNullColumn = true;
            this.columns = new ScanWildcardColumnTracker(scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        } else {
            this.hasNullColumn = ((byte[])columns.first()).length == 0;
            byte[] attr = scan.getAttribute("_look_ahead_");
            this.columns = new ExplicitColumnTracker(columns, scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS, attr == null ? 0 : Bytes.toInt((byte[])attr));
        }
        this.isReversed = scan.isReversed();
    }

    public ScanQueryMatcher(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) {
        this(scan, scanInfo, columns, ScanType.COMPACT_RETAIN_DELETES, readPointToUse, earliestPutTs, oldestUnexpiredTS);
        Preconditions.checkArgument((dropDeletesFromRow != null && dropDeletesToRow != null ? 1 : 0) != 0);
        this.dropDeletesFromRow = dropDeletesFromRow;
        this.dropDeletesToRow = dropDeletesToRow;
    }

    ScanQueryMatcher(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, long oldestUnexpiredTS) {
        this(scan, scanInfo, columns, ScanType.USER_SCAN, Long.MAX_VALUE, Long.MAX_VALUE, oldestUnexpiredTS);
    }

    public boolean hasNullColumnInQuery() {
        return this.hasNullColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatchCode match(KeyValue kv) throws IOException {
        int timestampComparison;
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return MatchCode.DONE_SCAN;
        }
        byte[] bytes = kv.getBuffer();
        int offset = kv.getOffset();
        int keyLength = Bytes.toInt((byte[])bytes, (int)offset, (int)4);
        int initialOffset = offset += 8;
        short rowLength = Bytes.toShort((byte[])bytes, (int)offset, (int)2);
        int ret = this.rowComparator.compareRows(this.row, this.rowOffset, (int)this.rowLength, bytes, offset += 2, (int)rowLength);
        if (!this.isReversed) {
            if (ret <= -1) {
                return MatchCode.DONE;
            }
            if (ret >= 1) {
                return MatchCode.SEEK_NEXT_ROW;
            }
        } else {
            if (ret <= -1) {
                return MatchCode.SEEK_NEXT_ROW;
            }
            if (ret >= 1) {
                return MatchCode.DONE;
            }
        }
        if (this.stickyNextRow) {
            return MatchCode.SEEK_NEXT_ROW;
        }
        if (this.columns.done()) {
            this.stickyNextRow = true;
            return MatchCode.SEEK_NEXT_ROW;
        }
        byte familyLength = bytes[offset += rowLength];
        int qualLength = keyLength - ((offset += familyLength + 1) - initialOffset) - 9;
        long timestamp = Bytes.toLong((byte[])bytes, (int)(initialOffset + keyLength - 9));
        if (this.columns.isDone(timestamp)) {
            return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
        }
        byte type = bytes[initialOffset + keyLength - 1];
        if (kv.isDelete()) {
            if (!this.keepDeletedCells) {
                boolean includeDeleteMarker;
                boolean bl = includeDeleteMarker = this.seePastDeleteMarkers ? this.tr.withinTimeRange(timestamp) : this.tr.withinOrAfterTimeRange(timestamp);
                if (includeDeleteMarker && kv.getMvccVersion() <= this.maxReadPointToTrackVersions) {
                    this.deletes.add(bytes, offset, qualLength, timestamp, type);
                }
            }
            if (this.retainDeletesInOutput || !this.isUserScan && EnvironmentEdgeManager.currentTimeMillis() - timestamp <= this.timeToPurgeDeletes || kv.getMvccVersion() > this.maxReadPointToTrackVersions) {
                if (!this.isUserScan) {
                    return MatchCode.INCLUDE;
                }
            } else {
                if (!this.keepDeletedCells) return MatchCode.SKIP;
                if (timestamp < this.earliestPutTs) {
                    return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
                }
            }
        } else if (!this.deletes.isEmpty()) {
            DeleteTracker.DeleteResult deleteResult = this.deletes.isDeleted(bytes, offset, qualLength, timestamp);
            switch (deleteResult) {
                case FAMILY_DELETED: 
                case COLUMN_DELETED: {
                    return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
                }
                case VERSION_DELETED: 
                case FAMILY_VERSION_DELETED: {
                    return MatchCode.SKIP;
                }
                case NOT_DELETED: {
                    break;
                }
                default: {
                    throw new RuntimeException("UNEXPECTED");
                }
            }
        }
        if ((timestampComparison = this.tr.compare(timestamp)) >= 1) {
            return MatchCode.SKIP;
        }
        if (timestampComparison <= -1) {
            return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
        }
        MatchCode colChecker = this.columns.checkColumn(bytes, offset, qualLength, type);
        if (colChecker == MatchCode.INCLUDE) {
            Filter.ReturnCode filterResponse = Filter.ReturnCode.SKIP;
            if (this.filter != null) {
                filterResponse = this.filter.filterKeyValue((Cell)kv);
                switch (filterResponse) {
                    case SKIP: {
                        return MatchCode.SKIP;
                    }
                    case NEXT_COL: {
                        return this.columns.getNextRowOrNextColumn(bytes, offset, qualLength);
                    }
                    case NEXT_ROW: {
                        this.stickyNextRow = true;
                        return MatchCode.SEEK_NEXT_ROW;
                    }
                    case SEEK_NEXT_USING_HINT: {
                        return MatchCode.SEEK_NEXT_USING_HINT;
                    }
                }
            }
            colChecker = this.columns.checkVersions(bytes, offset, qualLength, timestamp, type, kv.getMvccVersion() > this.maxReadPointToTrackVersions);
            this.stickyNextRow = colChecker == MatchCode.INCLUDE_AND_SEEK_NEXT_ROW ? true : this.stickyNextRow;
            return filterResponse == Filter.ReturnCode.INCLUDE_AND_NEXT_COL && colChecker == MatchCode.INCLUDE ? MatchCode.INCLUDE_AND_SEEK_NEXT_COL : colChecker;
        }
        this.stickyNextRow = colChecker == MatchCode.SEEK_NEXT_ROW ? true : this.stickyNextRow;
        return colChecker;
    }

    private void checkPartialDropDeleteRange(byte[] row, int offset, short length) {
        if (this.dropDeletesFromRow != null && (this.dropDeletesFromRow == HConstants.EMPTY_START_ROW || Bytes.compareTo((byte[])row, (int)offset, (int)length, (byte[])this.dropDeletesFromRow, (int)0, (int)this.dropDeletesFromRow.length) >= 0)) {
            this.retainDeletesInOutput = false;
            this.dropDeletesFromRow = null;
        }
        if (this.dropDeletesFromRow == null && this.dropDeletesToRow != null && this.dropDeletesToRow != HConstants.EMPTY_END_ROW && Bytes.compareTo((byte[])row, (int)offset, (int)length, (byte[])this.dropDeletesToRow, (int)0, (int)this.dropDeletesToRow.length) >= 0) {
            this.retainDeletesInOutput = true;
            this.dropDeletesToRow = null;
        }
    }

    public boolean moreRowsMayExistAfter(KeyValue kv) {
        if (this.isReversed) {
            return this.rowComparator.compareRows(kv.getBuffer(), kv.getRowOffset(), (int)kv.getRowLength(), this.stopRow, 0, this.stopRow.length) > 0;
        }
        return Bytes.equals((byte[])this.stopRow, (byte[])HConstants.EMPTY_END_ROW) || this.rowComparator.compareRows(kv.getBuffer(), kv.getRowOffset(), (int)kv.getRowLength(), this.stopRow, 0, this.stopRow.length) < 0;
    }

    public void setRow(byte[] row, int offset, short length) {
        this.checkPartialDropDeleteRange(row, offset, length);
        this.row = row;
        this.rowOffset = offset;
        this.rowLength = length;
        this.reset();
    }

    public void reset() {
        this.deletes.reset();
        this.columns.reset();
        this.stickyNextRow = false;
    }

    public KeyValue getStartKey() {
        return this.startKey;
    }

    Filter getFilter() {
        return this.filter;
    }

    public Cell getNextKeyHint(Cell kv) throws IOException {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getNextCellHint(kv);
    }

    public KeyValue getKeyForNextColumn(KeyValue kv) {
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return KeyValue.createLastOnRow((byte[])kv.getBuffer(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])kv.getBuffer(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])kv.getBuffer(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength());
        }
        return KeyValue.createFirstOnRow((byte[])kv.getBuffer(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])kv.getBuffer(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])nextColumn.getBuffer(), (int)nextColumn.getOffset(), (int)nextColumn.getLength());
    }

    public KeyValue getKeyForNextRow(KeyValue kv) {
        return KeyValue.createLastOnRow((byte[])kv.getBuffer(), (int)kv.getRowOffset(), (int)kv.getRowLength(), null, (int)0, (int)0, null, (int)0, (int)0);
    }

    static MatchCode checkColumn(ColumnTracker columnTracker, byte[] bytes, int offset, int length, long ttl, byte type, boolean ignoreCount) throws IOException {
        MatchCode matchCode = columnTracker.checkColumn(bytes, offset, length, type);
        if (matchCode == MatchCode.INCLUDE) {
            return columnTracker.checkVersions(bytes, offset, length, ttl, type, ignoreCount);
        }
        return matchCode;
    }

    public static enum MatchCode {
        INCLUDE,
        SKIP,
        NEXT,
        DONE,
        SEEK_NEXT_ROW,
        SEEK_NEXT_COL,
        DONE_SCAN,
        SEEK_NEXT_USING_HINT,
        INCLUDE_AND_SEEK_NEXT_COL,
        INCLUDE_AND_SEEK_NEXT_ROW;

    }
}

