/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsManager;

@InterfaceAudience.Private
public class DefaultScanLabelGenerator
implements ScanLabelGenerator {
    private static final Log LOG = LogFactory.getLog(DefaultScanLabelGenerator.class);
    private Configuration conf;
    private VisibilityLabelsManager labelsManager = VisibilityLabelsManager.get();

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public List<String> getLabels(User user, Authorizations authorizations) {
        if (authorizations != null) {
            List labels = authorizations.getLabels();
            String userName = user.getShortName();
            List<String> auths = this.labelsManager.getAuths(userName);
            return this.dropLabelsNotInUserAuths(labels, auths, userName);
        }
        return null;
    }

    private List<String> dropLabelsNotInUserAuths(List<String> labels, List<String> auths, String userName) {
        ArrayList<String> droppedLabels = new ArrayList<String>();
        ArrayList<String> passedLabels = new ArrayList<String>(labels.size());
        for (String label : labels) {
            if (auths.contains(label)) {
                passedLabels.add(label);
                continue;
            }
            droppedLabels.add(label);
        }
        if (!droppedLabels.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Labels " + droppedLabels + " in Scan/Get visibility attributes dropped as user " + userName + " having no auth set for those."));
        }
        return passedLabels;
    }
}

