/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransaction;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionMergeTransaction {
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final Path testdir = this.TEST_UTIL.getDataTestDir(this.getClass().getName());
    private HRegion region_a;
    private HRegion region_b;
    private HRegion region_c;
    private HLog wal;
    private FileSystem fs;
    private static final byte[] STARTROW_A = new byte[]{97, 97, 97};
    private static final byte[] STARTROW_B = new byte[]{103, 103, 103};
    private static final byte[] STARTROW_C = new byte[]{119, 119, 119};
    private static final byte[] ENDROW = new byte[]{123, 123, 123};
    private static final byte[] CF = HConstants.CATALOG_FAMILY;

    @Before
    public void setup() throws IOException {
        this.fs = FileSystem.get((Configuration)this.TEST_UTIL.getConfiguration());
        this.fs.delete(this.testdir, true);
        this.wal = HLogFactory.createHLog((FileSystem)this.fs, (Path)this.testdir, (String)"logs", (Configuration)this.TEST_UTIL.getConfiguration());
        this.region_a = this.createRegion(this.testdir, this.wal, STARTROW_A, STARTROW_B);
        this.region_b = this.createRegion(this.testdir, this.wal, STARTROW_B, STARTROW_C);
        this.region_c = this.createRegion(this.testdir, this.wal, STARTROW_C, ENDROW);
        assert (this.region_a != null && this.region_b != null && this.region_c != null);
        this.TEST_UTIL.getConfiguration().setBoolean("hbase.testing.nocluster", true);
    }

    @After
    public void teardown() throws IOException {
        for (HRegion region : new HRegion[]{this.region_a, this.region_b, this.region_c}) {
            if (region != null && !region.isClosed()) {
                region.close();
            }
            if (!this.fs.exists(region.getRegionFileSystem().getRegionDir()) || this.fs.delete(region.getRegionFileSystem().getRegionDir(), true)) continue;
            throw new IOException("Failed deleting of " + region.getRegionFileSystem().getRegionDir());
        }
        if (this.wal != null) {
            this.wal.closeAndDelete();
        }
        this.fs.delete(this.testdir, true);
    }

    @Test
    public void testPrepare() throws IOException {
        this.prepareOnGoodRegions();
    }

    private RegionMergeTransaction prepareOnGoodRegions() throws IOException {
        RegionMergeTransaction mt = new RegionMergeTransaction(this.region_a, this.region_b, false);
        RegionMergeTransaction spyMT = (RegionMergeTransaction)Mockito.spy((Object)mt);
        ((RegionMergeTransaction)Mockito.doReturn((Object)false).when((Object)spyMT)).hasMergeQualifierInMeta(null, this.region_a.getRegionName());
        ((RegionMergeTransaction)Mockito.doReturn((Object)false).when((Object)spyMT)).hasMergeQualifierInMeta(null, this.region_b.getRegionName());
        Assert.assertTrue((boolean)spyMT.prepare(null));
        return spyMT;
    }

    @Test
    public void testPrepareWithSameRegion() throws IOException {
        RegionMergeTransaction mt = new RegionMergeTransaction(this.region_a, this.region_a, true);
        Assert.assertFalse((String)"should not merge the same region even if it is forcible ", (boolean)mt.prepare(null));
    }

    @Test
    public void testPrepareWithRegionsNotAdjacent() throws IOException {
        RegionMergeTransaction mt = new RegionMergeTransaction(this.region_a, this.region_c, false);
        Assert.assertFalse((String)"should not merge two regions if they are adjacent except it is forcible", (boolean)mt.prepare(null));
    }

    @Test
    public void testPrepareWithRegionsNotAdjacentUnderCompulsory() throws IOException {
        RegionMergeTransaction mt = new RegionMergeTransaction(this.region_a, this.region_c, true);
        RegionMergeTransaction spyMT = (RegionMergeTransaction)Mockito.spy((Object)mt);
        ((RegionMergeTransaction)Mockito.doReturn((Object)false).when((Object)spyMT)).hasMergeQualifierInMeta(null, this.region_a.getRegionName());
        ((RegionMergeTransaction)Mockito.doReturn((Object)false).when((Object)spyMT)).hasMergeQualifierInMeta(null, this.region_c.getRegionName());
        Assert.assertTrue((String)"Since focible is true, should merge two regions even if they are not adjacent", (boolean)spyMT.prepare(null));
    }

    @Test
    public void testPrepareWithRegionsWithReference() throws IOException {
        HStore storeMock = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)storeMock.hasReferences()).thenReturn((Object)true);
        Mockito.when((Object)storeMock.getFamily()).thenReturn((Object)new HColumnDescriptor("cf"));
        Mockito.when((Object)storeMock.close()).thenReturn((Object)ImmutableList.of());
        this.region_a.stores.put(Bytes.toBytes((String)""), storeMock);
        RegionMergeTransaction mt = new RegionMergeTransaction(this.region_a, this.region_b, false);
        Assert.assertFalse((String)"a region should not be mergeable if it has instances of store file references", (boolean)mt.prepare(null));
    }

    @Test
    public void testPrepareWithClosedRegion() throws IOException {
        this.region_a.close();
        RegionMergeTransaction mt = new RegionMergeTransaction(this.region_a, this.region_b, false);
        Assert.assertFalse((boolean)mt.prepare(null));
    }

    @Test
    public void testPrepareWithRegionsWithMergeReference() throws IOException {
        RegionMergeTransaction mt = new RegionMergeTransaction(this.region_a, this.region_b, false);
        RegionMergeTransaction spyMT = (RegionMergeTransaction)Mockito.spy((Object)mt);
        ((RegionMergeTransaction)Mockito.doReturn((Object)true).when((Object)spyMT)).hasMergeQualifierInMeta(null, this.region_a.getRegionName());
        ((RegionMergeTransaction)Mockito.doReturn((Object)true).when((Object)spyMT)).hasMergeQualifierInMeta(null, this.region_b.getRegionName());
        Assert.assertFalse((boolean)spyMT.prepare(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWholesomeMerge() throws IOException, InterruptedException {
        int rowCountOfRegionA = this.loadRegion(this.region_a, CF, true);
        int rowCountOfRegionB = this.loadRegion(this.region_b, CF, true);
        Assert.assertTrue((rowCountOfRegionA > 0 && rowCountOfRegionB > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)rowCountOfRegionA, (long)this.countRows(this.region_a));
        Assert.assertEquals((long)rowCountOfRegionB, (long)this.countRows(this.region_b));
        RegionMergeTransaction mt = this.prepareOnGoodRegions();
        this.TEST_UTIL.getConfiguration().setInt("hbase.regionserver.port", 0);
        HRegionServer mockServer = new HRegionServer(this.TEST_UTIL.getConfiguration());
        HRegion mergedRegion = mt.execute((Server)mockServer, null);
        Assert.assertTrue((boolean)this.fs.exists(mt.getMergesDir()));
        Assert.assertTrue((boolean)this.region_a.isClosed());
        Assert.assertTrue((boolean)this.region_b.isClosed());
        Assert.assertEquals((long)0L, (long)this.fs.listStatus(mt.getMergesDir()).length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])this.region_a.getStartKey(), (byte[])mergedRegion.getStartKey()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])this.region_b.getEndKey(), (byte[])mergedRegion.getEndKey()));
        try {
            int mergedRegionRowCount = this.countRows(mergedRegion);
            Assert.assertEquals((long)(rowCountOfRegionA + rowCountOfRegionB), (long)mergedRegionRowCount);
        }
        finally {
            HRegion.closeHRegion((HRegion)mergedRegion);
        }
        Assert.assertTrue((!this.region_a.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
        Assert.assertTrue((!this.region_b.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollback() throws IOException, InterruptedException {
        int rowCountOfRegionA = this.loadRegion(this.region_a, CF, true);
        int rowCountOfRegionB = this.loadRegion(this.region_b, CF, true);
        Assert.assertTrue((rowCountOfRegionA > 0 && rowCountOfRegionB > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)rowCountOfRegionA, (long)this.countRows(this.region_a));
        Assert.assertEquals((long)rowCountOfRegionB, (long)this.countRows(this.region_b));
        RegionMergeTransaction mt = this.prepareOnGoodRegions();
        Mockito.when((Object)mt.createMergedRegionFromMerges(this.region_a, this.region_b, mt.getMergedRegionInfo())).thenThrow(new Throwable[]{new MockedFailedMergedRegionCreation()});
        boolean expectedException = false;
        this.TEST_UTIL.getConfiguration().setInt("hbase.regionserver.port", 0);
        HRegionServer mockServer = new HRegionServer(this.TEST_UTIL.getConfiguration());
        try {
            mt.execute((Server)mockServer, null);
        }
        catch (MockedFailedMergedRegionCreation e) {
            expectedException = true;
        }
        Assert.assertTrue((boolean)expectedException);
        Assert.assertTrue((boolean)mt.rollback(null, null));
        int rowCountOfRegionA2 = this.countRows(this.region_a);
        Assert.assertEquals((long)rowCountOfRegionA, (long)rowCountOfRegionA2);
        int rowCountOfRegionB2 = this.countRows(this.region_b);
        Assert.assertEquals((long)rowCountOfRegionB, (long)rowCountOfRegionB2);
        Assert.assertTrue((!this.fs.exists(HRegion.getRegionDir((Path)this.testdir, (HRegionInfo)mt.getMergedRegionInfo())) ? 1 : 0) != 0);
        Assert.assertTrue((!this.region_a.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
        Assert.assertTrue((!this.region_b.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)mt.prepare(null));
        HRegion mergedRegion = mt.execute((Server)mockServer, null);
        try {
            int mergedRegionRowCount = this.countRows(mergedRegion);
            Assert.assertEquals((long)(rowCountOfRegionA + rowCountOfRegionB), (long)mergedRegionRowCount);
        }
        finally {
            HRegion.closeHRegion((HRegion)mergedRegion);
        }
        Assert.assertTrue((!this.region_a.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
        Assert.assertTrue((!this.region_b.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
    }

    @Test
    public void testFailAfterPONR() throws IOException, KeeperException, InterruptedException {
        int rowCountOfRegionA = this.loadRegion(this.region_a, CF, true);
        int rowCountOfRegionB = this.loadRegion(this.region_b, CF, true);
        Assert.assertTrue((rowCountOfRegionA > 0 && rowCountOfRegionB > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)rowCountOfRegionA, (long)this.countRows(this.region_a));
        Assert.assertEquals((long)rowCountOfRegionB, (long)this.countRows(this.region_b));
        RegionMergeTransaction mt = this.prepareOnGoodRegions();
        ((RegionMergeTransaction)Mockito.doThrow((Throwable)new MockedFailedMergedRegionOpen()).when((Object)mt)).openMergedRegion((Server)Mockito.anyObject(), (RegionServerServices)Mockito.anyObject(), (HRegion)Mockito.anyObject());
        boolean expectedException = false;
        this.TEST_UTIL.getConfiguration().setInt("hbase.regionserver.port", 0);
        HRegionServer mockServer = new HRegionServer(this.TEST_UTIL.getConfiguration());
        try {
            mt.execute((Server)mockServer, null);
        }
        catch (MockedFailedMergedRegionOpen e) {
            expectedException = true;
        }
        Assert.assertTrue((boolean)expectedException);
        Assert.assertFalse((boolean)mt.rollback(null, null));
        Path tableDir = this.region_a.getRegionFileSystem().getRegionDir().getParent();
        Path mergedRegionDir = new Path(tableDir, mt.getMergedRegionInfo().getEncodedName());
        Assert.assertTrue((boolean)this.TEST_UTIL.getTestFileSystem().exists(mergedRegionDir));
    }

    @Test
    public void testMeregedRegionBoundary() {
        TableName tableName = TableName.valueOf((String)"testMeregedRegionBoundary");
        byte[] a = Bytes.toBytes((String)"a");
        byte[] b = Bytes.toBytes((String)"b");
        HRegionInfo r1 = new HRegionInfo(tableName);
        byte[] z = Bytes.toBytes((String)"z");
        HRegionInfo r2 = new HRegionInfo(tableName, a, z);
        HRegionInfo m = RegionMergeTransaction.getMergedRegionInfo((HRegionInfo)r1, (HRegionInfo)r2);
        Assert.assertTrue((Bytes.equals((byte[])m.getStartKey(), (byte[])r1.getStartKey()) && Bytes.equals((byte[])m.getEndKey(), (byte[])r1.getEndKey()) ? 1 : 0) != 0);
        r1 = new HRegionInfo(tableName, null, a);
        r2 = new HRegionInfo(tableName, a, z);
        m = RegionMergeTransaction.getMergedRegionInfo((HRegionInfo)r1, (HRegionInfo)r2);
        Assert.assertTrue((Bytes.equals((byte[])m.getStartKey(), (byte[])r1.getStartKey()) && Bytes.equals((byte[])m.getEndKey(), (byte[])r2.getEndKey()) ? 1 : 0) != 0);
        r1 = new HRegionInfo(tableName, null, a);
        r2 = new HRegionInfo(tableName, z, null);
        m = RegionMergeTransaction.getMergedRegionInfo((HRegionInfo)r1, (HRegionInfo)r2);
        Assert.assertTrue((Bytes.equals((byte[])m.getStartKey(), (byte[])r1.getStartKey()) && Bytes.equals((byte[])m.getEndKey(), (byte[])r2.getEndKey()) ? 1 : 0) != 0);
        r1 = new HRegionInfo(tableName, a, z);
        r2 = new HRegionInfo(tableName, z, null);
        m = RegionMergeTransaction.getMergedRegionInfo((HRegionInfo)r1, (HRegionInfo)r2);
        Assert.assertTrue((Bytes.equals((byte[])m.getStartKey(), (byte[])r1.getStartKey()) && Bytes.equals((byte[])m.getEndKey(), (byte[])r2.getEndKey()) ? 1 : 0) != 0);
        r1 = new HRegionInfo(tableName, a, b);
        r2 = new HRegionInfo(tableName, b, z);
        m = RegionMergeTransaction.getMergedRegionInfo((HRegionInfo)r1, (HRegionInfo)r2);
        Assert.assertTrue((Bytes.equals((byte[])m.getStartKey(), (byte[])r1.getStartKey()) && Bytes.equals((byte[])m.getEndKey(), (byte[])r2.getEndKey()) ? 1 : 0) != 0);
    }

    private HRegion createRegion(Path testdir, HLog wal, byte[] startrow, byte[] endrow) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"table"));
        HColumnDescriptor hcd = new HColumnDescriptor(CF);
        htd.addFamily(hcd);
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), startrow, endrow);
        HRegion a = HRegion.createHRegion((HRegionInfo)hri, (Path)testdir, (Configuration)this.TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)a);
        return HRegion.openHRegion((Path)testdir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal, (Configuration)this.TEST_UTIL.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countRows(HRegion r) throws IOException {
        int rowcount = 0;
        RegionScanner scanner = r.getScanner(new Scan());
        try {
            ArrayList kvs = new ArrayList();
            boolean hasNext = true;
            while (hasNext) {
                hasNext = scanner.next(kvs);
                if (kvs.isEmpty()) continue;
                ++rowcount;
            }
        }
        finally {
            scanner.close();
        }
        return rowcount;
    }

    private int loadRegion(HRegion r, byte[] f, boolean flush) throws IOException {
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    if (!HRegion.rowIsInRange((HRegionInfo)r.getRegionInfo(), (byte[])k)) continue;
                    Put put = new Put(k);
                    put.add(f, null, k);
                    if (r.getLog() == null) {
                        put.setDurability(Durability.SKIP_WAL);
                    }
                    r.put(put);
                    ++rowCount;
                }
            }
            if (!flush) continue;
            r.flushcache();
        }
        return rowCount;
    }

    private class MockedFailedMergedRegionOpen
    extends IOException {
        private MockedFailedMergedRegionOpen() {
        }
    }

    private class MockedFailedMergedRegionCreation
    extends IOException {
        private MockedFailedMergedRegionCreation() {
        }
    }
}

