/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ExponentialClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientPushback {
    private static final Log LOG = LogFactory.getLog(TestClientPushback.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] tableName = Bytes.toBytes((String)"client-pushback");
    private static final byte[] family = Bytes.toBytes((String)"f");
    private static final byte[] qualifier = Bytes.toBytes((String)"q");
    private static long flushSizeBytes = 1024L;

    @BeforeClass
    public static void setupCluster() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.client.backpressure.enabled", true);
        conf.setClass("hbase.client.statistics.backoff-policy", ExponentialClientBackoffPolicy.class, ClientBackoffPolicy.class);
        conf.setLong("hbase.hregion.memstore.flush.size", flushSizeBytes);
        conf.setLong("hbase.hregion.memstore.block.multiplier", 2L);
        UTIL.startMiniCluster(1);
        UTIL.createTable(tableName, family);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testClientTracksServerPushback() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        TableName tablename = TableName.valueOf((byte[])tableName);
        HConnection conn = HConnectionManager.createConnection((Configuration)conf);
        HTable table = (HTable)conn.getTable(tablename);
        HRegionServer rs = UTIL.getHBaseCluster().getRegionServer(0);
        HRegion region = (HRegion)rs.getOnlineRegions(tablename).get(0);
        LOG.debug((Object)("Writing some data to " + tablename));
        Put p = new Put(Bytes.toBytes((String)"row"));
        p.add(family, qualifier, Bytes.toBytes((String)"value1"));
        table.put(p);
        table.flushCommits();
        int load = (int)(region.addAndGetGlobalMemstoreSize(0L) * 100L / flushSizeBytes);
        LOG.debug((Object)("Done writing some data to " + tablename));
        ClientBackoffPolicy backoffPolicy = conn.getBackoffPolicy();
        Assert.assertTrue((String)"Backoff policy is not correctly configured", (boolean)(backoffPolicy instanceof ExponentialClientBackoffPolicy));
        ServerStatisticTracker stats = conn.getStatisticsTracker();
        Assert.assertNotNull((String)"No stats configured for the client!", (Object)stats);
        ServerName server = rs.getServerName();
        byte[] regionName = region.getRegionName();
        ServerStatistics serverStats = stats.getServerStatsForTesting(server);
        ServerStatistics.RegionStatistics regionStats = serverStats.getStatsForRegion(regionName);
        Assert.assertEquals((String)"We did not find some load on the memstore", (long)load, (long)regionStats.getMemstoreLoadPercent());
        long backoffTime = backoffPolicy.getBackoffTime(server, regionName, serverStats);
        Assert.assertNotEquals((String)"Reported load does not produce a backoff", (long)backoffTime, (long)0L);
        LOG.debug((Object)("Backoff calculated for " + region.getRegionNameAsString() + " @ " + server + " is " + backoffTime));
        ArrayList<Put> ops = new ArrayList<Put>(1);
        p = new Put(Bytes.toBytes((String)"row"));
        p.add(family, qualifier, Bytes.toBytes((String)"value2"));
        ops.add(p);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicLong endTime = new AtomicLong();
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        table.ap.submit(ops, true, (Batch.Callback)new Batch.Callback<Object>(){

            public void update(byte[] region, byte[] row, Object result) {
                endTime.set(EnvironmentEdgeManager.currentTimeMillis());
                latch.countDown();
            }
        });
        latch.await(backoffTime * 2L, TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((String)"AsyncProcess did not submit the work in time", (long)endTime.get(), (long)0L);
        Assert.assertTrue((String)"AsyncProcess did not delay long enough", (endTime.get() - startTime >= backoffTime ? 1 : 0) != 0);
    }
}

