/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.StringRange;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestColumnRangeFilter {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final Log LOG = LogFactory.getLog(this.getClass());

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void TestColumnRangeFilterClient() throws Exception {
        String family = "Family";
        String table = "TestColumnRangeFilterClient";
        HTable ht = TEST_UTIL.createTable(Bytes.toBytes((String)table), Bytes.toBytes((String)family), Integer.MAX_VALUE);
        List<String> rows = this.generateRandomWords(10, 8);
        long maxTimestamp = 2L;
        List<String> columns = this.generateRandomWords(20000, 8);
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        HashMap rangeMap = new HashMap();
        rangeMap.put(new StringRange(null, true, "b", false), new ArrayList());
        rangeMap.put(new StringRange("p", true, "q", false), new ArrayList());
        rangeMap.put(new StringRange("r", false, "s", true), new ArrayList());
        rangeMap.put(new StringRange("z", false, null, false), new ArrayList());
        String valueString = "ValueString";
        for (String row : rows) {
            Put p = new Put(Bytes.toBytes((String)row));
            p.setDurability(Durability.SKIP_WAL);
            for (String column : columns) {
                for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                    KeyValue kv = KeyValueTestUtil.create((String)row, (String)family, (String)column, (long)timestamp, (String)valueString);
                    p.add((Cell)kv);
                    kvList.add(kv);
                    for (StringRange s : rangeMap.keySet()) {
                        if (!s.inRange(column)) continue;
                        ((List)rangeMap.get(s)).add(kv);
                    }
                }
            }
            ht.put(p);
        }
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.setMaxVersions();
        for (StringRange s : rangeMap.keySet()) {
            Result result;
            ColumnRangeFilter filter = new ColumnRangeFilter(s.getStart() == null ? null : Bytes.toBytes((String)s.getStart()), s.isStartInclusive(), s.getEnd() == null ? null : Bytes.toBytes((String)s.getEnd()), s.isEndInclusive());
            scan.setFilter((Filter)filter);
            ResultScanner scanner = ht.getScanner(scan);
            ArrayList<Cell> results = new ArrayList<Cell>();
            this.LOG.info((Object)("scan column range: " + s.toString()));
            long timeBeforeScan = System.currentTimeMillis();
            while ((result = scanner.next()) != null) {
                for (Cell kv : result.listCells()) {
                    results.add(kv);
                }
            }
            long scanTime = System.currentTimeMillis() - timeBeforeScan;
            scanner.close();
            this.LOG.info((Object)("scan time = " + scanTime + "ms"));
            this.LOG.info((Object)("found " + results.size() + " results"));
            this.LOG.info((Object)("Expecting " + ((List)rangeMap.get(s)).size() + " results"));
            Assert.assertEquals((long)((List)rangeMap.get(s)).size(), (long)results.size());
        }
        ht.close();
    }

    List<String> generateRandomWords(int numberOfWords, int maxLengthOfWords) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            int lengthOfWords = (int)(Math.random() * (double)maxLengthOfWords) + 1;
            char[] wordChar = new char[lengthOfWords];
            for (int j = 0; j < wordChar.length; ++j) {
                wordChar[j] = (char)(Math.random() * 26.0 + 97.0);
            }
            String word = new String(wordChar);
            wordSet.add(word);
        }
        ArrayList<String> wordList = new ArrayList<String>(wordSet);
        return wordList;
    }
}

