/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSplitTransactionOnCluster {
    private static final Log LOG = LogFactory.getLog(TestSplitTransactionOnCluster.class);
    private HBaseAdmin admin = null;
    private MiniHBaseCluster cluster = null;
    private static final int NB_SERVERS = 3;
    private static CountDownLatch latch = new CountDownLatch(1);
    private static volatile boolean secondSplit = false;
    private static volatile boolean callRollBack = false;
    private static volatile boolean firstSplitCompleted = false;
    private static boolean useZKForAssignment = true;
    static final HBaseTestingUtility TESTING_UTIL = new HBaseTestingUtility();

    static void setupOnce() throws Exception {
        TESTING_UTIL.getConfiguration().setInt("hbase.balancer.period", 60000);
        useZKForAssignment = TESTING_UTIL.getConfiguration().getBoolean("hbase.assignment.usezk", false);
        TESTING_UTIL.startMiniCluster(3);
    }

    @BeforeClass
    public static void before() throws Exception {
        TESTING_UTIL.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        TestSplitTransactionOnCluster.setupOnce();
    }

    @AfterClass
    public static void after() throws Exception {
        TESTING_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TESTING_UTIL.ensureSomeNonStoppedRegionServersAvailable(3);
        this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        this.cluster = TESTING_UTIL.getMiniHBaseCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.admin.close();
    }

    private HRegionInfo getAndCheckSingleTableRegion(List<HRegion> regions) {
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegionInfo hri = regions.get(0).getRegionInfo();
        return this.waitOnRIT(hri);
    }

    private HRegionInfo waitOnRIT(HRegionInfo hri) {
        while (TESTING_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionInTransition(hri)) {
            LOG.info((Object)("Waiting on region in transition: " + TESTING_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionTransitionState(hri)));
            Threads.sleep((long)10L);
        }
        return hri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack() throws Exception {
        TableName tableName = TableName.valueOf((String)"testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack");
        if (!useZKForAssignment) {
            return;
        }
        try {
            HTable t = this.createTableAndWait(tableName.getName(), Bytes.toBytes((String)"cf"));
            List<HRegion> regions = this.cluster.getRegions(tableName);
            HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            final HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName.getName(), this.admin, t);
            t.close();
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            final HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            new Thread(){

                @Override
                public void run() {
                    MockedSplitTransaction st = null;
                    st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2"));
                    try {
                        st.prepare();
                        st.execute((Server)regionServer, (RegionServerServices)regionServer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            for (int i = 0; !callRollBack && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"Waited too long for rollback", (boolean)callRollBack);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row3"));
            try {
                secondSplit = true;
                region.initialize();
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                LOG.debug((Object)("Rollback started :" + e.getMessage()));
                st.rollback((Server)regionServer, (RegionServerServices)regionServer);
            }
            for (int i = 0; !firstSplitCompleted && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"fist split did not complete", (boolean)firstSplitCompleted);
            RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
            Map rit = regionStates.getRegionsInTransition();
            for (int i = 0; rit.containsKey(hri.getTable()) && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertFalse((String)"region still in transition", (boolean)rit.containsKey(rit.containsKey(hri.getTable())));
            List onlineRegions = regionServer.getOnlineRegions(tableName);
            Assert.assertEquals((String)"The parent region should be splitted", (long)2L, (long)onlineRegions.size());
            List regionsOfTable = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(tableName);
            Assert.assertEquals((String)"No of regions in master", (long)2L, (long)regionsOfTable.size());
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            secondSplit = false;
            firstSplitCompleted = false;
            callRollBack = false;
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRITStateForRollback() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRITStateForRollback");
        try {
            HTable t = this.createTableAndWait(tableName.getName(), Bytes.toBytes((String)"cf"));
            List<HRegion> regions = this.cluster.getRegions(tableName);
            final HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            this.insertData(tableName.getName(), this.admin, t);
            t.close();
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            region.getCoprocessorHost().load(FailingSplitRegionObserver.class, 0x3FFFFFFF, region.getBaseConf());
            this.admin.split(region.getRegionName(), new byte[]{42});
            FailingSplitRegionObserver observer = (FailingSplitRegionObserver)region.getCoprocessorHost().findCoprocessor(FailingSplitRegionObserver.class.getName());
            Assert.assertNotNull((Object)((Object)observer));
            observer.latch.await();
            LOG.info((Object)"Waiting for region to come out of RIT");
            TESTING_UTIL.waitFor(60000L, 1000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    RegionStates regionStates = TestSplitTransactionOnCluster.this.cluster.getMaster().getAssignmentManager().getRegionStates();
                    Map rit = regionStates.getRegionsInTransition();
                    return !rit.containsKey(hri.getEncodedName());
                }
            });
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRSSplitEphemeralsDisappearButDaughtersAreOnlinedAfterShutdownHandling() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, DeserializationException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testRSSplitEphemeralsDisappearButDaughtersAreOnlinedAfterShutdownHandling");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size();
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = true;
            this.split(hri, server, regionCount);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (String)hri.getEncodedName());
            RegionTransition rt = null;
            Stat stats = null;
            List<HRegion> daughters = null;
            if (useZKForAssignment) {
                daughters = this.checkAndGetDaughters(tableName);
                for (int i = 0; i < 100; ++i) {
                    stats = TESTING_UTIL.getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false);
                    rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (String)hri.getEncodedName()));
                    if (rt.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT)) break;
                    Thread.sleep(100L);
                }
                LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
                Assert.assertTrue((rt != null && rt.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT) ? 1 : 0) != 0);
                this.cluster.abortRegionServer(tableRegionIndex);
            }
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, 2);
            if (useZKForAssignment) {
                regions = this.cluster.getRegions(tableName);
                for (HRegion r : regions) {
                    Assert.assertTrue((boolean)daughters.contains(r));
                }
                for (int i = 0; i < 100 && (stats = TESTING_UTIL.getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false)) != null; ++i) {
                    Thread.sleep(100L);
                }
                LOG.info((Object)("EPHEMERAL NODE AFTER SERVER ABORT, path=" + path + ", stats=" + stats));
                Assert.assertTrue((stats == null ? 1 : 0) != 0);
            }
        }
        finally {
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            this.cluster.startRegionServer();
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testExistingZnodeBlocksSplitAndWeRollback() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testExistingZnodeBlocksSplitAndWeRollback");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size();
            ServerName fakedServer = ServerName.valueOf((String)"any.old.server", (int)1234, (long)-1L);
            if (useZKForAssignment) {
                ZKAssign.createNodeClosing((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)fakedServer);
            } else {
                regionStates.updateRegionState(hri, RegionState.State.CLOSING);
            }
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                Assert.assertEquals((long)regionCount, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size());
            }
            if (useZKForAssignment) {
                ZKAssign.deleteClosingNode((ZooKeeperWatcher)TESTING_UTIL.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)fakedServer);
            } else {
                regionStates.regionOnline(hri, server.getServerName());
            }
            this.split(hri, server, regionCount);
            this.checkAndGetDaughters(tableName);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testShutdownFixupWhenDaughterHasSplit() throws IOException, InterruptedException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testShutdownFixupWhenDaughterHasSplit");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size();
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            regionCount = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size();
            HRegionInfo daughter = daughters.get(0).getRegionInfo();
            LOG.info((Object)("Daughter we are going to split: " + daughter));
            this.admin.compact(daughter.getRegionName());
            daughters = this.cluster.getRegions(tableName);
            HRegion daughterRegion = null;
            for (HRegion r : daughters) {
                if (!r.getRegionInfo().equals((Object)daughter)) continue;
                daughterRegion = r;
                LOG.info((Object)("Found matching HRI: " + daughterRegion));
                break;
            }
            Assert.assertTrue((daughterRegion != null ? 1 : 0) != 0);
            for (int i = 0; i < 100 && daughterRegion.hasReferences(); ++i) {
                Threads.sleep((long)100L);
            }
            Assert.assertFalse((String)"Waiting for reference to be compacted", (boolean)daughterRegion.hasReferences());
            LOG.info((Object)("Daughter hri before split (has been compacted): " + daughter));
            this.split(daughter, server, regionCount);
            daughters = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info((Object)("Regions before crash: " + d));
            }
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info((Object)("Regions after crash: " + d));
            }
            Assert.assertEquals((long)daughters.size(), (long)regions.size());
            for (HRegion r : regions) {
                LOG.info((Object)("Regions post crash " + r));
                Assert.assertTrue((String)("Missing region post crash " + r), (boolean)daughters.contains(r));
            }
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles() throws Exception {
        Configuration conf = TESTING_UTIL.getConfiguration();
        TableName userTableName = TableName.valueOf((String)"testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles");
        HTableDescriptor htd = new HTableDescriptor(userTableName);
        HColumnDescriptor hcd = new HColumnDescriptor("col");
        htd.addFamily(hcd);
        this.admin.createTable(htd);
        HTable table = new HTable(conf, userTableName);
        try {
            Put p;
            for (int i = 0; i <= 5; ++i) {
                String row = "row" + i;
                p = new Put(row.getBytes());
                String val = "Val" + i;
                p.add("col".getBytes(), "ql".getBytes(), val.getBytes());
                table.put(p);
                this.admin.flush(userTableName.getName());
                Delete d = new Delete(row.getBytes());
                table.delete(d);
                this.admin.flush(userTableName.getName());
            }
            this.admin.majorCompact(userTableName.getName());
            List regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            HRegionInfo hRegionInfo = (HRegionInfo)regionsOfTable.get(0);
            p = new Put("row6".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            p = new Put("row7".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            p = new Put("row8".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            this.admin.flush(userTableName.getName());
            this.admin.split(hRegionInfo.getRegionName(), "row7".getBytes());
            regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            while (regionsOfTable.size() != 2) {
                Thread.sleep(2000L);
                regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            }
            Assert.assertEquals((long)2L, (long)regionsOfTable.size());
            Scan s = new Scan();
            ResultScanner scanner = table.getScanner(s);
            int mainTableCount = 0;
            Result rr = scanner.next();
            while (rr != null) {
                ++mainTableCount;
                rr = scanner.next();
            }
            Assert.assertEquals((long)3L, (long)mainTableCount);
        }
        finally {
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=400000L)
    public void testMasterRestartWhenSplittingIsPartial() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, DeserializationException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testMasterRestartWhenSplittingIsPartial");
        if (!useZKForAssignment) {
            return;
        }
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(t.getConfiguration(), "testMasterRestartWhenSplittingIsPartial", (Abortable)new UselessTestAbortable());
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = true;
            this.admin.split(hri.getRegionNameAsString());
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            byte[] bytes = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            RegionTransition rtd = RegionTransition.parseFrom((byte[])bytes);
            Assert.assertTrue((rtd.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT) || rtd.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLITTING) ? 1 : 0) != 0);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            ServerName regionServerOfRegion = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion != null ? 1 : 0) != 0);
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Split parent should be in SPLIT state", (boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            zkw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMasterRestartAtRegionSplitPendingCatalogJanitor() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException {
        byte[] tableName = Bytes.toBytes((String)"testMasterRestartAtRegionSplitPendingCatalogJanitor");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(t.getConfiguration(), "testMasterRestartAtRegionSplitPendingCatalogJanitor", (Abortable)new UselessTestAbortable());
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            this.admin.split(hri.getRegionNameAsString());
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Split parent should be in SPLIT state", (boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            ServerName regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            zkw.close();
        }
    }

    @Test(timeout=60000L)
    public void testSplitBeforeSettingSplittingInZK() throws Exception, InterruptedException, KeeperException {
        this.testSplitBeforeSettingSplittingInZKInternals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTableExistsIfTheSpecifiedTableRegionIsSplitParent() throws Exception {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TESTING_UTIL);
        TableName tableName = TableName.valueOf((String)"testTableExistsIfTheSpecifiedTableRegionIsSplitParent");
        HTable t = this.createTableAndWait(tableName.getName(), Bytes.toBytes((String)"cf"));
        List<HRegion> regions = null;
        try {
            regions = this.cluster.getRegions(tableName);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName.getName(), this.admin, t);
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            boolean tableExists = MetaReader.tableExists((CatalogTracker)regionServer.getCatalogTracker(), (TableName)tableName);
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            SplitTransaction st = new SplitTransaction(region, Bytes.toBytes((String)"row2"));
            try {
                st.prepare();
                st.createDaughters((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                // empty catch block
            }
            tableExists = MetaReader.tableExists((CatalogTracker)regionServer.getCatalogTracker(), (TableName)tableName);
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
            Map rit = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsInTransition();
            Assert.assertTrue((rit.size() == 3 ? 1 : 0) != 0);
            this.cluster.getMaster().getAssignmentManager().regionOffline(st.getFirstDaughter());
            this.cluster.getMaster().getAssignmentManager().regionOffline(st.getSecondDaughter());
            this.cluster.getMaster().getAssignmentManager().regionOffline(region.getRegionInfo());
            rit = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsInTransition();
            Assert.assertTrue((rit.size() == 0 ? 1 : 0) != 0);
        }
        finally {
            if (regions != null) {
                String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)regions.get(0).getRegionInfo().getEncodedName());
                ZKUtil.deleteNodeFailSilent((ZooKeeperWatcher)zkw, (String)node);
            }
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    private void insertData(byte[] tableName, HBaseAdmin admin, HTable t) throws IOException, InterruptedException {
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"1"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"2"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row3"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"3"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row4"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"4"));
        t.put(p);
        admin.flush(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSplitRegionWithNoStoreFiles() throws Exception {
        TableName tableName = TableName.valueOf((String)"testSplitRegionWithNoStoreFiles");
        this.createTableAndWait(tableName.getName(), HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
        HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            this.printOutRegions(regionServer, "Initial regions: ");
            Configuration conf = this.cluster.getConfiguration();
            HBaseFsck.debugLsr((Configuration)conf, (Path)new Path("/"));
            Path rootDir = FSUtils.getRootDir((Configuration)conf);
            DistributedFileSystem fs = TESTING_UTIL.getDFSCluster().getFileSystem();
            Map storefiles = FSUtils.getTableStoreFilePathMap(null, (FileSystem)fs, (Path)rootDir, (TableName)tableName);
            Assert.assertEquals((String)("Expected nothing but found " + storefiles.toString()), (long)storefiles.size(), (long)0L);
            regions = this.cluster.getRegions(tableName);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2"));
            try {
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                Assert.fail((String)"Split execution should have succeeded with no exceptions thrown");
            }
            List<HRegion> daughters = this.cluster.getRegions(tableName);
            Assert.assertTrue((daughters.size() == 2 ? 1 : 0) != 0);
            HBaseFsck.debugLsr((Configuration)conf, (Path)new Path("/"));
            Map storefilesAfter = FSUtils.getTableStoreFilePathMap(null, (FileSystem)fs, (Path)rootDir, (TableName)tableName);
            Assert.assertEquals((String)("Expected nothing but found " + storefilesAfter.toString()), (long)storefilesAfter.size(), (long)0L);
            hri = region.getRegionInfo();
            AssignmentManager am = this.cluster.getMaster().getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            long start = EnvironmentEdgeManager.currentTimeMillis();
            while (!regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT})) {
                Assert.assertFalse((String)"Timed out in waiting split parent to be in state SPLIT", (EnvironmentEdgeManager.currentTimeMillis() - start > 60000L ? 1 : 0) != 0);
                Thread.sleep(500L);
            }
            am.assign(hri, true, true);
            Assert.assertFalse((String)"Split region can't be assigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
            am.unassign(hri, true, null);
            Assert.assertFalse((String)"Split region can't be unassigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.SPLIT}));
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitHooksBeforeAndAfterPONR() throws Exception {
        TableName firstTable = TableName.valueOf((String)"testSplitHooksBeforeAndAfterPONR_1");
        TableName secondTable = TableName.valueOf((String)"testSplitHooksBeforeAndAfterPONR_2");
        HColumnDescriptor hcd = new HColumnDescriptor("cf");
        HTableDescriptor desc = new HTableDescriptor(firstTable);
        desc.addCoprocessor(MockedRegionObserver.class.getName());
        desc.addFamily(hcd);
        this.admin.createTable(desc);
        TESTING_UTIL.waitUntilAllRegionsAssigned(firstTable);
        desc = new HTableDescriptor(secondTable);
        desc.addFamily(hcd);
        this.admin.createTable(desc);
        TESTING_UTIL.waitUntilAllRegionsAssigned(secondTable);
        List<HRegion> firstTableRegions = this.cluster.getRegions(firstTable);
        List<HRegion> secondTableRegions = this.cluster.getRegions(secondTable);
        if (firstTableRegions.size() == 0 || secondTableRegions.size() == 0) {
            Assert.fail((String)"Each table should have at least one region.");
        }
        ServerName serverName = this.cluster.getServerHoldingRegion(firstTableRegions.get(0).getRegionName());
        this.admin.move(secondTableRegions.get(0).getRegionInfo().getEncodedNameAsBytes(), Bytes.toBytes((String)serverName.getServerName()));
        HTable table1 = null;
        HTable table2 = null;
        try {
            table1 = new HTable(TESTING_UTIL.getConfiguration(), firstTable);
            table2 = new HTable(TESTING_UTIL.getConfiguration(), firstTable);
            this.insertData(firstTable.getName(), this.admin, table1);
            this.insertData(secondTable.getName(), this.admin, table2);
            this.admin.split(firstTable.getName(), "row2".getBytes());
            firstTableRegions = this.cluster.getRegions(firstTable.getName());
            while (firstTableRegions.size() != 2) {
                Thread.sleep(1000L);
                firstTableRegions = this.cluster.getRegions(firstTable.getName());
            }
            Assert.assertEquals((String)"Number of regions after split should be 2.", (long)2L, (long)firstTableRegions.size());
            secondTableRegions = this.cluster.getRegions(secondTable.getName());
            Assert.assertEquals((String)"Number of regions after split should be 2.", (long)2L, (long)secondTableRegions.size());
        }
        finally {
            if (table1 != null) {
                table1.close();
            }
            if (table2 != null) {
                table2.close();
            }
            TESTING_UTIL.deleteTable(firstTable);
            TESTING_UTIL.deleteTable(secondTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSplitBeforeSettingSplittingInZKInternals() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testSplitBeforeSettingSplittingInZK");
        try {
            this.createTableAndWait(tableName, Bytes.toBytes((String)"cf"));
            List<HRegion> regions = this.awaitTableRegions(tableName);
            Assert.assertTrue((String)"Table not online", (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes((String)"row2")){

                public PairOfSameType<HRegion> stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
                    throw new SplittingNodeCreationFailedException();
                }
            };
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)region.getRegionInfo().getEncodedName());
            regionServer.getZooKeeper().sync(node);
            for (int i = 0; i < 100; ++i) {
                if (ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1) continue;
                Thread.sleep(100L);
            }
            try {
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                Assert.assertTrue((String)"Should be instance of CreateSplittingNodeFailedException", (boolean)(e instanceof SplittingNodeCreationFailedException));
                node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)region.getRegionInfo().getEncodedName());
                Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)st.rollback((Server)regionServer, (RegionServerServices)regionServer));
                Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
            }
        }
        finally {
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreFileReferenceCreationWhenSplitPolicySaysToSkipRangeCheck() throws Exception {
        TableName tableName = TableName.valueOf((String)"testStoreFileReferenceCreationWhenSplitPolicySaysToSkipRangeCheck");
        try {
            HTableDescriptor htd = new HTableDescriptor(tableName);
            htd.addFamily(new HColumnDescriptor("f"));
            htd.setRegionSplitPolicyClassName(CustomSplitPolicy.class.getName());
            this.admin.createTable(htd);
            List<HRegion> regions = this.awaitTableRegions(tableName.toBytes());
            HRegion region = regions.get(0);
            for (int i = 3; i < 9; ++i) {
                Put p = new Put(Bytes.toBytes((String)("row" + i)));
                p.add(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), Bytes.toBytes((String)("value" + i)));
                region.put(p);
            }
            region.flushcache();
            Store store = region.getStore(Bytes.toBytes((String)"f"));
            Collection storefiles = store.getStorefiles();
            Assert.assertEquals((long)storefiles.size(), (long)1L);
            Assert.assertFalse((boolean)region.hasReferences());
            Path referencePath = region.getRegionFileSystem().splitStoreFile(region.getRegionInfo(), "f", (StoreFile)storefiles.iterator().next(), Bytes.toBytes((String)"row1"), false, region.getSplitPolicy());
            Assert.assertNotNull((Object)referencePath);
        }
        finally {
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSSHCleanupDaugtherRegionsOfAbortedSplit() throws Exception {
        TableName table = TableName.valueOf((String)"testSSHCleanupDaugtherRegionsOfAbortedSplit");
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"f")));
            this.admin.createTable(desc);
            HTable hTable = new HTable(this.cluster.getConfiguration(), desc.getTableName());
            for (int i = 1; i < 5; ++i) {
                Put p1 = new Put(("r" + i).getBytes());
                p1.add(Bytes.toBytes((String)"f"), "q1".getBytes(), "v".getBytes());
                hTable.put(p1);
            }
            this.admin.flush(desc.getTableName().toString());
            List<HRegion> regions = this.cluster.getRegions(desc.getTableName());
            int serverWith = this.cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(serverWith);
            this.cluster.getServerWith(regions.get(0).getRegionName());
            SplitTransaction st = new SplitTransaction(regions.get(0), Bytes.toBytes((String)"r3"));
            st.prepare();
            st.stepsBeforePONR((Server)regionServer, (RegionServerServices)regionServer, false);
            Path tableDir = FSUtils.getTableDir((Path)this.cluster.getMaster().getMasterFileSystem().getRootDir(), (TableName)desc.getTableName());
            tableDir.getFileSystem(this.cluster.getConfiguration());
            List regionDirs = FSUtils.getRegionDirs((FileSystem)tableDir.getFileSystem(this.cluster.getConfiguration()), (Path)tableDir);
            Assert.assertEquals((long)3L, (long)regionDirs.size());
            this.cluster.startRegionServer();
            regionServer.kill();
            this.cluster.getRegionServerThreads().get(serverWith).join();
            while (this.cluster.getMaster().getServerManager().areDeadServersInProgress()) {
                Thread.sleep(10L);
            }
            AssignmentManager am = this.cluster.getMaster().getAssignmentManager();
            while (am.getRegionStates().isRegionsInTransition()) {
                Thread.sleep(10L);
            }
            Assert.assertEquals((String)am.getRegionStates().getRegionsInTransition().toString(), (long)am.getRegionStates().getRegionsInTransition().size(), (long)0L);
            regionDirs = FSUtils.getRegionDirs((FileSystem)tableDir.getFileSystem(this.cluster.getConfiguration()), (Path)tableDir);
            Assert.assertEquals((long)1L, (long)regionDirs.size());
        }
        finally {
            TESTING_UTIL.deleteTable(table);
        }
    }

    private HRegion findSplittableRegion(List<HRegion> regions) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            for (HRegion r : regions) {
                if (!r.isSplittable()) continue;
                return r;
            }
            Thread.sleep(100L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testFailedSplit() throws Exception {
        TableName tableName = TableName.valueOf((String)"testFailedSplit");
        byte[] colFamily = Bytes.toBytes((String)"info");
        TESTING_UTIL.createTable(tableName, colFamily);
        HTable table = new HTable(TESTING_UTIL.getConfiguration(), tableName);
        try {
            TESTING_UTIL.loadTable(table, colFamily);
            List regions = TESTING_UTIL.getHBaseAdmin().getTableRegions(tableName);
            Assert.assertTrue((regions.size() == 1 ? 1 : 0) != 0);
            HRegion actualRegion = this.cluster.getRegions(tableName).get(0);
            actualRegion.getCoprocessorHost().load(FailingSplitRegionObserver.class, 0x3FFFFFFF, actualRegion.getBaseConf());
            this.admin.split(tableName.getNameAsString());
            FailingSplitRegionObserver observer = (FailingSplitRegionObserver)actualRegion.getCoprocessorHost().findCoprocessor(FailingSplitRegionObserver.class.getName());
            Assert.assertNotNull((Object)((Object)observer));
            observer.latch.await();
            observer.postSplit.await();
            LOG.info((Object)"Waiting for region to come out of RIT");
            TESTING_UTIL.waitFor(60000L, 1000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    RegionStates regionStates = TestSplitTransactionOnCluster.this.cluster.getMaster().getAssignmentManager().getRegionStates();
                    Map rit = regionStates.getRegionsInTransition();
                    return rit.size() == 0;
                }
            });
            regions = TESTING_UTIL.getHBaseAdmin().getTableRegions(tableName);
            Assert.assertTrue((regions.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.admin.balancer());
        }
        finally {
            table.close();
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    private List<HRegion> checkAndGetDaughters(byte[] tableName) throws InterruptedException {
        List<HRegion> daughters = null;
        for (int i = 0; i < 100 && (daughters = this.cluster.getRegions(tableName)).size() < 2; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((daughters.size() >= 2 ? 1 : 0) != 0);
        return daughters;
    }

    private MockMasterWithoutCatalogJanitor abortAndWaitForMaster() throws IOException, InterruptedException {
        this.cluster.abortMaster(0);
        this.cluster.waitOnMaster(0);
        this.cluster.getConfiguration().setClass("hbase.master.impl", MockMasterWithoutCatalogJanitor.class, HMaster.class);
        MockMasterWithoutCatalogJanitor master = null;
        master = (MockMasterWithoutCatalogJanitor)this.cluster.startMaster().getMaster();
        this.cluster.waitForActiveAndReadyMaster();
        return master;
    }

    private void split(HRegionInfo hri, HRegionServer server, int regionCount) throws IOException, InterruptedException {
        block3: {
            this.admin.split(hri.getRegionNameAsString());
            try {
                for (int i = 0; ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size() <= regionCount && i < 300; ++i) {
                    LOG.debug((Object)"Waiting on region to split");
                    Thread.sleep(100L);
                }
                Assert.assertFalse((String)"Waited too long for split", (ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server).size() <= regionCount ? 1 : 0) != 0);
            }
            catch (RegionServerStoppedException e) {
                if (!useZKForAssignment) break block3;
                LOG.error((Object)e);
                throw e;
            }
        }
    }

    private int ensureTableRegionNotOnSameServerAsMeta(HBaseAdmin admin, HRegionInfo hri) throws HBaseIOException, MasterNotRunningException, ZooKeeperConnectionException, InterruptedException {
        int metaServerIndex = this.cluster.getServerWithMeta();
        Assert.assertTrue((metaServerIndex != -1 ? 1 : 0) != 0);
        HRegionServer metaRegionServer = this.cluster.getRegionServer(metaServerIndex);
        int tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        HRegionServer tableRegionServer = this.cluster.getRegionServer(tableRegionIndex);
        if (metaRegionServer.getServerName().equals((Object)tableRegionServer.getServerName())) {
            HRegionServer hrs = this.getOtherRegionServer(this.cluster, metaRegionServer);
            Assert.assertNotNull((Object)hrs);
            Assert.assertNotNull((Object)hri);
            LOG.info((Object)("Moving " + hri.getRegionNameAsString() + " from " + metaRegionServer.getServerName() + " to " + hrs.getServerName() + "; metaServerIndex=" + metaServerIndex));
            admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hrs.getServerName().toString()));
        }
        for (int i = 0; i < 100 && ((tableRegionIndex = this.cluster.getServerWith(hri.getRegionName())) == -1 || tableRegionIndex == metaServerIndex); ++i) {
            LOG.debug((Object)("Waiting on region move off the hbase:meta server; current index " + tableRegionIndex + " and metaServerIndex=" + metaServerIndex));
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"Region not moved off hbase:meta server", (tableRegionIndex != -1 && tableRegionIndex != metaServerIndex ? 1 : 0) != 0);
        tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        Assert.assertNotSame((Object)metaServerIndex, (Object)tableRegionIndex);
        return tableRegionIndex;
    }

    private HRegionServer getOtherRegionServer(MiniHBaseCluster cluster, HRegionServer notThisOne) {
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.getServerName().equals((Object)notThisOne.getServerName()) || hrs.isStopping() || hrs.isStopped()) continue;
            return hrs;
        }
        return null;
    }

    private void printOutRegions(HRegionServer hrs, String prefix) throws IOException {
        List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs);
        for (HRegionInfo region : regions) {
            LOG.info((Object)(prefix + region.getRegionNameAsString()));
        }
    }

    private void waitUntilRegionServerDead() throws InterruptedException {
        for (int i = 0; this.cluster.getMaster().getClusterStatus().getServers().size() == 3 && i < 100; ++i) {
            LOG.info((Object)"Waiting on server to go down");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for RS to die", (this.cluster.getMaster().getClusterStatus().getServers().size() == 3 ? 1 : 0) != 0);
    }

    private void awaitDaughters(byte[] tableName, int numDaughters) throws InterruptedException {
        for (int i = 0; this.cluster.getRegions(tableName).size() < numDaughters && i < 60; ++i) {
            LOG.info((Object)"Waiting for repair to happen");
            Thread.sleep(1000L);
        }
        if (this.cluster.getRegions(tableName).size() < numDaughters) {
            Assert.fail((String)"Waiting too long for daughter regions");
        }
    }

    private List<HRegion> awaitTableRegions(byte[] tableName) throws InterruptedException {
        List<HRegion> regions = null;
        for (int i = 0; i < 100 && (regions = this.cluster.getRegions(tableName)).size() <= 0; ++i) {
            Thread.sleep(100L);
        }
        return regions;
    }

    private HTable createTableAndWait(byte[] tableName, byte[] cf) throws IOException, InterruptedException {
        HTable t = TESTING_UTIL.createTable(tableName, cf);
        this.awaitTableRegions(tableName);
        Assert.assertTrue((String)("Table not online: " + Bytes.toString((byte[])tableName)), (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
        return t;
    }

    static class CustomSplitPolicy
    extends RegionSplitPolicy {
        CustomSplitPolicy() {
        }

        protected boolean shouldSplit() {
            return true;
        }

        public boolean skipStoreFileRangeCheck() {
            return true;
        }
    }

    public static class MockedRegionObserver
    extends BaseRegionObserver {
        private SplitTransaction st = null;
        private PairOfSameType<HRegion> daughterRegions = null;

        public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
            RegionCoprocessorEnvironment environment = (RegionCoprocessorEnvironment)ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            List onlineRegions = rs.getOnlineRegions(TableName.valueOf((String)"testSplitHooksBeforeAndAfterPONR_2"));
            HRegion region = (HRegion)onlineRegions.get(0);
            for (HRegion r : onlineRegions) {
                if (!r.getRegionInfo().containsRow(splitKey)) continue;
                region = r;
                break;
            }
            this.st = new SplitTransaction(region, splitKey);
            if (!this.st.prepare()) {
                LOG.error((Object)("Prepare for the table " + region.getTableDesc().getNameAsString() + " failed. So returning null. "));
                ctx.bypass();
                return;
            }
            region.forceSplit(splitKey);
            this.daughterRegions = this.st.stepsBeforePONR((Server)rs, (RegionServerServices)rs, false);
            HRegionInfo copyOfParent = new HRegionInfo(region.getRegionInfo());
            copyOfParent.setOffline(true);
            copyOfParent.setSplit(true);
            Put putParent = MetaEditor.makePutFromRegionInfo((HRegionInfo)copyOfParent);
            MetaEditor.addDaughtersToPut((Put)putParent, (HRegionInfo)((HRegion)this.daughterRegions.getFirst()).getRegionInfo(), (HRegionInfo)((HRegion)this.daughterRegions.getSecond()).getRegionInfo());
            metaEntries.add((Mutation)putParent);
            Put putA = MetaEditor.makePutFromRegionInfo((HRegionInfo)((HRegion)this.daughterRegions.getFirst()).getRegionInfo());
            Put putB = MetaEditor.makePutFromRegionInfo((HRegionInfo)((HRegion)this.daughterRegions.getSecond()).getRegionInfo());
            this.st.addLocation(putA, rs.getServerName(), 1L);
            this.st.addLocation(putB, rs.getServerName(), 1L);
            metaEntries.add((Mutation)putA);
            metaEntries.add((Mutation)putB);
        }

        public void preSplitAfterPONR(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            RegionCoprocessorEnvironment environment = (RegionCoprocessorEnvironment)ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            this.st.stepsAfterPONR((Server)rs, (RegionServerServices)rs, this.daughterRegions);
        }
    }

    private static class SplittingNodeCreationFailedException
    extends IOException {
        private static final long serialVersionUID = 1652404976265623004L;
    }

    public static class MockMasterWithoutCatalogJanitor
    extends HMaster {
        public MockMasterWithoutCatalogJanitor(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }
    }

    public static class MockedSplitTransaction
    extends SplitTransaction {
        private HRegion currentRegion;

        public MockedSplitTransaction(HRegion r, byte[] splitrow) {
            super(r, splitrow);
            this.currentRegion = r;
        }

        void transitionZKNode(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                try {
                    if (!secondSplit) {
                        callRollBack = true;
                        latch.await();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            super.transitionZKNode(server, services, a, b);
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                firstSplitCompleted = true;
            }
        }

        public boolean rollback(Server server, RegionServerServices services) throws IOException {
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack") && secondSplit) {
                super.rollback(server, services);
                latch.countDown();
                return true;
            }
            return super.rollback(server, services);
        }
    }

    static class UselessTestAbortable
    implements Abortable {
        boolean aborted = false;

        UselessTestAbortable() {
        }

        public void abort(String why, Throwable e) {
            LOG.warn((Object)("ABORTED (But nothing to abort): why=" + why), e);
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }

    public static class FailingSplitRegionObserver
    extends BaseRegionObserver {
        volatile CountDownLatch latch;
        volatile CountDownLatch postSplit;

        public void start(CoprocessorEnvironment e) throws IOException {
            this.latch = new CountDownLatch(1);
            this.postSplit = new CountDownLatch(1);
        }

        public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
            this.latch.countDown();
            LOG.info((Object)"Causing rollback of region split");
            throw new IOException("Causing rollback of region split");
        }

        public void postCompleteSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            this.postSplit.countDown();
            LOG.info((Object)"postCompleteSplit called");
        }
    }
}

