/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationPeerZKImpl;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestPerTableCFReplication {
    private static final Log LOG = LogFactory.getLog(TestPerTableCFReplication.class);
    private static Configuration conf1;
    private static Configuration conf2;
    private static Configuration conf3;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static HBaseTestingUtility utility3;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 100;
    private static final byte[] tableName;
    private static final byte[] tabAName;
    private static final byte[] tabBName;
    private static final byte[] tabCName;
    private static final byte[] famName;
    private static final byte[] f1Name;
    private static final byte[] f2Name;
    private static final byte[] f3Name;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] noRepfamName;
    private static final byte[] val;
    private static HTableDescriptor table;
    private static HTableDescriptor tabA;
    private static HTableDescriptor tabB;
    private static HTableDescriptor tabC;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1 = HBaseConfiguration.create();
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("hbase.regionserver.hlog.blocksize", 20480);
        conf1.setInt("replication.source.size.capacity", 1024);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setBoolean("hbase.replication", true);
        conf1.setBoolean("dfs.support.append", true);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{"org.apache.hadoop.hbase.replication.TestMasterReplication$CoprocessorCounter"});
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        new ZooKeeperWatcher(conf1, "cluster1", null, true);
        conf2 = new Configuration(conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf3 = new Configuration(conf1);
        conf3.set("zookeeper.znode.parent", "/3");
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf2, "cluster3", null, true);
        utility3 = new HBaseTestingUtility(conf3);
        utility3.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf3, "cluster3", null, true);
        table = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        table.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        table.addFamily(fam);
        tabA = new HTableDescriptor(tabAName);
        fam = new HColumnDescriptor(f1Name);
        fam.setScope(1);
        tabA.addFamily(fam);
        fam = new HColumnDescriptor(f2Name);
        fam.setScope(1);
        tabA.addFamily(fam);
        fam = new HColumnDescriptor(f3Name);
        fam.setScope(1);
        tabA.addFamily(fam);
        tabB = new HTableDescriptor(tabBName);
        fam = new HColumnDescriptor(f1Name);
        fam.setScope(1);
        tabB.addFamily(fam);
        fam = new HColumnDescriptor(f2Name);
        fam.setScope(1);
        tabB.addFamily(fam);
        fam = new HColumnDescriptor(f3Name);
        fam.setScope(1);
        tabB.addFamily(fam);
        tabC = new HTableDescriptor(tabCName);
        fam = new HColumnDescriptor(f1Name);
        fam.setScope(1);
        tabC.addFamily(fam);
        fam = new HColumnDescriptor(f2Name);
        fam.setScope(1);
        tabC.addFamily(fam);
        fam = new HColumnDescriptor(f3Name);
        fam.setScope(1);
        tabC.addFamily(fam);
        utility1.startMiniCluster();
        utility2.startMiniCluster();
        utility3.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility3.shutdownMiniCluster();
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Test
    public void testParseTableCFsFromConfig() {
        Map tabCFsMap = null;
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig(null);
        Assert.assertEquals(null, (Object)tabCFsMap);
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig((String)"");
        Assert.assertEquals(null, (Object)tabCFsMap);
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig((String)"   ");
        Assert.assertEquals(null, (Object)tabCFsMap);
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig((String)"tab1");
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab1"));
        Assert.assertFalse((boolean)tabCFsMap.containsKey("tab2"));
        Assert.assertEquals(null, tabCFsMap.get("tab1"));
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig((String)"tab2:cf1");
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab2"));
        Assert.assertFalse((boolean)tabCFsMap.containsKey("tab1"));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get("tab2")).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get("tab2")).get(0));
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig((String)"tab3 : cf1 , cf3");
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab3"));
        Assert.assertFalse((boolean)tabCFsMap.containsKey("tab1"));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get("tab3")).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get("tab3")).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get("tab3")).contains("cf3"));
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig((String)"tab1 ; tab2:cf1 ; tab3:cf1,cf3");
        Assert.assertEquals((long)3L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab1"));
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab2"));
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab3"));
        Assert.assertEquals(null, tabCFsMap.get("tab1"));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get("tab2")).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get("tab2")).get(0));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get("tab3")).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get("tab3")).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get("tab3")).contains("cf3"));
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig((String)"tab1 ; ; tab2:cf1 ; tab3:cf1,,cf3 ;");
        Assert.assertEquals((long)3L, (long)tabCFsMap.size());
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab1"));
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab2"));
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab3"));
        Assert.assertEquals(null, tabCFsMap.get("tab1"));
        Assert.assertEquals((long)1L, (long)((List)tabCFsMap.get("tab2")).size());
        Assert.assertEquals((Object)"cf1", ((List)tabCFsMap.get("tab2")).get(0));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get("tab3")).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get("tab3")).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get("tab3")).contains("cf3"));
        tabCFsMap = ReplicationPeerZKImpl.parseTableCFsFromConfig((String)"tab1:tt:cf1 ; tab2::cf1 ; tab3:cf1,cf3");
        Assert.assertEquals((long)1L, (long)tabCFsMap.size());
        Assert.assertFalse((boolean)tabCFsMap.containsKey("tab1"));
        Assert.assertFalse((boolean)tabCFsMap.containsKey("tab2"));
        Assert.assertTrue((boolean)tabCFsMap.containsKey("tab3"));
        Assert.assertEquals((long)2L, (long)((List)tabCFsMap.get("tab3")).size());
        Assert.assertTrue((boolean)((List)tabCFsMap.get("tab3")).contains("cf1"));
        Assert.assertTrue((boolean)((List)tabCFsMap.get("tab3")).contains("cf3"));
    }

    @Test(timeout=300000L)
    public void testPerTableCFReplication() throws Exception {
        LOG.info((Object)"testPerTableCFReplication");
        ReplicationAdmin admin1 = new ReplicationAdmin(conf1);
        new HBaseAdmin(conf1).createTable(tabA);
        new HBaseAdmin(conf1).createTable(tabB);
        new HBaseAdmin(conf1).createTable(tabC);
        new HBaseAdmin(conf2).createTable(tabA);
        new HBaseAdmin(conf2).createTable(tabB);
        new HBaseAdmin(conf2).createTable(tabC);
        new HBaseAdmin(conf3).createTable(tabA);
        new HBaseAdmin(conf3).createTable(tabB);
        new HBaseAdmin(conf3).createTable(tabC);
        HTable htab1A = new HTable(conf1, tabAName);
        HTable htab2A = new HTable(conf2, tabAName);
        HTable htab3A = new HTable(conf3, tabAName);
        HTable htab1B = new HTable(conf1, tabBName);
        HTable htab2B = new HTable(conf2, tabBName);
        HTable htab3B = new HTable(conf3, tabBName);
        HTable htab1C = new HTable(conf1, tabCName);
        HTable htab2C = new HTable(conf2, tabCName);
        HTable htab3C = new HTable(conf3, tabCName);
        admin1.addPeer("2", utility2.getClusterKey(), "TC;TB:f1,f3");
        admin1.addPeer("3", utility3.getClusterKey(), "TA;TB:f1,f2");
        this.putAndWaitWithFamily(row1, f1Name, htab1A, htab3A);
        this.ensureRowNotReplicated(row1, f1Name, htab2A);
        this.deleteAndWaitWithFamily(row1, f1Name, htab1A, htab3A);
        this.putAndWaitWithFamily(row1, f2Name, htab1A, htab3A);
        this.ensureRowNotReplicated(row1, f2Name, htab2A);
        this.deleteAndWaitWithFamily(row1, f2Name, htab1A, htab3A);
        this.putAndWaitWithFamily(row1, f3Name, htab1A, htab3A);
        this.ensureRowNotReplicated(row1, f3Name, htab2A);
        this.deleteAndWaitWithFamily(row1, f3Name, htab1A, htab3A);
        this.putAndWaitWithFamily(row1, f1Name, htab1B, htab2B, htab3B);
        this.deleteAndWaitWithFamily(row1, f1Name, htab1B, htab2B, htab3B);
        this.putAndWaitWithFamily(row1, f2Name, htab1B, htab3B);
        this.ensureRowNotReplicated(row1, f2Name, htab2B);
        this.deleteAndWaitWithFamily(row1, f2Name, htab1B, htab3B);
        this.putAndWaitWithFamily(row1, f3Name, htab1B, htab2B);
        this.ensureRowNotReplicated(row1, f3Name, htab3B);
        this.deleteAndWaitWithFamily(row1, f3Name, htab1B, htab2B);
        this.putAndWaitWithFamily(row1, f1Name, htab1C, htab2C);
        this.ensureRowNotReplicated(row1, f1Name, htab3C);
        this.deleteAndWaitWithFamily(row1, f1Name, htab1C, htab2C);
        this.putAndWaitWithFamily(row1, f2Name, htab1C, htab2C);
        this.ensureRowNotReplicated(row1, f2Name, htab3C);
        this.deleteAndWaitWithFamily(row1, f2Name, htab1C, htab2C);
        this.putAndWaitWithFamily(row1, f3Name, htab1C, htab2C);
        this.ensureRowNotReplicated(row1, f3Name, htab3C);
        this.deleteAndWaitWithFamily(row1, f3Name, htab1C, htab2C);
        admin1.setPeerTableCFs("2", "TA:f1,f2; TC:f2,f3");
        admin1.setPeerTableCFs("3", "TB; TC:f3");
        this.putAndWaitWithFamily(row2, f1Name, htab1A, htab2A);
        this.ensureRowNotReplicated(row2, f1Name, htab3A);
        this.deleteAndWaitWithFamily(row2, f1Name, htab1A, htab2A);
        this.putAndWaitWithFamily(row2, f2Name, htab1A, htab2A);
        this.ensureRowNotReplicated(row2, f2Name, htab3A);
        this.deleteAndWaitWithFamily(row2, f2Name, htab1A, htab2A);
        this.putAndWaitWithFamily(row2, f3Name, htab1A, new HTable[0]);
        this.ensureRowNotReplicated(row2, f3Name, htab2A, htab3A);
        this.deleteAndWaitWithFamily(row2, f3Name, htab1A, new HTable[0]);
        this.putAndWaitWithFamily(row2, f1Name, htab1B, htab3B);
        this.ensureRowNotReplicated(row2, f1Name, htab2B);
        this.deleteAndWaitWithFamily(row2, f1Name, htab1B, htab3B);
        this.putAndWaitWithFamily(row2, f2Name, htab1B, htab3B);
        this.ensureRowNotReplicated(row2, f2Name, htab2B);
        this.deleteAndWaitWithFamily(row2, f2Name, htab1B, htab3B);
        this.putAndWaitWithFamily(row2, f3Name, htab1B, htab3B);
        this.ensureRowNotReplicated(row2, f3Name, htab2B);
        this.deleteAndWaitWithFamily(row2, f3Name, htab1B, htab3B);
        this.putAndWaitWithFamily(row2, f1Name, htab1C, new HTable[0]);
        this.ensureRowNotReplicated(row2, f1Name, htab2C, htab3C);
        this.deleteAndWaitWithFamily(row2, f1Name, htab1C, new HTable[0]);
        this.putAndWaitWithFamily(row2, f2Name, htab1C, htab2C);
        this.ensureRowNotReplicated(row2, f2Name, htab3C);
        this.deleteAndWaitWithFamily(row2, f2Name, htab1C, htab2C);
        this.putAndWaitWithFamily(row2, f3Name, htab1C, htab2C, htab3C);
        this.deleteAndWaitWithFamily(row2, f3Name, htab1C, htab2C, htab3C);
    }

    private void ensureRowNotReplicated(byte[] row, byte[] fam, HTable ... tables) throws IOException {
        Get get = new Get(row);
        get.addFamily(fam);
        for (HTable table : tables) {
            Result res = table.get(get);
            Assert.assertEquals((long)0L, (long)res.size());
        }
    }

    private void deleteAndWaitWithFamily(byte[] row, byte[] fam, HTable source, HTable ... targets) throws Exception {
        Delete del = new Delete(row);
        del.deleteFamily(fam);
        source.delete(del);
        Get get = new Get(row);
        get.addFamily(fam);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            boolean removedFromAll = true;
            for (HTable target : targets) {
                Result res = target.get(get);
                if (res.size() < 1) continue;
                LOG.info((Object)"Row not deleted");
                removedFromAll = false;
                break;
            }
            if (removedFromAll) break;
            Thread.sleep(500L);
        }
    }

    private void putAndWaitWithFamily(byte[] row, byte[] fam, HTable source, HTable ... targets) throws Exception {
        Put put = new Put(row);
        put.add(fam, row, val);
        source.put(put);
        Get get = new Get(row);
        get.addFamily(fam);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            boolean replicatedToAll = true;
            for (HTable target : targets) {
                Result res = target.get(get);
                if (res.size() == 0) {
                    LOG.info((Object)"Row not available");
                    replicatedToAll = false;
                    break;
                }
                Assert.assertEquals((long)res.size(), (long)1L);
                Assert.assertArrayEquals((byte[])res.value(), (byte[])val);
            }
            if (replicatedToAll) break;
            Thread.sleep(500L);
        }
    }

    static {
        tableName = Bytes.toBytes((String)"test");
        tabAName = Bytes.toBytes((String)"TA");
        tabBName = Bytes.toBytes((String)"TB");
        tabCName = Bytes.toBytes((String)"TC");
        famName = Bytes.toBytes((String)"f");
        f1Name = Bytes.toBytes((String)"f1");
        f2Name = Bytes.toBytes((String)"f2");
        f3Name = Bytes.toBytes((String)"f3");
        row1 = Bytes.toBytes((String)"row1");
        row2 = Bytes.toBytes((String)"row2");
        noRepfamName = Bytes.toBytes((String)"norep");
        val = Bytes.toBytes((String)"myval");
    }
}

