/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationSource {
    private static final Log LOG = LogFactory.getLog(TestReplicationSource.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static FileSystem FS;
    private static Path oldLogDir;
    private static Path logDir;
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniDFSCluster(1);
        FS = TEST_UTIL.getDFSCluster().getFileSystem();
        oldLogDir = new Path(FS.getHomeDirectory(), "oldWALs");
        if (FS.exists(oldLogDir)) {
            FS.delete(oldLogDir, true);
        }
        if (FS.exists(logDir = new Path(FS.getHomeDirectory(), "WALs"))) {
            FS.delete(logDir, true);
        }
    }

    @Test
    public void testLogMoving() throws Exception {
        Path logPath = new Path(logDir, "log");
        if (!FS.exists(logDir)) {
            FS.mkdirs(logDir);
        }
        if (!FS.exists(oldLogDir)) {
            FS.mkdirs(oldLogDir);
        }
        HLog.Writer writer = HLogFactory.createWALWriter((FileSystem)FS, (Path)logPath, (Configuration)conf);
        for (int i = 0; i < 3; ++i) {
            byte[] b = Bytes.toBytes((String)Integer.toString(i));
            KeyValue kv = new KeyValue(b, b, b);
            WALEdit edit = new WALEdit();
            edit.add(kv);
            HLogKey key = new HLogKey(b, TableName.valueOf((byte[])b), 0L, 0L, HConstants.DEFAULT_CLUSTER_ID);
            writer.append(new HLog.Entry(key, edit));
            writer.sync();
        }
        writer.close();
        HLog.Reader reader = HLogFactory.createReader((FileSystem)FS, (Path)logPath, (Configuration)conf);
        HLog.Entry entry = reader.next();
        Assert.assertNotNull((Object)entry);
        Path oldLogPath = new Path(oldLogDir, "log");
        FS.rename(logPath, oldLogPath);
        entry = reader.next();
        Assert.assertNotNull((Object)entry);
        entry = reader.next();
        entry = reader.next();
        Assert.assertNull((Object)entry);
    }

    static {
        conf = HBaseConfiguration.create();
    }
}

