/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.ExpAsStringVisibilityLabelServiceImpl;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.TestVisibilityLabelsReplication;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestVisibilityLabelReplicationWithExpAsString
extends TestVisibilityLabelsReplication {
    private static final Log LOG = LogFactory.getLog(TestVisibilityLabelReplicationWithExpAsString.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setup() throws Exception {
        TestVisibilityLabelReplicationWithExpAsString.expected[0] = 4;
        TestVisibilityLabelReplicationWithExpAsString.expected[1] = 6;
        TestVisibilityLabelReplicationWithExpAsString.expected[2] = 4;
        TestVisibilityLabelReplicationWithExpAsString.expected[3] = 0;
        TestVisibilityLabelReplicationWithExpAsString.expected[3] = 3;
        TestVisibilityLabelReplicationWithExpAsString.expectedVisString[0] = "(\"public\"&\"secret\"&\"topsecret\")|(\"confidential\"&\"topsecret\")";
        TestVisibilityLabelReplicationWithExpAsString.expectedVisString[1] = "(\"private\"&\"public\")|(\"private\"&\"topsecret\")|(\"confidential\"&\"public\")|(\"confidential\"&\"topsecret\")";
        TestVisibilityLabelReplicationWithExpAsString.expectedVisString[2] = "(!\"topsecret\"&\"secret\")|(!\"topsecret\"&\"confidential\")";
        TestVisibilityLabelReplicationWithExpAsString.expectedVisString[3] = "(\"secret\"&\"\u00a9ABC\\\"\u0941\\\\secret\\\"'&\\\\\")";
        conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        conf.setBoolean("hbase.online.schema.update.enable", true);
        conf.setInt("hfile.format.version", 3);
        conf.set("zookeeper.znode.parent", "/1");
        conf.setInt("replication.source.size.capacity", 10240);
        conf.setLong("replication.source.sleepforretries", 100L);
        conf.setInt("hbase.regionserver.maxlogs", 10);
        conf.setLong("hbase.master.logcleaner.ttl", 10L);
        conf.setInt("zookeeper.recovery.retry", 1);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf.setBoolean("dfs.support.append", true);
        conf.setLong("hbase.server.thread.wakefrequency", 100L);
        conf.setInt("replication.stats.thread.period.seconds", 5);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        TestVisibilityLabelReplicationWithExpAsString.setVisibilityLabelServiceImpl(conf, ExpAsStringVisibilityLabelServiceImpl.class);
        conf.setBoolean("hbase.replication", true);
        conf.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.set("hbase.coprocessor.regionserver.classes", VisibilityController.VisibilityReplication.class.getName());
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestVisibilityLabelsReplication.SimpleCP.class.getName()});
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        conf.set("hbase.superuser", User.getCurrent().getShortName());
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)User.getCurrent().getShortName(), (String[])new String[]{"supergroup"});
        User.createUserForTesting((Configuration)conf, (String)User.getCurrent().getShortName(), (String[])new String[]{"supergroup"});
        USER1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = TEST_UTIL.getZkCluster();
        zkw1 = new ZooKeeperWatcher(conf, "cluster1", null, true);
        replicationAdmin = new ReplicationAdmin(conf);
        conf1 = HBaseConfiguration.create((Configuration)conf);
        conf1.setInt("hfile.format.version", 3);
        conf1.set("zookeeper.znode.parent", "/2");
        conf1.setInt("hbase.client.retries.number", 6);
        conf1.setBoolean("dfs.support.append", true);
        conf1.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf.setBoolean("hbase.replication", true);
        conf1.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestVisibilityLabelsReplication.TestCoprocessorForTagsAtSink.class.getName()});
        TestVisibilityLabelReplicationWithExpAsString.setVisibilityLabelServiceImpl(conf1, ExpAsStringVisibilityLabelServiceImpl.class);
        TEST_UTIL1 = new HBaseTestingUtility(conf1);
        TEST_UTIL1.setZkCluster(miniZK);
        zkw2 = new ZooKeeperWatcher(conf1, "cluster2", null, true);
        replicationAdmin.addPeer("2", TEST_UTIL1.getClusterKey());
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TEST_UTIL1.startMiniCluster(1);
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor table = new HTableDescriptor(TableName.valueOf((String)TABLE_NAME));
        HColumnDescriptor desc = new HColumnDescriptor(fam);
        desc.setScope(1);
        table.addFamily(desc);
        try {
            hBaseAdmin.createTable(table);
        }
        finally {
            if (hBaseAdmin != null) {
                hBaseAdmin.close();
            }
        }
        HBaseAdmin hBaseAdmin1 = TEST_UTIL1.getHBaseAdmin();
        try {
            hBaseAdmin1.createTable(table);
        }
        finally {
            if (hBaseAdmin1 != null) {
                hBaseAdmin1.close();
            }
        }
        TestVisibilityLabelReplicationWithExpAsString.addLabels();
        TestVisibilityLabelReplicationWithExpAsString.setAuths(conf);
        TestVisibilityLabelReplicationWithExpAsString.setAuths(conf1);
    }

    protected static void setVisibilityLabelServiceImpl(Configuration conf, Class clazz) {
        conf.setClass("hbase.regionserver.visibility.label.service.class", clazz, VisibilityLabelService.class);
    }

    @Override
    protected void verifyGet(final byte[] row, final String visString, final int expected, final boolean nullExpected, final String ... auths) throws IOException, InterruptedException {
        PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){
            HTable table2 = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                try {
                    this.table2 = new HTable(TestVisibilityLabelsReplication.conf1, TestVisibilityLabelsReplication.TABLE_NAME_BYTES);
                    Get get = new Get(row);
                    get.setAuthorizations(new Authorizations(auths));
                    Result result = this.table2.get(get);
                    CellScanner cellScanner = result.cellScanner();
                    boolean advance = cellScanner.advance();
                    if (nullExpected) {
                        Assert.assertTrue((!advance ? 1 : 0) != 0);
                        Void void_ = null;
                        return void_;
                    }
                    Cell current = cellScanner.current();
                    Assert.assertArrayEquals((byte[])CellUtil.cloneRow((Cell)current), (byte[])row);
                    Assert.assertEquals((long)expected, (long)TestVisibilityLabelsReplication.TestCoprocessorForTagsAtSink.tags.size());
                    boolean foundNonVisTag = false;
                    for (Tag t : TestVisibilityLabelsReplication.TestCoprocessorForTagsAtSink.tags) {
                        if (t.getType() != 100) continue;
                        Assert.assertEquals((Object)"temp", (Object)Bytes.toString((byte[])t.getValue()));
                        foundNonVisTag = true;
                        break;
                    }
                    TestVisibilityLabelsReplication.doAssert(row, visString);
                    Assert.assertTrue((boolean)foundNonVisTag);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    if (this.table2 != null) {
                        this.table2.close();
                    }
                }
            }
        };
        USER1.runAs((PrivilegedExceptionAction)scanAction);
    }
}

