/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRecoverableZooKeeper {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    Abortable abortable = new Abortable(){

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }
    };

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testSetDataVersionMismatchInLoop() throws Exception {
        String znode = "/hbase/splitWAL/9af7cfc9b15910a0b3d714bf40a3248f";
        Configuration conf = TEST_UTIL.getConfiguration();
        Properties properties = ZKConfig.makeZKProps((Configuration)conf);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testSetDataVersionMismatchInLoop", this.abortable, true);
        String ensemble = ZKConfig.getZKQuorumServersString((Properties)properties);
        RecoverableZooKeeper rzk = ZKUtil.connect((Configuration)conf, (String)ensemble, (Watcher)zkw);
        rzk.create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        rzk.setData(znode, "OPENING".getBytes(), 0);
        Field zkField = RecoverableZooKeeper.class.getDeclaredField("zk");
        zkField.setAccessible(true);
        int timeout = conf.getInt("zookeeper.session.timeout", 180000);
        ZookeeperStub zkStub = new ZookeeperStub(ensemble, timeout, (Watcher)zkw);
        zkStub.setThrowExceptionInNumOperations(1);
        zkField.set(rzk, (Object)zkStub);
        byte[] opened = "OPENED".getBytes();
        rzk.setData(znode, opened, 1);
        byte[] data = rzk.getData(znode, false, new Stat());
        Assert.assertTrue((boolean)Bytes.equals((byte[])opened, (byte[])data));
    }

    class ZookeeperStub
    extends ZooKeeper {
        private int throwExceptionInNumOperations;

        public ZookeeperStub(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
            super(connectString, sessionTimeout, watcher);
        }

        public void setThrowExceptionInNumOperations(int throwExceptionInNumOperations) {
            this.throwExceptionInNumOperations = throwExceptionInNumOperations;
        }

        private void checkThrowKeeperException() throws KeeperException {
            if (this.throwExceptionInNumOperations == 1) {
                this.throwExceptionInNumOperations = 0;
                throw new KeeperException.ConnectionLossException();
            }
            if (this.throwExceptionInNumOperations > 0) {
                --this.throwExceptionInNumOperations;
            }
        }

        public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
            Stat stat = super.setData(path, data, version);
            this.checkThrowKeeperException();
            return stat;
        }
    }
}

