/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class HFileLink
extends FileLink {
    private static final Log LOG = LogFactory.getLog(HFileLink.class);
    public static final String LINK_NAME_REGEX = String.format("(?:(?:%s=)?)%s=%s-%s", "(?:[a-zA-Z_0-9]+)", "(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)", "(?:[a-f0-9]+)", "[0-9a-f]+(?:_SeqId_[0-9]+_)?");
    static final Pattern LINK_NAME_PATTERN = Pattern.compile(String.format("^(?:(%s)(?:\\=))?(%s)=(%s)-(%s)$", "(?:[a-zA-Z_0-9]+)", "(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)", "(?:[a-f0-9]+)", "[0-9a-f]+(?:_SeqId_[0-9]+_)?"));
    private static final Pattern REF_OR_HFILE_LINK_PATTERN = Pattern.compile(String.format("^(?:(%s)(?:=))?(%s)=(%s)-(.+)$", "(?:[a-zA-Z_0-9]+)", "(?:[a-zA-Z_0-9][a-zA-Z_0-9-.]*)", "(?:[a-f0-9]+)"));
    private final Path archivePath;
    private final Path originPath;
    private final Path tempPath;

    public HFileLink(Configuration conf, Path path) throws IOException {
        this(FSUtils.getRootDir(conf), HFileArchiveUtil.getArchivePath(conf), path);
    }

    public HFileLink(Path rootDir, Path archiveDir, Path path) {
        Path hfilePath = HFileLink.getRelativeTablePath(path);
        this.tempPath = new Path(new Path(rootDir, ".tmp"), hfilePath);
        this.originPath = new Path(rootDir, hfilePath);
        this.archivePath = new Path(archiveDir, hfilePath);
        this.setLocations(this.originPath, this.tempPath, this.archivePath);
    }

    public static Path createPath(TableName table, String region, String family, String hfile) {
        if (HFileLink.isHFileLink(hfile)) {
            return new Path(family, hfile);
        }
        return new Path(family, HFileLink.createHFileLinkName(table, region, hfile));
    }

    public static HFileLink create(Configuration conf, TableName table, String region, String family, String hfile) throws IOException {
        return new HFileLink(conf, HFileLink.createPath(table, region, family, hfile));
    }

    public Path getOriginPath() {
        return this.originPath;
    }

    public Path getArchivePath() {
        return this.archivePath;
    }

    public static boolean isHFileLink(Path path) {
        return HFileLink.isHFileLink(path.getName());
    }

    public static boolean isHFileLink(String fileName) {
        Matcher m = LINK_NAME_PATTERN.matcher(fileName);
        if (!m.matches()) {
            return false;
        }
        return m.groupCount() > 2 && m.group(4) != null && m.group(3) != null && m.group(2) != null;
    }

    private static Path getRelativeTablePath(Path path) {
        Matcher m = REF_OR_HFILE_LINK_PATTERN.matcher(path.getName());
        if (!m.matches()) {
            throw new IllegalArgumentException(path.getName() + " is not a valid HFileLink name!");
        }
        TableName tableName = TableName.valueOf((String)m.group(1), (String)m.group(2));
        String regionName = m.group(3);
        String hfileName = m.group(4);
        String familyName = path.getParent().getName();
        Path tableDir = FSUtils.getTableDir(new Path("./"), tableName);
        return new Path(tableDir, new Path(regionName, new Path(familyName, hfileName)));
    }

    public static String getReferencedHFileName(String fileName) {
        Matcher m = REF_OR_HFILE_LINK_PATTERN.matcher(fileName);
        if (!m.matches()) {
            throw new IllegalArgumentException(fileName + " is not a valid HFileLink name!");
        }
        return m.group(4);
    }

    public static String getReferencedRegionName(String fileName) {
        Matcher m = REF_OR_HFILE_LINK_PATTERN.matcher(fileName);
        if (!m.matches()) {
            throw new IllegalArgumentException(fileName + " is not a valid HFileLink name!");
        }
        return m.group(3);
    }

    public static TableName getReferencedTableName(String fileName) {
        Matcher m = REF_OR_HFILE_LINK_PATTERN.matcher(fileName);
        if (!m.matches()) {
            throw new IllegalArgumentException(fileName + " is not a valid HFileLink name!");
        }
        return TableName.valueOf((String)m.group(1), (String)m.group(2));
    }

    public static String createHFileLinkName(HRegionInfo hfileRegionInfo, String hfileName) {
        return HFileLink.createHFileLinkName(hfileRegionInfo.getTable(), hfileRegionInfo.getEncodedName(), hfileName);
    }

    public static String createHFileLinkName(TableName tableName, String regionName, String hfileName) {
        String s = String.format("%s=%s-%s", tableName.getNameAsString().replace(':', '='), regionName, hfileName);
        return s;
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, HRegionInfo hfileRegionInfo, String hfileName) throws IOException {
        return HFileLink.create(conf, fs, dstFamilyPath, hfileRegionInfo, hfileName, true);
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, HRegionInfo hfileRegionInfo, String hfileName, boolean createBackRef) throws IOException {
        TableName linkedTable = hfileRegionInfo.getTable();
        String linkedRegion = hfileRegionInfo.getEncodedName();
        return HFileLink.create(conf, fs, dstFamilyPath, linkedTable, linkedRegion, hfileName, createBackRef);
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, TableName linkedTable, String linkedRegion, String hfileName) throws IOException {
        return HFileLink.create(conf, fs, dstFamilyPath, linkedTable, linkedRegion, hfileName, true);
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, TableName linkedTable, String linkedRegion, String hfileName, boolean createBackRef) throws IOException {
        String familyName = dstFamilyPath.getName();
        String regionName = dstFamilyPath.getParent().getName();
        String tableName = FSUtils.getTableName(dstFamilyPath.getParent().getParent()).getNameAsString();
        String name = HFileLink.createHFileLinkName(linkedTable, linkedRegion, hfileName);
        String refName = HFileLink.createBackReferenceName(tableName, regionName);
        fs.mkdirs(dstFamilyPath);
        Path archiveStoreDir = HFileArchiveUtil.getStoreArchivePath(conf, linkedTable, linkedRegion, familyName);
        Path backRefPath = null;
        if (createBackRef) {
            Path backRefssDir = HFileLink.getBackReferencesDir(archiveStoreDir, hfileName);
            fs.mkdirs(backRefssDir);
            backRefPath = new Path(backRefssDir, refName);
            fs.createNewFile(backRefPath);
        }
        try {
            return fs.createNewFile(new Path(dstFamilyPath, name));
        }
        catch (IOException e) {
            LOG.error((Object)("couldn't create the link=" + name + " for " + dstFamilyPath), (Throwable)e);
            if (createBackRef) {
                fs.delete(backRefPath, false);
            }
            throw e;
        }
    }

    public static boolean createFromHFileLink(Configuration conf, FileSystem fs, Path dstFamilyPath, String hfileLinkName) throws IOException {
        return HFileLink.createFromHFileLink(conf, fs, dstFamilyPath, hfileLinkName, true);
    }

    public static boolean createFromHFileLink(Configuration conf, FileSystem fs, Path dstFamilyPath, String hfileLinkName, boolean createBackRef) throws IOException {
        Matcher m = LINK_NAME_PATTERN.matcher(hfileLinkName);
        if (!m.matches()) {
            throw new IllegalArgumentException(hfileLinkName + " is not a valid HFileLink name!");
        }
        return HFileLink.create(conf, fs, dstFamilyPath, TableName.valueOf((String)m.group(1), (String)m.group(2)), m.group(3), m.group(4), createBackRef);
    }

    static String createBackReferenceName(String tableNameStr, String regionName) {
        return regionName + "." + tableNameStr.replace(':', '=');
    }

    public static Path getHFileFromBackReference(Path rootDir, Path linkRefPath) {
        Pair<TableName, String> p = HFileLink.parseBackReferenceName(linkRefPath.getName());
        TableName linkTableName = (TableName)p.getFirst();
        String linkRegionName = (String)p.getSecond();
        String hfileName = HFileLink.getBackReferenceFileName(linkRefPath.getParent());
        Path familyPath = linkRefPath.getParent().getParent();
        Path regionPath = familyPath.getParent();
        Path tablePath = regionPath.getParent();
        String linkName = HFileLink.createHFileLinkName(FSUtils.getTableName(tablePath), regionPath.getName(), hfileName);
        Path linkTableDir = FSUtils.getTableDir(rootDir, linkTableName);
        Path regionDir = HRegion.getRegionDir(linkTableDir, linkRegionName);
        return new Path(new Path(regionDir, familyPath.getName()), linkName);
    }

    static Pair<TableName, String> parseBackReferenceName(String name) {
        int separatorIndex = name.indexOf(46);
        String linkRegionName = name.substring(0, separatorIndex);
        String tableSubstr = name.substring(separatorIndex + 1).replace('=', ':');
        TableName linkTableName = TableName.valueOf((String)tableSubstr);
        return new Pair((Object)linkTableName, (Object)linkRegionName);
    }

    public static Path getHFileFromBackReference(Configuration conf, Path linkRefPath) throws IOException {
        return HFileLink.getHFileFromBackReference(FSUtils.getRootDir(conf), linkRefPath);
    }
}

