/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class RpcExecutor {
    private static final Log LOG = LogFactory.getLog(RpcExecutor.class);
    private final AtomicInteger activeHandlerCount = new AtomicInteger(0);
    private final List<Thread> handlers;
    private final int handlerCount;
    private final String name;
    private final AtomicInteger failedHandlerCount = new AtomicInteger(0);
    private boolean running;
    private Configuration conf = null;
    private Abortable abortable = null;
    private static QueueBalancer ONE_QUEUE = new QueueBalancer(){

        @Override
        public int getNextQueue() {
            return 0;
        }
    };

    public RpcExecutor(String name, int handlerCount) {
        this.handlers = new ArrayList<Thread>(handlerCount);
        this.handlerCount = handlerCount;
        this.name = Strings.nullToEmpty((String)name);
    }

    public RpcExecutor(String name, int handlerCount, Configuration conf, Abortable abortable) {
        this(name, handlerCount);
        this.conf = conf;
        this.abortable = abortable;
    }

    public void start(int port) {
        this.running = true;
        this.startHandlers(port);
    }

    public void stop() {
        this.running = false;
        for (Thread handler : this.handlers) {
            handler.interrupt();
        }
    }

    public int getActiveHandlerCount() {
        return this.activeHandlerCount.get();
    }

    public abstract int getQueueLength();

    public abstract void dispatch(CallRunner var1) throws InterruptedException;

    protected abstract List<BlockingQueue<CallRunner>> getQueues();

    protected void startHandlers(int port) {
        List<BlockingQueue<CallRunner>> callQueues = this.getQueues();
        this.startHandlers(null, this.handlerCount, callQueues, 0, callQueues.size(), port);
    }

    protected void startHandlers(String nameSuffix, int numHandlers, final List<BlockingQueue<CallRunner>> callQueues, int qindex, int qsize, int port) {
        String threadPrefix = this.name + Strings.nullToEmpty((String)nameSuffix);
        for (int i = 0; i < numHandlers; ++i) {
            final int index = qindex + i % qsize;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    RpcExecutor.this.consumerLoop((BlockingQueue)callQueues.get(index));
                }
            });
            t.setDaemon(true);
            t.setName(threadPrefix + "RpcServer.handler=" + this.handlers.size() + ",queue=" + index + ",port=" + port);
            t.start();
            LOG.debug((Object)(threadPrefix + " Start Handler index=" + this.handlers.size() + " queue=" + index));
            this.handlers.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumerLoop(BlockingQueue<CallRunner> myQueue) {
        block15: {
            boolean interrupted = false;
            double handlerFailureThreshhold = this.conf == null ? 1.0 : (double)this.conf.getFloat("hbase.regionserver.handler.abort.on.error.percent", -1.0f);
            block10: while (true) {
                while (this.running) {
                    try {
                        MonitoredRPCHandler status = RpcServer.getStatus();
                        CallRunner task = myQueue.take();
                        task.setStatus(status);
                        try {
                            this.activeHandlerCount.incrementAndGet();
                            task.run();
                            continue block10;
                        }
                        catch (Error e) {
                            int failedCount = this.failedHandlerCount.incrementAndGet();
                            if (handlerFailureThreshhold >= 0.0 && (double)failedCount > (double)this.handlerCount * handlerFailureThreshhold) {
                                String message = "Number of failed RpcServer handler exceeded threshhold " + handlerFailureThreshhold + "  with failed reason: " + StringUtils.stringifyException((Throwable)e);
                                if (this.abortable != null) {
                                    this.abortable.abort(message, (Throwable)e);
                                    continue block10;
                                }
                                LOG.error((Object)("Received " + StringUtils.stringifyException((Throwable)e) + " but not aborting due to abortable being null"));
                                throw e;
                            }
                            LOG.warn((Object)("RpcServer handler threads encountered errors " + StringUtils.stringifyException((Throwable)e)));
                            continue block10;
                        }
                        finally {
                            this.activeHandlerCount.decrementAndGet();
                            continue block10;
                        }
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                break block15;
                {
                    continue block10;
                    break;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static QueueBalancer getBalancer(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0, (Object)"Queue size is <= 0, must be at least 1");
        if (queueSize == 1) {
            return ONE_QUEUE;
        }
        return new RandomQueueBalancer(queueSize);
    }

    private static class RandomQueueBalancer
    extends QueueBalancer {
        private final int queueSize;
        private final ThreadLocal<Random> threadRandom = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                return new Random();
            }
        };

        public RandomQueueBalancer(int queueSize) {
            this.queueSize = queueSize;
        }

        @Override
        public int getNextQueue() {
            return this.threadRandom.get().nextInt(this.queueSize);
        }
    }

    public static abstract class QueueBalancer {
        public abstract int getNextQueue();
    }
}

