/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaMigrationConvertingToPB;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.ClusterStatusPublisher;
import org.apache.hadoop.hbase.master.HMasterCommandLine;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterDumpServlet;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterStatusServlet;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapperImpl;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.balancer.BalancerChore;
import org.apache.hadoop.hbase.master.balancer.ClusterStatusChore;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.master.handler.DeleteTableHandler;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.DispatchMergingRegionHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.ModifyTableHandler;
import org.apache.hadoop.hbase.master.handler.TableAddFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableDeleteFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TableModifyFamilyHandler;
import org.apache.hadoop.hbase.master.handler.TruncateTableHandler;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.monitoring.MemoryBoundedLogMessageBuffer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.MasterProcedureManagerHost;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.trace.SpanReceiverHost;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.JvmPauseMonitor;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.DrainingServerTracker;
import org.apache.hadoop.hbase.zookeeper.LoadBalancerTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.util.VersionInfo;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class HMaster
extends HasThread
implements MasterProtos.MasterService.BlockingInterface,
RegionServerStatusProtos.RegionServerStatusService.BlockingInterface,
MasterServices,
Server {
    private static final Log LOG = LogFactory.getLog((String)HMaster.class.getName());
    public static final String MASTER = "master";
    private final Configuration conf;
    private InfoServer infoServer;
    private ZooKeeperWatcher zooKeeper;
    private ActiveMasterManager activeMasterManager;
    RegionServerTracker regionServerTracker;
    private DrainingServerTracker drainingServerTracker;
    private LoadBalancerTracker loadBalancerTracker;
    private MasterAddressTracker masterAddressTracker;
    private final RpcServerInterface rpcServer;
    private JvmPauseMonitor pauseMonitor;
    private volatile boolean rpcServerOpen = false;
    private TableNamespaceManager tableNamespaceManager;
    private final InetSocketAddress isa;
    private final MetricsMaster metricsMaster;
    private MasterFileSystem fileSystemManager;
    ServerManager serverManager;
    AssignmentManager assignmentManager;
    private CatalogTracker catalogTracker;
    private ClusterStatusTracker clusterStatusTracker;
    private MemoryBoundedLogMessageBuffer rsFatals;
    private volatile boolean stopped = false;
    private volatile boolean abort = false;
    private volatile boolean isActiveMaster = false;
    volatile boolean initialized = false;
    private volatile boolean serverShutdownHandlerEnabled = false;
    org.apache.hadoop.hbase.executor.ExecutorService executorService;
    private LoadBalancer balancer;
    private Thread balancerChore;
    private Thread clusterStatusChore;
    private ClusterStatusPublisher clusterStatusPublisherChore = null;
    private CatalogJanitor catalogJanitorChore;
    private LogCleaner logCleaner;
    private HFileCleaner hfileCleaner;
    private MasterCoprocessorHost cpHost;
    private final ServerName serverName;
    private final boolean preLoadTableDescriptors;
    private TableDescriptors tableDescriptors;
    private TableLockManager tableLockManager;
    private long masterStartTime;
    private long masterActiveTime;
    private final int msgInterval;
    private ObjectName mxBean = null;
    private final boolean masterCheckCompression;
    private final boolean masterCheckEncryption;
    private SpanReceiverHost spanReceiverHost;
    private Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    private SnapshotManager snapshotManager;
    private MasterProcedureManagerHost mpmHost;
    private HealthCheckChore healthCheckChore;
    private volatile boolean initializationBeforeMetaAssignment = false;
    private List<ZooKeeperListener> registeredZKListenersBeforeRecovery;
    private Sleeper stopSleeper = new Sleeper(100, (Stoppable)this);

    public HMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
        this.conf = new Configuration(conf);
        this.conf.setFloat("hfile.block.cache.size", 0.0f);
        FSUtils.setupShortCircuitRead(conf);
        String hostname = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.master.dns.interface", "default"), (String)conf.get("hbase.master.dns.nameserver", "default")));
        int port = conf.getInt("hbase.master.port", 60000);
        InetSocketAddress initialIsa = new InetSocketAddress(hostname, port);
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of hostname " + initialIsa);
        }
        String bindAddress = conf.get("hbase.master.ipc.address");
        if (bindAddress != null && (initialIsa = new InetSocketAddress(bindAddress, port)).getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of bind address " + initialIsa);
        }
        String name = "master/" + initialIsa.toString();
        HConnectionManager.setServerSideHConnectionRetries((Configuration)this.conf, (String)name, (Log)LOG);
        int numHandlers = conf.getInt("hbase.master.handler.count", conf.getInt("hbase.regionserver.handler.count", 25));
        this.rpcServer = new RpcServer(this, name, this.getServices(), initialIsa, conf, new FifoRpcScheduler(conf, numHandlers));
        this.isa = this.rpcServer.getListenerAddress();
        this.serverName = ServerName.valueOf((String)hostname, (int)this.isa.getPort(), (long)System.currentTimeMillis());
        this.rsFatals = new MemoryBoundedLogMessageBuffer(conf.getLong("hbase.master.buffer.for.rs.fatals", 0x100000L));
        ZKUtil.loginClient((Configuration)this.conf, (String)"hbase.zookeeper.client.keytab.file", (String)"hbase.zookeeper.client.kerberos.principal", (String)this.isa.getHostName());
        UserProvider provider = UserProvider.instantiate((Configuration)conf);
        provider.login("hbase.master.keytab.file", "hbase.master.kerberos.principal", this.isa.getHostName());
        LOG.info((Object)("hbase.rootdir=" + FSUtils.getRootDir(this.conf) + ", hbase.cluster.distributed=" + this.conf.getBoolean("hbase.cluster.distributed", false)));
        this.setName("master:" + this.serverName.toShortString());
        Replication.decorateMasterConfiguration(this.conf);
        if (this.conf.get("mapred.task.id") == null) {
            this.conf.set("mapred.task.id", "hb_m_" + this.serverName.toString());
        }
        this.zooKeeper = new ZooKeeperWatcher(conf, "master:" + this.isa.getPort(), (Abortable)this, true);
        this.rpcServer.startThreads();
        this.pauseMonitor = new JvmPauseMonitor(conf);
        this.pauseMonitor.start();
        this.msgInterval = conf.getInt("hbase.regionserver.msginterval", 3000);
        this.masterCheckCompression = conf.getBoolean("hbase.master.check.compression", true);
        this.masterCheckEncryption = conf.getBoolean("hbase.master.check.encryption", true);
        this.metricsMaster = new MetricsMaster(new MetricsMasterWrapperImpl(this));
        this.preLoadTableDescriptors = conf.getBoolean("hbase.master.preload.tabledescriptors", true);
        int sleepTime = this.conf.getInt("hbase.node.health.script.frequency", 10000);
        if (this.isHealthCheckerConfigured()) {
            this.healthCheckChore = new HealthCheckChore(sleepTime, (Stoppable)this, this.getConfiguration());
        }
        boolean shouldPublish = conf.getBoolean("hbase.status.published", false);
        Class publisherClass = conf.getClass("hbase.status.publisher.class", ClusterStatusPublisher.DEFAULT_STATUS_PUBLISHER_CLASS, ClusterStatusPublisher.Publisher.class);
        if (shouldPublish) {
            if (publisherClass == null) {
                LOG.warn((Object)("hbase.status.published is true, but " + ClusterStatusPublisher.DEFAULT_STATUS_PUBLISHER_CLASS + " is not set - not publishing status"));
            } else {
                this.clusterStatusPublisherChore = new ClusterStatusPublisher(this, conf, publisherClass);
                Threads.setDaemonThreadRunning((Thread)this.clusterStatusPublisherChore.getThread());
            }
        }
    }

    private List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(3);
        bssi.add(new RpcServer.BlockingServiceAndInterface(MasterProtos.MasterService.newReflectiveBlockingService((MasterProtos.MasterService.BlockingInterface)this), MasterProtos.MasterService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(RegionServerStatusProtos.RegionServerStatusService.newReflectiveBlockingService((RegionServerStatusProtos.RegionServerStatusService.BlockingInterface)this), RegionServerStatusProtos.RegionServerStatusService.BlockingInterface.class));
        return bssi;
    }

    private static void stallIfBackupMaster(Configuration c, ActiveMasterManager amm) throws InterruptedException {
        if (!c.getBoolean("hbase.master.backup", false)) {
            return;
        }
        LOG.debug((Object)"HMaster started in backup mode.  Stalling until master znode is written.");
        while (!amm.isActiveMaster()) {
            LOG.debug((Object)"Waiting for master address ZNode to be written (Also watching cluster state node)");
            Thread.sleep(c.getInt("zookeeper.session.timeout", 180000));
        }
    }

    MetricsMaster getMetrics() {
        return this.metricsMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MonitoredTask startupStatus = TaskMonitor.get().createStatus("Master startup");
        startupStatus.setDescription("Master startup");
        this.masterStartTime = System.currentTimeMillis();
        try {
            this.masterAddressTracker = new MasterAddressTracker(this.getZooKeeperWatcher(), (Abortable)this);
            this.masterAddressTracker.start();
            int port = this.conf.getInt("hbase.master.info.port", 60010);
            if (port >= 0) {
                String a = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
                this.infoServer = new InfoServer(MASTER, a, port, false, this.conf);
                this.infoServer.addServlet("status", "/master-status", MasterStatusServlet.class);
                this.infoServer.addServlet("dump", "/dump", MasterDumpServlet.class);
                this.infoServer.setAttribute(MASTER, this);
                this.infoServer.start();
            }
            this.registeredZKListenersBeforeRecovery = this.zooKeeper.getListeners();
            this.becomeActiveMaster(startupStatus);
            if (!this.stopped) {
                this.finishInitialization(startupStatus, false);
                this.loop();
            }
        }
        catch (Throwable t) {
            if (t instanceof NoClassDefFoundError && t.getMessage().contains("org/apache/hadoop/hdfs/protocol/FSConstants$SafeModeAction")) {
                this.abort("HBase is having a problem with its Hadoop jars.  You may need to recompile HBase against Hadoop version " + VersionInfo.getVersion() + " or change your hadoop jars to start properly", t);
            } else {
                this.abort("Unhandled exception. Starting shutdown.", t);
            }
        }
        finally {
            startupStatus.cleanup();
            this.stopChores();
            if (!this.abort && this.serverManager != null && this.serverManager.isClusterShutdown()) {
                this.serverManager.letRegionServersShutdown();
            }
            this.stopServiceThreads();
            if (this.activeMasterManager != null) {
                this.activeMasterManager.stop();
            }
            if (this.catalogTracker != null) {
                this.catalogTracker.stop();
            }
            if (this.serverManager != null) {
                this.serverManager.stop();
            }
            if (this.assignmentManager != null) {
                this.assignmentManager.stop();
            }
            if (this.fileSystemManager != null) {
                this.fileSystemManager.stop();
            }
            if (this.mpmHost != null) {
                this.mpmHost.stop("server shutting down.");
            }
            this.zooKeeper.close();
        }
        LOG.info((Object)"HMaster main thread exiting");
    }

    protected void startCatalogJanitorChore() {
        Threads.setDaemonThreadRunning((Thread)this.catalogJanitorChore.getThread());
    }

    private boolean becomeActiveMaster(MonitoredTask startupStatus) throws InterruptedException {
        this.activeMasterManager = new ActiveMasterManager(this.zooKeeper, this.serverName, this);
        this.zooKeeper.registerListener((ZooKeeperListener)this.activeMasterManager);
        HMaster.stallIfBackupMaster(this.conf, this.activeMasterManager);
        this.clusterStatusTracker = new ClusterStatusTracker(this.getZooKeeper(), (Abortable)this);
        this.clusterStatusTracker.start();
        return this.activeMasterManager.blockUntilBecomingActiveMaster(startupStatus);
    }

    void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException {
        this.catalogTracker = this.createCatalogTracker(this.zooKeeper, this.conf, (Abortable)this);
        this.catalogTracker.start();
        this.balancer = LoadBalancerFactory.getLoadBalancer(this.conf);
        this.loadBalancerTracker = new LoadBalancerTracker(this.zooKeeper, (Abortable)this);
        this.loadBalancerTracker.start();
        this.assignmentManager = new AssignmentManager(this, this.serverManager, this.catalogTracker, this.balancer, this.executorService, this.metricsMaster, this.tableLockManager);
        this.zooKeeper.registerListenerFirst((ZooKeeperListener)this.assignmentManager);
        this.regionServerTracker = new RegionServerTracker(this.zooKeeper, (Abortable)this, this.serverManager);
        this.regionServerTracker.start();
        this.drainingServerTracker = new DrainingServerTracker(this.zooKeeper, (Abortable)this, this.serverManager);
        this.drainingServerTracker.start();
        boolean wasUp = this.clusterStatusTracker.isClusterUp();
        if (!wasUp) {
            this.clusterStatusTracker.setClusterUp();
        }
        LOG.info((Object)("Server active/primary master=" + this.serverName + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId()) + ", setting cluster-up flag (Was=" + wasUp + ")"));
        this.snapshotManager = new SnapshotManager();
        this.mpmHost = new MasterProcedureManagerHost();
        this.mpmHost.register(this.snapshotManager);
        this.mpmHost.loadProcedures(this.conf);
        this.mpmHost.initialize(this, this.metricsMaster);
    }

    CatalogTracker createCatalogTracker(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) throws IOException {
        return new CatalogTracker(zk, conf, abortable);
    }

    private void loop() {
        long lastMsgTs = 0L;
        long now = 0L;
        while (!this.stopped) {
            now = System.currentTimeMillis();
            if (now - lastMsgTs >= (long)this.msgInterval) {
                this.doMetrics();
                lastMsgTs = System.currentTimeMillis();
            }
            this.stopSleeper.sleep();
        }
    }

    private void doMetrics() {
        try {
            this.assignmentManager.updateRegionsInTransitionMetrics();
        }
        catch (Throwable e) {
            LOG.error((Object)("Couldn't update metrics: " + e.getMessage()));
        }
    }

    private void finishInitialization(MonitoredTask status, boolean masterRecovery) throws IOException, InterruptedException, KeeperException {
        this.isActiveMaster = true;
        Thread zombieDetector = new Thread((Runnable)((Object)new InitializationMonitor(this)));
        zombieDetector.start();
        status.setStatus("Initializing Master file system");
        this.masterActiveTime = System.currentTimeMillis();
        this.fileSystemManager = new MasterFileSystem(this, this, masterRecovery);
        this.tableDescriptors = new FSTableDescriptors(this.conf, this.fileSystemManager.getFileSystem(), this.fileSystemManager.getRootDir());
        this.tableDescriptors.setCacheOn();
        if (this.preLoadTableDescriptors) {
            status.setStatus("Pre-loading table descriptors");
            this.tableDescriptors.getAll();
        }
        status.setStatus("Publishing Cluster ID in ZooKeeper");
        ZKClusterId.setClusterId((ZooKeeperWatcher)this.zooKeeper, (ClusterId)this.fileSystemManager.getClusterId());
        if (!masterRecovery) {
            this.executorService = new org.apache.hadoop.hbase.executor.ExecutorService(this.getServerName().toShortString());
            this.serverManager = this.createServerManager(this, this);
        }
        this.tableLockManager = TableLockManager.createTableLockManager(this.conf, this.zooKeeper, this.serverName);
        if (!masterRecovery) {
            this.tableLockManager.reapWriteLocks();
        }
        status.setStatus("Initializing ZK system trackers");
        this.initializeZKBasedSystemTrackers();
        if (!masterRecovery) {
            status.setStatus("Initializing master coprocessors");
            this.cpHost = new MasterCoprocessorHost(this, this.conf);
            this.spanReceiverHost = SpanReceiverHost.getInstance(this.getConfiguration());
            status.setStatus("Initializing master service threads");
            this.startServiceThreads();
        }
        this.serverManager.waitForRegionServers(status);
        for (ServerName sn : this.regionServerTracker.getOnlineServers()) {
            if (this.serverManager.isServerOnline(sn) || !this.serverManager.checkAndRecordNewServer(sn, ServerLoad.EMPTY_SERVERLOAD)) continue;
            LOG.info((Object)("Registered server found up in zk but who has not yet reported in: " + sn));
        }
        if (!masterRecovery) {
            this.assignmentManager.startTimeOutMonitor();
        }
        Set<ServerName> previouslyFailedServers = this.fileSystemManager.getFailedServersFromLogFolders();
        this.fileSystemManager.removeStaleRecoveringRegionsFromZK(previouslyFailedServers);
        ServerName oldMetaServerLocation = this.catalogTracker.getMetaLocation();
        if (oldMetaServerLocation != null && previouslyFailedServers.contains(oldMetaServerLocation)) {
            this.splitMetaLogBeforeAssignment(oldMetaServerLocation);
        }
        Set<ServerName> previouslyFailedMetaRSs = this.getPreviouselyFailedMetaServersFromZK();
        previouslyFailedMetaRSs.addAll(previouslyFailedServers);
        this.initializationBeforeMetaAssignment = true;
        this.balancer.setClusterStatus(this.getClusterStatus());
        this.balancer.setMasterServices(this);
        this.balancer.initialize();
        status.setStatus("Assigning Meta Region");
        this.assignMeta(status, previouslyFailedMetaRSs);
        if (this.stopped) {
            return;
        }
        status.setStatus("Submitting log splitting work for previously failed region servers");
        for (ServerName tmpServer : previouslyFailedServers) {
            this.serverManager.processDeadServer(tmpServer, true);
        }
        if (this.conf.getBoolean("hbase.MetaMigrationConvertingToPB", true)) {
            MetaMigrationConvertingToPB.updateMetaIfNecessary(this);
        }
        status.setStatus("Starting assignment manager");
        this.assignmentManager.joinCluster();
        this.balancer.setClusterStatus(this.getClusterStatus());
        if (!masterRecovery) {
            status.setStatus("Starting balancer and catalog janitor");
            this.clusterStatusChore = HMaster.getAndStartClusterStatusChore(this);
            this.balancerChore = HMaster.getAndStartBalancerChore(this);
            this.catalogJanitorChore = new CatalogJanitor(this, this);
            this.startCatalogJanitorChore();
        }
        status.setStatus("Starting namespace manager");
        this.initNamespace();
        if (this.cpHost != null) {
            try {
                this.cpHost.preMasterInitialization();
            }
            catch (IOException e) {
                LOG.error((Object)"Coprocessor preMasterInitialization() hook failed", (Throwable)e);
            }
        }
        status.markComplete("Initialization successful");
        LOG.info((Object)"Master has completed initialization");
        this.initialized = true;
        this.serverManager.clearDeadServersWithSameHostNameAndPortOfOnlineServer();
        status.setStatus("Checking ZNode ACLs");
        this.zooKeeper.checkAndSetZNodeAcls();
        if (!masterRecovery && this.cpHost != null) {
            try {
                this.cpHost.postStartMaster();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Coprocessor postStartMaster() hook failed", (Throwable)ioe);
            }
        }
        zombieDetector.interrupt();
    }

    ServerManager createServerManager(Server master, MasterServices services) throws IOException {
        return new ServerManager(master, services);
    }

    void assignMeta(MonitoredTask status, Set<ServerName> previouslyFailedMetaRSs) throws InterruptedException, IOException, KeeperException {
        int assigned = 0;
        long timeout = this.conf.getLong("hbase.catalog.verification.timeout", 1000L);
        status.setStatus("Assigning hbase:meta region");
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        RegionState regionState = this.catalogTracker.getMetaRegionState();
        ServerName currentMetaServer = regionState.getServerName();
        if (!ConfigUtil.useZKForAssignment(this.conf)) {
            regionStates.createRegionState(HRegionInfo.FIRST_META_REGIONINFO, regionState.getState(), currentMetaServer);
        } else {
            regionStates.createRegionState(HRegionInfo.FIRST_META_REGIONINFO);
        }
        boolean rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(HRegionInfo.FIRST_META_REGIONINFO);
        boolean metaRegionLocation = this.catalogTracker.verifyMetaRegionLocation(timeout);
        if (!metaRegionLocation || !regionState.isOpened()) {
            ++assigned;
            if (!ConfigUtil.useZKForAssignment(this.conf)) {
                this.assignMetaZkLess(regionStates, regionState, timeout, previouslyFailedMetaRSs);
            } else if (!rit) {
                if (currentMetaServer != null) {
                    if (this.serverManager.isServerOnline(currentMetaServer)) {
                        LOG.info((Object)("Forcing expire of " + currentMetaServer));
                        this.serverManager.expireServer(currentMetaServer);
                    }
                    this.splitMetaLogBeforeAssignment(currentMetaServer);
                    previouslyFailedMetaRSs.add(currentMetaServer);
                }
                this.assignmentManager.assignMeta();
            }
        } else {
            regionStates.updateRegionState(HRegionInfo.FIRST_META_REGIONINFO, RegionState.State.OPEN, currentMetaServer);
            this.assignmentManager.regionOnline(HRegionInfo.FIRST_META_REGIONINFO, currentMetaServer);
        }
        this.enableMeta(TableName.META_TABLE_NAME);
        if (ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY == this.getMasterFileSystem().getLogRecoveryMode() && !previouslyFailedMetaRSs.isEmpty()) {
            status.setStatus("replaying log for Meta Region");
            this.fileSystemManager.splitMetaLog(previouslyFailedMetaRSs);
        }
        this.enableServerShutdownHandler(assigned != 0);
        LOG.info((Object)("hbase:meta assigned=" + assigned + ", rit=" + rit + ", location=" + this.catalogTracker.getMetaLocation()));
        status.setStatus("META assigned.");
    }

    private void assignMetaZkLess(RegionStates regionStates, RegionState regionState, long timeout, Set<ServerName> previouslyFailedRs) throws IOException, KeeperException {
        ServerName currentServer = regionState.getServerName();
        if (this.serverManager.isServerOnline(currentServer)) {
            LOG.info((Object)("Meta was in transition on " + currentServer));
            this.assignmentManager.processRegionInTransitionZkLess();
        } else {
            if (currentServer != null) {
                this.splitMetaLogBeforeAssignment(currentServer);
                regionStates.logSplit(HRegionInfo.FIRST_META_REGIONINFO);
                previouslyFailedRs.add(currentServer);
            }
            LOG.info((Object)("Re-assigning hbase:meta, it was on " + currentServer));
            regionStates.updateRegionState(HRegionInfo.FIRST_META_REGIONINFO, RegionState.State.OFFLINE);
            this.assignmentManager.assignMeta();
        }
    }

    void initNamespace() throws IOException {
        this.tableNamespaceManager = new TableNamespaceManager(this);
        this.tableNamespaceManager.start();
    }

    private void splitMetaLogBeforeAssignment(ServerName currentMetaServer) throws IOException {
        if (ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY == this.getMasterFileSystem().getLogRecoveryMode()) {
            HashSet<HRegionInfo> regions = new HashSet<HRegionInfo>();
            regions.add(HRegionInfo.FIRST_META_REGIONINFO);
            this.fileSystemManager.prepareLogReplay(currentMetaServer, regions);
        } else {
            this.fileSystemManager.splitMetaLog(currentMetaServer);
        }
    }

    private void enableServerShutdownHandler(boolean waitForMeta) throws IOException, InterruptedException {
        if (!this.serverShutdownHandlerEnabled) {
            this.serverShutdownHandlerEnabled = true;
            this.serverManager.processQueuedDeadServers();
        }
        if (waitForMeta) {
            this.catalogTracker.waitForMeta();
            this.assignmentManager.waitForAssignment(HRegionInfo.FIRST_META_REGIONINFO);
        }
    }

    private void enableMeta(TableName metaTableName) {
        if (!this.assignmentManager.getZKTable().isEnabledTable(metaTableName)) {
            this.assignmentManager.setEnabledTable(metaTableName);
        }
    }

    private Set<ServerName> getPreviouselyFailedMetaServersFromZK() throws KeeperException {
        HashSet<ServerName> result = new HashSet<ServerName>();
        String metaRecoveringZNode = ZKUtil.joinZNode((String)this.zooKeeper.recoveringRegionsZNode, (String)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        List regionFailedServers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zooKeeper, (String)metaRecoveringZNode);
        if (regionFailedServers == null) {
            return result;
        }
        for (String failedServer : regionFailedServers) {
            ServerName server = ServerName.parseServerName((String)failedServer);
            result.add(server);
        }
        return result;
    }

    @Override
    public TableDescriptors getTableDescriptors() {
        return this.tableDescriptors;
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public org.apache.hadoop.hbase.executor.ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.zooKeeper;
    }

    public ActiveMasterManager getActiveMasterManager() {
        return this.activeMasterManager;
    }

    public MasterAddressTracker getMasterAddressTracker() {
        return this.masterAddressTracker;
    }

    void startServiceThreads() throws IOException {
        this.executorService.startExecutorService(ExecutorType.MASTER_OPEN_REGION, this.conf.getInt("hbase.master.executor.openregion.threads", 5));
        this.executorService.startExecutorService(ExecutorType.MASTER_CLOSE_REGION, this.conf.getInt("hbase.master.executor.closeregion.threads", 5));
        this.executorService.startExecutorService(ExecutorType.MASTER_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.executorService.startExecutorService(ExecutorType.MASTER_META_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.executorService.startExecutorService(ExecutorType.M_LOG_REPLAY_OPS, this.conf.getInt("hbase.master.executor.logreplayops.threads", 10));
        this.executorService.startExecutorService(ExecutorType.MASTER_TABLE_OPERATIONS, 1);
        String n = Thread.currentThread().getName();
        int cleanerInterval = this.conf.getInt("hbase.master.cleaner.interval", 60000);
        this.logCleaner = new LogCleaner(cleanerInterval, (Stoppable)this, this.conf, this.getMasterFileSystem().getFileSystem(), this.getMasterFileSystem().getOldLogDir());
        Threads.setDaemonThreadRunning((Thread)this.logCleaner.getThread(), (String)(n + ".oldLogCleaner"));
        Path archiveDir = HFileArchiveUtil.getArchivePath(this.conf);
        this.hfileCleaner = new HFileCleaner(cleanerInterval, (Stoppable)this, this.conf, this.getMasterFileSystem().getFileSystem(), archiveDir);
        Threads.setDaemonThreadRunning((Thread)this.hfileCleaner.getThread(), (String)(n + ".archivedHFileCleaner"));
        if (this.healthCheckChore != null) {
            Threads.setDaemonThreadRunning((Thread)this.healthCheckChore.getThread(), (String)(n + ".healthChecker"));
        }
        this.rpcServer.openServer();
        this.rpcServerOpen = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Started service threads");
        }
    }

    boolean isRpcServerOpen() {
        return this.rpcServerOpen;
    }

    private void stopServiceThreads() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping service threads");
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        this.rpcServerOpen = false;
        if (this.logCleaner != null) {
            this.logCleaner.interrupt();
        }
        if (this.hfileCleaner != null) {
            this.hfileCleaner.interrupt();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.healthCheckChore != null) {
            this.healthCheckChore.interrupt();
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
    }

    private static Thread getAndStartClusterStatusChore(HMaster master) {
        if (master == null || master.balancer == null) {
            return null;
        }
        ClusterStatusChore chore = new ClusterStatusChore(master, master.balancer);
        return Threads.setDaemonThreadRunning((Thread)chore.getThread());
    }

    private static Thread getAndStartBalancerChore(HMaster master) {
        BalancerChore chore = new BalancerChore(master);
        return Threads.setDaemonThreadRunning((Thread)chore.getThread());
    }

    private void stopChores() {
        if (this.balancerChore != null) {
            this.balancerChore.interrupt();
        }
        if (this.clusterStatusChore != null) {
            this.clusterStatusChore.interrupt();
        }
        if (this.catalogJanitorChore != null) {
            this.catalogJanitorChore.interrupt();
        }
        if (this.clusterStatusPublisherChore != null) {
            this.clusterStatusPublisherChore.interrupt();
        }
    }

    public RegionServerStatusProtos.RegionServerStartupResponse regionServerStartup(RpcController controller, RegionServerStatusProtos.RegionServerStartupRequest request) throws ServiceException {
        try {
            InetAddress ia = this.getRemoteInetAddress(request.getPort(), request.getServerStartCode());
            ServerName rs = this.serverManager.regionServerStartup(ia, request.getPort(), request.getServerStartCode(), request.getServerCurrentTime());
            RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.createConfigurationSubset();
            HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName("hbase.regionserver.hostname.seen.by.master").setValue(rs.getHostname());
            resp.addMapEntries(entry.build());
            return resp.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    InetAddress getRemoteInetAddress(int port, long serverStartCode) throws UnknownHostException {
        return RpcServer.getRemoteIp();
    }

    protected RegionServerStatusProtos.RegionServerStartupResponse.Builder createConfigurationSubset() {
        RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.addConfig(RegionServerStatusProtos.RegionServerStartupResponse.newBuilder(), "hbase.rootdir");
        resp = this.addConfig(resp, "fs.default.name");
        return this.addConfig(resp, "hbase.master.info.port");
    }

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder addConfig(RegionServerStatusProtos.RegionServerStartupResponse.Builder resp, String key) {
        HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName(key).setValue(this.conf.get(key));
        resp.addMapEntries(entry.build());
        return resp;
    }

    public RegionServerStatusProtos.GetLastFlushedSequenceIdResponse getLastFlushedSequenceId(RpcController controller, RegionServerStatusProtos.GetLastFlushedSequenceIdRequest request) throws ServiceException {
        byte[] regionName = request.getRegionName().toByteArray();
        long seqId = this.serverManager.getLastFlushedSequenceId(regionName);
        return ResponseConverter.buildGetLastFlushedSequenceIdResponse((long)seqId);
    }

    public RegionServerStatusProtos.RegionServerReportResponse regionServerReport(RpcController controller, RegionServerStatusProtos.RegionServerReportRequest request) throws ServiceException {
        try {
            ClusterStatusProtos.ServerLoad sl = request.getLoad();
            ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServer());
            ServerLoad oldLoad = this.serverManager.getLoad(serverName);
            this.serverManager.regionServerReport(serverName, new ServerLoad(sl));
            if (sl != null && this.metricsMaster != null) {
                this.metricsMaster.incrementRequests(sl.getTotalNumberOfRequests() - (oldLoad != null ? oldLoad.getTotalNumberOfRequests() : 0));
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return RegionServerStatusProtos.RegionServerReportResponse.newBuilder().build();
    }

    public RegionServerStatusProtos.ReportRSFatalErrorResponse reportRSFatalError(RpcController controller, RegionServerStatusProtos.ReportRSFatalErrorRequest request) throws ServiceException {
        String errorText = request.getErrorMessage();
        ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServer());
        String msg = "Region server " + sn + " reported a fatal error:\n" + errorText;
        LOG.error((Object)msg);
        this.rsFatals.add(msg);
        return RegionServerStatusProtos.ReportRSFatalErrorResponse.newBuilder().build();
    }

    public boolean isMasterRunning() {
        return !this.isStopped();
    }

    public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController c, MasterProtos.IsMasterRunningRequest req) throws ServiceException {
        return MasterProtos.IsMasterRunningResponse.newBuilder().setIsMasterRunning(this.isMasterRunning()).build();
    }

    public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController c, MasterProtos.RunCatalogScanRequest req) throws ServiceException {
        try {
            return ResponseConverter.buildRunCatalogScanResponse((int)this.catalogJanitorChore.scan());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController c, MasterProtos.EnableCatalogJanitorRequest req) throws ServiceException {
        return MasterProtos.EnableCatalogJanitorResponse.newBuilder().setPrevValue(this.catalogJanitorChore.setEnabled(req.getEnable())).build();
    }

    public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController c, MasterProtos.IsCatalogJanitorEnabledRequest req) throws ServiceException {
        boolean isEnabled = this.catalogJanitorChore != null ? this.catalogJanitorChore.getEnabled() : false;
        return MasterProtos.IsCatalogJanitorEnabledResponse.newBuilder().setValue(isEnabled).build();
    }

    private int getBalancerCutoffTime() {
        int balancerPeriod;
        int balancerCutoffTime = this.getConfiguration().getInt("hbase.balancer.max.balancing", -1);
        if (balancerCutoffTime == -1 && (balancerCutoffTime = (balancerPeriod = this.getConfiguration().getInt("hbase.balancer.period", 300000))) <= 0) {
            balancerCutoffTime = balancerPeriod;
        }
        return balancerCutoffTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean balance() throws HBaseIOException {
        boolean balancerRan;
        if (!this.initialized) {
            LOG.debug((Object)"Master has not been initialized, don't run balancer.");
            return false;
        }
        int maximumBalanceTime = this.getBalancerCutoffTime();
        LoadBalancer loadBalancer = this.balancer;
        synchronized (loadBalancer) {
            if (!this.loadBalancerTracker.isBalancerOn()) {
                return false;
            }
            if (this.assignmentManager.getRegionStates().isRegionsInTransition()) {
                Map<String, RegionState> regionsInTransition = this.assignmentManager.getRegionStates().getRegionsInTransition();
                LOG.debug((Object)("Not running balancer because " + regionsInTransition.size() + " region(s) in transition: " + StringUtils.abbreviate((String)regionsInTransition.toString(), (int)256)));
                return false;
            }
            if (this.serverManager.areDeadServersInProgress()) {
                LOG.debug((Object)("Not running balancer because processing dead regionserver(s): " + this.serverManager.getDeadServers()));
                return false;
            }
            if (this.cpHost != null) {
                try {
                    if (this.cpHost.preBalance()) {
                        LOG.debug((Object)"Coprocessor bypassing balancer request");
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor preBalance()", (Throwable)ioe);
                    return false;
                }
            }
            Map<TableName, Map<ServerName, List<HRegionInfo>>> assignmentsByTable = this.assignmentManager.getRegionStates().getAssignmentsByTable();
            ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
            this.balancer.setClusterStatus(this.getClusterStatus());
            for (Map<ServerName, List<HRegionInfo>> assignments : assignmentsByTable.values()) {
                List<RegionPlan> partialPlans = this.balancer.balanceCluster(assignments);
                if (partialPlans == null) continue;
                plans.addAll(partialPlans);
            }
            long cutoffTime = System.currentTimeMillis() + (long)maximumBalanceTime;
            int rpCount = 0;
            long totalRegPlanExecTime = 0L;
            boolean bl = balancerRan = plans != null;
            if (plans != null && !plans.isEmpty()) {
                for (RegionPlan plan : plans) {
                    LOG.info((Object)("balance " + plan));
                    long balStartTime = System.currentTimeMillis();
                    this.assignmentManager.balance(plan);
                    if (++rpCount >= plans.size() || System.currentTimeMillis() + (totalRegPlanExecTime += System.currentTimeMillis() - balStartTime) / (long)rpCount <= cutoffTime) continue;
                    LOG.debug((Object)("No more balancing till next balance run; maximumBalanceTime=" + maximumBalanceTime));
                    break;
                }
            }
            if (this.cpHost != null) {
                try {
                    this.cpHost.postBalance(rpCount < plans.size() ? plans.subList(0, rpCount) : plans);
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor postBalance()", (Throwable)ioe);
                }
            }
        }
        return balancerRan;
    }

    public MasterProtos.BalanceResponse balance(RpcController c, MasterProtos.BalanceRequest request) throws ServiceException {
        try {
            return MasterProtos.BalanceResponse.newBuilder().setBalancerRan(this.balance()).build();
        }
        catch (HBaseIOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean switchBalancer(boolean b, BalanceSwitchMode mode) throws IOException {
        boolean oldValue = this.loadBalancerTracker.isBalancerOn();
        boolean newValue = b;
        try {
            block10: {
                if (this.cpHost != null) {
                    newValue = this.cpHost.preBalanceSwitch(newValue);
                }
                try {
                    if (mode == BalanceSwitchMode.SYNC) {
                        LoadBalancer loadBalancer = this.balancer;
                        synchronized (loadBalancer) {
                            this.loadBalancerTracker.setBalancerOn(newValue);
                            break block10;
                        }
                    }
                    this.loadBalancerTracker.setBalancerOn(newValue);
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
            }
            LOG.info((Object)(this.getClientIdAuditPrefix() + " set balanceSwitch=" + newValue));
            if (this.cpHost != null) {
                this.cpHost.postBalanceSwitch(oldValue, newValue);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Error flipping balance switch", (Throwable)ioe);
        }
        return oldValue;
    }

    String getClientIdAuditPrefix() {
        return "Client=" + RpcServer.getRequestUserName() + "/" + RpcServer.getRemoteAddress();
    }

    public boolean synchronousBalanceSwitch(boolean b) throws IOException {
        return this.switchBalancer(b, BalanceSwitchMode.SYNC);
    }

    public boolean balanceSwitch(boolean b) throws IOException {
        return this.switchBalancer(b, BalanceSwitchMode.ASYNC);
    }

    public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController controller, MasterProtos.SetBalancerRunningRequest req) throws ServiceException {
        try {
            boolean prevValue = req.getSynchronous() ? this.synchronousBalanceSwitch(req.getOn()) : this.balanceSwitch(req.getOn());
            return MasterProtos.SetBalancerRunningResponse.newBuilder().setPrevBalanceValue(prevValue).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public void setCatalogJanitorEnabled(boolean b) {
        this.catalogJanitorChore.setEnabled(b);
    }

    public MasterProtos.DispatchMergingRegionsResponse dispatchMergingRegions(RpcController controller, MasterProtos.DispatchMergingRegionsRequest request) throws ServiceException {
        HRegionInfo regionInfoB;
        byte[] encodedNameOfRegionA = request.getRegionA().getValue().toByteArray();
        byte[] encodedNameOfRegionB = request.getRegionB().getValue().toByteArray();
        boolean forcible = request.getForcible();
        if (request.getRegionA().getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME || request.getRegionB().getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
            LOG.warn((Object)("mergeRegions specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: region_a=" + request.getRegionA().getType() + ", region_b=" + request.getRegionB().getType()));
        }
        RegionState regionStateA = this.assignmentManager.getRegionStates().getRegionState(Bytes.toString((byte[])encodedNameOfRegionA));
        RegionState regionStateB = this.assignmentManager.getRegionStates().getRegionState(Bytes.toString((byte[])encodedNameOfRegionB));
        if (regionStateA == null || regionStateB == null) {
            throw new ServiceException((Throwable)new UnknownRegionException(Bytes.toStringBinary((byte[])(regionStateA == null ? encodedNameOfRegionA : encodedNameOfRegionB))));
        }
        if (!regionStateA.isOpened() || !regionStateB.isOpened()) {
            throw new ServiceException((Throwable)new MergeRegionException("Unable to merge regions not online " + regionStateA + ", " + regionStateB));
        }
        HRegionInfo regionInfoA = regionStateA.getRegion();
        if (regionInfoA.compareTo(regionInfoB = regionStateB.getRegion()) == 0) {
            throw new ServiceException((Throwable)new MergeRegionException("Unable to merge a region to itself " + regionInfoA + ", " + regionInfoB));
        }
        if (!forcible && !HRegionInfo.areAdjacent((HRegionInfo)regionInfoA, (HRegionInfo)regionInfoB)) {
            throw new ServiceException((Throwable)new MergeRegionException("Unable to merge not adjacent regions " + regionInfoA.getRegionNameAsString() + ", " + regionInfoB.getRegionNameAsString() + " where forcible = " + forcible));
        }
        try {
            this.dispatchMergingRegions(regionInfoA, regionInfoB, forcible);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.DispatchMergingRegionsResponse.newBuilder().build();
    }

    @Override
    public void dispatchMergingRegions(HRegionInfo region_a, HRegionInfo region_b, boolean forcible) throws IOException {
        this.checkInitialized();
        this.executorService.submit(new DispatchMergingRegionHandler(this, this.catalogJanitorChore, region_a, region_b, forcible));
    }

    public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest req) throws ServiceException {
        byte[] encodedRegionName = req.getRegion().getValue().toByteArray();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
        byte[] destServerName = req.hasDestServerName() ? Bytes.toBytes((String)ProtobufUtil.toServerName((HBaseProtos.ServerName)req.getDestServerName()).getServerName()) : null;
        MasterProtos.MoveRegionResponse mrr = MasterProtos.MoveRegionResponse.newBuilder().build();
        if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
            LOG.warn((Object)("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: " + type));
        }
        try {
            this.move(encodedRegionName, destServerName);
        }
        catch (HBaseIOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return mrr;
    }

    void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException {
        ServerName dest;
        RegionState regionState = this.assignmentManager.getRegionStates().getRegionState(Bytes.toString((byte[])encodedRegionName));
        if (regionState == null) {
            throw new UnknownRegionException(Bytes.toStringBinary((byte[])encodedRegionName));
        }
        HRegionInfo hri = regionState.getRegion();
        if (destServerName == null || destServerName.length == 0) {
            LOG.info((Object)"Passed destination servername is null/empty so choosing a server at random");
            List<ServerName> destServers = this.serverManager.createDestinationServersList(regionState.getServerName());
            dest = this.balancer.randomAssignment(hri, destServers);
        } else {
            dest = ServerName.valueOf((String)Bytes.toString((byte[])destServerName));
            if (dest.equals((Object)regionState.getServerName())) {
                LOG.debug((Object)("Skipping move of region " + hri.getRegionNameAsString() + " because region already assigned to the same server " + dest + "."));
                return;
            }
        }
        RegionPlan rp = new RegionPlan(hri, regionState.getServerName(), dest);
        try {
            this.checkInitialized();
            if (this.cpHost != null && this.cpHost.preMove(hri, rp.getSource(), rp.getDestination())) {
                return;
            }
            LOG.info((Object)(this.getClientIdAuditPrefix() + " move " + rp + ", running balancer"));
            this.assignmentManager.balance(rp);
            if (this.cpHost != null) {
                this.cpHost.postMove(hri, rp.getSource(), rp.getDestination());
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof HBaseIOException) {
                throw (HBaseIOException)((Object)ioe);
            }
            throw new HBaseIOException((Throwable)ioe);
        }
    }

    @Override
    public void createTable(HTableDescriptor hTableDescriptor, byte[][] splitKeys) throws IOException {
        if (!this.isMasterRunning()) {
            throw new MasterNotRunningException();
        }
        String namespace = hTableDescriptor.getTableName().getNamespaceAsString();
        this.getNamespaceDescriptor(namespace);
        HRegionInfo[] newRegions = this.getHRegionInfos(hTableDescriptor, splitKeys);
        this.checkInitialized();
        this.sanityCheckTableDescriptor(hTableDescriptor);
        if (this.cpHost != null) {
            this.cpHost.preCreateTable(hTableDescriptor, newRegions);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " create " + hTableDescriptor));
        this.executorService.submit(new CreateTableHandler(this, this.fileSystemManager, hTableDescriptor, this.conf, newRegions, this).prepare());
        if (this.cpHost != null) {
            this.cpHost.postCreateTable(hTableDescriptor, newRegions);
        }
    }

    private void sanityCheckTableDescriptor(HTableDescriptor htd) throws IOException {
        String message;
        String tableVal;
        String CONF_KEY = "hbase.table.sanity.checks";
        boolean logWarn = false;
        if (!this.conf.getBoolean("hbase.table.sanity.checks", true)) {
            logWarn = true;
        }
        if ((tableVal = htd.getConfigurationValue("hbase.table.sanity.checks")) != null && !Boolean.valueOf(tableVal).booleanValue()) {
            logWarn = true;
        }
        long maxFileSizeLowerLimit = 0x200000L;
        long maxFileSize = htd.getMaxFileSize();
        if (maxFileSize < 0L) {
            maxFileSize = this.conf.getLong("hbase.hregion.max.filesize", maxFileSizeLowerLimit);
        }
        if (maxFileSize < this.conf.getLong("hbase.hregion.max.filesize.limit", maxFileSizeLowerLimit)) {
            String message2 = "MAX_FILESIZE for table descriptor or \"hbase.hregion.max.filesize\" (" + maxFileSize + ") is too small, which might cause over splitting into unmanageable " + "number of regions.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message2, null);
        }
        long flushSizeLowerLimit = 0x100000L;
        long flushSize = htd.getMemStoreFlushSize();
        if (flushSize < 0L) {
            flushSize = this.conf.getLong("hbase.hregion.memstore.flush.size", flushSizeLowerLimit);
        }
        if (flushSize < this.conf.getLong("hbase.hregion.memstore.flush.size.limit", flushSizeLowerLimit)) {
            message = "MEMSTORE_FLUSHSIZE for table descriptor or \"hbase.hregion.memstore.flush.size\" (" + flushSize + ") is too small, which might cause" + " very frequent flushing.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message, null);
        }
        try {
            this.checkClassLoading(this.conf, htd);
        }
        catch (Exception ex) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", ex.getMessage(), null);
        }
        try {
            this.checkCompression(htd);
        }
        catch (IOException e) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", e.getMessage(), e);
        }
        try {
            this.checkEncryption(this.conf, htd);
        }
        catch (IOException e) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", e.getMessage(), e);
        }
        if (htd.getColumnFamilies().length == 0) {
            message = "Table should have at least one column family.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message, null);
        }
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            String message3;
            if (hcd.getTimeToLive() <= 0) {
                message3 = "TTL for column family " + hcd.getNameAsString() + " must be positive.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getBlocksize() < 1024 || hcd.getBlocksize() > 0x1000000) {
                message3 = "Block size for column family " + hcd.getNameAsString() + "  must be between 1K and 16MB.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getMinVersions() < 0) {
                message3 = "Min versions for column family " + hcd.getNameAsString() + "  must be positive.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getMinVersions() > hcd.getMaxVersions()) {
                message3 = "Min versions for column family " + hcd.getNameAsString() + " must be less than the Max versions.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getScope() < 0) {
                message3 = "Replication scope for column family " + hcd.getNameAsString() + "  must be positive.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getDFSReplication() >= 0) continue;
            message3 = "HFile Replication for column family " + hcd.getNameAsString() + "  must be greater than zero.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
        }
    }

    private static void warnOrThrowExceptionForFailure(boolean logWarn, String confKey, String message, Exception cause) throws IOException {
        if (!logWarn) {
            throw new DoNotRetryIOException(message + " Set " + confKey + " to false at conf or table descriptor if you want to bypass sanity checks", (Throwable)cause);
        }
        LOG.warn((Object)message);
    }

    private void checkCompression(HTableDescriptor htd) throws IOException {
        if (!this.masterCheckCompression) {
            return;
        }
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            this.checkCompression(hcd);
        }
    }

    private void checkCompression(HColumnDescriptor hcd) throws IOException {
        if (!this.masterCheckCompression) {
            return;
        }
        CompressionTest.testCompression(hcd.getCompression());
        CompressionTest.testCompression(hcd.getCompactionCompression());
    }

    private void checkEncryption(Configuration conf, HTableDescriptor htd) throws IOException {
        if (!this.masterCheckEncryption) {
            return;
        }
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            this.checkEncryption(conf, hcd);
        }
    }

    private void checkEncryption(Configuration conf, HColumnDescriptor hcd) throws IOException {
        if (!this.masterCheckEncryption) {
            return;
        }
        EncryptionTest.testEncryption(conf, hcd.getEncryptionType(), hcd.getEncryptionKey());
    }

    private void checkClassLoading(Configuration conf, HTableDescriptor htd) throws IOException {
        RegionSplitPolicy.getSplitPolicyClass(htd, conf);
        RegionCoprocessorHost.testTableCoprocessorAttrs(conf, htd);
    }

    public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest req) throws ServiceException {
        HTableDescriptor hTableDescriptor = HTableDescriptor.convert((HBaseProtos.TableSchema)req.getTableSchema());
        byte[][] splitKeys = ProtobufUtil.getSplitKeysArray((MasterProtos.CreateTableRequest)req);
        try {
            this.createTable(hTableDescriptor, splitKeys);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.CreateTableResponse.newBuilder().build();
    }

    private HRegionInfo[] getHRegionInfos(HTableDescriptor hTableDescriptor, byte[][] splitKeys) {
        HRegionInfo[] hRegionInfos = null;
        if (splitKeys == null || splitKeys.length == 0) {
            hRegionInfos = new HRegionInfo[]{new HRegionInfo(hTableDescriptor.getTableName(), null, null)};
        } else {
            int numRegions = splitKeys.length + 1;
            hRegionInfos = new HRegionInfo[numRegions];
            byte[] startKey = null;
            byte[] endKey = null;
            for (int i = 0; i < numRegions; ++i) {
                endKey = i == splitKeys.length ? null : splitKeys[i];
                hRegionInfos[i] = new HRegionInfo(hTableDescriptor.getTableName(), startKey, endKey);
                startKey = endKey;
            }
        }
        return hRegionInfos;
    }

    private static boolean isCatalogTable(TableName tableName) {
        return tableName.equals((Object)TableName.META_TABLE_NAME);
    }

    @Override
    public void deleteTable(TableName tableName) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preDeleteTable(tableName);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " delete " + tableName));
        this.executorService.submit(new DeleteTableHandler(tableName, this, this).prepare());
        if (this.cpHost != null) {
            this.cpHost.postDeleteTable(tableName);
        }
    }

    public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
        try {
            this.deleteTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.DeleteTableResponse.newBuilder().build();
    }

    public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest req) throws ServiceException {
        TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName());
        try {
            Pair<Integer, Integer> pair = this.assignmentManager.getReopenStatus(tableName);
            MasterProtos.GetSchemaAlterStatusResponse.Builder ret = MasterProtos.GetSchemaAlterStatusResponse.newBuilder();
            ret.setYetToUpdateRegions(((Integer)pair.getFirst()).intValue());
            ret.setTotalRegions(((Integer)pair.getSecond()).intValue());
            return ret.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    @Override
    public void addColumn(TableName tableName, HColumnDescriptor columnDescriptor) throws IOException {
        this.checkInitialized();
        this.checkCompression(columnDescriptor);
        this.checkEncryption(this.conf, columnDescriptor);
        if (this.cpHost != null && this.cpHost.preAddColumn(tableName, columnDescriptor)) {
            return;
        }
        new TableAddFamilyHandler(tableName, columnDescriptor, (Server)this, (MasterServices)this).prepare().process();
        if (this.cpHost != null) {
            this.cpHost.postAddColumn(tableName, columnDescriptor);
        }
    }

    public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest req) throws ServiceException {
        try {
            this.addColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), HColumnDescriptor.convert((HBaseProtos.ColumnFamilySchema)req.getColumnFamilies()));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.AddColumnResponse.newBuilder().build();
    }

    @Override
    public void modifyColumn(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        this.checkInitialized();
        this.checkCompression(descriptor);
        this.checkEncryption(this.conf, descriptor);
        if (this.cpHost != null && this.cpHost.preModifyColumn(tableName, descriptor)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " modify " + descriptor));
        new TableModifyFamilyHandler(tableName, descriptor, (Server)this, (MasterServices)this).prepare().process();
        if (this.cpHost != null) {
            this.cpHost.postModifyColumn(tableName, descriptor);
        }
    }

    public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest req) throws ServiceException {
        try {
            this.modifyColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), HColumnDescriptor.convert((HBaseProtos.ColumnFamilySchema)req.getColumnFamilies()));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.ModifyColumnResponse.newBuilder().build();
    }

    @Override
    public void deleteColumn(TableName tableName, byte[] columnName) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null && this.cpHost.preDeleteColumn(tableName, columnName)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " delete " + Bytes.toString((byte[])columnName)));
        new TableDeleteFamilyHandler(tableName, columnName, (Server)this, (MasterServices)this).prepare().process();
        if (this.cpHost != null) {
            this.cpHost.postDeleteColumn(tableName, columnName);
        }
    }

    public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest req) throws ServiceException {
        try {
            this.deleteColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), req.getColumnName().toByteArray());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.DeleteColumnResponse.newBuilder().build();
    }

    @Override
    public void enableTable(TableName tableName) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preEnableTable(tableName);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " enable " + tableName));
        this.executorService.submit(new EnableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager, this.tableLockManager, false).prepare());
        if (this.cpHost != null) {
            this.cpHost.postEnableTable(tableName);
        }
    }

    public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
        try {
            this.enableTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.EnableTableResponse.newBuilder().build();
    }

    @Override
    public void disableTable(TableName tableName) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preDisableTable(tableName);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " disable " + tableName));
        this.executorService.submit(new DisableTableHandler(this, tableName, this.catalogTracker, this.assignmentManager, this.tableLockManager, false).prepare());
        if (this.cpHost != null) {
            this.cpHost.postDisableTable(tableName);
        }
    }

    public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
        try {
            this.disableTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.DisableTableResponse.newBuilder().build();
    }

    Pair<HRegionInfo, ServerName> getTableRegionForRow(final TableName tableName, byte[] rowKey) throws IOException {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

            public boolean processRow(Result data) throws IOException {
                if (data == null || data.size() <= 0) {
                    return true;
                }
                Pair pair = HRegionInfo.getHRegionInfoAndServerName((Result)data);
                if (pair == null) {
                    return false;
                }
                if (!((HRegionInfo)pair.getFirst()).getTable().equals((Object)tableName)) {
                    return false;
                }
                result.set(pair);
                return true;
            }
        };
        MetaScanner.metaScan((Configuration)this.conf, (MetaScanner.MetaScannerVisitor)visitor, (TableName)tableName, (byte[])rowKey, (int)1);
        return result.get();
    }

    @Override
    public void modifyTable(TableName tableName, HTableDescriptor descriptor) throws IOException {
        this.checkInitialized();
        this.sanityCheckTableDescriptor(descriptor);
        if (this.cpHost != null) {
            this.cpHost.preModifyTable(tableName, descriptor);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " modify " + tableName));
        new ModifyTableHandler(tableName, descriptor, (Server)this, (MasterServices)this).prepare().process();
        if (this.cpHost != null) {
            this.cpHost.postModifyTable(tableName, descriptor);
        }
    }

    public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest req) throws ServiceException {
        try {
            this.modifyTable(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), HTableDescriptor.convert((HBaseProtos.TableSchema)req.getTableSchema()));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.ModifyTableResponse.newBuilder().build();
    }

    @Override
    public void checkTableModifiable(TableName tableName) throws IOException, TableNotFoundException, TableNotDisabledException {
        if (HMaster.isCatalogTable(tableName)) {
            throw new IOException("Can't modify catalog tables");
        }
        if (!MetaReader.tableExists((CatalogTracker)this.getCatalogTracker(), (TableName)tableName)) {
            throw new TableNotFoundException(tableName);
        }
        if (!this.getAssignmentManager().getZKTable().isDisabledTable(tableName)) {
            throw new TableNotDisabledException(tableName);
        }
    }

    public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest req) throws ServiceException {
        MasterProtos.GetClusterStatusResponse.Builder response = MasterProtos.GetClusterStatusResponse.newBuilder();
        response.setClusterStatus(this.getClusterStatus().convert());
        return response.build();
    }

    public ClusterStatus getClusterStatus() {
        ArrayList backupMasterStrings;
        try {
            backupMasterStrings = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zooKeeper, (String)this.zooKeeper.backupMasterAddressesZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)this.zooKeeper.prefix("Unable to list backup servers"), (Throwable)e);
            backupMasterStrings = new ArrayList(0);
        }
        ArrayList<ServerName> backupMasters = new ArrayList<ServerName>(backupMasterStrings.size());
        for (String s : backupMasterStrings) {
            try {
                ServerName sn;
                byte[] bytes = ZKUtil.getData((ZooKeeperWatcher)this.zooKeeper, (String)ZKUtil.joinZNode((String)this.zooKeeper.backupMasterAddressesZNode, (String)s));
                if (bytes == null) continue;
                try {
                    sn = ServerName.parseFrom((byte[])bytes);
                }
                catch (DeserializationException e) {
                    LOG.warn((Object)"Failed parse, skipping registering backup server", (Throwable)e);
                    continue;
                }
                backupMasters.add(sn);
            }
            catch (KeeperException e) {
                LOG.warn((Object)this.zooKeeper.prefix("Unable to get information about backup servers"), (Throwable)e);
            }
        }
        Collections.sort(backupMasters, new Comparator<ServerName>(){

            @Override
            public int compare(ServerName s1, ServerName s2) {
                return s1.getServerName().compareTo(s2.getServerName());
            }
        });
        return new ClusterStatus(org.apache.hadoop.hbase.util.VersionInfo.getVersion(), this.fileSystemManager.getClusterId().toString(), this.serverManager.getOnlineServers(), this.serverManager.getDeadServers().copyServerNames(), this.serverName, backupMasters, this.assignmentManager.getRegionStates().getRegionsInTransition(), this.getCoprocessors(), Boolean.valueOf(this.loadBalancerTracker.isBalancerOn()));
    }

    public String getClusterId() {
        if (this.fileSystemManager == null) {
            return "";
        }
        ClusterId id = this.fileSystemManager.getClusterId();
        if (id == null) {
            return "";
        }
        return id.toString();
    }

    public static String getLoadedCoprocessors() {
        return CoprocessorHost.getLoadedCoprocessors().toString();
    }

    public long getMasterStartTime() {
        return this.masterStartTime;
    }

    public long getMasterActiveTime() {
        return this.masterActiveTime;
    }

    public int getRegionServerInfoPort(ServerName sn) {
        HBaseProtos.RegionServerInfo info = this.regionServerTracker.getRegionServerInfo(sn);
        if (info == null || info.getInfoPort() == 0) {
            return this.conf.getInt("hbase.regionserver.info.port", 60030);
        }
        return info.getInfoPort();
    }

    public String[] getCoprocessors() {
        Set<String> masterCoprocessors = this.getCoprocessorHost().getCoprocessors();
        return masterCoprocessors.toArray(new String[masterCoprocessors.size()]);
    }

    public void abort(String msg, Throwable t) {
        if (this.cpHost != null) {
            LOG.fatal((Object)("Master server abort: loaded coprocessors are: " + HMaster.getLoadedCoprocessors()));
        }
        if (this.abortNow(msg, t)) {
            if (t != null) {
                LOG.fatal((Object)msg, t);
            } else {
                LOG.fatal((Object)msg);
            }
            this.abort = true;
            this.stop("Aborting");
        }
    }

    private boolean tryRecoveringExpiredZKSession() throws InterruptedException, IOException, KeeperException, ExecutionException {
        Boolean recovered;
        this.zooKeeper.unregisterAllListeners();
        if (this.registeredZKListenersBeforeRecovery != null) {
            for (ZooKeeperListener curListener : this.registeredZKListenersBeforeRecovery) {
                this.zooKeeper.registerListener(curListener);
            }
        }
        this.zooKeeper.reconnectAfterExpiration();
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws InterruptedException, IOException, KeeperException {
                MonitoredTask status = TaskMonitor.get().createStatus("Recovering expired ZK session");
                try {
                    if (!HMaster.this.becomeActiveMaster(status)) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    HMaster.this.serverShutdownHandlerEnabled = false;
                    HMaster.this.initialized = false;
                    HMaster.this.finishInitialization(status, true);
                    Boolean bl = !HMaster.this.stopped;
                    return bl;
                }
                finally {
                    status.cleanup();
                }
            }
        };
        long timeout = this.conf.getLong("hbase.master.zksession.recover.timeout", 300000L);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> result = executor.submit(callable);
        executor.shutdown();
        if (executor.awaitTermination(timeout, TimeUnit.MILLISECONDS) && result.isDone() && (recovered = result.get()) != null) {
            return recovered;
        }
        executor.shutdownNow();
        return false;
    }

    private boolean abortNow(String msg, Throwable t) {
        if (!this.isActiveMaster || this.stopped) {
            return true;
        }
        boolean failFast = this.conf.getBoolean("fail.fast.expired.active.master", false);
        if (t != null && t instanceof KeeperException.SessionExpiredException && !failFast) {
            try {
                LOG.info((Object)"Primary Master trying to recover from ZooKeeper session expiry.");
                return !this.tryRecoveringExpiredZKSession();
            }
            catch (Throwable newT) {
                LOG.error((Object)"Primary master encountered unexpected exception while trying to recover from ZooKeeper session expiry. Proceeding with server abort.", newT);
            }
        }
        return true;
    }

    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public MasterCoprocessorHost getCoprocessorHost() {
        return this.cpHost;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public CatalogTracker getCatalogTracker() {
        return this.catalogTracker;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    @Override
    public TableLockManager getTableLockManager() {
        return this.tableLockManager;
    }

    public MemoryBoundedLogMessageBuffer getRegionServerFatalLogBuffer() {
        return this.rsFatals;
    }

    public void shutdown() {
        if (this.spanReceiverHost != null) {
            this.spanReceiverHost.closeReceivers();
        }
        if (this.cpHost != null) {
            try {
                this.cpHost.preShutdown();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Error call master coprocessor preShutdown()", (Throwable)ioe);
            }
        }
        if (this.mxBean != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mxBean);
            this.mxBean = null;
        }
        if (this.assignmentManager != null) {
            this.assignmentManager.shutdown();
        }
        if (this.serverManager != null) {
            this.serverManager.shutdownCluster();
        }
        try {
            if (this.clusterStatusTracker != null) {
                this.clusterStatusTracker.setClusterDown();
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)"ZooKeeper exception trying to set cluster as down in ZK", (Throwable)e);
        }
    }

    public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
        LOG.info((Object)(this.getClientIdAuditPrefix() + " shutdown"));
        this.shutdown();
        return MasterProtos.ShutdownResponse.newBuilder().build();
    }

    public void stopMaster() {
        if (this.cpHost != null) {
            try {
                this.cpHost.preStopMaster();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Error call master coprocessor preStopMaster()", (Throwable)ioe);
            }
        }
        this.stop("Stopped by " + Thread.currentThread().getName());
    }

    public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
        LOG.info((Object)(this.getClientIdAuditPrefix() + " stop"));
        this.stopMaster();
        return MasterProtos.StopMasterResponse.newBuilder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String why) {
        LOG.info((Object)why);
        this.stopped = true;
        this.stopSleeper.skipSleepCycle();
        if (this.activeMasterManager != null) {
            AtomicBoolean atomicBoolean = this.activeMasterManager.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                this.activeMasterManager.clusterHasActiveMaster.notifyAll();
            }
        }
        if (this.catalogTracker != null && this.serverManager.getOnlineServers().isEmpty()) {
            this.catalogTracker.stop();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isAborted() {
        return this.abort;
    }

    void checkInitialized() throws PleaseHoldException {
        if (!this.initialized) {
            throw new PleaseHoldException("Master is initializing");
        }
    }

    public boolean isActiveMaster() {
        return this.isActiveMaster;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isServerShutdownHandlerEnabled() {
        return this.serverShutdownHandlerEnabled;
    }

    public boolean isInitializationStartsMetaRegionAssignment() {
        return this.initializationBeforeMetaAssignment;
    }

    public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest req) throws ServiceException {
        try {
            HRegionInfo regionInfo;
            byte[] regionName = req.getRegion().getValue().toByteArray();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            MasterProtos.AssignRegionResponse arr = MasterProtos.AssignRegionResponse.newBuilder().build();
            this.checkInitialized();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn((Object)("assignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type));
            }
            if ((regionInfo = this.assignmentManager.getRegionStates().getRegionInfo(regionName)) == null) {
                throw new UnknownRegionException(Bytes.toString((byte[])regionName));
            }
            if (this.cpHost != null && this.cpHost.preAssign(regionInfo)) {
                return arr;
            }
            LOG.info((Object)(this.getClientIdAuditPrefix() + " assign " + regionInfo.getRegionNameAsString()));
            this.assignmentManager.assign(regionInfo, true, true);
            if (this.cpHost != null) {
                this.cpHost.postAssign(regionInfo);
            }
            return arr;
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public void assignRegion(HRegionInfo hri) {
        this.assignmentManager.assign(hri, true);
    }

    public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest req) throws ServiceException {
        try {
            Pair pair;
            byte[] regionName = req.getRegion().getValue().toByteArray();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            boolean force = req.getForce();
            MasterProtos.UnassignRegionResponse urr = MasterProtos.UnassignRegionResponse.newBuilder().build();
            this.checkInitialized();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn((Object)("unassignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type));
            }
            if ((pair = MetaReader.getRegion((CatalogTracker)this.catalogTracker, (byte[])regionName)) == null) {
                throw new UnknownRegionException(Bytes.toString((byte[])regionName));
            }
            HRegionInfo hri = (HRegionInfo)pair.getFirst();
            if (this.cpHost != null && this.cpHost.preUnassign(hri, force)) {
                return urr;
            }
            LOG.debug((Object)(this.getClientIdAuditPrefix() + " unassign " + hri.getRegionNameAsString() + " in current location if it is online and reassign.force=" + force));
            this.assignmentManager.unassign(hri, force);
            if (this.assignmentManager.getRegionStates().isRegionOffline(hri)) {
                LOG.debug((Object)("Region " + hri.getRegionNameAsString() + " is not online on any region server, reassigning it."));
                this.assignRegion(hri);
            }
            if (this.cpHost != null) {
                this.cpHost.postUnassign(hri, force);
            }
            return urr;
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController controller, MasterProtos.GetTableDescriptorsRequest req) throws ServiceException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        ArrayList<TableName> tableNameList = new ArrayList<TableName>();
        for (HBaseProtos.TableName tableNamePB : req.getTableNamesList()) {
            tableNameList.add(ProtobufUtil.toTableName((HBaseProtos.TableName)tableNamePB));
        }
        boolean bypass = false;
        if (this.cpHost != null) {
            try {
                bypass = this.cpHost.preGetTableDescriptors(tableNameList, descriptors);
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
        }
        if (!bypass) {
            if (req.getTableNamesCount() == 0) {
                Map<String, HTableDescriptor> descriptorMap = null;
                try {
                    descriptorMap = this.tableDescriptors.getAll();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Failed getting all descriptors", (Throwable)e);
                }
                if (descriptorMap != null) {
                    for (HTableDescriptor desc : descriptorMap.values()) {
                        if (desc.getTableName().isSystemTable()) continue;
                        descriptors.add(desc);
                    }
                }
            } else {
                for (TableName s : tableNameList) {
                    try {
                        HTableDescriptor desc;
                        desc = this.tableDescriptors.get(s);
                        if (desc == null) continue;
                        descriptors.add(desc);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed getting descriptor for " + s), (Throwable)e);
                    }
                }
            }
            if (this.cpHost != null) {
                try {
                    this.cpHost.postGetTableDescriptors(descriptors);
                }
                catch (IOException ioe) {
                    throw new ServiceException((Throwable)ioe);
                }
            }
        }
        MasterProtos.GetTableDescriptorsResponse.Builder builder = MasterProtos.GetTableDescriptorsResponse.newBuilder();
        for (HTableDescriptor htd : descriptors) {
            builder.addTableSchema(htd.convert());
        }
        return builder.build();
    }

    public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest req) throws ServiceException {
        try {
            Collection<HTableDescriptor> descriptors = this.tableDescriptors.getAll().values();
            MasterProtos.GetTableNamesResponse.Builder builder = MasterProtos.GetTableNamesResponse.newBuilder();
            for (HTableDescriptor descriptor : descriptors) {
                if (descriptor.getTableName().isSystemTable()) continue;
                builder.addTableNames(ProtobufUtil.toProtoTableName((TableName)descriptor.getTableName()));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public double getAverageLoad() {
        if (this.assignmentManager == null) {
            return 0.0;
        }
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        if (regionStates == null) {
            return 0.0;
        }
        return regionStates.getAverageLoad();
    }

    public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
        byte[] regionName = request.getRegion().getValue().toByteArray();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = request.getRegion().getType();
        if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
            LOG.warn((Object)("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type));
        }
        try {
            Pair pair = MetaReader.getRegion((CatalogTracker)this.catalogTracker, (byte[])regionName);
            if (pair == null) {
                throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionName));
            }
            HRegionInfo hri = (HRegionInfo)pair.getFirst();
            if (this.cpHost != null) {
                this.cpHost.preRegionOffline(hri);
            }
            LOG.info((Object)(this.getClientIdAuditPrefix() + " offline " + hri.getRegionNameAsString()));
            this.assignmentManager.regionOffline(hri);
            if (this.cpHost != null) {
                this.cpHost.postRegionOffline(hri);
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.OfflineRegionResponse.newBuilder().build();
    }

    @Override
    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        if (this.coprocessorServiceHandlers.containsKey(serviceDesc.getFullName())) {
            LOG.error((Object)("Coprocessor service " + serviceDesc.getFullName() + " already registered, rejecting request from " + instance));
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceDesc.getFullName(), instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered master coprocessor service: service=" + serviceDesc.getFullName()));
        }
        return true;
    }

    public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        try {
            ServerRpcController execController = new ServerRpcController();
            ClientProtos.CoprocessorServiceCall call = request.getCall();
            String serviceName = call.getServiceName();
            String methodName = call.getMethodName();
            if (!this.coprocessorServiceHandlers.containsKey(serviceName)) {
                throw new UnknownProtocolException(null, "No registered master coprocessor service found for name " + serviceName);
            }
            Service service = this.coprocessorServiceHandlers.get(serviceName);
            Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
            Descriptors.MethodDescriptor methodDesc = serviceDesc.findMethodByName(methodName);
            if (methodDesc == null) {
                throw new UnknownProtocolException(service.getClass(), "Unknown method " + methodName + " called on master service " + serviceName);
            }
            Message.Builder builderForType = service.getRequestPrototype(methodDesc).newBuilderForType();
            ProtobufUtil.mergeFrom((Message.Builder)builderForType, (ByteString)call.getRequest());
            Message execRequest = builderForType.build();
            final Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
            service.callMethod(methodDesc, (RpcController)execController, execRequest, (RpcCallback)new RpcCallback<Message>(){

                public void run(Message message) {
                    if (message != null) {
                        responseBuilder.mergeFrom(message);
                    }
                }
            });
            Message execResult = responseBuilder.build();
            if (execController.getFailedOn() != null) {
                throw execController.getFailedOn();
            }
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])HConstants.EMPTY_BYTE_ARRAY));
            builder.setValue(builder.getValueBuilder().setName(execResult.getClass().getName()).setValue(execResult.toByteString()));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public static HMaster constructMaster(Class<? extends HMaster> masterClass, Configuration conf) {
        try {
            Constructor<? extends HMaster> c = masterClass.getConstructor(Configuration.class);
            return c.newInstance(conf);
        }
        catch (InvocationTargetException ite) {
            Throwable target;
            Throwable throwable = target = ite.getTargetException() != null ? ite.getTargetException() : ite;
            if (target.getCause() != null) {
                target = target.getCause();
            }
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString(), target);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString() + (e.getCause() != null ? e.getCause().getMessage() : ""), e);
        }
    }

    public static void main(String[] args) {
        org.apache.hadoop.hbase.util.VersionInfo.logVersion();
        new HMasterCommandLine(HMaster.class).doMain(args);
    }

    public HFileCleaner getHFileCleaner() {
        return this.hfileCleaner;
    }

    public SnapshotManager getSnapshotManagerForTesting() {
        return this.snapshotManager;
    }

    public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
        try {
            this.snapshotManager.checkSnapshotSupport();
        }
        catch (UnsupportedOperationException e) {
            throw new ServiceException((Throwable)e);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " snapshot request for:" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)request.getSnapshot())));
        HBaseProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.validate(request.getSnapshot(), this.conf);
        try {
            this.snapshotManager.takeSnapshot(snapshot);
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        long waitTime = SnapshotDescriptionUtils.getMaxMasterTimeout(this.conf, snapshot.getType(), 300000L);
        return MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(waitTime).build();
    }

    public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
        try {
            MasterProtos.GetCompletedSnapshotsResponse.Builder builder = MasterProtos.GetCompletedSnapshotsResponse.newBuilder();
            List<HBaseProtos.SnapshotDescription> snapshots = this.snapshotManager.getCompletedSnapshots();
            for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
                builder.addSnapshots(snapshot);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
        try {
            this.snapshotManager.checkSnapshotSupport();
        }
        catch (UnsupportedOperationException e) {
            throw new ServiceException((Throwable)e);
        }
        try {
            LOG.info((Object)(this.getClientIdAuditPrefix() + " delete " + request.getSnapshot()));
            this.snapshotManager.deleteSnapshot(request.getSnapshot());
            return MasterProtos.DeleteSnapshotResponse.newBuilder().build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
        LOG.debug((Object)("Checking to see if snapshot from request:" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)request.getSnapshot()) + " is done"));
        try {
            MasterProtos.IsSnapshotDoneResponse.Builder builder = MasterProtos.IsSnapshotDoneResponse.newBuilder();
            boolean done = this.snapshotManager.isSnapshotDone(request.getSnapshot());
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
        try {
            this.snapshotManager.checkSnapshotSupport();
        }
        catch (UnsupportedOperationException e) {
            throw new ServiceException((Throwable)e);
        }
        try {
            TableName dstTable = TableName.valueOf((String)request.getSnapshot().getTable());
            this.getNamespaceDescriptor(dstTable.getNamespaceAsString());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        try {
            HBaseProtos.SnapshotDescription reqSnapshot = request.getSnapshot();
            this.snapshotManager.restoreSnapshot(reqSnapshot);
            return MasterProtos.RestoreSnapshotResponse.newBuilder().build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsRestoreSnapshotDoneResponse isRestoreSnapshotDone(RpcController controller, MasterProtos.IsRestoreSnapshotDoneRequest request) throws ServiceException {
        try {
            HBaseProtos.SnapshotDescription snapshot = request.getSnapshot();
            MasterProtos.IsRestoreSnapshotDoneResponse.Builder builder = MasterProtos.IsRestoreSnapshotDoneResponse.newBuilder();
            boolean done = this.snapshotManager.isRestoreDone(snapshot);
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        HBaseProtos.ProcedureDescription desc = request.getProcedure();
        MasterProcedureManager mpm = this.mpmHost.getProcedureManager(desc.getSignature());
        if (mpm == null) {
            throw new ServiceException("The procedure is not registered: " + desc.getSignature());
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature()));
        try {
            mpm.execProcedure(desc);
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        long waitTime = 300000L;
        return MasterProtos.ExecProcedureResponse.newBuilder().setExpectedTimeout(waitTime).build();
    }

    public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
        HBaseProtos.ProcedureDescription desc = request.getProcedure();
        MasterProcedureManager mpm = this.mpmHost.getProcedureManager(desc.getSignature());
        if (mpm == null) {
            throw new ServiceException("The procedure is not registered: " + desc.getSignature());
        }
        LOG.debug((Object)("Checking to see if procedure from request:" + desc.getSignature() + " is done"));
        try {
            MasterProtos.IsProcedureDoneResponse.Builder builder = MasterProtos.IsProcedureDoneResponse.newBuilder();
            boolean done = mpm.isProcedureDone(desc);
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
        try {
            this.modifyNamespace(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)request.getNamespaceDescriptor()));
            return MasterProtos.ModifyNamespaceResponse.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
        try {
            this.createNamespace(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)request.getNamespaceDescriptor()));
            return MasterProtos.CreateNamespaceResponse.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
        try {
            this.deleteNamespace(request.getNamespaceName());
            return MasterProtos.DeleteNamespaceResponse.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
        try {
            return MasterProtos.GetNamespaceDescriptorResponse.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.getNamespaceDescriptor(request.getNamespaceName()))).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController controller, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
        try {
            MasterProtos.ListNamespaceDescriptorsResponse.Builder response = MasterProtos.ListNamespaceDescriptorsResponse.newBuilder();
            for (NamespaceDescriptor ns : this.listNamespaceDescriptors()) {
                response.addNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)ns));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController controller, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableDescriptorsByNamespaceResponse.Builder b = MasterProtos.ListTableDescriptorsByNamespaceResponse.newBuilder();
            for (HTableDescriptor htd : this.listTableDescriptorsByNamespace(request.getNamespaceName())) {
                b.addTableSchema(htd.convert());
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController controller, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableNamesByNamespaceResponse.Builder b = MasterProtos.ListTableNamesByNamespaceResponse.newBuilder();
            for (TableName tableName : this.listTableNamesByNamespace(request.getNamespaceName())) {
                b.addTableName(ProtobufUtil.toProtoTableName((TableName)tableName));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private boolean isHealthCheckerConfigured() {
        String healthScriptLocation = this.conf.get("hbase.node.health.script.location");
        return StringUtils.isNotBlank((String)healthScriptLocation);
    }

    @Override
    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)descriptor.getName()));
        if (this.cpHost != null && this.cpHost.preCreateNamespace(descriptor)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " creating " + descriptor));
        this.tableNamespaceManager.create(descriptor);
        if (this.cpHost != null) {
            this.cpHost.postCreateNamespace(descriptor);
        }
    }

    @Override
    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)descriptor.getName()));
        if (this.cpHost != null && this.cpHost.preModifyNamespace(descriptor)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " modify " + descriptor));
        this.tableNamespaceManager.update(descriptor);
        if (this.cpHost != null) {
            this.cpHost.postModifyNamespace(descriptor);
        }
    }

    @Override
    public void deleteNamespace(String name) throws IOException {
        if (this.cpHost != null && this.cpHost.preDeleteNamespace(name)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " delete " + name));
        this.tableNamespaceManager.remove(name);
        if (this.cpHost != null) {
            this.cpHost.postDeleteNamespace(name);
        }
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
        boolean ready;
        boolean bl = ready = this.tableNamespaceManager != null && this.tableNamespaceManager.isTableAvailableAndInitialized();
        if (!ready) {
            throw new IOException("Table Namespace Manager not ready yet, try again later");
        }
        NamespaceDescriptor nsd = this.tableNamespaceManager.get(name);
        if (nsd == null) {
            throw new NamespaceNotFoundException(name);
        }
        return nsd;
    }

    @Override
    public List<NamespaceDescriptor> listNamespaceDescriptors() throws IOException {
        return Lists.newArrayList(this.tableNamespaceManager.list());
    }

    @Override
    public List<HTableDescriptor> listTableDescriptorsByNamespace(String name) throws IOException {
        this.getNamespaceDescriptor(name);
        return Lists.newArrayList(this.tableDescriptors.getByNamespace(name).values());
    }

    @Override
    public List<TableName> listTableNamesByNamespace(String name) throws IOException {
        ArrayList tableNames = Lists.newArrayList();
        this.getNamespaceDescriptor(name);
        for (HTableDescriptor descriptor : this.tableDescriptors.getByNamespace(name).values()) {
            tableNames.add(descriptor.getTableName());
        }
        return tableNames;
    }

    public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RpcController controller, RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws ServiceException {
        try {
            RegionServerStatusProtos.RegionStateTransition rt = req.getTransition(0);
            TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)rt.getRegionInfo(0).getTableName());
            RegionStates regionStates = this.assignmentManager.getRegionStates();
            if (!(TableName.META_TABLE_NAME.equals((Object)tableName) && regionStates.getRegionState(HRegionInfo.FIRST_META_REGIONINFO) != null || this.assignmentManager.isFailoverCleanupDone())) {
                throw new PleaseHoldException("Master is rebuilding user regions");
            }
            ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)req.getServer());
            String error = this.assignmentManager.onRegionTransition(sn, rt);
            RegionServerStatusProtos.ReportRegionStateTransitionResponse.Builder rrtr = RegionServerStatusProtos.ReportRegionStateTransitionResponse.newBuilder();
            if (error != null) {
                rrtr.setErrorMessage(error);
            }
            return rrtr.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    @Override
    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preTruncateTable(tableName);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " truncate " + tableName));
        TruncateTableHandler handler = new TruncateTableHandler(tableName, this, this, preserveSplits);
        handler.prepare();
        handler.process();
        if (this.cpHost != null) {
            this.cpHost.postTruncateTable(tableName);
        }
    }

    public MasterProtos.TruncateTableResponse truncateTable(RpcController controller, MasterProtos.TruncateTableRequest request) throws ServiceException {
        try {
            this.truncateTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getPreserveSplits());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return MasterProtos.TruncateTableResponse.newBuilder().build();
    }

    public MasterProtos.IsBalancerEnabledResponse isBalancerEnabled(RpcController controller, MasterProtos.IsBalancerEnabledRequest request) throws ServiceException {
        MasterProtos.IsBalancerEnabledResponse.Builder response = MasterProtos.IsBalancerEnabledResponse.newBuilder();
        response.setEnabled(this.isBalancerOn());
        return response.build();
    }

    public boolean isBalancerOn() {
        if (null == this.loadBalancerTracker) {
            return false;
        }
        return this.loadBalancerTracker.isBalancerOn();
    }

    public String getLoadBalancerClassName() {
        return this.conf.get("hbase.master.loadbalancer.class", LoadBalancerFactory.getDefaultLoadBalancerClass().getName());
    }

    public MasterProtos.SecurityCapabilitiesResponse getSecurityCapabilities(RpcController controller, MasterProtos.SecurityCapabilitiesRequest request) throws ServiceException {
        MasterProtos.SecurityCapabilitiesResponse.Builder response = MasterProtos.SecurityCapabilitiesResponse.newBuilder();
        try {
            this.checkInitialized();
            HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability> capabilities = new HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability>();
            if (User.isHBaseSecurityEnabled((Configuration)this.conf)) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SECURE_AUTHENTICATION);
            } else {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SIMPLE_AUTHENTICATION);
            }
            if (this.cpHost != null && this.cpHost.findCoprocessor(AccessController.class.getName()) != null) {
                if (AccessController.isAuthorizationSupported(this.conf)) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.AUTHORIZATION);
                }
                if (AccessController.isCellAuthorizationSupported(this.conf)) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_AUTHORIZATION);
                }
            }
            if (this.cpHost != null && this.cpHost.findCoprocessor(VisibilityController.class.getName()) != null && VisibilityController.isCellAuthorizationSupported(this.conf)) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_VISIBILITY);
            }
            response.addAllCapabilities(capabilities);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    static enum BalanceSwitchMode {
        SYNC,
        ASYNC;

    }

    private static class InitializationMonitor
    extends HasThread {
        public static final String TIMEOUT_KEY = "hbase.master.initializationmonitor.timeout";
        public static final long TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
        public static final String HALT_KEY = "hbase.master.initializationmonitor.haltontimeout";
        public static final boolean HALT_DEFAULT = false;
        private final HMaster master;
        private final long timeout;
        private final boolean haltOnTimeout;

        InitializationMonitor(HMaster master) {
            super("MasterInitializationMonitor");
            this.master = master;
            this.timeout = master.getConfiguration().getLong(TIMEOUT_KEY, TIMEOUT_DEFAULT);
            this.haltOnTimeout = master.getConfiguration().getBoolean(HALT_KEY, false);
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (!this.master.isStopped() && this.master.isActiveMaster()) {
                    Thread.sleep(this.timeout);
                    if (this.master.isInitialized()) {
                        LOG.debug((Object)"Initialization completed within allotted tolerance. Monitor exiting.");
                        continue;
                    }
                    LOG.error((Object)("Master failed to complete initialization after " + this.timeout + "ms. Please" + " consider submitting a bug report including a thread dump of this process."));
                    if (!this.haltOnTimeout) continue;
                    LOG.error((Object)"Zombie Master exiting. Thread dump to stdout");
                    Threads.printThreadInfo((PrintStream)System.out, (String)"Zombie HMaster");
                    System.exit(-1);
                }
            }
            catch (InterruptedException ie) {
                LOG.trace((Object)"InitMonitor thread interrupted. Existing.");
            }
        }
    }
}

