/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.ClusterLoadState;
import org.apache.hadoop.hbase.master.balancer.MetricsBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;

public abstract class BaseLoadBalancer
implements LoadBalancer {
    private static final int MIN_SERVER_BALANCE = 2;
    private volatile boolean stopped = false;
    protected float slop;
    private Configuration config;
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final Log LOG = LogFactory.getLog(BaseLoadBalancer.class);
    protected final MetricsBalancer metricsBalancer = new MetricsBalancer();
    protected MasterServices services;

    public void setConf(Configuration conf) {
        this.setSlop(conf);
        if (this.slop < 0.0f) {
            this.slop = 0.0f;
        } else if (this.slop > 1.0f) {
            this.slop = 1.0f;
        }
        this.config = conf;
    }

    protected void setSlop(Configuration conf) {
        this.slop = conf.getFloat("hbase.regions.slop", 0.2f);
    }

    public Configuration getConf() {
        return this.config;
    }

    @Override
    public void setClusterStatus(ClusterStatus st) {
    }

    @Override
    public void setMasterServices(MasterServices masterServices) {
        this.services = masterServices;
    }

    protected boolean needsBalance(ClusterLoadState cs) {
        if (cs.getNumServers() < 2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not running balancer because only " + cs.getNumServers() + " active regionserver(s)"));
            }
            return false;
        }
        float average = cs.getLoadAverage();
        int floor = (int)Math.floor(average * (1.0f - this.slop));
        int ceiling = (int)Math.ceil(average * (1.0f + this.slop));
        if (cs.getMaxLoad() <= ceiling && cs.getMinLoad() >= floor) {
            NavigableMap<ServerAndLoad, List<HRegionInfo>> serversByLoad = cs.getServersByLoad();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Skipping load balancing because balanced cluster; servers=" + cs.getNumServers() + " " + "regions=" + cs.getNumRegions() + " average=" + average + " " + "mostloaded=" + ((ServerAndLoad)serversByLoad.lastKey()).getLoad() + " leastloaded=" + ((ServerAndLoad)serversByLoad.firstKey()).getLoad()));
            }
            return false;
        }
        return true;
    }

    @Override
    public Map<ServerName, List<HRegionInfo>> roundRobinAssignment(List<HRegionInfo> regions, List<ServerName> servers) {
        this.metricsBalancer.incrMiscInvocations();
        if (regions.isEmpty() || servers.isEmpty()) {
            return null;
        }
        TreeMap<ServerName, List<HRegionInfo>> assignments = new TreeMap<ServerName, List<HRegionInfo>>();
        int numRegions = regions.size();
        int numServers = servers.size();
        int max = (int)Math.ceil((float)numRegions / (float)numServers);
        int serverIdx = 0;
        if (numServers > 1) {
            serverIdx = RANDOM.nextInt(numServers);
        }
        int regionIdx = 0;
        for (int j = 0; j < numServers; ++j) {
            ServerName server = servers.get((j + serverIdx) % numServers);
            ArrayList<HRegionInfo> serverRegions = new ArrayList<HRegionInfo>(max);
            for (int i = regionIdx; i < numRegions; i += numServers) {
                serverRegions.add(regions.get(i % numRegions));
            }
            assignments.put(server, serverRegions);
            ++regionIdx;
        }
        return assignments;
    }

    @Override
    public Map<HRegionInfo, ServerName> immediateAssignment(List<HRegionInfo> regions, List<ServerName> servers) {
        this.metricsBalancer.incrMiscInvocations();
        TreeMap<HRegionInfo, ServerName> assignments = new TreeMap<HRegionInfo, ServerName>();
        for (HRegionInfo region : regions) {
            assignments.put(region, this.randomAssignment(region, servers));
        }
        return assignments;
    }

    @Override
    public ServerName randomAssignment(HRegionInfo regionInfo, List<ServerName> servers) {
        this.metricsBalancer.incrMiscInvocations();
        if (servers == null || servers.isEmpty()) {
            LOG.warn((Object)"Wanted to do random assignment but no servers to assign to");
            return null;
        }
        return servers.get(RANDOM.nextInt(servers.size()));
    }

    @Override
    public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) {
        this.metricsBalancer.incrMiscInvocations();
        ArrayListMultimap serversByHostname = ArrayListMultimap.create();
        for (ServerName server : servers) {
            serversByHostname.put((Object)server.getHostname(), (Object)server);
        }
        TreeMap<ServerName, List<HRegionInfo>> assignments = new TreeMap<ServerName, List<HRegionInfo>>();
        for (ServerName server : servers) {
            assignments.put(server, new ArrayList());
        }
        TreeSet oldHostsNoLongerPresent = Sets.newTreeSet();
        int numRandomAssignments = 0;
        int numRetainedAssigments = 0;
        for (Map.Entry<HRegionInfo, ServerName> entry : regions.entrySet()) {
            HRegionInfo region = entry.getKey();
            ServerName oldServerName = entry.getValue();
            List localServers = new ArrayList();
            if (oldServerName != null) {
                localServers = serversByHostname.get((Object)oldServerName.getHostname());
            }
            if (localServers.isEmpty()) {
                ServerName randomServer = servers.get(RANDOM.nextInt(servers.size()));
                ((List)assignments.get(randomServer)).add(region);
                ++numRandomAssignments;
                if (oldServerName == null) continue;
                oldHostsNoLongerPresent.add(oldServerName.getHostname());
                continue;
            }
            if (localServers.size() == 1) {
                ((List)assignments.get(localServers.get(0))).add(region);
                ++numRetainedAssigments;
                continue;
            }
            int size = localServers.size();
            ServerName target = localServers.contains(oldServerName) ? oldServerName : (ServerName)localServers.get(RANDOM.nextInt(size));
            ((List)assignments.get(target)).add(region);
            ++numRetainedAssigments;
        }
        String randomAssignMsg = "";
        if (numRandomAssignments > 0) {
            randomAssignMsg = numRandomAssignments + " regions were assigned " + "to random hosts, since the old hosts for these regions are no " + "longer present in the cluster. These hosts were:\n  " + Joiner.on((String)"\n  ").join((Iterable)oldHostsNoLongerPresent);
        }
        LOG.info((Object)("Reassigned " + regions.size() + " regions. " + numRetainedAssigments + " retained the pre-restart assignment. " + randomAssignMsg));
        return assignments;
    }

    @Override
    public void initialize() throws HBaseIOException {
    }

    @Override
    public void regionOnline(HRegionInfo regionInfo, ServerName sn) {
    }

    @Override
    public void regionOffline(HRegionInfo regionInfo) {
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop(String why) {
        LOG.info((Object)("Load Balancer stop requested: " + why));
        this.stopped = true;
    }

    protected static class Cluster {
        ServerName[] servers;
        ArrayList<String> tables;
        HRegionInfo[] regions;
        Deque<RegionLoad>[] regionLoads;
        int[][] regionLocations;
        int[][] regionsPerServer;
        int[] regionIndexToServerIndex;
        int[] initialRegionIndexToServerIndex;
        int[] regionIndexToTableIndex;
        int[][] numRegionsPerServerPerTable;
        int[] numMaxRegionsPerTable;
        Integer[] serverIndicesSortedByRegionCount;
        Map<String, Integer> serversToIndex;
        Map<String, Integer> tablesToIndex;
        int numRegions = 0;
        int numServers;
        int numTables;
        int numMovedRegions = 0;
        int numMovedMetaRegions = 0;
        private Comparator<Integer> numRegionsComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer integer, Integer integer2) {
                return Integer.valueOf(Cluster.this.getNumRegions(integer)).compareTo(Cluster.this.getNumRegions(integer2));
            }
        };

        /*
         * WARNING - void declaration
         */
        protected Cluster(Map<ServerName, List<HRegionInfo>> clusterState, Map<String, Deque<RegionLoad>> loads, RegionLocationFinder regionFinder) {
            int i;
            this.serversToIndex = new HashMap<String, Integer>();
            this.tablesToIndex = new HashMap<String, Integer>();
            this.tables = new ArrayList();
            int serverIndex = 0;
            for (ServerName serverName : clusterState.keySet()) {
                if (this.serversToIndex.get(serverName.getHostAndPort()) != null) continue;
                this.serversToIndex.put(serverName.getHostAndPort(), serverIndex++);
            }
            for (Map.Entry entry : clusterState.entrySet()) {
                this.numRegions += ((List)entry.getValue()).size();
            }
            this.numServers = this.serversToIndex.size();
            this.regionsPerServer = new int[this.serversToIndex.size()][];
            this.servers = new ServerName[this.numServers];
            this.regions = new HRegionInfo[this.numRegions];
            this.regionIndexToServerIndex = new int[this.numRegions];
            this.initialRegionIndexToServerIndex = new int[this.numRegions];
            this.regionIndexToTableIndex = new int[this.numRegions];
            this.regionLoads = new Deque[this.numRegions];
            this.regionLocations = new int[this.numRegions][];
            this.serverIndicesSortedByRegionCount = new Integer[this.numServers];
            int tableIndex = 0;
            boolean bl = false;
            int regionPerServerIndex = 0;
            for (Map.Entry<ServerName, List<HRegionInfo>> entry : clusterState.entrySet()) {
                serverIndex = this.serversToIndex.get(entry.getKey().getHostAndPort());
                if (this.servers[serverIndex] == null || this.servers[serverIndex].getStartcode() < entry.getKey().getStartcode()) {
                    this.servers[serverIndex] = entry.getKey();
                }
                this.regionsPerServer[serverIndex] = this.regionsPerServer[serverIndex] != null ? new int[entry.getValue().size() + this.regionsPerServer[serverIndex].length] : new int[entry.getValue().size()];
                this.serverIndicesSortedByRegionCount[serverIndex] = serverIndex;
            }
            for (Map.Entry<ServerName, List<HRegionInfo>> entry : clusterState.entrySet()) {
                serverIndex = this.serversToIndex.get(entry.getKey().getHostAndPort());
                regionPerServerIndex = 0;
                for (HRegionInfo region : entry.getValue()) {
                    void var6_11;
                    String tableName = region.getTable().getNameAsString();
                    Integer idx = this.tablesToIndex.get(tableName);
                    if (idx == null) {
                        this.tables.add(tableName);
                        idx = tableIndex;
                        this.tablesToIndex.put(tableName, tableIndex++);
                    }
                    this.regions[var6_11] = region;
                    this.regionIndexToServerIndex[var6_11] = serverIndex;
                    this.initialRegionIndexToServerIndex[var6_11] = serverIndex;
                    this.regionIndexToTableIndex[var6_11] = idx;
                    this.regionsPerServer[serverIndex][regionPerServerIndex++] = var6_11;
                    if (loads != null) {
                        Deque<RegionLoad> rl = loads.get(region.getRegionNameAsString());
                        if (rl == null) {
                            rl = loads.get(region.getEncodedName());
                        }
                        this.regionLoads[var6_11] = rl;
                    }
                    if (regionFinder != null) {
                        List<ServerName> loc = regionFinder.getTopBlockLocations(region);
                        this.regionLocations[var6_11] = new int[loc.size()];
                        for (int i2 = 0; i2 < loc.size(); ++i2) {
                            this.regionLocations[var6_11][i2] = loc.get(i2) == null ? -1 : (this.serversToIndex.get(loc.get(i2).getHostAndPort()) == null ? -1 : this.serversToIndex.get(loc.get(i2).getHostAndPort()));
                        }
                    }
                    ++var6_11;
                }
            }
            this.numTables = this.tables.size();
            this.numRegionsPerServerPerTable = new int[this.numServers][this.numTables];
            for (i = 0; i < this.numServers; ++i) {
                for (int j = 0; j < this.numTables; ++j) {
                    this.numRegionsPerServerPerTable[i][j] = 0;
                }
            }
            for (i = 0; i < this.regionIndexToServerIndex.length; ++i) {
                int[] nArray = this.numRegionsPerServerPerTable[this.regionIndexToServerIndex[i]];
                int n = this.regionIndexToTableIndex[i];
                nArray[n] = nArray[n] + 1;
            }
            this.numMaxRegionsPerTable = new int[this.numTables];
            for (serverIndex = 0; serverIndex < this.numRegionsPerServerPerTable.length; ++serverIndex) {
                for (tableIndex = 0; tableIndex < this.numRegionsPerServerPerTable[serverIndex].length; ++tableIndex) {
                    if (this.numRegionsPerServerPerTable[serverIndex][tableIndex] <= this.numMaxRegionsPerTable[tableIndex]) continue;
                    this.numMaxRegionsPerTable[tableIndex] = this.numRegionsPerServerPerTable[serverIndex][tableIndex];
                }
            }
        }

        public void moveOrSwapRegion(int lServer, int rServer, int lRegion, int rRegion) {
            if (rRegion >= 0 && lRegion >= 0) {
                this.regionMoved(rRegion, rServer, lServer);
                this.regionsPerServer[rServer] = this.replaceRegion(this.regionsPerServer[rServer], rRegion, lRegion);
                this.regionMoved(lRegion, lServer, rServer);
                this.regionsPerServer[lServer] = this.replaceRegion(this.regionsPerServer[lServer], lRegion, rRegion);
            } else if (rRegion >= 0) {
                this.regionMoved(rRegion, rServer, lServer);
                this.regionsPerServer[rServer] = this.removeRegion(this.regionsPerServer[rServer], rRegion);
                this.regionsPerServer[lServer] = this.addRegion(this.regionsPerServer[lServer], rRegion);
            } else if (lRegion >= 0) {
                this.regionMoved(lRegion, lServer, rServer);
                this.regionsPerServer[lServer] = this.removeRegion(this.regionsPerServer[lServer], lRegion);
                this.regionsPerServer[rServer] = this.addRegion(this.regionsPerServer[rServer], lRegion);
            }
        }

        void regionMoved(int regionIndex, int oldServerIndex, int newServerIndex) {
            this.regionIndexToServerIndex[regionIndex] = newServerIndex;
            if (this.initialRegionIndexToServerIndex[regionIndex] == newServerIndex) {
                --this.numMovedRegions;
                if (this.regions[regionIndex].isMetaRegion()) {
                    --this.numMovedMetaRegions;
                }
            } else if (this.initialRegionIndexToServerIndex[regionIndex] == oldServerIndex) {
                ++this.numMovedRegions;
                if (this.regions[regionIndex].isMetaRegion()) {
                    ++this.numMovedMetaRegions;
                }
            }
            int tableIndex = this.regionIndexToTableIndex[regionIndex];
            int[] nArray = this.numRegionsPerServerPerTable[oldServerIndex];
            int n = tableIndex;
            nArray[n] = nArray[n] - 1;
            int[] nArray2 = this.numRegionsPerServerPerTable[newServerIndex];
            int n2 = tableIndex;
            nArray2[n2] = nArray2[n2] + 1;
            if (this.numRegionsPerServerPerTable[newServerIndex][tableIndex] > this.numMaxRegionsPerTable[tableIndex]) {
                this.numRegionsPerServerPerTable[newServerIndex][tableIndex] = this.numMaxRegionsPerTable[tableIndex];
            } else if (this.numRegionsPerServerPerTable[oldServerIndex][tableIndex] + 1 == this.numMaxRegionsPerTable[tableIndex]) {
                for (int serverIndex = 0; serverIndex < this.numRegionsPerServerPerTable.length; ++serverIndex) {
                    if (this.numRegionsPerServerPerTable[serverIndex][tableIndex] <= this.numMaxRegionsPerTable[tableIndex]) continue;
                    this.numMaxRegionsPerTable[tableIndex] = this.numRegionsPerServerPerTable[serverIndex][tableIndex];
                }
            }
        }

        int[] removeRegion(int[] regions, int regionIndex) {
            int[] newRegions = new int[regions.length - 1];
            int i = 0;
            for (i = 0; i < regions.length && regions[i] != regionIndex; ++i) {
                newRegions[i] = regions[i];
            }
            System.arraycopy(regions, i + 1, newRegions, i, newRegions.length - i);
            return newRegions;
        }

        int[] addRegion(int[] regions, int regionIndex) {
            int[] newRegions = new int[regions.length + 1];
            System.arraycopy(regions, 0, newRegions, 0, regions.length);
            newRegions[newRegions.length - 1] = regionIndex;
            return newRegions;
        }

        int[] replaceRegion(int[] regions, int regionIndex, int newRegionIndex) {
            int i = 0;
            for (i = 0; i < regions.length; ++i) {
                if (regions[i] != regionIndex) continue;
                regions[i] = newRegionIndex;
                break;
            }
            return regions;
        }

        void sortServersByRegionCount() {
            Arrays.sort(this.serverIndicesSortedByRegionCount, this.numRegionsComparator);
        }

        int getNumRegions(int server) {
            return this.regionsPerServer[server].length;
        }

        @VisibleForTesting
        protected void setNumRegions(int numRegions) {
            this.numRegions = numRegions;
        }

        @VisibleForTesting
        protected void setNumMovedRegions(int numMovedRegions) {
            this.numMovedRegions = numMovedRegions;
        }

        @VisibleForTesting
        protected void setNumMovedMetaRegions(int numMovedMetaRegions) {
            this.numMovedMetaRegions = numMovedMetaRegions;
        }

        public String toString() {
            String desc = "Cluster{servers=[";
            for (ServerName sn : this.servers) {
                desc = desc + sn.getHostAndPort() + ", ";
            }
            desc = desc + ", serverIndicesSortedByRegionCount=" + Arrays.toString((Object[])this.serverIndicesSortedByRegionCount) + ", regionsPerServer=[";
            for (int[] r : this.regionsPerServer) {
                desc = desc + Arrays.toString(r);
            }
            desc = desc + "], numMaxRegionsPerTable=" + Arrays.toString(this.numMaxRegionsPerTable) + ", numRegions=" + this.numRegions + ", numServers=" + this.numServers + ", numTables=" + this.numTables + ", numMovedRegions=" + this.numMovedRegions + ", numMovedMetaRegions=" + this.numMovedMetaRegions + '}';
            return desc;
        }
    }
}

