/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FavoredNodesForRegion;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public interface RegionServerServices
extends OnlineRegions,
FavoredNodesForRegion,
PriorityFunction {
    public boolean isStopping();

    public HLog getWAL(HRegionInfo var1) throws IOException;

    public CompactionRequestor getCompactionRequester();

    public FlushRequester getFlushRequester();

    public RegionServerAccounting getRegionServerAccounting();

    public TableLockManager getTableLockManager();

    public void postOpenDeployTasks(PostOpenDeployContext var1, CatalogTracker var2) throws KeeperException, IOException;

    @Deprecated
    public void postOpenDeployTasks(HRegion var1, CatalogTracker var2) throws KeeperException, IOException;

    public boolean reportRegionStateTransition(RegionStateTransitionContext var1);

    @Deprecated
    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode var1, HRegionInfo ... var2);

    @Deprecated
    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode var1, long var2, HRegionInfo ... var4);

    public RpcServerInterface getRpcServer();

    public ConcurrentMap<byte[], Boolean> getRegionsInTransitionInRS();

    public FileSystem getFileSystem();

    public Leases getLeases();

    public ExecutorService getExecutorService();

    public CatalogTracker getCatalogTracker();

    public Map<String, HRegion> getRecoveringRegions();

    public ServerNonceManager getNonceManager();

    public boolean registerService(Service var1);

    public HeapMemoryManager getHeapMemoryManager();

    public double getCompactionPressure();

    public static class RegionStateTransitionContext {
        private final RegionServerStatusProtos.RegionStateTransition.TransitionCode code;
        private final long openSeqNum;
        private final long masterSystemTime;
        private final HRegionInfo[] hris;

        @InterfaceAudience.Private
        public RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, long masterSystemTime, HRegionInfo ... hris) {
            this.code = code;
            this.openSeqNum = openSeqNum;
            this.masterSystemTime = masterSystemTime;
            this.hris = hris;
        }

        public RegionServerStatusProtos.RegionStateTransition.TransitionCode getCode() {
            return this.code;
        }

        public long getOpenSeqNum() {
            return this.openSeqNum;
        }

        public long getMasterSystemTime() {
            return this.masterSystemTime;
        }

        public HRegionInfo[] getHris() {
            return this.hris;
        }
    }

    public static class PostOpenDeployContext {
        private final HRegion region;
        private final long masterSystemTime;

        @InterfaceAudience.Private
        public PostOpenDeployContext(HRegion region, long masterSystemTime) {
            this.region = region;
            this.masterSystemTime = masterSystemTime;
        }

        public HRegion getRegion() {
            return this.region;
        }

        public long getMasterSystemTime() {
            return this.masterSystemTime;
        }
    }
}

