/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class HBaseFsckRepair {
    public static final Log LOG = LogFactory.getLog(HBaseFsckRepair.class);

    public static void fixMultiAssignment(HBaseAdmin admin, HRegionInfo region, List<ServerName> servers) throws IOException, KeeperException, InterruptedException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        for (ServerName server : servers) {
            HBaseFsckRepair.closeRegionSilentlyAndWait(admin, server, actualRegion);
        }
        HBaseFsckRepair.forceOfflineInZK(admin, actualRegion);
    }

    public static void fixUnassigned(HBaseAdmin admin, HRegionInfo region) throws IOException, KeeperException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        HBaseFsckRepair.forceOfflineInZK(admin, actualRegion);
    }

    private static void forceOfflineInZK(HBaseAdmin admin, HRegionInfo region) throws ZooKeeperConnectionException, KeeperException, IOException {
        admin.assign(region.getRegionName());
    }

    public static void waitUntilAssigned(HBaseAdmin admin, HRegionInfo region) throws IOException, InterruptedException {
        long timeout = admin.getConfiguration().getLong("hbase.hbck.assign.timeout", 120000L);
        long expiration = timeout + EnvironmentEdgeManager.currentTimeMillis();
        while (EnvironmentEdgeManager.currentTimeMillis() < expiration) {
            try {
                Map rits = admin.getClusterStatus().getRegionsInTransition();
                if (rits.keySet() != null && !rits.keySet().contains(region.getEncodedName())) {
                    return;
                }
                LOG.info((Object)("Region still in transition, waiting for it to become assigned: " + region));
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception when waiting for region to become assigned, retrying", (Throwable)e);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + region + " failed to move out of " + "transition within timeout " + timeout + "ms");
    }

    public static void closeRegionSilentlyAndWait(HBaseAdmin admin, ServerName server, HRegionInfo region) throws IOException, InterruptedException {
        HConnection connection = admin.getConnection();
        AdminProtos.AdminService.BlockingInterface rs = connection.getAdmin(server);
        try {
            ProtobufUtil.closeRegion((AdminProtos.AdminService.BlockingInterface)rs, (ServerName)server, (byte[])region.getRegionName(), (boolean)false);
        }
        catch (IOException e) {
            LOG.warn((Object)("Exception when closing region: " + region.getRegionNameAsString()), (Throwable)e);
        }
        long timeout = admin.getConfiguration().getLong("hbase.hbck.close.timeout", 120000L);
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            try {
                HRegionInfo rsRegion = ProtobufUtil.getRegionInfo((AdminProtos.AdminService.BlockingInterface)rs, (byte[])region.getRegionName());
                if (rsRegion == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                if (ioe instanceof NotServingRegionException) {
                    return;
                }
                LOG.warn((Object)("Exception when retrieving regioninfo from: " + region.getRegionNameAsString()), (Throwable)ioe);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + region + " failed to close within" + " timeout " + timeout);
    }

    public static void fixMetaHoleOnline(Configuration conf, HRegionInfo hri) throws IOException {
        HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
        MetaEditor.addRegionToMeta(meta, hri);
        meta.close();
    }

    public static HRegion createHDFSRegionDir(Configuration conf, HRegionInfo hri, HTableDescriptor htd) throws IOException {
        Path root = FSUtils.getRootDir(conf);
        HRegion region = HRegion.createHRegion(hri, root, conf, htd, null);
        region.close();
        return region;
    }
}

