/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHColumnDescriptor {
    @Test
    public void testPb() throws Exception {
        HColumnDescriptor hcd = new HColumnDescriptor(HConstants.CATALOG_FAMILY).setInMemory(true).setScope(0).setBloomFilterType(BloomType.NONE);
        int v = 123;
        hcd.setBlocksize(123);
        hcd.setTimeToLive(123);
        hcd.setBlockCacheEnabled(false);
        hcd.setValue("a", "b");
        hcd.setMaxVersions(123);
        Assert.assertEquals((long)123L, (long)hcd.getMaxVersions());
        hcd.setMinVersions(123);
        Assert.assertEquals((long)123L, (long)hcd.getMinVersions());
        hcd.setKeepDeletedCells(KeepDeletedCells.TRUE);
        hcd.setInMemory(true);
        boolean inmemory = hcd.isInMemory();
        hcd.setScope(123);
        hcd.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
        hcd.setBloomFilterType(BloomType.ROW);
        hcd.setCompressionType(Compression.Algorithm.SNAPPY);
        hcd.setDFSReplication((short)123);
        byte[] bytes = hcd.toByteArray();
        HColumnDescriptor deserializedHcd = HColumnDescriptor.parseFrom((byte[])bytes);
        Assert.assertTrue((boolean)hcd.equals((Object)deserializedHcd));
        Assert.assertEquals((long)123L, (long)hcd.getBlocksize());
        Assert.assertEquals((long)123L, (long)hcd.getTimeToLive());
        Assert.assertEquals((Object)hcd.getValue("a"), (Object)deserializedHcd.getValue("a"));
        Assert.assertEquals((long)hcd.getMaxVersions(), (long)deserializedHcd.getMaxVersions());
        Assert.assertEquals((long)hcd.getMinVersions(), (long)deserializedHcd.getMinVersions());
        Assert.assertEquals((Object)hcd.getKeepDeletedCells(), (Object)deserializedHcd.getKeepDeletedCells());
        Assert.assertEquals((Object)inmemory, (Object)deserializedHcd.isInMemory());
        Assert.assertEquals((long)hcd.getScope(), (long)deserializedHcd.getScope());
        Assert.assertTrue((boolean)deserializedHcd.getCompressionType().equals((Object)Compression.Algorithm.SNAPPY));
        Assert.assertTrue((boolean)deserializedHcd.getDataBlockEncoding().equals((Object)DataBlockEncoding.FAST_DIFF));
        Assert.assertTrue((boolean)deserializedHcd.getBloomFilterType().equals((Object)BloomType.ROW));
        Assert.assertEquals((long)123L, (long)deserializedHcd.getDFSReplication());
    }

    @Test
    public void testHColumnDescriptorShouldThrowIAEWhenFamiliyNameEmpty() throws Exception {
        try {
            new HColumnDescriptor("".getBytes());
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Family name can not be empty", (Object)e.getLocalizedMessage());
        }
    }

    @Test
    public void testAddGetRemoveConfiguration() throws Exception {
        HColumnDescriptor desc = new HColumnDescriptor("foo");
        String key = "Some";
        String value = "value";
        desc.setConfiguration(key, value);
        Assert.assertEquals((Object)value, (Object)desc.getConfigurationValue(key));
        desc.removeConfiguration(key);
        Assert.assertEquals(null, (Object)desc.getConfigurationValue(key));
    }
}

