/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestZooKeeper {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniDFSCluster(2);
        TEST_UTIL.startMiniZKCluster();
        conf.setBoolean("dfs.support.append", true);
        conf.setInt("zookeeper.session.timeout", 1000);
        conf.setClass("hbase.master.loadbalancer.class", MockLoadBalancer.class, LoadBalancer.class);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniHBaseCluster(1, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() throws Exception {
        try {
            TEST_UTIL.shutdownMiniHBaseCluster();
        }
        finally {
            TEST_UTIL.getTestFileSystem().delete(FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), true);
            ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)"/hbase");
        }
    }

    private ZooKeeperWatcher getZooKeeperWatcher(HConnection c) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getterZK = c.getClass().getDeclaredMethod("getKeepAliveZooKeeperWatcher", new Class[0]);
        getterZK.setAccessible(true);
        return (ZooKeeperWatcher)getterZK.invoke((Object)c, new Object[0]);
    }

    public void testClientSessionExpired() throws Exception {
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.set("hbase.client.instance.id", "1111");
        HConnection connection = HConnectionManager.getConnection((Configuration)c);
        ZooKeeperWatcher connectionZK = this.getZooKeeperWatcher(connection);
        this.LOG.info((Object)("ZooKeeperWatcher= 0x" + Integer.toHexString(connectionZK.hashCode())));
        this.LOG.info((Object)("getRecoverableZooKeeper= 0x" + Integer.toHexString(connectionZK.getRecoverableZooKeeper().hashCode())));
        this.LOG.info((Object)("session=" + Long.toHexString(connectionZK.getRecoverableZooKeeper().getSessionId())));
        TEST_UTIL.expireSession(connectionZK);
        this.LOG.info((Object)("Before using zkw state=" + connectionZK.getRecoverableZooKeeper().getState()));
        try {
            connectionZK.getRecoverableZooKeeper().getZooKeeper().exists("/1/1", false);
        }
        catch (KeeperException ignored) {
            // empty catch block
        }
        ZooKeeper.States state = connectionZK.getRecoverableZooKeeper().getState();
        this.LOG.info((Object)("After using zkw state=" + state));
        this.LOG.info((Object)("session=" + Long.toHexString(connectionZK.getRecoverableZooKeeper().getSessionId())));
        long limit1 = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < limit1 && state != ZooKeeper.States.CLOSED) {
            state = connectionZK.getRecoverableZooKeeper().getState();
        }
        this.LOG.info((Object)("After using zkw loop=" + state));
        this.LOG.info((Object)"ZooKeeper should have timed out");
        this.LOG.info((Object)("session=" + Long.toHexString(connectionZK.getRecoverableZooKeeper().getSessionId())));
        ZooKeeperWatcher newConnectionZK = this.getZooKeeperWatcher(connection);
        ZooKeeper.States state2 = newConnectionZK.getRecoverableZooKeeper().getState();
        this.LOG.info((Object)("After new get state=" + state2));
        long limit2 = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < limit2 && state2 != ZooKeeper.States.CONNECTED && state2 != ZooKeeper.States.CONNECTING) {
            newConnectionZK = this.getZooKeeperWatcher(connection);
            state2 = newConnectionZK.getRecoverableZooKeeper().getState();
        }
        this.LOG.info((Object)("After new get state loop=" + state2));
        Assert.assertTrue((state2 == ZooKeeper.States.CONNECTED || state2 == ZooKeeper.States.CONNECTING ? 1 : 0) != 0);
        connection.close();
    }

    @Test(timeout=60000L)
    public void testRegionServerSessionExpired() throws Exception {
        this.LOG.info((Object)"Starting testRegionServerSessionExpired");
        int metaIndex = TEST_UTIL.getMiniHBaseCluster().getServerWithMeta();
        TEST_UTIL.expireRegionServerSession(metaIndex);
        this.testSanity("testRegionServerSessionExpired");
    }

    public void testMasterSessionExpired() throws Exception {
        this.LOG.info((Object)"Starting testMasterSessionExpired");
        TEST_UTIL.expireMasterSession();
        this.testSanity("testMasterSessionExpired");
    }

    @Test(timeout=60000L)
    public void testMasterZKSessionRecoveryFailure() throws Exception {
        this.LOG.info((Object)"Starting testMasterZKSessionRecoveryFailure");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
        Assert.assertFalse((boolean)m.isStopped());
        this.testSanity("testMasterZKSessionRecoveryFailure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSanity(String testName) throws Exception {
        String tableName = testName + "_" + System.currentTimeMillis();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
        HColumnDescriptor family = new HColumnDescriptor("fam");
        desc.addFamily(family);
        this.LOG.info((Object)("Creating table " + tableName));
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        try {
            admin.createTable(desc);
        }
        finally {
            admin.close();
        }
        HTable table = new HTable(new Configuration(TEST_UTIL.getConfiguration()), tableName);
        Put put = new Put(Bytes.toBytes((String)"testrow"));
        put.add(Bytes.toBytes((String)"fam"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"testdata"));
        this.LOG.info((Object)("Putting table " + tableName));
        table.put(put);
        table.close();
    }

    @Test
    public void testMultipleZK() throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HTable localMeta = new HTable(new Configuration(TEST_UTIL.getConfiguration()), TableName.META_TABLE_NAME);
        Configuration otherConf = new Configuration(TEST_UTIL.getConfiguration());
        otherConf.set("hbase.zookeeper.quorum", "127.0.0.1");
        HTable ipMeta = new HTable(otherConf, TableName.META_TABLE_NAME);
        byte[] row = new byte[]{114};
        localMeta.exists(new Get(row));
        ipMeta.exists(new Get(row));
        ZooKeeperWatcher z1 = this.getZooKeeperWatcher(HConnectionManager.getConnection((Configuration)localMeta.getConfiguration()));
        ZooKeeperWatcher z2 = this.getZooKeeperWatcher(HConnectionManager.getConnection((Configuration)otherConf));
        Assert.assertFalse((z1 == z2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)z1.getQuorum().equals(z2.getQuorum()));
        localMeta.close();
        ipMeta.close();
    }

    @Test
    public void testCreateWithParents() throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(new Configuration(TEST_UTIL.getConfiguration()), TestZooKeeper.class.getName(), null);
        byte[] expectedData = new byte[]{1, 2, 3};
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4/testCreateWithParents", (byte[])expectedData);
        byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4/testCreateWithParents");
        Assert.assertTrue((boolean)Bytes.equals((byte[])expectedData, (byte[])data));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)"/l1");
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/testCreateWithParents", (byte[])expectedData);
        data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)"/testCreateWithParents");
        Assert.assertTrue((boolean)Bytes.equals((byte[])expectedData, (byte[])data));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)"/testCreateWithParents");
    }

    @Test
    public void testZNodeDeletes() throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(new Configuration(TEST_UTIL.getConfiguration()), TestZooKeeper.class.getName(), null);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4");
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)"/l1/l2");
            Assert.fail((String)"We should not be able to delete if znode has childs");
        }
        catch (KeeperException ex) {
            Assert.assertNotNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4", null));
        }
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)"/l1/l2");
        Assert.assertNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4", null));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)"/l1/l2");
        ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)"/l1");
        Assert.assertNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSilentIsReallySilent() throws InterruptedException, KeeperException, IOException {
        Configuration c = TEST_UTIL.getConfiguration();
        String aclZnode = "/aclRoot";
        String quorumServers = ZKConfig.getZKQuorumServersString((Configuration)c);
        int sessionTimeout = 5000;
        ZooKeeper zk = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance);
        zk.addAuthInfo("digest", "hbase:rox".getBytes());
        ZooKeeperWatcher zk2 = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testCreateSilentIsReallySilent", null);
        Stat s = null;
        List oldACL = null;
        block18: while (true) {
            try {
                s = new Stat();
                oldACL = zk.getACL("/", s);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case OPERATIONTIMEOUT: {
                        this.LOG.warn((Object)"Possibly transient ZooKeeper exception", (Throwable)e);
                        Threads.sleep((long)100L);
                        continue block18;
                    }
                }
                throw e;
            }
            break;
        }
        block19: while (true) {
            try {
                zk.setACL("/", (List)ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case OPERATIONTIMEOUT: {
                        this.LOG.warn((Object)("Possibly transient ZooKeeper exception: " + (Object)((Object)e)));
                        Threads.sleep((long)100L);
                        continue block19;
                    }
                }
                throw e;
            }
            break;
        }
        block20: while (true) {
            try {
                zk.create(aclZnode, null, (List)ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case OPERATIONTIMEOUT: {
                        this.LOG.warn((Object)("Possibly transient ZooKeeper exception: " + (Object)((Object)e)));
                        Threads.sleep((long)100L);
                        continue block20;
                    }
                }
                throw e;
            }
            break;
        }
        zk.close();
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zk2, (String)aclZnode);
        ZooKeeper zk3 = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance);
        zk3.addAuthInfo("digest", "hbase:rox".getBytes());
        try {
            zk3.setACL("/", oldACL, -1);
        }
        finally {
            zk3.close();
        }
    }

    @Test
    public void testGetChildDataAndWatchForNewChildrenShouldNotThrowNPE() throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testGetChildDataAndWatchForNewChildrenShouldNotThrowNPE", null);
        ZKUtil.getChildDataAndWatchForNewChildren((ZooKeeperWatcher)zkw, (String)"/wrongNode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionAssignmentAfterMasterRecoveryDueToZKExpiry() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.startRegionServer();
        cluster.waitForActiveAndReadyMaster(10000L);
        HMaster m = cluster.getMaster();
        ZooKeeperWatcher zkw = m.getZooKeeperWatcher();
        int expectedNumOfListeners = zkw.getNumberOfListeners();
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        try {
            byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i"), Bytes.toBytes((String)"j")};
            String tableName = "testRegionAssignmentAfterMasterRecoveryDueToZKExpiry";
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
            htd.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
            admin.createTable(htd, (byte[][])SPLIT_KEYS);
            ZooKeeperWatcher zooKeeperWatcher = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zooKeeperWatcher);
            m.getZooKeeperWatcher().close();
            MockLoadBalancer.retainAssignCalled = false;
            m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
            Assert.assertFalse((boolean)m.isStopped());
            Assert.assertFalse((String)"Retain assignment should not be called", (boolean)MockLoadBalancer.retainAssignCalled);
            cluster.waitForActiveAndReadyMaster(10000L);
            Assert.assertEquals((long)expectedNumOfListeners, (long)zkw.getNumberOfListeners());
        }
        finally {
            admin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=240000L)
    public void testLogSplittingAfterMasterRecoveryDueToZKExpiry() throws IOException, KeeperException, InterruptedException {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.startRegionServer();
        HMaster m = cluster.getMaster();
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        HTable table = null;
        try {
            int numberOfPuts;
            byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"3"), Bytes.toBytes((String)"4"), Bytes.toBytes((String)"5")};
            String tableName = "testLogSplittingAfterMasterRecoveryDueToZKExpiry";
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
            HColumnDescriptor hcd = new HColumnDescriptor("col");
            htd.addFamily(hcd);
            admin.createTable(htd, (byte[][])SPLIT_KEYS);
            ZooKeeperWatcher zooKeeperWatcher = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
            ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zooKeeperWatcher);
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            for (numberOfPuts = 0; numberOfPuts < 6; ++numberOfPuts) {
                Put p = new Put(Bytes.toBytes((int)numberOfPuts));
                p.add(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"ql"), Bytes.toBytes((String)("value" + numberOfPuts)));
                table.put(p);
            }
            m.getZooKeeperWatcher().close();
            m.abort("Test recovery from zk session expired", (Throwable)new KeeperException.SessionExpiredException());
            Assert.assertFalse((boolean)m.isStopped());
            cluster.getRegionServer(0).abort("Aborting");
            Scan scan = new Scan();
            int numberOfRows = 0;
            ResultScanner scanner = table.getScanner(scan);
            Result[] result = scanner.next(1);
            while (result != null && result.length > 0) {
                ++numberOfRows;
                result = scanner.next(1);
            }
            Assert.assertEquals((String)"Number of rows should be equal to number of puts.", (long)numberOfPuts, (long)numberOfRows);
        }
        finally {
            if (table != null) {
                table.close();
            }
            admin.close();
        }
    }

    static class MockLoadBalancer
    extends SimpleLoadBalancer {
        static boolean retainAssignCalled = false;

        MockLoadBalancer() {
        }

        public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) {
            retainAssignCalled = true;
            return super.retainAssignment(regions, servers);
        }
    }
}

