/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCoprocessorHConnection {
    static final Log LOG = LogFactory.getLog(TestCoprocessorHConnection.class);
    public static final byte[] A = Bytes.toBytes((String)"a");
    private static final int ROWSIZE = 20;
    private static final byte[] rowSeperator1 = Bytes.toBytes((int)5);
    private static final byte[] rowSeperator2 = Bytes.toBytes((int)12);
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster = null;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util.startMiniCluster();
        cluster = util.getMiniHBaseCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHConnection() throws Exception {
        HBaseAdmin admin = util.getHBaseAdmin();
        TableName testTable = TableName.valueOf((String)"TestHConnection");
        try {
            if (admin.tableExists(testTable)) {
                admin.disableTable(testTable);
                admin.deleteTable(testTable);
            }
            HTableDescriptor htd = new HTableDescriptor(testTable);
            htd.addFamily(new HColumnDescriptor(A));
            htd.addCoprocessor(FooCoprocessor.class.getName());
            admin.createTable(htd, (byte[][])new byte[][]{rowSeperator1, rowSeperator2});
            util.waitUntilAllRegionsAssigned(testTable);
        }
        finally {
            admin.close();
        }
        HTable table = new HTable(util.getConfiguration(), testTable);
        try {
            for (long i = 0L; i < 20L; ++i) {
                byte[] iBytes = Bytes.toBytes((long)i);
                Put put = new Put(iBytes);
                put.add(A, A, iBytes);
                table.put(put);
            }
            HRegion firstRegion = cluster.getRegions(testTable).get(0);
            Coprocessor cp = firstRegion.getCoprocessorHost().findCoprocessor(FooCoprocessor.class.getName());
            Assert.assertNotNull((String)"FooCoprocessor coprocessor should be loaded", (Object)cp);
            FooCoprocessor fc = (FooCoprocessor)cp;
            byte[] regionStartKey = fc.getRegionStartKey();
            if (regionStartKey == null || regionStartKey.length <= 0) {
                regionStartKey = new byte[]{0};
            }
            Get get = new Get(regionStartKey);
            Result keyData = table.get(get);
            Result cpData = fc.getOnCoprocessorHConnection(testTable, regionStartKey);
            Assert.assertEquals((Object)keyData.getValue(A, A), (Object)cpData.getValue(A, A));
        }
        finally {
            table.close();
        }
    }

    public static class FooCoprocessor
    extends BaseRegionObserver {
        private HRegion region;
        private CoprocessorEnvironment env;

        public void start(CoprocessorEnvironment e) {
            this.region = ((RegionCoprocessorEnvironment)e).getRegion();
            this.env = e;
        }

        public void stop(CoprocessorEnvironment e) {
            this.region = null;
        }

        public byte[] getRegionStartKey() {
            return this.region.getStartKey();
        }

        public Result getOnCoprocessorHConnection(TableName tableName, byte[] key) throws IOException {
            HConnection conn = CoprocessorHConnection.getConnectionForEnvironment((CoprocessorEnvironment)this.env);
            Assert.assertTrue((boolean)(conn instanceof CoprocessorHConnection));
            HTableInterface hTable = conn.getTable(tableName);
            Get get = new Get(key);
            Result result = hTable.get(get);
            return result;
        }
    }
}

