/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.BaseRegionServerObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransaction;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerObserver {
    private static final Log LOG = LogFactory.getLog(TestRegionServerObserver.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoprocessorHooksInRegionsMerge() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = true;
        String TABLENAME = "testRegionServerObserver";
        String TABLENAME2 = "testRegionServerObserver_2";
        byte[] FAM = Bytes.toBytes((String)"fam");
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.coprocessor.regionserver.classes", CPRegionServerObserver.class, RegionServerObserver.class);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 1);
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            HRegionServer regionServer = cluster.getRegionServer(0);
            RegionServerCoprocessorHost cpHost = regionServer.getCoprocessorHost();
            Coprocessor coprocessor = cpHost.findCoprocessor(CPRegionServerObserver.class.getName());
            CPRegionServerObserver regionServerObserver = (CPRegionServerObserver)coprocessor;
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"testRegionServerObserver"));
            desc.addFamily(new HColumnDescriptor(FAM));
            admin.createTable(desc, (byte[][])new byte[][]{Bytes.toBytes((String)"row")});
            desc = new HTableDescriptor(TableName.valueOf((String)"testRegionServerObserver_2"));
            desc.addFamily(new HColumnDescriptor(FAM));
            admin.createTable(desc, (byte[][])new byte[][]{Bytes.toBytes((String)"row")});
            Assert.assertFalse((boolean)regionServerObserver.wasRegionMergeCalled());
            List regions = regionServer.getOnlineRegions(TableName.valueOf((String)"testRegionServerObserver"));
            admin.mergeRegions(((HRegion)regions.get(0)).getRegionInfo().getEncodedNameAsBytes(), ((HRegion)regions.get(1)).getRegionInfo().getEncodedNameAsBytes(), true);
            int regionsCount = regionServer.getOnlineRegions(TableName.valueOf((String)"testRegionServerObserver")).size();
            while (regionsCount != 1) {
                regionsCount = regionServer.getOnlineRegions(TableName.valueOf((String)"testRegionServerObserver")).size();
                Thread.sleep(1000L);
            }
            Assert.assertTrue((boolean)regionServerObserver.wasRegionMergeCalled());
            Assert.assertTrue((boolean)regionServerObserver.wasPreMergeCommit());
            Assert.assertTrue((boolean)regionServerObserver.wasPostMergeCommit());
            Assert.assertEquals((long)regionsCount, (long)1L);
            Assert.assertEquals((long)regionServer.getOnlineRegions(TableName.valueOf((String)"testRegionServerObserver_2")).size(), (long)1L);
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    public static class CPRegionServerObserver
    extends BaseRegionServerObserver {
        private RegionMergeTransaction rmt = null;
        private HRegion mergedRegion = null;
        private boolean bypass = false;
        private boolean preMergeCalled;
        private boolean preMergeBeforePONRCalled;
        private boolean preMergeAfterPONRCalled;
        private boolean preRollBackMergeCalled;
        private boolean postRollBackMergeCalled;
        private boolean postMergeCalled;

        public void enableBypass(boolean bypass) {
            this.bypass = bypass;
        }

        public void resetStates() {
            this.preMergeCalled = false;
            this.preMergeBeforePONRCalled = false;
            this.preMergeAfterPONRCalled = false;
            this.preRollBackMergeCalled = false;
            this.postRollBackMergeCalled = false;
            this.postMergeCalled = false;
        }

        public void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
            this.preMergeCalled = true;
        }

        public void preMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB, List<Mutation> metaEntries) throws IOException {
            this.preMergeBeforePONRCalled = true;
            RegionServerCoprocessorEnvironment environment = (RegionServerCoprocessorEnvironment)ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            List onlineRegions = rs.getOnlineRegions(TableName.valueOf((String)"testRegionServerObserver_2"));
            this.rmt = new RegionMergeTransaction((HRegion)onlineRegions.get(0), (HRegion)onlineRegions.get(1), true);
            if (!this.rmt.prepare((RegionServerServices)rs)) {
                LOG.error((Object)("Prepare for the region merge of table " + ((HRegion)onlineRegions.get(0)).getTableDesc().getNameAsString() + " failed. So returning null. "));
                ctx.bypass();
                return;
            }
            this.mergedRegion = this.rmt.stepsBeforePONR((Server)rs, (RegionServerServices)rs, false);
            this.rmt.prepareMutationsForMerge(this.mergedRegion.getRegionInfo(), regionA.getRegionInfo(), regionB.getRegionInfo(), rs.getServerName(), metaEntries);
            MetaEditor.mutateMetaTable((CatalogTracker)rs.getCatalogTracker(), metaEntries);
        }

        public void postMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB, HRegion mr) throws IOException {
            this.preMergeAfterPONRCalled = true;
            RegionServerCoprocessorEnvironment environment = (RegionServerCoprocessorEnvironment)ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            this.rmt.stepsAfterPONR((Server)rs, (RegionServerServices)rs, this.mergedRegion, null);
        }

        public void preRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
            this.preRollBackMergeCalled = true;
        }

        public void postRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
            this.postRollBackMergeCalled = true;
        }

        public void postMerge(ObserverContext<RegionServerCoprocessorEnvironment> c, HRegion regionA, HRegion regionB, HRegion mergedRegion) throws IOException {
            this.postMergeCalled = true;
        }

        public boolean wasPreMergeCalled() {
            return this.preMergeCalled;
        }

        public boolean wasPostMergeCalled() {
            return this.postMergeCalled;
        }

        public boolean wasPreMergeCommit() {
            return this.preMergeBeforePONRCalled;
        }

        public boolean wasPostMergeCommit() {
            return this.preMergeAfterPONRCalled;
        }

        public boolean wasPreRollBackMerge() {
            return this.preRollBackMergeCalled;
        }

        public boolean wasPostRollBackMerge() {
            return this.postRollBackMergeCalled;
        }

        public boolean wasRegionMergeCalled() {
            return this.preMergeCalled && this.postMergeCalled;
        }
    }
}

