/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.TestHFileWriterV2;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSeekBeforeWithInlineBlocks {
    private static final Log LOG = LogFactory.getLog(TestSeekBeforeWithInlineBlocks.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_KV = 10000;
    private static final int DATA_BLOCK_SIZE = 4096;
    private static final int BLOOM_BLOCK_SIZE = 1024;
    private static final int[] INDEX_CHUNK_SIZES = new int[]{131072, 65536, 4096, 1024};
    private static final int[] EXPECTED_NUM_LEVELS = new int[]{1, 1, 2, 3};
    private static final Random RAND = new Random(192537L);
    private static final byte[] FAM = Bytes.toBytes((String)"family");
    private FileSystem fs;
    private Configuration conf;

    @Test
    public void testMultiIndexLevelRandomHFileWithBlooms() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        for (int hfileVersion = 2; hfileVersion <= 3; ++hfileVersion) {
            this.conf.setInt("hfile.format.version", hfileVersion);
            this.fs = HFileSystem.get((Configuration)this.conf);
            for (BloomType bloomType : BloomType.values()) {
                for (int testI = 0; testI < INDEX_CHUNK_SIZES.length; ++testI) {
                    int indexBlockSize = INDEX_CHUNK_SIZES[testI];
                    int expectedNumLevels = EXPECTED_NUM_LEVELS[testI];
                    LOG.info((Object)String.format("Testing HFileVersion: %s, BloomType: %s, Index Levels: %s", hfileVersion, bloomType, expectedNumLevels));
                    this.conf.setInt("hfile.index.block.max.size", indexBlockSize);
                    this.conf.setInt("io.storefile.bloom.block.size", 1024);
                    byte[][] keys = new byte[10000][];
                    byte[][] values = new byte[10000][];
                    Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), String.format("testMultiIndexLevelRandomHFileWithBlooms-%s-%s-%s", hfileVersion, bloomType, testI));
                    this.conf.setFloat("hfile.block.cache.size", 0.0f);
                    CacheConfig cacheConf = new CacheConfig(this.conf);
                    HFileContext meta = new HFileContextBuilder().withBlockSize(4096).build();
                    StoreFile.Writer storeFileWriter = new StoreFile.WriterBuilder(this.conf, cacheConf, this.fs).withFilePath(hfilePath).withFileContext(meta).withBloomType(bloomType).build();
                    for (int i = 0; i < 10000; ++i) {
                        byte[] row = TestHFileWriterV2.randomOrderedKey(RAND, i);
                        byte[] qual = TestHFileWriterV2.randomRowOrQualifier(RAND);
                        byte[] value = TestHFileWriterV2.randomValue(RAND);
                        KeyValue kv = new KeyValue(row, FAM, qual, value);
                        storeFileWriter.append(kv);
                        keys[i] = kv.getKey();
                        values[i] = value;
                    }
                    storeFileWriter.close();
                    HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)hfilePath, (CacheConfig)cacheConf, (Configuration)this.conf);
                    Assert.assertEquals((long)expectedNumLevels, (long)reader.getTrailer().getNumDataIndexLevels());
                    for (boolean pread : new boolean[]{false, true}) {
                        int i;
                        HFileScanner scanner = reader.getScanner(true, pread);
                        this.checkNoSeekBefore(keys, scanner, 0);
                        for (i = 1; i < 10000; ++i) {
                            this.checkSeekBefore(keys, scanner, i);
                            this.checkKeyValue("i=" + i, keys[i - 1], values[i - 1], scanner.getKey(), scanner.getValue());
                        }
                        Assert.assertTrue((boolean)scanner.seekTo());
                        for (i = 9999; i >= 1; --i) {
                            this.checkSeekBefore(keys, scanner, i);
                            this.checkKeyValue("i=" + i, keys[i - 1], values[i - 1], scanner.getKey(), scanner.getValue());
                        }
                        this.checkNoSeekBefore(keys, scanner, 0);
                    }
                    reader.close();
                }
            }
        }
    }

    private void checkSeekBefore(byte[][] keys, HFileScanner scanner, int i) throws IOException {
        Assert.assertEquals((String)("Failed to seek to the key before #" + i + " (" + Bytes.toStringBinary((byte[])keys[i]) + ")"), (Object)true, (Object)scanner.seekBefore(keys[i]));
    }

    private void checkNoSeekBefore(byte[][] keys, HFileScanner scanner, int i) throws IOException {
        Assert.assertEquals((String)("Incorrectly succeeded in seeking to before first key (" + Bytes.toStringBinary((byte[])keys[i]) + ")"), (Object)false, (Object)scanner.seekBefore(keys[i]));
    }

    private void assertArrayEqualsBuffer(String msgPrefix, byte[] arr, ByteBuffer buf) {
        Assert.assertEquals((String)(msgPrefix + ": expected " + Bytes.toStringBinary((byte[])arr) + ", actual " + Bytes.toStringBinary((ByteBuffer)buf)), (long)0L, (long)Bytes.compareTo((byte[])arr, (int)0, (int)arr.length, (byte[])buf.array(), (int)buf.arrayOffset(), (int)buf.limit()));
    }

    private void checkKeyValue(String msgPrefix, byte[] expectedKey, byte[] expectedValue, ByteBuffer keyRead, ByteBuffer valueRead) {
        if (!msgPrefix.isEmpty()) {
            msgPrefix = msgPrefix + ". ";
        }
        this.assertArrayEqualsBuffer(msgPrefix + "Invalid key", expectedKey, keyRead);
        this.assertArrayEqualsBuffer(msgPrefix + "Invalid value", expectedValue, valueRead);
    }
}

