/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcScheduler;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandlerImpl;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestSimpleRpcScheduler {
    private final RpcScheduler.Context CONTEXT = new RpcScheduler.Context(){

        public InetSocketAddress getListenerAddress() {
            return InetSocketAddress.createUnresolved("127.0.0.1", 1000);
        }
    };
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
    }

    @Test
    public void testBasic() throws IOException, InterruptedException {
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(this.conf, 10, 0, 0, qosFunction, null, 0);
        scheduler.init(this.CONTEXT);
        scheduler.start();
        CallRunner task = this.createMockTask();
        task.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
        scheduler.dispatch(task);
        ((CallRunner)Mockito.verify((Object)task, (VerificationMode)Mockito.timeout((int)1000))).run();
        scheduler.stop();
    }

    @Test
    public void testHandlerIsolation() throws IOException, InterruptedException {
        CallRunner generalTask = this.createMockTask();
        CallRunner priorityTask = this.createMockTask();
        CallRunner replicationTask = this.createMockTask();
        ImmutableList tasks = ImmutableList.of((Object)generalTask, (Object)priorityTask, (Object)replicationTask);
        ImmutableMap qos = ImmutableMap.of((Object)generalTask, (Object)0, (Object)priorityTask, (Object)101, (Object)replicationTask, (Object)5);
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        final HashMap handlerThreads = Maps.newHashMap();
        final CountDownLatch countDownLatch = new CountDownLatch(tasks.size());
        Answer<Void> answerToRun = new Answer<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Map map = handlerThreads;
                synchronized (map) {
                    handlerThreads.put((CallRunner)invocationOnMock.getMock(), Thread.currentThread());
                }
                countDownLatch.countDown();
                return null;
            }
        };
        for (CallRunner task : tasks) {
            task.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
            ((CallRunner)Mockito.doAnswer((Answer)answerToRun).when((Object)task)).run();
        }
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(this.conf, 1, 1, 1, qosFunction, null, 100);
        scheduler.init(this.CONTEXT);
        scheduler.start();
        for (CallRunner task : tasks) {
            Mockito.when((Object)qosFunction.getPriority((RPCProtos.RequestHeader)Matchers.anyObject(), (Message)Matchers.anyObject())).thenReturn(qos.get(task));
            scheduler.dispatch(task);
        }
        for (CallRunner task : tasks) {
            ((CallRunner)Mockito.verify((Object)task, (VerificationMode)Mockito.timeout((int)1000))).run();
        }
        scheduler.stop();
        countDownLatch.await();
        Assert.assertEquals((long)3L, (long)ImmutableSet.copyOf(handlerThreads.values()).size());
    }

    private CallRunner createMockTask() {
        RpcServer.Call call = (RpcServer.Call)Mockito.mock(RpcServer.Call.class);
        CallRunner task = (CallRunner)Mockito.mock(CallRunner.class);
        Mockito.when((Object)task.getCall()).thenReturn((Object)call);
        return task;
    }
}

