/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.BufferedHTable;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MediumTests.class})
public class TestBufferedHTable {
    public static final Configuration CONF = HBaseConfiguration.create();
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(CONF);
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] QUAL = Bytes.toBytes((String)"qual");
    private static final byte[] VAL = Bytes.toBytes((String)"val");
    private static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final byte[] ROW3 = Bytes.toBytes((String)"row3");
    private static final byte[] ROW4 = Bytes.toBytes((String)"row4");
    @Rule
    public TestTableName name = new TestTableName();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void startMiniCluster() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void shutdownMiniCluster() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMutationBuffering() throws IOException {
        TEST_UTIL.createTable(this.name.getTableName(), CF);
        BufferedHTable table = null;
        ResultScanner scanner = null;
        try {
            table = this.createBufferedHTable();
            Put put1 = this.createPut(ROW1);
            table.put(put1);
            Delete delete2 = new Delete(ROW2);
            table.delete(delete2);
            Put put2 = this.createPut(ROW2);
            Put put3 = this.createPut(ROW3);
            table.put(Arrays.asList(put2, put3));
            Delete delete1 = new Delete(ROW1);
            Delete delete3 = new Delete(ROW3);
            table.delete(Arrays.asList(delete1, delete3));
            List buffer = table.getWriteBuffer();
            List<Mutation> expected = Arrays.asList(put1, delete2, put2, put3, delete1, delete3);
            Assert.assertEquals((long)expected.size(), (long)buffer.size());
            for (int i = 0; i < buffer.size(); ++i) {
                Assert.assertEquals((Object)expected.get(i), buffer.get(i));
            }
            table.put(this.createPut(ROW4));
            table.setWriteBufferSize(0L);
            Assert.assertEquals((long)0L, (long)buffer.size());
            Assert.assertEquals((long)0L, (long)table.getCurrentWriteBufferSize());
            scanner = table.getScanner(new Scan());
            for (Result result : scanner) {
                Assert.assertArrayEquals((byte[])ROW4, (byte[])result.getRow());
            }
            scanner.close();
            table.delete(new Delete(ROW4));
            scanner = table.getScanner(new Scan());
            Assert.assertNull((Object)scanner.next());
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeletesAfterCloseNotAllowed() throws IOException {
        TEST_UTIL.createTable(this.name.getTableName(), CF);
        BufferedHTable table = null;
        try {
            table = this.createBufferedHTable();
            table.close();
            this.thrown.expect(IllegalStateException.class);
            table.delete(new Delete(ROW1));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    private BufferedHTable createBufferedHTable() throws IOException {
        BufferedHTable table = new BufferedHTable(CONF, this.name.getTableName().getName());
        table.setAutoFlush(false, false);
        return table;
    }

    private Put createPut(byte[] row) throws IOException {
        Put put = new Put(row);
        put.add(CF, QUAL, VAL);
        return put;
    }
}

