/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class TestTableInputFormatScanBase {
    static final Log LOG = LogFactory.getLog(TestTableInputFormatScanBase.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final byte[] TABLE_NAME = Bytes.toBytes((String)"scantest");
    static final byte[] INPUT_FAMILY = Bytes.toBytes((String)"contents");
    static final String KEY_STARTROW = "startRow";
    static final String KEY_LASTROW = "stpRow";
    private static HTable table = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.setProperty("hbase.tests.use.shortcircuit.reads", "false");
        TEST_UTIL.enableDebug(TableInputFormat.class);
        TEST_UTIL.enableDebug(TableInputFormatBase.class);
        TEST_UTIL.startMiniCluster(3);
        table = TEST_UTIL.createTable(TABLE_NAME, INPUT_FAMILY);
        TEST_UTIL.createMultiRegions(table, INPUT_FAMILY);
        TEST_UTIL.loadTable(table, INPUT_FAMILY, false);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    protected void testScanFromConfiguration(String start, String stop, String last) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "ScanFromConfig" + (start != null ? start.toUpperCase() : "Empty") + "To" + (stop != null ? stop.toUpperCase() : "Empty");
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.set("hbase.mapreduce.inputtable", Bytes.toString((byte[])TABLE_NAME));
        c.set("hbase.mapreduce.scan.column.family", Bytes.toString((byte[])INPUT_FAMILY));
        c.set(KEY_STARTROW, start != null ? start : "");
        c.set(KEY_LASTROW, last != null ? last : "");
        if (start != null) {
            c.set("hbase.mapreduce.scan.row.start", start);
        }
        if (stop != null) {
            c.set("hbase.mapreduce.scan.row.stop", stop);
        }
        Job job = new Job(c, jobName);
        job.setMapperClass(ScanMapper.class);
        job.setReducerClass(ScanReducer.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(ImmutableBytesWritable.class);
        job.setInputFormatClass(TableInputFormat.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(job.getJobName()));
        TableMapReduceUtil.addDependencyJars((Job)job);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
    }

    protected void testScan(String start, String stop, String last) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "Scan" + (start != null ? start.toUpperCase() : "Empty") + "To" + (stop != null ? stop.toUpperCase() : "Empty");
        LOG.info((Object)("Before map/reduce startup - job " + jobName));
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        Scan scan = new Scan();
        scan.addFamily(INPUT_FAMILY);
        if (start != null) {
            scan.setStartRow(Bytes.toBytes((String)start));
        }
        c.set(KEY_STARTROW, start != null ? start : "");
        if (stop != null) {
            scan.setStopRow(Bytes.toBytes((String)stop));
        }
        c.set(KEY_LASTROW, last != null ? last : "");
        LOG.info((Object)("scan before: " + scan));
        Job job = new Job(c, jobName);
        TableMapReduceUtil.initTableMapperJob((String)Bytes.toString((byte[])TABLE_NAME), (Scan)scan, ScanMapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (Job)job);
        job.setReducerClass(ScanReducer.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(job.getJobName()));
        LOG.info((Object)("Started " + job.getJobName()));
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        LOG.info((Object)("After map/reduce completion - job " + jobName));
    }

    public void testNumOfSplits(String ratio, int expectedNumOfSplits) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "TestJobForNumOfSplits";
        LOG.info((Object)("Before map/reduce startup - job " + jobName));
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        Scan scan = new Scan();
        scan.addFamily(INPUT_FAMILY);
        c.set("hbase.mapreduce.input.autobalance", "true");
        c.set("hbase.mapreduce.input.autobalance.maxskewratio", ratio);
        c.set(KEY_STARTROW, "");
        c.set(KEY_LASTROW, "");
        Job job = new Job(c, jobName);
        TableMapReduceUtil.initTableMapperJob((String)Bytes.toString((byte[])TABLE_NAME), (Scan)scan, ScanMapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (Job)job);
        TableInputFormat tif = new TableInputFormat();
        tif.setConf(job.getConfiguration());
        Assert.assertEquals((Object)new String(TABLE_NAME), (Object)new String(table.getTableName()));
        List splits = tif.getSplits((JobContext)job);
        Assert.assertEquals((long)expectedNumOfSplits, (long)splits.size());
    }

    public void testGetSplitKey(byte[] startKey, byte[] endKey, byte[] splitKey, boolean isText) {
        byte[] result = TableInputFormatBase.getSplitKey((byte[])startKey, (byte[])endKey, (boolean)isText);
        Assert.assertArrayEquals((byte[])splitKey, (byte[])result);
    }

    public static class ScanReducer
    extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, NullWritable> {
        private String first = null;
        private String last = null;

        protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (ImmutableBytesWritable value : values) {
                String val = Bytes.toStringBinary((byte[])value.get());
                LOG.info((Object)("reduce: key[" + count + "] -> " + Bytes.toStringBinary((byte[])key.get()) + ", value -> " + val));
                if (this.first == null) {
                    this.first = val;
                }
                this.last = val;
                ++count;
            }
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration c = context.getConfiguration();
            String startRow = c.get(TestTableInputFormatScanBase.KEY_STARTROW);
            String lastRow = c.get(TestTableInputFormatScanBase.KEY_LASTROW);
            LOG.info((Object)("cleanup: first -> \"" + this.first + "\", start row -> \"" + startRow + "\""));
            LOG.info((Object)("cleanup: last -> \"" + this.last + "\", last row -> \"" + lastRow + "\""));
            if (startRow != null && startRow.length() > 0) {
                Assert.assertEquals((Object)startRow, (Object)this.first);
            }
            if (lastRow != null && lastRow.length() > 0) {
                Assert.assertEquals((Object)lastRow, (Object)this.last);
            }
        }
    }

    public static class ScanMapper
    extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            NavigableMap cf = value.getMap();
            if (!cf.containsKey(INPUT_FAMILY)) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString((byte[])INPUT_FAMILY) + "'.");
            }
            String val = Bytes.toStringBinary((byte[])value.getValue(INPUT_FAMILY, null));
            LOG.info((Object)("map: key -> " + Bytes.toStringBinary((byte[])key.get()) + ", value -> " + val));
            context.write((Object)key, (Object)key);
        }
    }
}

