/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestStochasticLoadBalancer
extends BalancerTestBase {
    public static final String REGION_KEY = "testRegion";
    private static StochasticLoadBalancer loadBalancer;
    private static final Log LOG;
    int[] largeCluster = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56};
    int[][] clusterStateMocks = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {1, 1}, {0, 1}, {10, 1}, {514, 1432}, {48, 53}, {0, 1, 2}, {1, 2, 3}, {0, 2, 2}, {0, 3, 0}, {0, 4, 0}, {20, 20, 0}, {0, 1, 2, 3}, {4, 0, 0, 0}, {5, 0, 0, 0}, {6, 6, 0, 0}, {6, 2, 0, 0}, {6, 1, 0, 0}, {6, 0, 0, 0}, {4, 4, 4, 7}, {4, 4, 4, 8}, {0, 0, 0, 7}, {1, 1, 1, 1, 4}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {6, 6, 5, 6, 6, 6, 6, 6, 6, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 10}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 123}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 155}, {10, 7, 12, 8, 11, 10, 9, 14}, {13, 14, 6, 10, 10, 10, 8, 10}, {130, 14, 60, 10, 100, 10, 80, 10}, {130, 140, 60, 100, 100, 100, 80, 100}, this.largeCluster};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 0.75f);
        conf.setFloat("hbase.regions.slop", 0.0f);
        loadBalancer = new StochasticLoadBalancer();
        loadBalancer.setConf(conf);
    }

    @Test
    public void testKeepRegionLoad() throws Exception {
        RegionLoad rl;
        ServerName sn = ServerName.valueOf((String)"test:8080", (long)100L);
        int numClusterStatusToAdd = 20000;
        for (int i = 0; i < numClusterStatusToAdd; ++i) {
            ServerLoad sl = (ServerLoad)Mockito.mock(ServerLoad.class);
            rl = (RegionLoad)Mockito.mock(RegionLoad.class);
            Mockito.when((Object)rl.getStores()).thenReturn((Object)i);
            TreeMap<byte[], RegionLoad> regionLoadMap = new TreeMap<byte[], RegionLoad>(Bytes.BYTES_COMPARATOR);
            regionLoadMap.put(Bytes.toBytes((String)REGION_KEY), rl);
            Mockito.when((Object)sl.getRegionsLoad()).thenReturn(regionLoadMap);
            ClusterStatus clusterStatus = (ClusterStatus)Mockito.mock(ClusterStatus.class);
            Mockito.when((Object)clusterStatus.getServers()).thenReturn(Arrays.asList(sn));
            Mockito.when((Object)clusterStatus.getLoad(sn)).thenReturn((Object)sl);
            loadBalancer.setClusterStatus(clusterStatus);
        }
        Assert.assertTrue((TestStochasticLoadBalancer.loadBalancer.loads.get(REGION_KEY) != null ? 1 : 0) != 0);
        Assert.assertTrue((((Deque)TestStochasticLoadBalancer.loadBalancer.loads.get(REGION_KEY)).size() == 15 ? 1 : 0) != 0);
        Queue loads = (Queue)TestStochasticLoadBalancer.loadBalancer.loads.get(REGION_KEY);
        int i = 0;
        while (loads.size() > 0) {
            rl = (RegionLoad)loads.remove();
            Assert.assertEquals((long)(i + (numClusterStatusToAdd - 15)), (long)rl.getStores());
            ++i;
        }
    }

    @Test
    public void testBalanceCluster() throws Exception {
        for (int[] mockCluster : this.clusterStateMocks) {
            Map<ServerName, List<HRegionInfo>> servers = this.mockClusterServers(mockCluster);
            List<ServerAndLoad> list = this.convertToList(servers);
            LOG.info((Object)("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list)));
            List plans = loadBalancer.balanceCluster(servers);
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, servers);
            LOG.info((Object)("Mock Balance : " + this.printMock(balancedCluster)));
            this.assertClusterAsBalanced(balancedCluster);
            List secondPlans = loadBalancer.balanceCluster(servers);
            Assert.assertNull((Object)secondPlans);
            for (Map.Entry<ServerName, List<HRegionInfo>> entry : servers.entrySet()) {
                this.returnRegions(entry.getValue());
                this.returnServer(entry.getKey());
            }
        }
    }

    @Test
    public void testMoveCost() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.MoveCostFunction costFunction = new StochasticLoadBalancer.MoveCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BaseLoadBalancer.Cluster cluster = this.mockCluster(mockCluster);
            double cost = costFunction.cost(cluster);
            Assert.assertEquals((double)0.0, (double)cost, (double)0.001);
            cluster.setNumRegions(190);
            cluster.setNumMovedRegions(10);
            cost = costFunction.cost(cluster);
            Assert.assertEquals((double)0.05f, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(100);
            cost = costFunction.cost(cluster);
            Assert.assertEquals((double)0.5, (double)cost, (double)0.001);
            cluster.setNumRegions(10000);
            cluster.setNumMovedRegions(250);
            cost = costFunction.cost(cluster);
            Assert.assertEquals((double)0.1f, (double)cost, (double)0.01);
            cluster.setNumMovedRegions(1250);
            cost = costFunction.cost(cluster);
            Assert.assertEquals((double)0.5, (double)cost, (double)0.01);
            cluster.setNumMovedRegions(2500);
            cluster.setNumMovedMetaRegions(1);
            cost = costFunction.cost(cluster);
            Assert.assertEquals((double)1.0, (double)cost, (double)0.01);
        }
    }

    @Test
    public void testSkewCost() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.RegionCountSkewCostFunction costFunction = new StochasticLoadBalancer.RegionCountSkewCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            double cost = costFunction.cost(this.mockCluster(mockCluster));
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
        Assert.assertEquals((double)0.0, (double)costFunction.cost(this.mockCluster(new int[]{0, 0, 0, 0, 1})), (double)0.01);
        Assert.assertEquals((double)0.0, (double)costFunction.cost(this.mockCluster(new int[]{0, 0, 0, 1, 1})), (double)0.01);
        Assert.assertEquals((double)0.0, (double)costFunction.cost(this.mockCluster(new int[]{0, 0, 1, 1, 1})), (double)0.01);
        Assert.assertEquals((double)0.0, (double)costFunction.cost(this.mockCluster(new int[]{0, 1, 1, 1, 1})), (double)0.01);
        Assert.assertEquals((double)0.0, (double)costFunction.cost(this.mockCluster(new int[]{1, 1, 1, 1, 1})), (double)0.01);
        Assert.assertEquals((double)0.0, (double)costFunction.cost(this.mockCluster(new int[]{10, 10, 10, 10, 10})), (double)0.01);
        Assert.assertEquals((double)1.0, (double)costFunction.cost(this.mockCluster(new int[]{10000, 0, 0, 0, 0})), (double)0.01);
    }

    @Test
    public void testTableSkewCost() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.TableSkewCostFunction costFunction = new StochasticLoadBalancer.TableSkewCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BaseLoadBalancer.Cluster cluster = this.mockCluster(mockCluster);
            double cost = costFunction.cost(cluster);
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCostFromArray() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.MemstoreSizeCostFunction costFunction = new StochasticLoadBalancer.MemstoreSizeCostFunction(conf);
        double[] statOne = new double[100];
        for (int i = 0; i < 100; ++i) {
            statOne[i] = 10.0;
        }
        Assert.assertEquals((double)0.0, (double)costFunction.costFromArray(statOne), (double)0.01);
        double[] statTwo = new double[101];
        for (int i = 0; i < 100; ++i) {
            statTwo[i] = 0.0;
        }
        statTwo[100] = 101.0;
        Assert.assertEquals((double)1.0, (double)costFunction.costFromArray(statTwo), (double)0.01);
        double[] statThree = new double[200];
        for (int i = 0; i < 100; ++i) {
            statThree[i] = 0.0;
            statThree[i + 100] = 100.0;
        }
        Assert.assertEquals((double)0.5, (double)costFunction.costFromArray(statThree), (double)0.01);
    }

    @Test(timeout=60000L)
    public void testLosingRs() throws Exception {
        int numNodes = 3;
        int numRegions = 20;
        int numRegionsPerServer = 3;
        int numTables = 2;
        Map<ServerName, List<HRegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, numTables);
        List<ServerAndLoad> list = this.convertToList(serverMap);
        List plans = loadBalancer.balanceCluster(serverMap);
        Assert.assertNotNull((Object)plans);
        List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, serverMap);
        this.assertClusterAsBalanced(balancedCluster);
        ServerName sn = serverMap.keySet().toArray(new ServerName[serverMap.size()])[0];
        ServerName deadSn = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)(sn.getStartcode() - 100L));
        serverMap.put(deadSn, new ArrayList(0));
        plans = loadBalancer.balanceCluster(serverMap);
        Assert.assertNull((Object)plans);
    }

    @Test(timeout=60000L)
    public void testSmallCluster() {
        int numNodes = 10;
        int numRegions = 1000;
        int numRegionsPerServer = 40;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, numTables, true);
    }

    @Test(timeout=60000L)
    public void testSmallCluster2() {
        int numNodes = 20;
        int numRegions = 2000;
        int numRegionsPerServer = 40;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, numTables, true);
    }

    @Test(timeout=60000L)
    public void testSmallCluster3() {
        int numNodes = 20;
        int numRegions = 2000;
        int numRegionsPerServer = 1;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, numTables, false);
    }

    @Test(timeout=800000L)
    public void testMidCluster() {
        int numNodes = 100;
        int numRegions = 10000;
        int numRegionsPerServer = 60;
        int numTables = 40;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, numTables, true);
    }

    @Test(timeout=800000L)
    public void testMidCluster2() {
        int numNodes = 200;
        int numRegions = 100000;
        int numRegionsPerServer = 40;
        int numTables = 400;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, numTables, false);
    }

    @Test(timeout=800000L)
    public void testMidCluster3() {
        int numNodes = 100;
        int numRegions = 2000;
        int numRegionsPerServer = 9;
        int numTables = 110;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, numTables, true);
    }

    @Test
    public void testLargeCluster() {
        int numNodes = 1000;
        int numRegions = 100000;
        int numRegionsPerServer = 80;
        int numTables = 100;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, numTables, true);
    }

    protected void testWithCluster(int numNodes, int numRegions, int numRegionsPerServer, int numTables, boolean assertFullyBalanced) {
        Map<ServerName, List<HRegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, numTables);
        List<ServerAndLoad> list = this.convertToList(serverMap);
        LOG.info((Object)("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list)));
        List plans = loadBalancer.balanceCluster(serverMap);
        Assert.assertNotNull((Object)plans);
        if (assertFullyBalanced) {
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, serverMap);
            LOG.info((Object)("Mock Balance : " + this.printMock(balancedCluster)));
            this.assertClusterAsBalanced(balancedCluster);
            List secondPlans = loadBalancer.balanceCluster(serverMap);
            Assert.assertNull((Object)secondPlans);
        }
    }

    private Map<ServerName, List<HRegionInfo>> createServerMap(int numNodes, int numRegions, int numRegionsPerServer, int numTables) {
        int[] cluster = new int[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            cluster[i] = numRegionsPerServer;
        }
        cluster[cluster.length - 1] = numRegions - (cluster.length - 1) * numRegionsPerServer;
        return this.mockClusterServers(cluster, numTables);
    }

    static {
        LOG = LogFactory.getLog(TestStochasticLoadBalancer.class);
    }
}

