/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestLogsCleaner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testLogCleaning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        long ttl = 10000L;
        conf.setLong("hbase.master.logcleaner.ttl", ttl);
        conf.setBoolean("hbase.replication", true);
        Replication.decorateMasterConfiguration((Configuration)conf);
        DummyServer server = new DummyServer();
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)server.getZooKeeper(), (Configuration)conf, (Abortable)server);
        repQueues.init(server.getServerName().toString());
        final Path oldLogDir = new Path(TEST_UTIL.getDataTestDir(), "oldWALs");
        String fakeMachineName = URLEncoder.encode(server.getServerName().toString(), "UTF8");
        final FileSystem fs = FileSystem.get((Configuration)conf);
        long now = System.currentTimeMillis();
        fs.delete(oldLogDir, true);
        fs.mkdirs(oldLogDir);
        fs.createNewFile(new Path(oldLogDir, "a"));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + "a"));
        System.out.println("Now is: " + now);
        for (int i = 1; i < 31; ++i) {
            Path fileName = new Path(oldLogDir, fakeMachineName + "." + (now - (long)i));
            fs.createNewFile(fileName);
            if (i % 10 != 1) continue;
            repQueues.addLog(fakeMachineName, fileName.getName());
            System.out.println("Replication log file: " + fileName);
        }
        Thread.sleep(ttl);
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + now));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + (now + 10000L)));
        for (FileStatus stat : fs.listStatus(oldLogDir)) {
            System.out.println(stat.getPath().toString());
        }
        Assert.assertEquals((long)34L, (long)fs.listStatus(oldLogDir).length);
        LogCleaner cleaner = new LogCleaner(1000, (Stoppable)server, conf, fs, oldLogDir);
        cleaner.chore();
        TEST_UTIL.waitFor(1000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return 5 == fs.listStatus(oldLogDir).length;
            }
        });
        for (FileStatus file : fs.listStatus(oldLogDir)) {
            System.out.println("Kept log files: " + file.getPath().getName());
        }
    }

    @Test(timeout=5000L)
    public void testZnodeCversionChange() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        cleaner.setConf(conf);
        ReplicationQueuesClient rqcMock = (ReplicationQueuesClient)Mockito.mock(ReplicationQueuesClient.class);
        Mockito.when((Object)rqcMock.getQueuesZNodeCversion()).thenReturn((Object)1, (Object[])new Integer[]{2, 3, 4});
        Field rqc = ReplicationLogCleaner.class.getDeclaredField("replicationQueues");
        rqc.setAccessible(true);
        rqc.set(cleaner, rqcMock);
        cleaner.getDeletableFiles(new LinkedList());
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        public ZooKeeperWatcher getZooKeeper() {
            try {
                return new ZooKeeperWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CatalogTracker getCatalogTracker() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"regionserver,60020,000000");
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }
    }
}

