/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestFlushRegionEntry {
    @BeforeClass
    public static void setUp() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        edge.setValue(12345L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
    }

    @AfterClass
    public static void teardown() {
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testFlushRegionEntryEquality() {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)"TestTable"));
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)hri.getRegionName()).when((Object)r)).getRegionName();
        MemStoreFlusher.FlushRegionEntry entry = new MemStoreFlusher.FlushRegionEntry(r);
        MemStoreFlusher.FlushRegionEntry other = new MemStoreFlusher.FlushRegionEntry(r);
        Assert.assertEquals((long)entry.hashCode(), (long)other.hashCode());
        Assert.assertEquals((Object)entry, (Object)other);
    }
}

