/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSplitTransaction {
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final Path testdir = this.TEST_UTIL.getDataTestDir(this.getClass().getName());
    private HRegion parent;
    private HLog wal;
    private FileSystem fs;
    private static final byte[] STARTROW = new byte[]{97, 97, 97};
    private static final byte[] ENDROW = new byte[]{123, 123, 123};
    private static final byte[] GOOD_SPLIT_ROW = new byte[]{100, 100, 100};
    private static final byte[] CF = HConstants.CATALOG_FAMILY;
    private static boolean preRollBackCalled = false;
    private static boolean postRollBackCalled = false;

    @Before
    public void setup() throws IOException {
        this.fs = FileSystem.get((Configuration)this.TEST_UTIL.getConfiguration());
        this.TEST_UTIL.getConfiguration().set("hbase.coprocessor.region.classes", CustomObserver.class.getName());
        this.fs.delete(this.testdir, true);
        this.wal = HLogFactory.createHLog((FileSystem)this.fs, (Path)this.testdir, (String)"logs", (Configuration)this.TEST_UTIL.getConfiguration());
        this.parent = this.createRegion(this.testdir, this.wal);
        RegionCoprocessorHost host = new RegionCoprocessorHost(this.parent, null, this.TEST_UTIL.getConfiguration());
        this.parent.setCoprocessorHost(host);
        this.TEST_UTIL.getConfiguration().setBoolean("hbase.testing.nocluster", true);
    }

    @After
    public void teardown() throws IOException {
        Path regionDir;
        if (this.parent != null && !this.parent.isClosed()) {
            this.parent.close();
        }
        if (this.fs.exists(regionDir = this.parent.getRegionFileSystem().getRegionDir()) && !this.fs.delete(regionDir, true)) {
            throw new IOException("Failed delete of " + regionDir);
        }
        if (this.wal != null) {
            this.wal.closeAndDelete();
        }
        this.fs.delete(this.testdir, true);
    }

    @Test
    public void testFailAfterPONR() throws IOException, KeeperException {
        boolean expectedException;
        SplitTransaction spiedUponSt;
        block2: {
            int rowcount = this.TEST_UTIL.loadRegion(this.parent, CF);
            Assert.assertTrue((rowcount > 0 ? 1 : 0) != 0);
            int parentRowCount = this.countRows(this.parent);
            Assert.assertEquals((long)rowcount, (long)parentRowCount);
            SplitTransaction st = this.prepareGOOD_SPLIT_ROW();
            spiedUponSt = (SplitTransaction)Mockito.spy((Object)st);
            ((SplitTransaction)Mockito.doThrow((Throwable)new MockedFailedDaughterOpen()).when((Object)spiedUponSt)).openDaughterRegion((Server)Mockito.anyObject(), (HRegion)Mockito.anyObject());
            expectedException = false;
            Server mockServer = (Server)Mockito.mock(Server.class);
            Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.TEST_UTIL.getConfiguration());
            try {
                spiedUponSt.execute(mockServer, null);
            }
            catch (IOException e) {
                if (e.getCause() == null || !(e.getCause() instanceof MockedFailedDaughterOpen)) break block2;
                expectedException = true;
            }
        }
        Assert.assertTrue((boolean)expectedException);
        Assert.assertFalse((boolean)spiedUponSt.rollback(null, null));
        Path tableDir = this.parent.getRegionFileSystem().getTableDir();
        Path daughterADir = new Path(tableDir, spiedUponSt.getFirstDaughter().getEncodedName());
        Path daughterBDir = new Path(tableDir, spiedUponSt.getSecondDaughter().getEncodedName());
        Assert.assertTrue((boolean)this.TEST_UTIL.getTestFileSystem().exists(daughterADir));
        Assert.assertTrue((boolean)this.TEST_UTIL.getTestFileSystem().exists(daughterBDir));
    }

    @Test
    public void testPrepare() throws IOException {
        this.prepareGOOD_SPLIT_ROW();
    }

    private SplitTransaction prepareGOOD_SPLIT_ROW() {
        return this.prepareGOOD_SPLIT_ROW(this.parent);
    }

    private SplitTransaction prepareGOOD_SPLIT_ROW(HRegion parentRegion) {
        SplitTransaction st = new SplitTransaction(parentRegion, GOOD_SPLIT_ROW);
        Assert.assertTrue((boolean)st.prepare());
        return st;
    }

    @Test
    public void testPrepareWithRegionsWithReference() throws IOException {
        HStore storeMock = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)storeMock.hasReferences()).thenReturn((Object)true);
        Mockito.when((Object)storeMock.getFamily()).thenReturn((Object)new HColumnDescriptor("cf"));
        Mockito.when((Object)storeMock.close()).thenReturn((Object)ImmutableList.of());
        this.parent.stores.put(Bytes.toBytes((String)""), storeMock);
        SplitTransaction st = new SplitTransaction(this.parent, GOOD_SPLIT_ROW);
        Assert.assertFalse((String)"a region should not be splittable if it has instances of store file references", (boolean)st.prepare());
    }

    @Test
    public void testPrepareWithBadSplitRow() throws IOException {
        SplitTransaction st = new SplitTransaction(this.parent, STARTROW);
        Assert.assertFalse((boolean)st.prepare());
        st = new SplitTransaction(this.parent, HConstants.EMPTY_BYTE_ARRAY);
        Assert.assertFalse((boolean)st.prepare());
        st = new SplitTransaction(this.parent, new byte[]{65, 65, 65});
        Assert.assertFalse((boolean)st.prepare());
        st = new SplitTransaction(this.parent, ENDROW);
        Assert.assertFalse((boolean)st.prepare());
    }

    @Test
    public void testPrepareWithClosedRegion() throws IOException {
        this.parent.close();
        SplitTransaction st = new SplitTransaction(this.parent, GOOD_SPLIT_ROW);
        Assert.assertFalse((boolean)st.prepare());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWholesomeSplit() throws IOException {
        int rowcount = this.TEST_UTIL.loadRegion(this.parent, CF, true);
        Assert.assertTrue((rowcount > 0 ? 1 : 0) != 0);
        int parentRowCount = this.countRows(this.parent);
        Assert.assertEquals((long)rowcount, (long)parentRowCount);
        CacheConfig cacheConf = new CacheConfig(this.TEST_UTIL.getConfiguration());
        ((LruBlockCache)cacheConf.getBlockCache()).clearCache();
        SplitTransaction st = this.prepareGOOD_SPLIT_ROW();
        Server mockServer = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.TEST_UTIL.getConfiguration());
        PairOfSameType daughters = st.execute(mockServer, null);
        Assert.assertTrue((boolean)this.fs.exists(this.parent.getRegionFileSystem().getSplitsDir()));
        Assert.assertTrue((boolean)this.parent.isClosed());
        Assert.assertEquals((long)0L, (long)this.fs.listStatus(this.parent.getRegionFileSystem().getSplitsDir()).length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])this.parent.getStartKey(), (byte[])((HRegion)daughters.getFirst()).getStartKey()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])GOOD_SPLIT_ROW, (byte[])((HRegion)daughters.getFirst()).getEndKey()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])((HRegion)daughters.getSecond()).getStartKey(), (byte[])GOOD_SPLIT_ROW));
        Assert.assertTrue((boolean)Bytes.equals((byte[])this.parent.getEndKey(), (byte[])((HRegion)daughters.getSecond()).getEndKey()));
        int daughtersRowCount = 0;
        for (HRegion openRegion : daughters) {
            try {
                int count = this.countRows(openRegion);
                Assert.assertTrue((count > 0 && count != rowcount ? 1 : 0) != 0);
                daughtersRowCount += count;
            }
            finally {
                HRegion.closeHRegion((HRegion)openRegion);
            }
        }
        Assert.assertEquals((long)rowcount, (long)daughtersRowCount);
        Assert.assertTrue((!this.parent.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
    }

    @Test
    public void testCountReferencesFailsSplit() throws IOException {
        int rowcount = this.TEST_UTIL.loadRegion(this.parent, CF);
        Assert.assertTrue((rowcount > 0 ? 1 : 0) != 0);
        int parentRowCount = this.countRows(this.parent);
        Assert.assertEquals((long)rowcount, (long)parentRowCount);
        HRegion spiedRegion = (HRegion)Mockito.spy((Object)this.parent);
        SplitTransaction st = this.prepareGOOD_SPLIT_ROW(spiedRegion);
        SplitTransaction spiedUponSt = (SplitTransaction)Mockito.spy((Object)st);
        ((SplitTransaction)Mockito.doThrow((Throwable)new IOException("Failing split. Expected reference file count isn't equal.")).when((Object)spiedUponSt)).assertReferenceFileCount(Matchers.anyInt(), (Path)Matchers.eq((Object)new Path(this.parent.getRegionFileSystem().getTableDir(), st.getSecondDaughter().getEncodedName())));
        boolean expectedException = false;
        Server mockServer = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.TEST_UTIL.getConfiguration());
        try {
            spiedUponSt.execute(mockServer, null);
        }
        catch (IOException e) {
            expectedException = true;
        }
        Assert.assertTrue((boolean)expectedException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollback() throws IOException {
        int rowcount = this.TEST_UTIL.loadRegion(this.parent, CF);
        Assert.assertTrue((rowcount > 0 ? 1 : 0) != 0);
        int parentRowCount = this.countRows(this.parent);
        Assert.assertEquals((long)rowcount, (long)parentRowCount);
        HRegion spiedRegion = (HRegion)Mockito.spy((Object)this.parent);
        SplitTransaction st = this.prepareGOOD_SPLIT_ROW(spiedRegion);
        SplitTransaction spiedUponSt = (SplitTransaction)Mockito.spy((Object)st);
        ((SplitTransaction)Mockito.doNothing().when((Object)spiedUponSt)).assertReferenceFileCount(Matchers.anyInt(), (Path)Matchers.eq((Object)this.parent.getRegionFileSystem().getSplitsDir(st.getFirstDaughter())));
        Mockito.when((Object)spiedRegion.createDaughterRegionFromSplits(spiedUponSt.getSecondDaughter())).thenThrow(new Throwable[]{new MockedFailedDaughterCreation()});
        boolean expectedException = false;
        Server mockServer = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.TEST_UTIL.getConfiguration());
        try {
            spiedUponSt.execute(mockServer, null);
        }
        catch (MockedFailedDaughterCreation e) {
            expectedException = true;
        }
        Assert.assertTrue((boolean)expectedException);
        Assert.assertTrue((boolean)spiedUponSt.rollback(null, null));
        int parentRowCount2 = this.countRows(this.parent);
        Assert.assertEquals((long)parentRowCount, (long)parentRowCount2);
        Assert.assertTrue((!this.fs.exists(HRegion.getRegionDir((Path)this.testdir, (HRegionInfo)st.getFirstDaughter())) ? 1 : 0) != 0);
        Assert.assertTrue((!this.fs.exists(HRegion.getRegionDir((Path)this.testdir, (HRegionInfo)st.getSecondDaughter())) ? 1 : 0) != 0);
        Assert.assertTrue((!this.parent.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)st.prepare());
        PairOfSameType daughters = st.execute(mockServer, null);
        int daughtersRowCount = 0;
        for (HRegion openRegion : daughters) {
            try {
                int count = this.countRows(openRegion);
                Assert.assertTrue((count > 0 && count != rowcount ? 1 : 0) != 0);
                daughtersRowCount += count;
            }
            finally {
                HRegion.closeHRegion((HRegion)openRegion);
            }
        }
        Assert.assertEquals((long)rowcount, (long)daughtersRowCount);
        Assert.assertTrue((!this.parent.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Rollback hooks should be called.", (boolean)this.wasRollBackHookCalled());
    }

    private boolean wasRollBackHookCalled() {
        return preRollBackCalled && postRollBackCalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countRows(HRegion r) throws IOException {
        int rowcount = 0;
        RegionScanner scanner = r.getScanner(new Scan());
        try {
            ArrayList kvs = new ArrayList();
            boolean hasNext = true;
            while (hasNext) {
                hasNext = scanner.next(kvs);
                if (kvs.isEmpty()) continue;
                ++rowcount;
            }
        }
        finally {
            scanner.close();
        }
        return rowcount;
    }

    HRegion createRegion(Path testdir, HLog wal) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"table"));
        HColumnDescriptor hcd = new HColumnDescriptor(CF);
        htd.addFamily(hcd);
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), STARTROW, ENDROW);
        HRegion r = HRegion.createHRegion((HRegionInfo)hri, (Path)testdir, (Configuration)this.TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)r);
        return HRegion.openHRegion((Path)testdir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal, (Configuration)this.TEST_UTIL.getConfiguration());
    }

    public static class CustomObserver
    extends BaseRegionObserver {
        public void preRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            preRollBackCalled = true;
        }

        public void postRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            postRollBackCalled = true;
        }
    }

    private class MockedFailedDaughterOpen
    extends IOException {
        private MockedFailedDaughterOpen() {
        }
    }

    private class MockedFailedDaughterCreation
    extends IOException {
        private MockedFailedDaughterCreation() {
        }
    }
}

