/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestOpenRegionHandler {
    static final Log LOG = LogFactory.getLog(TestOpenRegionHandler.class);
    private static final HBaseTestingUtility HTU = HBaseTestingUtility.createLocalHTU();
    private static HTableDescriptor TEST_HTD;
    private HRegionInfo TEST_HRI;
    private int testIndex = 0;

    @BeforeClass
    public static void before() throws Exception {
        HTU.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        HTU.startMiniZKCluster();
        TEST_HTD = new HTableDescriptor(TableName.valueOf((String)"TestOpenRegionHandler.java"));
    }

    @AfterClass
    public static void after() throws IOException {
        TEST_HTD = null;
        HTU.shutdownMiniZKCluster();
    }

    @Before
    public void setupHRI() {
        this.TEST_HRI = new HRegionInfo(TEST_HTD.getTableName(), Bytes.toBytes((int)this.testIndex), Bytes.toBytes((int)(this.testIndex + 1)));
        ++this.testIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testYankingRegionFromUnderIt() throws IOException, KeeperException.NodeExistsException, KeeperException {
        MockServer server = new MockServer(HTU);
        RegionServerServices rss = HTU.createMockRegionServerService();
        HTableDescriptor htd = TEST_HTD;
        final HRegionInfo hri = this.TEST_HRI;
        HRegion region = HRegion.createHRegion((HRegionInfo)hri, (Path)HTU.getDataTestDir(), (Configuration)HTU.getConfiguration(), (HTableDescriptor)htd);
        Assert.assertNotNull((Object)region);
        try {
            OpenRegionHandler handler = new OpenRegionHandler(server, rss, hri, htd){

                HRegion openRegion() {
                    HRegion region = super.openRegion();
                    ZooKeeperWatcher zkw = this.server.getZooKeeper();
                    String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
                    try {
                        ZKUtil.deleteNodeFailSilent((ZooKeeperWatcher)zkw, (String)node);
                    }
                    catch (KeeperException e) {
                        throw new RuntimeException("Ugh failed delete of " + node, e);
                    }
                    return region;
                }
            };
            rss.getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
            handler.process();
            rss.getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
            ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
            handler.process();
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionServerAbortionDueToFailureTransitioningToOpened() throws IOException, KeeperException.NodeExistsException, KeeperException {
        MockServer server = new MockServer(HTU);
        RegionServerServices rss = HTU.createMockRegionServerService();
        HTableDescriptor htd = TEST_HTD;
        final HRegionInfo hri = this.TEST_HRI;
        HRegion region = HRegion.createHRegion((HRegionInfo)hri, (Path)HTU.getDataTestDir(), (Configuration)HTU.getConfiguration(), (HTableDescriptor)htd);
        Assert.assertNotNull((Object)region);
        try {
            OpenRegionHandler handler = new OpenRegionHandler(server, rss, hri, htd){

                boolean transitionToOpened(HRegion r) throws IOException {
                    ZooKeeperWatcher zkw = this.server.getZooKeeper();
                    String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
                    try {
                        ZKUtil.deleteNodeFailSilent((ZooKeeperWatcher)zkw, (String)node);
                    }
                    catch (KeeperException e) {
                        throw new RuntimeException("Ugh failed delete of " + node, e);
                    }
                    return super.transitionToOpened(r);
                }
            };
            rss.getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
            handler.process();
            rss.getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
            ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
            handler.process();
        }
        catch (IOException ioe) {
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
        Assert.assertTrue((String)"region server should have aborted", (boolean)rss.isAborted());
    }

    @Test
    public void testFailedOpenRegion() throws Exception {
        MockServer server = new MockServer(HTU);
        RegionServerServices rsServices = HTU.createMockRegionServerService();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        OpenRegionHandler handler = new OpenRegionHandler(server, rsServices, this.TEST_HRI, TEST_HTD){

            HRegion openRegion() {
                return null;
            }
        };
        rsServices.getRegionsInTransitionInRS().put(this.TEST_HRI.getEncodedNameAsBytes(), Boolean.TRUE);
        handler.process();
        RegionTransition rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)this.TEST_HRI.getEncodedName()));
        Assert.assertEquals((Object)EventType.RS_ZK_REGION_FAILED_OPEN, (Object)rt.getEventType());
    }

    @Test
    public void testFailedUpdateMeta() throws Exception {
        MockServer server = new MockServer(HTU);
        RegionServerServices rsServices = HTU.createMockRegionServerService();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        OpenRegionHandler handler = new OpenRegionHandler(server, rsServices, this.TEST_HRI, TEST_HTD){

            boolean updateMeta(HRegion r, long masterSystemTime) {
                return false;
            }
        };
        rsServices.getRegionsInTransitionInRS().put(this.TEST_HRI.getEncodedNameAsBytes(), Boolean.TRUE);
        handler.process();
        RegionTransition rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)this.TEST_HRI.getEncodedName()));
        Assert.assertEquals((Object)EventType.RS_ZK_REGION_FAILED_OPEN, (Object)rt.getEventType());
    }

    @Test
    public void testTransitionToFailedOpenEvenIfCleanupFails() throws Exception {
        MockServer server = new MockServer(HTU);
        RegionServerServices rsServices = HTU.createMockRegionServerService();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        OpenRegionHandler handler = new OpenRegionHandler(server, rsServices, this.TEST_HRI, TEST_HTD){

            boolean updateMeta(HRegion r, long masterSystemTime) {
                return false;
            }

            void cleanupFailedOpen(HRegion region) throws IOException {
                throw new IOException("FileSystem got closed.");
            }
        };
        rsServices.getRegionsInTransitionInRS().put(this.TEST_HRI.getEncodedNameAsBytes(), Boolean.TRUE);
        try {
            handler.process();
        }
        catch (Exception e) {
            // empty catch block
        }
        RegionTransition rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)this.TEST_HRI.getEncodedName()));
        Assert.assertEquals((Object)EventType.RS_ZK_REGION_FAILED_OPEN, (Object)rt.getEventType());
    }

    @Test
    public void testTransitionToFailedOpenFromOffline() throws Exception {
        MockServer server = new MockServer(HTU);
        RegionServerServices rsServices = HTU.createMockRegionServerService(server.getServerName());
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        OpenRegionHandler handler = new OpenRegionHandler(server, rsServices, this.TEST_HRI, TEST_HTD){

            boolean transitionZookeeperOfflineToOpening(String encodedName, int versionOfOfflineNode) {
                return false;
            }
        };
        rsServices.getRegionsInTransitionInRS().put(this.TEST_HRI.getEncodedNameAsBytes(), Boolean.TRUE);
        handler.process();
        RegionTransition rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)this.TEST_HRI.getEncodedName()));
        Assert.assertEquals((Object)EventType.RS_ZK_REGION_FAILED_OPEN, (Object)rt.getEventType());
    }
}

