/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import com.google.common.collect.Lists;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.TestDelayedRpc;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestDelayedRpcProtos;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSecureRPC {
    public static RpcServerInterface rpcServer;

    @Test
    public void testRpcCallWithEnabledKerberosSaslAuth() throws Exception {
        Assume.assumeTrue((boolean)HBaseKerberosUtils.isKerberosPropertySetted());
        String krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        String krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        UserGroupInformation ugi = this.loginKerberosPrincipal(krbKeytab, krbPrincipal);
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi, (Object)ugi2);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)krbPrincipal, (Object)ugi.getUserName());
        Configuration clientConf = HBaseKerberosUtils.getSecuredConfiguration();
        this.callRpcService(User.create((UserGroupInformation)ugi2), clientConf, false);
    }

    private UserGroupInformation loginKerberosPrincipal(String krbKeytab, String krbPrincipal) throws Exception {
        Configuration cnf = new Configuration();
        cnf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)cnf);
        UserGroupInformation.loginUserFromKeytab((String)krbPrincipal, (String)krbKeytab);
        return UserGroupInformation.getLoginUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callRpcService(User clientUser, Configuration clientConf, boolean allowInsecureFallback) throws Exception {
        Configuration conf = HBaseKerberosUtils.getSecuredConfiguration();
        conf.setBoolean("hbase.ipc.server.fallback-to-simple-auth-allowed", allowInsecureFallback);
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipal()).thenReturn((Object)"hbase.regionserver.kerberos.principal");
        SecurityInfo.addInfo((String)"TestDelayedService", (SecurityInfo)securityInfoMock);
        boolean delayReturnValue = false;
        InetSocketAddress isa = new InetSocketAddress("localhost", 0);
        TestDelayedRpc.TestDelayedImplementation instance = new TestDelayedRpc.TestDelayedImplementation(delayReturnValue);
        BlockingService service = TestDelayedRpcProtos.TestDelayedService.newReflectiveBlockingService(instance);
        rpcServer = new RpcServer(null, "testSecuredDelayedRpc", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(service, null)}), isa, conf, (RpcScheduler)new FifoRpcScheduler(conf, 1));
        rpcServer.start();
        RpcClient rpcClient = new RpcClient(clientConf, HConstants.DEFAULT_CLUSTER_ID.toString());
        try {
            InetSocketAddress address = rpcServer.getListenerAddress();
            if (address == null) {
                throw new IOException("Listener channel is closed");
            }
            BlockingRpcChannel channel = rpcClient.createBlockingRpcChannel(ServerName.valueOf((String)address.getHostName(), (int)address.getPort(), (long)System.currentTimeMillis()), clientUser, 1000);
            TestDelayedRpcProtos.TestDelayedService.BlockingInterface stub = TestDelayedRpcProtos.TestDelayedService.newBlockingStub(channel);
            ArrayList<Integer> results = new ArrayList<Integer>();
            TestDelayedRpc.TestThread th1 = new TestDelayedRpc.TestThread(stub, true, results);
            th1.start();
            Thread.sleep(100L);
            th1.join();
            Assert.assertEquals((long)-559038737L, (long)((Integer)results.get(0)).intValue());
        }
        finally {
            rpcClient.stop();
        }
    }

    @Test
    public void testRpcFallbackToSimpleAuth() throws Exception {
        Assume.assumeTrue((boolean)HBaseKerberosUtils.isKerberosPropertySetted());
        String krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        String krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        UserGroupInformation ugi = this.loginKerberosPrincipal(krbKeytab, krbPrincipal);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)krbPrincipal, (Object)ugi.getUserName());
        String clientUsername = "testuser";
        UserGroupInformation clientUgi = UserGroupInformation.createUserForTesting((String)clientUsername, (String[])new String[]{clientUsername});
        Assert.assertNotSame((Object)ugi, (Object)clientUgi);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE, (Object)clientUgi.getAuthenticationMethod());
        Assert.assertEquals((Object)clientUsername, (Object)clientUgi.getUserName());
        Configuration clientConf = new Configuration();
        clientConf.set("hbase.security.authentication", "simple");
        this.callRpcService(User.create((UserGroupInformation)clientUgi), clientConf, true);
    }
}

