/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAccessController2
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestAccessController2.class);
    private static final byte[] TEST_ROW = Bytes.toBytes((String)"test");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"q");
    private static final byte[] TEST_VALUE = Bytes.toBytes((String)"value");
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static final byte[] Q1;
    private static final byte[] value1;
    private static byte[] TEST_FAMILY_2;
    private static byte[] TEST_ROW_2;
    private static final byte[] Q2;
    private static final byte[] value2;
    private static byte[] TEST_ROW_3;
    private static final String TESTGROUP_1 = "testgroup_1";
    private static final String TESTGROUP_2 = "testgroup_2";
    private static User TESTGROUP1_USER1;
    private static User TESTGROUP2_USER1;
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private String namespace = "testNamespace";
    private String tname = this.namespace + ":testtable1";
    private byte[] tableName = Bytes.toBytes((String)this.tname);
    private static String TESTGROUP_1_NAME;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestAccessController2.enableSecurity(conf);
        TestAccessController2.verifyConfiguration(conf);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        TESTGROUP_1_NAME = AuthUtil.toGroupEntry((String)TESTGROUP_1);
        TESTGROUP1_USER1 = User.createUserForTesting((Configuration)conf, (String)"testgroup1_user1", (String[])new String[]{TESTGROUP_1});
        TESTGROUP2_USER1 = User.createUserForTesting((Configuration)conf, (String)"testgroup2_user2", (String[])new String[]{TESTGROUP_2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create((String)this.namespace).build());
        HTable table = null;
        try {
            table = TEST_UTIL.createTable(TableName.valueOf((byte[])this.tableName), new String[]{Bytes.toString((byte[])TEST_FAMILY), Bytes.toString((byte[])TEST_FAMILY_2)});
            table.put(Arrays.asList(new Put(TEST_ROW).add(TEST_FAMILY, Q1, value1), new Put(TEST_ROW_2).add(TEST_FAMILY, Q2, value2), new Put(TEST_ROW_3).add(TEST_FAMILY_2, Q1, value1)));
        }
        finally {
            table.close();
        }
        Assert.assertEquals((long)1L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TableName.valueOf((byte[])this.tableName)).size());
        try {
            Assert.assertEquals((long)1L, (long)AccessControlClient.getUserPermissions((Configuration)conf, (String)this.tableName.toString()).size());
        }
        catch (Throwable e) {
            LOG.error((Object)"Error during call of AccessControlClient.getUserPermissions. ", e);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.tableName);
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.tableName));
        }
        TEST_UTIL.getHBaseAdmin().deleteNamespace(this.namespace);
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TableName.valueOf((byte[])this.tableName)).size());
        Assert.assertEquals((long)0L, (long)AccessControlLists.getNamespacePermissions((Configuration)conf, (String)this.namespace).size());
    }

    @Test
    public void testCreateWithCorrectOwner() throws Exception {
        User testUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"TestUser", (String[])new String[0]);
        SecureTestUtil.grantGlobal(TEST_UTIL, testUser.getShortName(), Permission.Action.CREATE);
        TestAccessController2.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTableDescriptor desc = new HTableDescriptor(TestAccessController2.this.TEST_TABLE.getTableName());
                desc.addFamily(new HColumnDescriptor(TEST_FAMILY));
                HBaseAdmin admin = new HBaseAdmin(conf);
                try {
                    admin.createTable(desc);
                }
                finally {
                    admin.close();
                }
                return null;
            }
        }, testUser);
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName().getName());
        List perms = AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).get((Object)testUser.getShortName());
        Assert.assertNotNull((Object)perms);
        Assert.assertFalse((boolean)perms.isEmpty());
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.READ));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.WRITE));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.EXEC));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.CREATE));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.ADMIN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithGroupPermissions() throws Exception {
        TestAccessController2.grantGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.CREATE);
        try {
            SecureTestUtil.AccessTestAction createAction = new SecureTestUtil.AccessTestAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                    HTableDescriptor desc = new HTableDescriptor(TestAccessController2.this.TEST_TABLE.getTableName());
                    desc.addFamily(new HColumnDescriptor(TEST_FAMILY));
                    try {
                        admin.createTable(desc);
                    }
                    finally {
                        admin.close();
                    }
                    return null;
                }
            };
            TestAccessController2.verifyAllowed(createAction, TESTGROUP1_USER1);
            TestAccessController2.verifyDenied(createAction, TESTGROUP2_USER1);
        }
        catch (Throwable throwable) {
            TestAccessController2.revokeGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.CREATE);
            throw throwable;
        }
        TestAccessController2.revokeGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testACLTableAccess() throws Exception {
        final Configuration conf = TEST_UTIL.getConfiguration();
        User superUser = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        User globalRead = User.createUserForTesting((Configuration)conf, (String)"globalRead", (String[])new String[0]);
        User globalWrite = User.createUserForTesting((Configuration)conf, (String)"globalWrite", (String[])new String[0]);
        User globalCreate = User.createUserForTesting((Configuration)conf, (String)"globalCreate", (String[])new String[0]);
        User globalAdmin = User.createUserForTesting((Configuration)conf, (String)"globalAdmin", (String[])new String[0]);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalRead.getShortName(), Permission.Action.READ);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalWrite.getShortName(), Permission.Action.WRITE);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalCreate.getShortName(), Permission.Action.CREATE);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalAdmin.getShortName(), Permission.Action.ADMIN);
        User nsRead = User.createUserForTesting((Configuration)conf, (String)"nsRead", (String[])new String[0]);
        User nsWrite = User.createUserForTesting((Configuration)conf, (String)"nsWrite", (String[])new String[0]);
        User nsCreate = User.createUserForTesting((Configuration)conf, (String)"nsCreate", (String[])new String[0]);
        User nsAdmin = User.createUserForTesting((Configuration)conf, (String)"nsAdmin", (String[])new String[0]);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsRead.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsWrite.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.WRITE);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsCreate.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.CREATE);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsAdmin.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.ADMIN);
        User tableRead = User.createUserForTesting((Configuration)conf, (String)"tableRead", (String[])new String[0]);
        User tableWrite = User.createUserForTesting((Configuration)conf, (String)"tableWrite", (String[])new String[0]);
        User tableCreate = User.createUserForTesting((Configuration)conf, (String)"tableCreate", (String[])new String[0]);
        User tableAdmin = User.createUserForTesting((Configuration)conf, (String)"tableAdmin", (String[])new String[0]);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableRead.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableWrite.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.WRITE);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableCreate.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.CREATE);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableAdmin.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.ADMIN);
        TestAccessController2.grantGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.WRITE);
        try {
            SecureTestUtil.AccessTestAction writeAction = new SecureTestUtil.AccessTestAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    HTable t = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                    try {
                        t.put(new Put(TEST_ROW).add(AccessControlLists.ACL_LIST_FAMILY, TEST_QUALIFIER, TEST_VALUE));
                        Object var2_2 = null;
                        return var2_2;
                    }
                    finally {
                        t.close();
                    }
                }
            };
            TestAccessController2.verifyDenied(writeAction, globalAdmin, globalCreate, globalRead, TESTGROUP2_USER1);
            TestAccessController2.verifyDenied(writeAction, nsAdmin, nsCreate, nsRead, nsWrite);
            TestAccessController2.verifyDenied(writeAction, tableAdmin, tableCreate, tableRead, tableWrite);
            TestAccessController2.verifyAllowed(writeAction, superUser, globalWrite, TESTGROUP1_USER1);
        }
        catch (Throwable throwable) {
            TestAccessController2.revokeGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.WRITE);
            throw throwable;
        }
        TestAccessController2.revokeGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.WRITE);
        TestAccessController2.grantGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.READ);
        try {
            SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    HTable t = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                    try {
                        ResultScanner s = t.getScanner(new Scan());
                        try {
                            Result r = s.next();
                            while (r != null) {
                                r = s.next();
                            }
                        }
                        finally {
                            s.close();
                        }
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        t.close();
                    }
                }
            };
            TestAccessController2.verifyDenied(scanAction, globalAdmin, globalCreate, globalWrite, TESTGROUP2_USER1);
            TestAccessController2.verifyDenied(scanAction, nsCreate, nsAdmin, nsRead, nsWrite);
            TestAccessController2.verifyDenied(scanAction, tableCreate, tableAdmin, tableRead, tableWrite);
            TestAccessController2.verifyAllowed(scanAction, superUser, globalRead, TESTGROUP1_USER1);
        }
        catch (Throwable throwable) {
            TestAccessController2.revokeGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.READ);
            throw throwable;
        }
        TestAccessController2.revokeGlobal(TEST_UTIL, TESTGROUP_1_NAME, Permission.Action.READ);
    }

    @Test(timeout=300000L)
    public void testPostGrantAndRevokeScanAction() throws Exception {
        TableName name = TableName.valueOf((byte[])this.tableName);
        SecureTestUtil.AccessTestAction scanTableActionForGroupWithTableLevelAccess = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable table = new HTable(conf, TestAccessController2.this.tableName);
                Scan s1 = new Scan();
                ResultScanner scanner1 = table.getScanner(s1);
                try {
                    Result[] next1 = scanner1.next(5);
                    Assert.assertTrue((String)"User having table level access should be able to scan all the data in the table.", (next1.length == 3 ? 1 : 0) != 0);
                }
                finally {
                    scanner1.close();
                    table.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction scanTableActionForGroupWithFamilyLevelAccess = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable table = new HTable(conf, TestAccessController2.this.tableName);
                Scan s1 = new Scan();
                ResultScanner scanner1 = table.getScanner(s1);
                try {
                    Result[] next1 = scanner1.next(5);
                    Assert.assertTrue((String)"User having column family level access should be able to scan all the data belonging to that family.", (next1.length == 2 ? 1 : 0) != 0);
                }
                finally {
                    scanner1.close();
                    table.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction scanFamilyActionForGroupWithFamilyLevelAccess = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable table = new HTable(conf, TestAccessController2.this.tableName);
                Scan s1 = new Scan();
                s1.addFamily(TEST_FAMILY_2);
                ResultScanner scanner1 = null;
                try {
                    scanner1 = table.getScanner(s1);
                }
                finally {
                    if (scanner1 != null) {
                        scanner1.close();
                    }
                    table.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction scanTableActionForGroupWithQualifierLevelAccess = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable table = new HTable(conf, TestAccessController2.this.tableName);
                Scan s1 = new Scan();
                ResultScanner scanner1 = table.getScanner(s1);
                try {
                    Result[] next1 = scanner1.next(5);
                    Assert.assertTrue((String)"User having column qualifier level access should be able to scan that column family qualifier data.", (next1.length == 1 ? 1 : 0) != 0);
                }
                finally {
                    scanner1.close();
                    table.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction scanFamilyActionForGroupWithQualifierLevelAccess = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable table = new HTable(conf, TestAccessController2.this.tableName);
                Scan s1 = new Scan();
                s1.addFamily(TEST_FAMILY_2);
                ResultScanner scanner1 = null;
                try {
                    scanner1 = table.getScanner(s1);
                }
                finally {
                    if (scanner1 != null) {
                        scanner1.close();
                    }
                    table.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction scanQualifierActionForGroupWithQualifierLevelAccess = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable table = new HTable(conf, TestAccessController2.this.tableName);
                Scan s1 = new Scan();
                s1.addColumn(TEST_FAMILY, Q2);
                ResultScanner scanner1 = null;
                try {
                    scanner1 = table.getScanner(s1);
                }
                finally {
                    if (scanner1 != null) {
                        scanner1.close();
                    }
                    table.close();
                }
                return null;
            }
        };
        TestAccessController2.grantOnTable(TEST_UTIL, "@testgroup_1", name, null, null, Permission.Action.READ);
        TestAccessController2.verifyAllowed(TESTGROUP1_USER1, scanTableActionForGroupWithTableLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP2_USER1, scanTableActionForGroupWithTableLevelAccess);
        TestAccessController2.revokeFromTable(TEST_UTIL, "@testgroup_1", name, null, null, new Permission.Action[0]);
        TestAccessController2.verifyDenied(TESTGROUP1_USER1, scanTableActionForGroupWithTableLevelAccess);
        TestAccessController2.grantOnTable(TEST_UTIL, "@testgroup_1", name, TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController2.verifyAllowed(TESTGROUP1_USER1, scanTableActionForGroupWithFamilyLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP1_USER1, scanFamilyActionForGroupWithFamilyLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP2_USER1, scanTableActionForGroupWithFamilyLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP2_USER1, scanFamilyActionForGroupWithFamilyLevelAccess);
        TestAccessController2.revokeFromTable(TEST_UTIL, "@testgroup_1", name, TEST_FAMILY, null, new Permission.Action[0]);
        TestAccessController2.verifyDenied(TESTGROUP1_USER1, scanTableActionForGroupWithFamilyLevelAccess);
        TestAccessController2.grantOnTable(TEST_UTIL, "@testgroup_1", name, TEST_FAMILY, Q1, Permission.Action.READ);
        TestAccessController2.verifyAllowed(TESTGROUP1_USER1, scanTableActionForGroupWithQualifierLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP1_USER1, scanFamilyActionForGroupWithQualifierLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP1_USER1, scanQualifierActionForGroupWithQualifierLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP2_USER1, scanTableActionForGroupWithQualifierLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP2_USER1, scanFamilyActionForGroupWithQualifierLevelAccess);
        TestAccessController2.verifyDenied(TESTGROUP2_USER1, scanQualifierActionForGroupWithQualifierLevelAccess);
        TestAccessController2.revokeFromTable(TEST_UTIL, "@testgroup_1", name, TEST_FAMILY, Q1, new Permission.Action[0]);
        TestAccessController2.verifyDenied(TESTGROUP1_USER1, scanTableActionForGroupWithQualifierLevelAccess);
    }

    @Test
    public void testCoprocessorLoading() throws Exception {
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getCoprocessorHost();
        cpHost.load(MyAccessController.class, 0, conf);
        AccessController ACCESS_CONTROLLER = (AccessController)cpHost.findCoprocessor(MyAccessController.class.getName());
        MasterCoprocessorHost.MasterEnvironment CP_ENV = cpHost.createEnvironment(MyAccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getCoprocessorHost();
        RegionServerCoprocessorHost.RegionServerEnvironment RSCP_ENV = rsHost.createEnvironment(MyAccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
    }

    @Test
    public void testACLZNodeDeletion() throws Exception {
        String baseAclZNode = "/hbase/acl/";
        String ns = "testACLZNodeDeletionNamespace";
        NamespaceDescriptor desc = NamespaceDescriptor.create((String)ns).build();
        TestAccessController2.createNamespace(TEST_UTIL, desc);
        TableName table = TableName.valueOf((String)ns, (String)"testACLZNodeDeletionTable");
        byte[] family = Bytes.toBytes((String)"f1");
        HTableDescriptor htd = new HTableDescriptor(table);
        htd.addFamily(new HColumnDescriptor(family));
        TEST_UTIL.getHBaseAdmin().createTable(htd);
        TestAccessController2.grantOnNamespace(TEST_UTIL, TESTGROUP1_USER1.getShortName(), ns, Permission.Action.ADMIN);
        ZooKeeperWatcher zkw = TEST_UTIL.getMiniHBaseCluster().getMaster().getZooKeeper();
        Assert.assertTrue((String)"The acl znode for table should exist", (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)(baseAclZNode + table.getNameAsString())) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The acl znode for namespace should exist", (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)(baseAclZNode + TestAccessController2.convertToNamespace(ns))) != -1 ? 1 : 0) != 0);
        TestAccessController2.revokeFromNamespace(TEST_UTIL, TESTGROUP1_USER1.getShortName(), ns, Permission.Action.ADMIN);
        TEST_UTIL.deleteTable(table);
        TestAccessController2.deleteNamespace(TEST_UTIL, ns);
        Assert.assertTrue((String)"The acl znode for table should have been deleted", (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)(baseAclZNode + table.getNameAsString())) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The acl znode for namespace should have been deleted", (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)(baseAclZNode + TestAccessController2.convertToNamespace(ns))) == -1 ? 1 : 0) != 0);
    }

    static {
        Q1 = Bytes.toBytes((String)"q1");
        value1 = Bytes.toBytes((String)"value1");
        TEST_FAMILY_2 = Bytes.toBytes((String)"f2");
        TEST_ROW_2 = Bytes.toBytes((String)"r2");
        Q2 = Bytes.toBytes((String)"q2");
        value2 = Bytes.toBytes((String)"value2");
        TEST_ROW_3 = Bytes.toBytes((String)"r3");
    }

    public static class MyAccessController
    extends AccessController {
    }
}

