/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCellACLWithMultipleVersions
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestCellACLWithMultipleVersions.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static final HBaseTestingUtility TEST_UTIL;
    private static final byte[] TEST_FAMILY1;
    private static final byte[] TEST_FAMILY2;
    private static final byte[] TEST_ROW;
    private static final byte[] TEST_Q1;
    private static final byte[] TEST_Q2;
    private static final byte[] ZERO;
    private static final byte[] ONE;
    private static final byte[] TWO;
    private static Configuration conf;
    private static final String GROUP = "group";
    private static User GROUP_USER;
    private static User USER_OWNER;
    private static User USER_OTHER;
    private static User USER_OTHER2;
    private static String[] usersAndGroups;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestCellACLWithMultipleVersions.enableSecurity(conf);
        TestCellACLWithMultipleVersions.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        AccessController ac = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        cpHost.createEnvironment(AccessController.class, (Coprocessor)ac, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getCoprocessorHost();
        rsHost.createEnvironment(AccessController.class, (Coprocessor)ac, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName());
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_OTHER = User.createUserForTesting((Configuration)conf, (String)"other", (String[])new String[0]);
        USER_OTHER2 = User.createUserForTesting((Configuration)conf, (String)"other2", (String[])new String[0]);
        GROUP_USER = User.createUserForTesting((Configuration)conf, (String)"group_user", (String[])new String[]{GROUP});
        usersAndGroups = new String[]{USER_OTHER.getShortName(), AuthUtil.toGroupEntry((String)GROUP)};
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY1);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        hcd = new HColumnDescriptor(TEST_FAMILY2);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        admin.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName().getName());
    }

    @Test
    public void testCellPermissionwithVersions() throws Exception {
        final Map<String, Permission> writePerms = this.prepareCellPermissions(usersAndGroups, Permission.Action.WRITE);
        final Map<String, Permission> readPerms = this.prepareCellPermissions(usersAndGroups, Permission.Action.READ);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(readPerms);
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(readPerms);
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW);
                get.setMaxVersions(10);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    List list = t.get(get).listCells();
                    return list;
                }
                finally {
                    t.close();
                }
            }
        };
        SecureTestUtil.AccessTestAction get2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW);
                get.setMaxVersions(10);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    List list = t.get(get).listCells();
                    return list;
                }
                finally {
                    t.close();
                }
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(GROUP_USER, getQ1, 2);
        TestCellACLWithMultipleVersions.verifyAllowed(USER_OTHER, getQ1, 2);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(readPerms);
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLWithMultipleVersions.verifyAllowed(USER_OTHER, get2, 1);
        TestCellACLWithMultipleVersions.verifyAllowed(GROUP_USER, get2, 1);
    }

    private Map<String, Permission> prepareCellPermissions(String[] users, Permission.Action ... action) {
        HashMap<String, Permission> perms = new HashMap<String, Permission>(2);
        for (String user : users) {
            perms.put(user, new Permission(action));
        }
        return perms;
    }

    @Test
    public void testCellPermissionsWithDeleteMutipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_ROW2 = Bytes.toBytes((String)"r2");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW2);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    Map perms = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP)}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    p.setACL(perms);
                    t.put(p);
                    p = new Put(TEST_ROW2);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(perms);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, user1);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q2);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        this.verifyUserDeniedForDeleteMultipleVersions(user2, TEST_ROW2, TEST_Q1, TEST_Q2);
        this.verifyUserDeniedForDeleteMultipleVersions(GROUP_USER, TEST_ROW2, TEST_Q1, TEST_Q2);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW2);
                    d.deleteFamily(TEST_FAMILY1);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    private void verifyUserDeniedForDeleteMultipleVersions(final User user, final byte[] row, final byte[] q1, final byte[] q2) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(row);
                    d.deleteColumns(TEST_FAMILY1, q1);
                    d.deleteColumns(TEST_FAMILY1, q2);
                    t.delete(d);
                    Assert.fail((String)(user.getShortName() + " should not be allowed to delete the row"));
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testDeleteWithFutureTimestamp() throws Exception {
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, EnvironmentEdgeManager.currentTimeMillis() + 1000000L, ZERO);
                    Map readAndWritePerms = TestCellACLWithMultipleVersions.this.prepareCellPermissions(usersAndGroups, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    p.setACL(TestCellACLWithMultipleVersions.this.prepareCellPermissions(usersAndGroups, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q2, ONE);
                    p.setACL(readAndWritePerms);
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY2, TEST_Q2, ONE);
                    p.setACL(readAndWritePerms);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    List list = t.get(get).listCells();
                    return list;
                }
                finally {
                    t.close();
                }
            }
        };
        SecureTestUtil.AccessTestAction getQ2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q2);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    List list = t.get(get).listCells();
                    return list;
                }
                finally {
                    t.close();
                }
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(getQ1, USER_OWNER, USER_OTHER, GROUP_USER);
        TestCellACLWithMultipleVersions.verifyAllowed(getQ2, USER_OWNER, USER_OTHER, GROUP_USER);
        SecureTestUtil.AccessTestAction deleteFamily1 = this.getDeleteFamilyAction(TEST_FAMILY1);
        SecureTestUtil.AccessTestAction deleteFamily2 = this.getDeleteFamilyAction(TEST_FAMILY2);
        TestCellACLWithMultipleVersions.verifyAllowed(deleteFamily1, USER_OTHER);
        TestCellACLWithMultipleVersions.verifyAllowed(deleteFamily2, GROUP_USER);
        TestCellACLWithMultipleVersions.verifyAllowed(getQ1, USER_OWNER, USER_OTHER, GROUP_USER);
        TestCellACLWithMultipleVersions.verifyIfNull(getQ2, USER_OTHER, GROUP_USER);
    }

    private SecureTestUtil.AccessTestAction getDeleteFamilyAction(final byte[] fam) {
        SecureTestUtil.AccessTestAction deleteFamily = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete delete = new Delete(TEST_ROW).deleteFamily(fam);
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    t.delete(delete);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        return deleteFamily;
    }

    @Test
    public void testCellPermissionsWithDeleteWithUserTs() throws Exception {
        USER_OWNER.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{USER_OTHER.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OTHER2.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW);
                    p.add(TEST_FAMILY1, TEST_Q1, 125L, ONE);
                    p.add(TEST_FAMILY1, TEST_Q2, 125L, ONE);
                    p.setACL(TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{USER_OTHER.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP)}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, TWO);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, TWO);
                    p.setACL(TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{USER_OTHER.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP)}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    Object var3_3 = null;
                    return var3_3;
                }
                finally {
                    t.close();
                }
            }
        });
        USER_OTHER2.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW, 124L);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        USER_OTHER2.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q2, 124L);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsWithDeleteExactVersion() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Map permsU1andOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU2andGUandOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 123L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 125L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 125L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 129L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 129L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumn(TEST_FAMILY1, TEST_Q1, 123L);
                    d.deleteColumn(TEST_FAMILY1, TEST_Q2);
                    d.deleteFamilyVersion(TEST_FAMILY2, 125L);
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        this.verifyUserDeniedForDeleteExactVersion(user2, TEST_ROW1, TEST_Q1, TEST_Q2);
        this.verifyUserDeniedForDeleteExactVersion(GROUP_USER, TEST_ROW1, TEST_Q1, TEST_Q2);
    }

    private void verifyUserDeniedForDeleteExactVersion(final User user, final byte[] row, final byte[] q1, final byte[] q2) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(row, 127L);
                    d.deleteColumns(TEST_FAMILY1, q1);
                    d.deleteColumns(TEST_FAMILY1, q2);
                    d.deleteFamily(TEST_FAMILY2, 129L);
                    t.delete(d);
                    Assert.fail((String)(user.getShortName() + " can not do the delete"));
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForIncrementWithMultipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Map permsU1andOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU2andGUandOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Increment inc = new Increment(TEST_ROW1);
                    inc.setTimeRange(0L, 123L);
                    inc.addColumn(TEST_FAMILY1, TEST_Q1, 2L);
                    t.increment(inc);
                    t.incrementColumnValue(TEST_ROW1, TEST_FAMILY1, TEST_Q2, 1L);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        this.verifyUserDeniedForIncrementMultipleVersions(user2, TEST_ROW1, TEST_Q2);
        this.verifyUserDeniedForIncrementMultipleVersions(GROUP_USER, TEST_ROW1, TEST_Q2);
    }

    private void verifyUserDeniedForIncrementMultipleVersions(final User user, final byte[] row, final byte[] q1) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Increment inc = new Increment(row);
                    inc.setTimeRange(0L, 127L);
                    inc.addColumn(TEST_FAMILY1, q1, 2L);
                    t.increment(inc);
                    Assert.fail((String)(user.getShortName() + " cannot do the increment."));
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForPutWithMultipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Map permsU1andOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU2andGUandOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    permsU2andGUandOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU2andGUandOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 125L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        this.verifyUserDeniedForPutMultipleVersions(user2, TEST_ROW1, TEST_Q1, TEST_Q2, ZERO);
        this.verifyUserDeniedForPutMultipleVersions(GROUP_USER, TEST_ROW1, TEST_Q1, TEST_Q2, ZERO);
    }

    private void verifyUserDeniedForPutMultipleVersions(final User user, final byte[] row, final byte[] q1, final byte[] q2, final byte[] val) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Put p = new Put(row);
                    p.add(TEST_FAMILY1, q1, 124L, val);
                    p.add(TEST_FAMILY1, q2, val);
                    t.put(p);
                    Assert.fail((String)(user.getShortName() + " cannot do the put."));
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForCheckAndDelete() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q3 = Bytes.toBytes((String)"q3");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Map permsU1andOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU1andU2andGUandOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU1andU2andGU = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP)}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 120L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, 120L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q3, 120L, ZERO);
                    p.setACL(permsU1andU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q3, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU1andU2andGU);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q3, 127L, ZERO);
                    p.setACL(AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1, 120L);
                    t.checkAndDelete(TEST_ROW1, TEST_FAMILY1, TEST_Q1, ZERO, d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
        this.verifyUserDeniedForCheckAndDelete(user2, TEST_ROW1, ZERO);
        this.verifyUserDeniedForCheckAndDelete(GROUP_USER, TEST_ROW1, ZERO);
        this.verifyUserAllowedforCheckAndDelete(user2, TEST_ROW1, TEST_Q2, ZERO);
        this.verifyUserAllowedforCheckAndDelete(GROUP_USER, TEST_ROW1, TEST_Q3, ZERO);
    }

    private void verifyUserAllowedforCheckAndDelete(User user, final byte[] row, final byte[] q1, final byte[] value) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(row);
                    d.deleteColumn(TEST_FAMILY1, q1, 120L);
                    t.checkAndDelete(row, TEST_FAMILY1, q1, value, d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    private void verifyUserDeniedForCheckAndDelete(final User user, final byte[] row, final byte[] value) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());
                try {
                    Delete d = new Delete(row);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    t.checkAndDelete(row, TEST_FAMILY1, TEST_Q1, value, d);
                    Assert.fail((String)(user.getShortName() + " should not be allowed to do checkAndDelete"));
                }
                catch (Exception exception) {
                }
                finally {
                    t.close();
                }
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.TEST_TABLE.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).size());
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_UTIL = new HBaseTestingUtility();
        TEST_FAMILY1 = Bytes.toBytes((String)"f1");
        TEST_FAMILY2 = Bytes.toBytes((String)"f2");
        TEST_ROW = Bytes.toBytes((String)"cellpermtest");
        TEST_Q1 = Bytes.toBytes((String)"q1");
        TEST_Q2 = Bytes.toBytes((String)"q2");
        ZERO = Bytes.toBytes((long)0L);
        ONE = Bytes.toBytes((long)1L);
        TWO = Bytes.toBytes((long)2L);
    }
}

