/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CoprocessorClassLoader;
import org.apache.hadoop.hbase.util.SortedList;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.io.MultipleIOException;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public abstract class CoprocessorHost<E extends CoprocessorEnvironment> {
    public static final String REGION_COPROCESSOR_CONF_KEY = "hbase.coprocessor.region.classes";
    public static final String REGIONSERVER_COPROCESSOR_CONF_KEY = "hbase.coprocessor.regionserver.classes";
    public static final String USER_REGION_COPROCESSOR_CONF_KEY = "hbase.coprocessor.user.region.classes";
    public static final String MASTER_COPROCESSOR_CONF_KEY = "hbase.coprocessor.master.classes";
    public static final String WAL_COPROCESSOR_CONF_KEY = "hbase.coprocessor.wal.classes";
    public static final String ABORT_ON_ERROR_KEY = "hbase.coprocessor.abortonerror";
    public static final boolean DEFAULT_ABORT_ON_ERROR = true;
    public static final String COPROCESSORS_ENABLED_CONF_KEY = "hbase.coprocessor.enabled";
    public static final boolean DEFAULT_COPROCESSORS_ENABLED = true;
    public static final String USER_COPROCESSORS_ENABLED_CONF_KEY = "hbase.coprocessor.user.enabled";
    public static final boolean DEFAULT_USER_COPROCESSORS_ENABLED = true;
    protected static final Log LOG = LogFactory.getLog(CoprocessorHost.class);
    protected Abortable abortable;
    protected SortedList<E> coprocessors = new SortedList<CoprocessorEnvironment>(new EnvironmentPriorityComparator());
    protected Configuration conf;
    protected String pathPrefix;
    protected AtomicInteger loadSequence = new AtomicInteger();
    private static Set<String> coprocessorNames = Collections.synchronizedSet(new HashSet());

    public CoprocessorHost(Abortable abortable) {
        this.abortable = abortable;
        this.pathPrefix = UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getLoadedCoprocessors() {
        Set<String> set = coprocessorNames;
        synchronized (set) {
            return new HashSet<String>(coprocessorNames);
        }
    }

    public Set<String> getCoprocessors() {
        TreeSet<String> returnValue = new TreeSet<String>();
        for (CoprocessorEnvironment e : this.coprocessors) {
            returnValue.add(e.getInstance().getClass().getSimpleName());
        }
        return returnValue;
    }

    protected void loadSystemCoprocessors(Configuration conf, String confKey) {
        boolean coprocessorsEnabled = conf.getBoolean(COPROCESSORS_ENABLED_CONF_KEY, true);
        if (!coprocessorsEnabled) {
            return;
        }
        Class<?> implClass = null;
        String[] defaultCPClasses = conf.getStrings(confKey);
        if (defaultCPClasses == null || defaultCPClasses.length == 0) {
            return;
        }
        int priority = 0x1FFFFFFF;
        for (String className : defaultCPClasses) {
            if (this.findCoprocessor(className = className.trim()) != null) {
                LOG.warn((Object)("Attempted duplicate loading of " + className + "; skipped"));
                continue;
            }
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                implClass = cl.loadClass(className);
                this.coprocessors.add(this.loadInstance(implClass, 0x1FFFFFFF, conf));
                LOG.info((Object)("System coprocessor " + className + " was loaded " + "successfully with priority (" + priority++ + ")."));
            }
            catch (Throwable t) {
                this.abortServer(className, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E load(Path path, String className, int priority, Configuration conf) throws IOException {
        Class<?> implClass = null;
        LOG.debug((Object)("Loading coprocessor class " + className + " with path " + path + " and priority " + priority));
        CoprocessorClassLoader cl = null;
        if (path == null) {
            try {
                implClass = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("No jar path specified for " + className);
            }
        }
        cl = CoprocessorClassLoader.getClassLoader((Path)path, (ClassLoader)this.getClass().getClassLoader(), (String)this.pathPrefix, (Configuration)conf);
        try {
            implClass = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot load external coprocessor class " + className, e);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader hostClassLoader = currentThread.getContextClassLoader();
        try {
            E cpInstance;
            currentThread.setContextClassLoader((ClassLoader)cl);
            E e = cpInstance = this.loadInstance(implClass, priority, conf);
            return e;
        }
        finally {
            currentThread.setContextClassLoader(hostClassLoader);
        }
    }

    public void load(Class<?> implClass, int priority, Configuration conf) throws IOException {
        E env = this.loadInstance(implClass, priority, conf);
        this.coprocessors.add(env);
    }

    public E loadInstance(Class<?> implClass, int priority, Configuration conf) throws IOException {
        Coprocessor impl;
        if (!Coprocessor.class.isAssignableFrom(implClass)) {
            throw new IOException("Configured class " + implClass.getName() + " must implement " + Coprocessor.class.getName() + " interface ");
        }
        Object o = null;
        try {
            o = implClass.newInstance();
            impl = o;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        E env = this.createEnvironment(implClass, impl, priority, this.loadSequence.incrementAndGet(), conf);
        if (env instanceof Environment) {
            ((Environment)env).startup();
        }
        coprocessorNames.add(implClass.getName());
        return env;
    }

    public abstract E createEnvironment(Class<?> var1, Coprocessor var2, int var3, int var4, Configuration var5);

    public void shutdown(CoprocessorEnvironment e) {
        if (e instanceof Environment) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Stop coprocessor " + e.getInstance().getClass().getName()));
            }
            ((Environment)e).shutdown();
        } else {
            LOG.warn((Object)("Shutdown called on unknown environment: " + e.getClass().getName()));
        }
    }

    public Coprocessor findCoprocessor(String className) {
        for (CoprocessorEnvironment env : this.coprocessors) {
            if (!env.getInstance().getClass().getName().equals(className) && !env.getInstance().getClass().getSimpleName().equals(className)) continue;
            return env.getInstance();
        }
        return null;
    }

    public <T extends Coprocessor> List<T> findCoprocessors(Class<T> cls) {
        ArrayList<Coprocessor> ret = new ArrayList<Coprocessor>();
        for (CoprocessorEnvironment env : this.coprocessors) {
            Coprocessor cp = env.getInstance();
            if (cp == null || !cls.isAssignableFrom(cp.getClass())) continue;
            ret.add(cp);
        }
        return ret;
    }

    public CoprocessorEnvironment findCoprocessorEnvironment(String className) {
        for (CoprocessorEnvironment env : this.coprocessors) {
            if (!env.getInstance().getClass().getName().equals(className) && !env.getInstance().getClass().getSimpleName().equals(className)) continue;
            return env;
        }
        return null;
    }

    Set<ClassLoader> getExternalClassLoaders() {
        HashSet<ClassLoader> externalClassLoaders = new HashSet<ClassLoader>();
        ClassLoader systemClassLoader = this.getClass().getClassLoader();
        for (CoprocessorEnvironment env : this.coprocessors) {
            ClassLoader cl = env.getInstance().getClass().getClassLoader();
            if (cl == systemClassLoader) continue;
            externalClassLoaders.add(cl);
        }
        return externalClassLoaders;
    }

    protected void abortServer(CoprocessorEnvironment environment, Throwable e) {
        this.abortServer(environment.getInstance().getClass().getName(), e);
    }

    protected void abortServer(String coprocessorName, Throwable e) {
        String message = "The coprocessor " + coprocessorName + " threw " + e.toString();
        LOG.error((Object)message, e);
        if (this.abortable != null) {
            this.abortable.abort(message, e);
        } else {
            LOG.warn((Object)"No available Abortable, process was not aborted");
        }
    }

    protected void handleCoprocessorThrowable(CoprocessorEnvironment env, Throwable e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (!env.getConfiguration().getBoolean(ABORT_ON_ERROR_KEY, true)) {
            LOG.error((Object)("Removing coprocessor '" + env.toString() + "' from " + "environment because it threw:  " + e), e);
            this.coprocessors.remove(env);
            try {
                this.shutdown(env);
            }
            catch (Exception x) {
                LOG.error((Object)("Uncaught exception when shutting down coprocessor '" + env.toString() + "'"), (Throwable)x);
            }
            throw new DoNotRetryIOException("Coprocessor: '" + env.toString() + "' threw: '" + e + "' and has been removed from the active " + "coprocessor set.", e);
        }
        this.abortServer(env, e);
    }

    public static class Environment
    implements CoprocessorEnvironment {
        public Coprocessor impl;
        protected int priority = 0x3FFFFFFF;
        Coprocessor.State state = Coprocessor.State.UNINSTALLED;
        protected List<HTableInterface> openTables = Collections.synchronizedList(new ArrayList());
        private int seq;
        private Configuration conf;
        private ClassLoader classLoader;

        public Environment(Coprocessor impl, int priority, int seq, Configuration conf) {
            this.impl = impl;
            this.classLoader = impl.getClass().getClassLoader();
            this.priority = priority;
            this.state = Coprocessor.State.INSTALLED;
            this.seq = seq;
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startup() throws IOException {
            if (this.state == Coprocessor.State.INSTALLED || this.state == Coprocessor.State.STOPPED) {
                this.state = Coprocessor.State.STARTING;
                Thread currentThread = Thread.currentThread();
                ClassLoader hostClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this.getClassLoader());
                    this.impl.start((CoprocessorEnvironment)this);
                    this.state = Coprocessor.State.ACTIVE;
                }
                finally {
                    currentThread.setContextClassLoader(hostClassLoader);
                }
            } else {
                LOG.warn((Object)("Not starting coprocessor " + this.impl.getClass().getName() + " because not inactive (state=" + this.state.toString() + ")"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown() {
            if (this.state == Coprocessor.State.ACTIVE) {
                this.state = Coprocessor.State.STOPPING;
                Thread currentThread = Thread.currentThread();
                ClassLoader hostClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this.getClassLoader());
                    this.impl.stop((CoprocessorEnvironment)this);
                    this.state = Coprocessor.State.STOPPED;
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Error stopping coprocessor " + this.impl.getClass().getName()), (Throwable)ioe);
                }
                finally {
                    currentThread.setContextClassLoader(hostClassLoader);
                }
            } else {
                LOG.warn((Object)("Not stopping coprocessor " + this.impl.getClass().getName() + " because not active (state=" + this.state.toString() + ")"));
            }
            List<HTableInterface> list = this.openTables;
            synchronized (list) {
                for (HTableInterface table : this.openTables) {
                    try {
                        ((HTableWrapper)table).internalClose();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed to close " + Bytes.toStringBinary((byte[])table.getTableName())), (Throwable)e);
                    }
                }
            }
        }

        public Coprocessor getInstance() {
            return this.impl;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getLoadSequence() {
            return this.seq;
        }

        public int getVersion() {
            return 1;
        }

        public String getHBaseVersion() {
            return VersionInfo.getVersion();
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public HTableInterface getTable(TableName tableName) throws IOException {
            return this.getTable(tableName, HTable.getDefaultExecutor((Configuration)this.getConfiguration()));
        }

        public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
            return new HTableWrapper(tableName, CoprocessorHConnection.getConnectionForEnvironment(this), pool);
        }

        class HTableWrapper
        implements HTableInterface {
            private TableName tableName;
            private HTable table;
            private HConnection connection;

            public HTableWrapper(TableName tableName, HConnection connection, ExecutorService pool) throws IOException {
                this.tableName = tableName;
                this.table = new HTable(tableName, connection, pool);
                this.connection = connection;
                Environment.this.openTables.add(this);
            }

            void internalClose() throws IOException {
                ArrayList<IOException> exceptions = new ArrayList<IOException>(2);
                try {
                    this.table.close();
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
                if (!exceptions.isEmpty()) {
                    throw MultipleIOException.createIOException(exceptions);
                }
            }

            public Configuration getConfiguration() {
                return this.table.getConfiguration();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    this.internalClose();
                }
                finally {
                    Environment.this.openTables.remove(this);
                }
            }

            public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
                return this.table.getRowOrBefore(row, family);
            }

            public Result get(Get get) throws IOException {
                return this.table.get(get);
            }

            public boolean exists(Get get) throws IOException {
                return this.table.exists(get);
            }

            public Boolean[] exists(List<Get> gets) throws IOException {
                return this.table.exists(gets);
            }

            public void put(Put put) throws IOException {
                this.table.put(put);
            }

            public void put(List<Put> puts) throws IOException {
                this.table.put(puts);
            }

            public void delete(Delete delete) throws IOException {
                this.table.delete(delete);
            }

            public void delete(List<Delete> deletes) throws IOException {
                this.table.delete(deletes);
            }

            public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
                return this.table.checkAndPut(row, family, qualifier, value, put);
            }

            public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
                return this.table.checkAndDelete(row, family, qualifier, value, delete);
            }

            public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
                return this.table.incrementColumnValue(row, family, qualifier, amount);
            }

            public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
                return this.table.incrementColumnValue(row, family, qualifier, amount, durability);
            }

            public Result append(Append append) throws IOException {
                return this.table.append(append);
            }

            public Result increment(Increment increment) throws IOException {
                return this.table.increment(increment);
            }

            public void flushCommits() throws IOException {
                this.table.flushCommits();
            }

            public boolean isAutoFlush() {
                return this.table.isAutoFlush();
            }

            public ResultScanner getScanner(Scan scan) throws IOException {
                return this.table.getScanner(scan);
            }

            public ResultScanner getScanner(byte[] family) throws IOException {
                return this.table.getScanner(family);
            }

            public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
                return this.table.getScanner(family, qualifier);
            }

            public HTableDescriptor getTableDescriptor() throws IOException {
                return this.table.getTableDescriptor();
            }

            public byte[] getTableName() {
                return this.tableName.getName();
            }

            public TableName getName() {
                return this.table.getName();
            }

            public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
                this.table.batch(actions, results);
            }

            public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
                return this.table.batch(actions);
            }

            public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
                this.table.batchCallback(actions, results, callback);
            }

            public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
                return this.table.batchCallback(actions, callback);
            }

            public Result[] get(List<Get> gets) throws IOException {
                return this.table.get(gets);
            }

            public CoprocessorRpcChannel coprocessorService(byte[] row) {
                return this.table.coprocessorService(row);
            }

            public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
                return this.table.coprocessorService(service, startKey, endKey, callable);
            }

            public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
                this.table.coprocessorService(service, startKey, endKey, callable, callback);
            }

            public void mutateRow(RowMutations rm) throws IOException {
                this.table.mutateRow(rm);
            }

            public void setAutoFlush(boolean autoFlush) {
                this.table.setAutoFlush(autoFlush, autoFlush);
            }

            public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
                this.table.setAutoFlush(autoFlush, clearBufferOnFail);
            }

            public void setAutoFlushTo(boolean autoFlush) {
                this.table.setAutoFlushTo(autoFlush);
            }

            public long getWriteBufferSize() {
                return this.table.getWriteBufferSize();
            }

            public void setWriteBufferSize(long writeBufferSize) throws IOException {
                this.table.setWriteBufferSize(writeBufferSize);
            }

            public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
                return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
            }

            public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor method, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
                return this.table.batchCoprocessorService(method, request, startKey, endKey, responsePrototype);
            }

            public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor method, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
                this.table.batchCoprocessorService(method, request, startKey, endKey, responsePrototype, callback);
            }

            public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
                return this.table.checkAndMutate(row, family, qualifier, compareOp, value, mutation);
            }
        }
    }

    static class EnvironmentPriorityComparator
    implements Comparator<CoprocessorEnvironment> {
        EnvironmentPriorityComparator() {
        }

        @Override
        public int compare(CoprocessorEnvironment env1, CoprocessorEnvironment env2) {
            if (env1.getPriority() < env2.getPriority()) {
                return -1;
            }
            if (env1.getPriority() > env2.getPriority()) {
                return 1;
            }
            if (env1.getLoadSequence() < env2.getLoadSequence()) {
                return -1;
            }
            if (env1.getLoadSequence() > env2.getLoadSequence()) {
                return 1;
            }
            return 0;
        }
    }
}

